/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.authentication.formpersona;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.orion.internal.server.core.IOUtilities;
import org.eclipse.orion.server.authentication.formpersona.PersonaException;
import org.eclipse.orion.server.authentication.formpersona.PersonaVerificationFailure;
import org.eclipse.orion.server.authentication.formpersona.PersonaVerificationResponse;
import org.eclipse.orion.server.authentication.formpersona.PersonaVerificationSuccess;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.user.profile.IOrionUserProfileNode;
import org.eclipse.orion.server.user.profile.IOrionUserProfileService;
import org.eclipse.orion.server.useradmin.IOrionCredentialsService;
import org.eclipse.orion.server.useradmin.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonaHelper {
    public static final String DEFAULT_VERIFIER = "https://verifier.login.persona.org/verify";
    private final Logger log = LoggerFactory.getLogger((String)"org.eclipse.orion.server.login");
    private static IOrionCredentialsService userAdmin;
    private static IOrionUserProfileService userProfileService;
    private static URL configuredAudience;
    private static String verifierUrl;

    static {
        configuredAudience = null;
        try {
            String audiencePref = PreferenceHelper.getString((String)"orion.auth.host", null);
            if (audiencePref != null) {
                configuredAudience = new URL(audiencePref);
            }
        }
        catch (MalformedURLException e) {
            LogHelper.log((Throwable)e);
        }
        verifierUrl = PreferenceHelper.getString((String)"orion.auth.persona.verifier", (String)DEFAULT_VERIFIER);
    }

    public static String getAuthType() {
        return "Persona";
    }

    public static IOrionCredentialsService getDefaultUserAdmin() {
        return userAdmin;
    }

    public void setUserAdmin(IOrionCredentialsService _userAdmin) {
        userAdmin = _userAdmin;
    }

    public void unsetUserAdmin(IOrionCredentialsService _userAdmin) {
        if (_userAdmin.equals(userAdmin)) {
            userAdmin = null;
        }
    }

    public static IOrionUserProfileService getUserProfileService() {
        return userProfileService;
    }

    public static void bindUserProfileService(IOrionUserProfileService _userProfileService) {
        userProfileService = _userProfileService;
    }

    public static void unbindUserProfileService(IOrionUserProfileService userProfileService) {
        userProfileService = null;
    }

    private String getConfiguredAudience(HttpServletRequest req) throws PersonaException {
        if (configuredAudience == null) {
            throw new PersonaException("Authentication host not configured");
        }
        return configuredAudience.toString();
    }

    private static boolean isLoopback(InetAddress addr) {
        block3: {
            try {
                if (!addr.isLoopbackAddress()) break block3;
                return true;
            }
            catch (SocketException socketException) {
                return false;
            }
        }
        return NetworkInterface.getByInetAddress(addr) != null;
    }

    private String getLoopbackAudience(HttpServletRequest req) throws PersonaException {
        try {
            String serverName = req.getServerName();
            try {
                InetAddress addr;
                if (PersonaHelper.isLoopback(InetAddress.getByName(req.getLocalAddr())) && PersonaHelper.isLoopback(addr = InetAddress.getByName(serverName))) {
                    return new URI(req.getScheme(), req.getRemoteUser(), serverName, req.getServerPort(), null, null, null).toString();
                }
            }
            catch (UnknownHostException unknownHostException) {}
        }
        catch (URISyntaxException e) {
            throw new PersonaException(e);
        }
        return null;
    }

    private String getVerifiedAudience(HttpServletRequest req) {
        try {
            if (configuredAudience != null) {
                String audience = this.getConfiguredAudience(req);
                if (this.log.isInfoEnabled()) {
                    this.log.info("Persona auth request for configured host. Sending audience " + audience);
                }
                return audience;
            }
            String audience = this.getLoopbackAudience(req);
            if (audience == null) {
                throw new PersonaException("Authentication host not configured");
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Persona auth request from loopback. Sending audience " + audience);
            }
            return audience;
        }
        catch (PersonaException e) {
            throw new PersonaException("Error logging in: " + e.getMessage() + ". Contact your system administrator for assistance.");
        }
    }

    public void handleCredentialsAndLogin(HttpServletRequest req, HttpServletResponse res) throws PersonaException {
        String assertion = req.getParameter("assertion");
        if (assertion != null) {
            String audience = this.getVerifiedAudience(req);
            PersonaVerificationSuccess success = this.verifyCredentials(assertion, audience, req);
            String email = success.getEmail();
            if (email == null || email.equals("")) {
                throw new PersonaException("Verification response is not sufficient");
            }
            User user = userAdmin.getUser("email", email);
            if (user == null) {
                throw new PersonaException("There is no Orion account associated with your Persona email. Please register or contact your system administrator for assistance.");
            }
            req.getSession().setAttribute("user", (Object)user.getUid());
            IOrionUserProfileNode userProfileNode = PersonaHelper.getUserProfileService().getUserProfileNode(user.getUid(), "general");
            try {
                userProfileNode.put("lastlogintimestamp", new Long(System.currentTimeMillis()).toString(), false);
                userProfileNode.flush();
            }
            catch (CoreException e) {
                LogHelper.log((Throwable)e);
            }
            return;
        }
    }

    public PersonaVerificationSuccess verifyCredentials(String assertion, String audience, HttpServletRequest req) throws PersonaException {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(verifierUrl).openConnection();
            connection.setRequestMethod("POST");
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setUseCaches(false);
            connection.connect();
            String postData = "assertion=" + URLEncoder.encode(assertion, "UTF-8") + "&audience=" + URLEncoder.encode(audience, "UTF-8");
            connection.getOutputStream().write(postData.getBytes("UTF-8"));
            PersonaVerificationResponse personaResponse = new PersonaVerificationResponse(IOUtilities.toString((InputStream)connection.getInputStream()));
            PersonaVerificationSuccess success = personaResponse.getSuccess();
            if (success != null) {
                HttpSession session = req.getSession(true);
                String email = success.getEmail();
                session.setAttribute("persona_identifier", (Object)email);
                if (this.log.isInfoEnabled()) {
                    this.log.info("Persona verification succeeded: " + email);
                }
                return success;
            }
            PersonaVerificationFailure failure = personaResponse.getFailure();
            if (failure != null) {
                String failMessage = "Persona verification failed: " + failure.getReason();
                if (this.log.isInfoEnabled()) {
                    this.log.info(failMessage);
                }
                throw new PersonaException(failMessage);
            }
            throw new PersonaException("Unknown state");
        }
        catch (MalformedURLException e) {
            this.log.error("An error occured when verifying credentials.", (Throwable)e);
            throw new PersonaException(e);
        }
        catch (ProtocolException e) {
            this.log.error("An error occured when verifying credentials.", (Throwable)e);
            throw new PersonaException(e);
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("An error occured when verifying credentials.", (Throwable)e);
            throw new PersonaException(e);
        }
        catch (IOException e) {
            this.log.error("An error occured when verifying credentials.", (Throwable)e);
            throw new PersonaException(e);
        }
    }
}

