/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spell;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import org.apache.lucene.search.spell.Dictionary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlainTextDictionary
implements Dictionary {
    private BufferedReader in;
    private String line;
    private boolean hasNextCalled;

    public PlainTextDictionary(File file) throws FileNotFoundException {
        this.in = new BufferedReader(new FileReader(file));
    }

    public PlainTextDictionary(InputStream dictFile) {
        this.in = new BufferedReader(new InputStreamReader(dictFile));
    }

    public PlainTextDictionary(Reader reader) {
        this.in = new BufferedReader(reader);
    }

    @Override
    public Iterator<String> getWordsIterator() {
        return new fileIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class fileIterator
    implements Iterator<String> {
        fileIterator() {
        }

        @Override
        public String next() {
            if (!PlainTextDictionary.this.hasNextCalled) {
                this.hasNext();
            }
            PlainTextDictionary.this.hasNextCalled = false;
            return PlainTextDictionary.this.line;
        }

        @Override
        public boolean hasNext() {
            PlainTextDictionary.this.hasNextCalled = true;
            try {
                PlainTextDictionary.this.line = PlainTextDictionary.this.in.readLine();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            return PlainTextDictionary.this.line != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

