/*******************************************************************************
 * Copyright (c) 2010, 2011 IBM Corporation and others 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.orion.server.useradmin.servlets;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.orion.server.useradmin.UserServiceHelper;
import org.eclipse.osgi.util.NLS;

// POST /users/ creates a new user
// GET /users/ gets list of users
//
// One user methods:
//
// GET /users/[userId] gets user details
// PUT /users/[userId] updates user details
// DELETE /users/[usersId] deletes a user
//
// Roles methods:
//
// GET /users/[usersId]/roles returns a list of roles for given user
// PUT /users/[usersId]/roles adds roles for given user
// DELETE /users/[usersId]/roles removes roles for given a user
public class UserServlet extends OrionServlet {

	private static final long serialVersionUID = -6809742538472682623L;

	public static final String USERS_URI = "/users";

	private ServletResourceHandler<String> userSerializer;

	public UserServlet() {
		userSerializer = new ServletUserHandler(UserServiceHelper.getDefault(), getStatusHandler());
	}

	@Override
	protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
		traceRequest(req);
		String pathInfo = req.getPathInfo();

		if (pathInfo != null && !pathInfo.equals("/")) {
			String userId = pathInfo.split("\\/")[1];
			if (UserServiceHelper.getDefault().getUserProfileService().getUserProfileNode(userId, false) == null) {
				handleException(resp, new ServerStatus(IStatus.ERROR, HttpServletResponse.SC_NOT_FOUND, NLS.bind("User not found: {0}", userId), null));
				return;
			}
		}

		if (userSerializer.handleRequest(req, resp, pathInfo))
			return;
		// finally invoke super to return an error for requests we don't know how to handle
		super.doGet(req, resp);
	}

	@Override
	protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
		doGet(req, resp);
	}

	@Override
	protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
		doGet(req, resp);
	}

	@Override
	protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
		doGet(req, resp);
	}
}
