/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.workspace;

import java.net.URI;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.internal.server.servlets.workspace.WebElementResourceHandler;
import org.eclipse.orion.internal.server.servlets.workspace.WebUser;
import org.eclipse.orion.internal.server.servlets.workspace.WebWorkspace;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebUserResourceHandler
extends WebElementResourceHandler<WebUser> {
    @Override
    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, WebUser object) throws ServletException {
        return false;
    }

    public static JSONObject toJSON(WebUser user, URI baseLocation) {
        JSONObject result = WebElementResourceHandler.toJSON(user);
        try {
            result.put("UserName", (Object)user.getUserName());
            JSONArray workspacesJSON = user.getWorkspacesJSON();
            int i = 0;
            while (i < workspacesJSON.length()) {
                JSONObject workspace = workspacesJSON.getJSONObject(i);
                String workspaceId = workspace.getString("Id");
                workspace.put("Location", (Object)URIUtil.append((URI)baseLocation, (String)workspaceId));
                workspace.put("Name", (Object)WebWorkspace.fromId(workspaceId).getName());
                ++i;
            }
            result.put("Workspaces", (Object)workspacesJSON);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return result;
    }
}

