/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.useradmin.servlets;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.orion.server.useradmin.UserServiceHelper;
import org.eclipse.orion.server.useradmin.servlets.ServletUserHandler;
import org.eclipse.osgi.util.NLS;

public class UserServlet
extends OrionServlet {
    private static final long serialVersionUID = -6809742538472682623L;
    public static final String USERS_URI = "/users";
    private ServletResourceHandler<String> userSerializer = new ServletUserHandler(UserServiceHelper.getDefault(), (ServletResourceHandler<IStatus>)this.getStatusHandler());

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.traceRequest(req);
        String pathInfo = req.getPathInfo();
        if (pathInfo != null && !pathInfo.equals("/")) {
            String userId = pathInfo.split("\\/")[1];
            if (UserServiceHelper.getDefault().getUserProfileService().getUserProfileNode(userId, false) == null) {
                this.handleException(resp, (IStatus)new ServerStatus(4, 404, NLS.bind((String)"User not found: {0}", (Object)userId), null));
                return;
            }
        }
        if (this.userSerializer.handleRequest(req, resp, (Object)pathInfo)) {
            return;
        }
        super.doGet(req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }
}

