/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.objects;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.orion.server.core.resources.Property;
import org.eclipse.orion.server.core.resources.ResourceShape;
import org.eclipse.orion.server.core.resources.annotations.PropertyDescription;
import org.eclipse.orion.server.core.resources.annotations.ResourceDescription;
import org.eclipse.orion.server.git.BaseToRemoteConverter;
import org.eclipse.orion.server.git.objects.GitObject;
import org.eclipse.orion.server.git.objects.RemoteBranch;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@ResourceDescription(type="Remote")
public class Remote
extends GitObject {
    public static final String RESOURCE = "remote";
    public static final String TYPE = "Remote";
    private static final ResourceShape DEFAULT_RESOURCE_SHAPE_WITHOUT_CHILDREN = new ResourceShape();
    private static final ResourceShape DEFAULT_RESOURCE_SHAPE = new ResourceShape();
    private String name;
    private String newBranch;

    static {
        Property[] defaultProperties = new Property[]{new Property("Location"), new Property("CloneLocation"), new Property("Name"), new Property("GitUrl"), new Property("PushUrl")};
        DEFAULT_RESOURCE_SHAPE_WITHOUT_CHILDREN.setProperties(defaultProperties);
        DEFAULT_RESOURCE_SHAPE.setProperties(DEFAULT_RESOURCE_SHAPE_WITHOUT_CHILDREN.getProperties());
        DEFAULT_RESOURCE_SHAPE.addProperty(new Property("Children"));
    }

    public Remote(URI cloneLocation, Repository db, String name) {
        super(cloneLocation, db);
        this.name = name;
    }

    public void setNewBranch(String newBranch) {
        this.newBranch = newBranch;
    }

    @Override
    public JSONObject toJSON() throws JSONException, URISyntaxException, IOException, CoreException {
        return this.toJSON(true);
    }

    public JSONObject toJSON(boolean includeChildren) throws JSONException, URISyntaxException, IOException, CoreException {
        Assert.isLegal((boolean)this.getConfig().getSubsections(RESOURCE).contains(this.name), (String)NLS.bind((String)"Remote {0} not found.", (Object)this.name));
        if (includeChildren) {
            return (JSONObject)this.jsonSerializer.serialize((Object)this, DEFAULT_RESOURCE_SHAPE);
        }
        return (JSONObject)this.jsonSerializer.serialize((Object)this, DEFAULT_RESOURCE_SHAPE_WITHOUT_CHILDREN);
    }

    @PropertyDescription(name="GitUrl")
    private String getUrl() {
        return this.getConfig().getString(RESOURCE, this.name, "url");
    }

    @PropertyDescription(name="PushUrl")
    private String getPushUrl() {
        return this.getConfig().getString(RESOURCE, this.name, "pushurl");
    }

    @PropertyDescription(name="Children")
    private JSONArray getChildren() throws IOException, JSONException, URISyntaxException, CoreException {
        JSONArray children = new JSONArray();
        boolean branchFound = false;
        ArrayList<Ref> refs = new ArrayList<Ref>();
        String currentBranch = this.db.getBranch();
        for (Map.Entry refEntry : this.db.getRefDatabase().getRefs("refs/remotes/" + this.name + "/").entrySet()) {
            if (((Ref)refEntry.getValue()).isSymbolic()) continue;
            Ref ref = (Ref)refEntry.getValue();
            String name = ref.getName();
            if (currentBranch.equals(name = Repository.shortenRefName((String)name).substring("origin".length() + 1))) {
                refs.add(0, ref);
                continue;
            }
            refs.add(ref);
        }
        for (Ref ref : refs) {
            String remoteBranchName = Repository.shortenRefName((String)ref.getName());
            remoteBranchName = remoteBranchName.substring((String.valueOf(this.name) + "/").length());
            RemoteBranch remoteBranch = new RemoteBranch(this.cloneLocation, this.db, this, remoteBranchName);
            children.put((Object)remoteBranch.toJSON());
            if (this.newBranch == null || this.newBranch.isEmpty() || !remoteBranchName.equals(this.newBranch)) continue;
            children = new JSONArray().put((Object)remoteBranch.toJSON());
            branchFound = true;
            break;
        }
        if (!branchFound && this.newBranch != null && !this.newBranch.isEmpty()) {
            JSONObject o = new JSONObject();
            String name = "refs/remotes/" + this.getName() + "/" + this.newBranch;
            o.put("Name", (Object)name.substring("refs/remotes/".length()));
            o.put("FullName", (Object)name);
            o.put("Type", (Object)"RemoteTrackingBranch");
            o.put("Location", (Object)BaseToRemoteConverter.REMOVE_FIRST_2.baseToRemoteLocation(this.cloneLocation, "", String.valueOf(this.getName()) + "/" + GitUtils.encode(this.newBranch)));
            children.put((Object)o);
        }
        return children;
    }

    @Override
    public URI getLocation() throws URISyntaxException {
        return BaseToRemoteConverter.REMOVE_FIRST_2.baseToRemoteLocation(this.cloneLocation, this.name, "");
    }

    @PropertyDescription(name="Name")
    public String getName() {
        return this.name;
    }

    public String toString() {
        return "Remote [name=" + this.name + "]";
    }
}

