/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.search;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.orion.internal.server.search.Indexer;
import org.eclipse.orion.internal.server.search.SearchActivator;
import org.eclipse.orion.server.core.LogHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexPurgeJob
extends Job {
    private static final long DEFAULT_DELAY = 30000L;
    private static final long PAGE_SIZE = 1000L;
    private final SolrServer server;

    public IndexPurgeJob(SolrServer server) {
        super("Purging Index");
        this.server = server;
        this.setSystem(true);
    }

    public boolean belongsTo(Object family) {
        return SearchActivator.JOB_FAMILY.equals(family);
    }

    private void checkCanceled(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public void ensureUpdated() {
        this.schedule(30000L);
    }

    private SolrQuery findAllQuery() {
        SolrQuery query = new SolrQuery();
        query.setParam("rows", new String[]{Long.toString(1000L)});
        query.setFields(new String[]{"Id"});
        query.setQuery("*:*");
        return query;
    }

    private void handleIndexingFailure(Throwable t) {
        LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.core.search", "Error during search index purge", t));
    }

    private void markStaleIndexes(SolrDocumentList list, List<String> listIds) {
        for (SolrDocument doc : list) {
            try {
                URI uri = new URI((String)doc.getFieldValue("Id"));
                IFileStore file = null;
                file = uri.isAbsolute() ? EFS.getLocalFileSystem().getStore(URIUtil.toPath((URI)uri)) : EFS.getStore((URI)uri);
                if (file.fetchInfo().exists()) continue;
                listIds.add((String)doc.getFieldValue("Id"));
            }
            catch (Exception e) {
                this.handleIndexingFailure(e);
            }
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        Logger logger = LoggerFactory.getLogger(Indexer.class);
        if (logger.isDebugEnabled()) {
            logger.debug("Purging indexes");
        }
        long start = System.currentTimeMillis();
        SolrQuery query = this.findAllQuery();
        try {
            QueryResponse solrResponse = this.server.query((SolrParams)query);
            SolrDocumentList result = solrResponse.getResults();
            long numFound = result.getNumFound();
            long processed = 0L;
            ArrayList<String> listIds = new ArrayList<String>();
            if (numFound > processed) {
                while (true) {
                    this.checkCanceled(monitor);
                    this.markStaleIndexes(result, listIds);
                    if ((processed += 1000L) >= numFound) break;
                    query.setParam("start", new String[]{Long.toString(processed)});
                    solrResponse = this.server.query((SolrParams)query);
                    result = solrResponse.getResults();
                    numFound = result.getNumFound();
                }
            }
            this.checkCanceled(monitor);
            if (listIds.size() > 0) {
                this.server.deleteById(listIds);
                this.server.commit();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\tPurged: " + listIds.size());
            }
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (Exception e) {
            this.handleIndexingFailure(e);
        }
        long duration = System.currentTimeMillis() - start;
        if (logger.isDebugEnabled()) {
            logger.debug("Purge job took " + duration + "ms");
        }
        long delay = Math.max(30000L, duration * 20L);
        this.schedule(delay);
        return Status.OK_STATUS;
    }
}

