/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.search;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrCore;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.orion.internal.server.core.Activator;
import org.eclipse.orion.internal.server.core.IOUtilities;
import org.eclipse.orion.internal.server.core.IWebResourceDecorator;
import org.eclipse.orion.internal.server.search.IndexPurgeJob;
import org.eclipse.orion.internal.server.search.Indexer;
import org.eclipse.orion.server.core.LogHelper;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class SearchActivator
implements BundleActivator,
IWebResourceDecorator {
    private static BundleContext context;
    private static final int CURRENT_INDEX_GENERATION = 14;
    private static final String INDEX_GENERATION_FILE = "index.generation";
    private static SearchActivator instance;
    public static final String PI_SEARCH = "org.eclipse.orion.server.core.search";
    public static final Object JOB_FAMILY;
    private Indexer indexer;
    private IndexPurgeJob purgeJob;
    private ServiceRegistration<IWebResourceDecorator> searchDecoratorRegistration;
    private SolrServer server;
    private SolrCore solrCore;
    private CoreContainer solrContainer;

    static {
        JOB_FAMILY = new Object();
    }

    static BundleContext getContext() {
        return context;
    }

    public static SearchActivator getInstance() {
        return instance;
    }

    public SearchActivator() {
        instance = this;
    }

    public void addAtributesFor(HttpServletRequest request, URI resource, JSONObject representation) {
        String service = request.getServletPath();
        if (!"/file".equals(service) && !"/workspace".equals(service)) {
            return;
        }
        try {
            URI result = new URI(resource.getScheme(), resource.getAuthority(), "/filesearch", "q=", null);
            representation.put("SearchLocation", (Object)result);
        }
        catch (URISyntaxException e) {
            LogHelper.log((Throwable)e);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    private void createServer() {
        try {
            File rootFile = Activator.getDefault().getPlatformLocation().toFile();
            File baseDir = new File(rootFile, ".metadata/.plugins/org.eclipse.orion.server.core.search");
            if (this.readIndexGeneration(baseDir) != 14) {
                this.delete(baseDir);
                this.writeIndexGeneration(baseDir);
            }
            this.createSolrConfig(baseDir);
            String solrDataDir = baseDir.toString();
            this.solrContainer = new CoreContainer(solrDataDir);
            CoreDescriptor descriptor = new CoreDescriptor(this.solrContainer, "Eclipse Web Search", solrDataDir);
            descriptor.setDataDir(String.valueOf(solrDataDir.toString()) + File.separatorChar + "data");
            this.solrCore = this.solrContainer.create(descriptor);
            this.solrContainer.register(this.solrCore, false);
            this.server = new EmbeddedSolrServer(this.solrContainer, "Eclipse Web Search");
        }
        catch (Exception e) {
            LogHelper.log((Throwable)e);
        }
    }

    private File createSolrConfig(File baseDir) throws FileNotFoundException, IOException {
        File configDir = new File(baseDir, "conf");
        configDir.mkdirs();
        File configFile = new File(configDir, "solrconfig.xml");
        this.createSolrFile(configFile);
        this.createSolrFile(new File(configDir, "schema.xml"));
        this.createSolrFile(new File(configDir, "synonyms.txt"));
        this.createSolrFile(new File(configDir, "stopwords.txt"));
        this.createSolrFile(new File(configDir, "protwords.txt"));
        this.createSolrFile(new File(configDir, "elevate.xml"));
        return configFile;
    }

    private void createSolrFile(File solrFile) throws FileNotFoundException, IOException {
        if (solrFile.exists()) {
            return;
        }
        URL source = this.getClass().getClassLoader().getResource("solrconf/" + solrFile.getName());
        source = FileLocator.resolve((URL)source);
        IOUtilities.pipe((InputStream)source.openStream(), (OutputStream)new FileOutputStream(solrFile), (boolean)true, (boolean)true);
    }

    private void delete(File baseDir) {
        try {
            EFS.getStore((URI)baseDir.toURI()).delete(0, null);
        }
        catch (CoreException e) {
            LogHelper.log((Throwable)e);
        }
    }

    SolrServer getSolrServer() {
        return this.server;
    }

    SolrCore getSolrCore() {
        return this.solrCore;
    }

    private int readIndexGeneration(File baseDir) {
        File generationFile = new File(baseDir, INDEX_GENERATION_FILE);
        if (!generationFile.exists()) {
            return -1;
        }
        DataInputStream in = null;
        try {
            int generation;
            in = new DataInputStream(new FileInputStream(generationFile));
            int n = generation = Integer.valueOf(in.readUTF()).intValue();
            IOUtilities.safeClose((Closeable)in);
            return n;
        }
        catch (Exception exception) {
        }
        finally {
            IOUtilities.safeClose(in);
        }
        return -1;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        this.createServer();
        if (this.server != null) {
            this.indexer = new Indexer(this.server);
            this.indexer.schedule();
            this.purgeJob = new IndexPurgeJob(this.server);
            this.purgeJob.schedule();
        }
        this.searchDecoratorRegistration = context.registerService(IWebResourceDecorator.class, (Object)this, null);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.searchDecoratorRegistration.unregister();
        if (this.solrContainer != null) {
            this.solrContainer.shutdown();
            this.solrContainer = null;
        }
        if (this.indexer != null) {
            this.indexer.cancel();
            this.indexer = null;
        }
        if (this.purgeJob != null) {
            this.purgeJob.cancel();
            this.purgeJob = null;
        }
        Job.getJobManager().join(JOB_FAMILY, null);
        context = null;
    }

    private void writeIndexGeneration(File baseDir) {
        block5: {
            baseDir.mkdirs();
            File generationFile = new File(baseDir, INDEX_GENERATION_FILE);
            DataOutputStream out = null;
            try {
                try {
                    out = new DataOutputStream(new FileOutputStream(generationFile));
                    out.writeUTF(Integer.toString(14));
                }
                catch (IOException e) {
                    String msg = "Error writing search index generation number. Subsequent restarts will discard and rebuild search index from scratch";
                    LogHelper.log((IStatus)new Status(4, PI_SEARCH, msg, (Throwable)e));
                    IOUtilities.safeClose((Closeable)out);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOUtilities.safeClose(out);
                throw throwable;
            }
            IOUtilities.safeClose((Closeable)out);
        }
    }

    public void testWaitForIndex() {
        try {
            this.indexer.cancel();
            this.indexer.schedule();
            this.indexer.join();
        }
        catch (InterruptedException interruptedException) {}
    }
}

