/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.configurator;

import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.http.jetty.JettyConfigurator;
import org.eclipse.orion.server.configurator.ConfiguratorActivator;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebApplication
implements IApplication {
    private static final Integer EXIT_WORKSPACE_LOCKED = new Integer(15);
    private static final String EQUINOX_HTTP_JETTY = "org.eclipse.equinox.http.jetty";
    private static final String EQUINOX_HTTP_REGISTRY = "org.eclipse.equinox.http.registry";
    private IApplicationContext appContext;

    public Object start(IApplicationContext context) throws Exception {
        Object instanceLocationCheck;
        this.appContext = context;
        this.ensureBundleStarted(EQUINOX_HTTP_JETTY);
        this.ensureBundleStarted(EQUINOX_HTTP_REGISTRY);
        IEclipsePreferences preferences = DefaultScope.INSTANCE.getNode("org.eclipse.orion.server.configurator");
        Boolean httpsEnabled = new Boolean(preferences.get("jetty.https.enabled", "false"));
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("context.sessioninactiveinterval", new Integer(14400));
        if (httpsEnabled.booleanValue()) {
            LogHelper.log((IStatus)new Status(1, "org.eclipse.orion.server.configurator", "Https is enabled", null));
            ((Dictionary)properties).put("https.enabled", true);
            ((Dictionary)properties).put("https.port", new Integer(preferences.get("jetty.https.port", System.getProperty("org.eclipse.equinox.http.jetty.https.port", "8443"))));
            ((Dictionary)properties).put("ssl.keystore", preferences.get("jetty.ssl.keystore", "keystore"));
            LogHelper.log((IStatus)new Status(1, "org.eclipse.orion.server.configurator", "Keystore absolute path is " + preferences.get("jetty.ssl.keystore", "keystore")));
            ((Dictionary)properties).put("ssl.password", preferences.get("jetty.ssl.password", "password"));
            ((Dictionary)properties).put("ssl.keypassword", preferences.get("jetty.ssl.keypassword", "password"));
            ((Dictionary)properties).put("ssl.protocol", preferences.get("jetty.ssl.protocol", "SSLv3"));
            String httpsHost = System.getProperty("org.eclipse.equinox.http.jetty.https.host");
            if (httpsHost != null) {
                ((Dictionary)properties).put("https.host", httpsHost);
            }
        }
        String port = null;
        if (!httpsEnabled.booleanValue()) {
            ((Dictionary)properties).put("http.enabled", true);
            port = preferences.get("jetty.http.port", System.getProperty("org.eclipse.equinox.http.jetty.http.port", "8080"));
            ((Dictionary)properties).put("http.port", new Integer(port));
            String httpHost = System.getProperty("org.eclipse.equinox.http.jetty.http.host");
            if (httpHost != null) {
                ((Dictionary)properties).put("http.host", httpHost);
            }
        }
        ((Dictionary)properties).put("other.info", "org.eclipse.orion");
        try {
            JettyConfigurator.startServer((String)"MasterJetty", properties);
        }
        catch (Exception e) {
            throw new Exception("Error starting Jetty on port: " + port, e);
        }
        if (this.appContext != null) {
            this.appContext.applicationRunning();
        }
        if ((instanceLocationCheck = this.checkInstanceLocation()) != null) {
            return instanceLocationCheck;
        }
        return IApplicationContext.EXIT_ASYNC_RESULT;
    }

    public void stop() {
        try {
            JettyConfigurator.stopServer((String)"MasterJetty");
        }
        catch (Exception exception) {}
        if (this.appContext != null) {
            this.appContext.setResult((Object)EXIT_OK, (IApplication)this);
        }
    }

    private Object checkInstanceLocation() {
        File workspaceDirectory;
        Location instanceLoc = ConfiguratorActivator.getDefault().getInstanceLocation();
        if (instanceLoc == null || !instanceLoc.isSet()) {
            this.getLogger().error("Instance location must be set");
            return EXIT_OK;
        }
        try {
            if (instanceLoc.lock()) {
                this.getLogger().info("Workspace location locked successfully: " + instanceLoc.getURL());
                return null;
            }
        }
        catch (IOException iOException) {
            this.getLogger().error("Workspace location could not be locked: " + instanceLoc.getURL());
        }
        if ((workspaceDirectory = new File(instanceLoc.getURL().getFile())).exists()) {
            this.getLogger().error("The workspace location is already in use by another server instance: " + workspaceDirectory);
            return EXIT_WORKSPACE_LOCKED;
        }
        this.getLogger().error("Workspace location could not be created: " + workspaceDirectory);
        return EXIT_OK;
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger((String)"org.eclipse.orion.app");
    }

    private void ensureBundleStarted(String symbolicName) throws BundleException {
        Bundle bundle = ConfiguratorActivator.getDefault().getBundle(symbolicName);
        if (bundle != null && (bundle.getState() == 4 || bundle.getState() == 8)) {
            bundle.start(1);
        }
    }
}

