/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.npm;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ProcessController {
    private boolean finished;
    private OutputStream forwardStdErr;
    private InputStream forwardStdIn;
    private OutputStream forwardStdOut;
    private boolean killed;
    private String[] params;
    private Process process;
    private long startupTime;
    private long timeLimit;
    private File cwd;

    public ProcessController(long timeout, String[] params, File cwd) {
        this.timeLimit = timeout;
        this.params = params;
        this.cwd = cwd;
    }

    private void controlProcess() {
        new Thread("Process controller"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!ProcessController.this.isFinished() && !ProcessController.this.timedOut()) {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        try {
                            this.wait(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            break;
                        }
                    }
                }
                ProcessController.this.kill();
            }
        }.start();
    }

    public int execute() throws InterruptedException, IOException, TimeOutException {
        this.startupTime = System.currentTimeMillis();
        this.process = Runtime.getRuntime().exec(this.params, null, this.cwd);
        Thread threadOut = null;
        Thread threadErr = null;
        if (this.forwardStdErr != null) {
            threadErr = this.forwardStream("stderr", this.process.getErrorStream(), this.forwardStdErr);
        }
        if (this.forwardStdOut != null) {
            threadOut = this.forwardStream("stdout", this.process.getInputStream(), this.forwardStdOut);
        }
        if (this.forwardStdIn != null) {
            this.forwardStream("stdin", this.forwardStdIn, this.process.getOutputStream());
        }
        if (this.timeLimit > 0L) {
            this.controlProcess();
        }
        try {
            int result = this.process.waitFor();
            this.markFinished();
            if (threadOut != null) {
                threadOut.join();
            }
            if (threadErr != null) {
                threadErr.join();
            }
            int n = result;
            return n;
        }
        finally {
            if (this.wasKilled()) {
                throw new TimeOutException("Timeout processing npm command.");
            }
        }
    }

    public void forwardErrorOutput(OutputStream err) {
        this.forwardStdErr = err;
    }

    public void forwardOutput(OutputStream out) {
        this.forwardStdOut = out;
    }

    private Thread forwardStream(String name, final InputStream in, final OutputStream out) {
        Thread t = new Thread("Stream forwarder [" + name + "]"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                while (true) {
                    try {
                        while (in.available() > 0) {
                            out.write(in.read());
                        }
                        if (ProcessController.this.isFinished()) {
                            out.flush();
                            return;
                        }
                        2 var1_1 = this;
                        synchronized (var1_1) {
                            this.wait(100L);
                        }
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        return;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        return;
                    }
                }
            }
        };
        t.start();
        return t;
    }

    public Process getProcess() {
        return this.process;
    }

    protected synchronized boolean isFinished() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        ProcessController processController = this;
        synchronized (processController) {
            if (this.isFinished()) {
                return;
            }
            this.killed = true;
        }
        this.process.destroy();
    }

    private synchronized void markFinished() {
        this.finished = true;
        this.notifyAll();
    }

    protected synchronized boolean timedOut() {
        return System.currentTimeMillis() - this.startupTime > this.timeLimit;
    }

    public boolean wasKilled() {
        return this.killed;
    }

    public void forwardInput(InputStream in) {
        this.forwardStdIn = in;
    }

    public class TimeOutException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public TimeOutException() {
        }

        public TimeOutException(String message) {
            super(message);
        }
    }
}

