/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.file;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.file.NewFileServlet;
import org.eclipse.orion.internal.server.servlets.file.ServletFileStoreHandler;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryHandlerV1
extends ServletResourceHandler<IFileStore> {
    static final int CREATE_COPY = 1;
    static final int CREATE_MOVE = 2;
    static final int CREATE_NO_OVERWRITE = 4;
    private final ServletResourceHandler<IStatus> statusHandler;

    public DirectoryHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        this.statusHandler = statusHandler;
    }

    private boolean handleGet(HttpServletRequest request, HttpServletResponse response, IFileStore dir) throws IOException, CoreException {
        URI location = DirectoryHandlerV1.getURI(request);
        JSONObject result = ServletFileStoreHandler.toJSON(dir, dir.fetchInfo(0, null), location);
        String depthString = request.getParameter("depth");
        int depth = 0;
        if (depthString != null) {
            try {
                depth = Integer.parseInt(depthString);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.encodeChildren(dir, location, result, depth);
        OrionServlet.writeJSONResponse(request, response, result);
        return true;
    }

    private void encodeChildren(IFileStore dir, URI location, JSONObject result, int depth) throws CoreException {
        IFileInfo[] childInfos;
        if (depth <= 0) {
            return;
        }
        JSONArray children = new JSONArray();
        IFileInfo[] iFileInfoArray = childInfos = dir.childInfos(0, null);
        int n = childInfos.length;
        int n2 = 0;
        while (n2 < n) {
            IFileInfo childInfo = iFileInfoArray[n2];
            IFileStore childStore = dir.getChild(childInfo.getName());
            String name = childInfo.getName();
            if (childInfo.isDirectory()) {
                name = String.valueOf(name) + "/";
            }
            URI childLocation = URIUtil.append((URI)location, (String)name);
            JSONObject childResult = ServletFileStoreHandler.toJSON(childStore, childInfo, childLocation);
            if (childInfo.isDirectory()) {
                this.encodeChildren(childStore, childLocation, childResult, depth - 1);
            }
            children.put((Object)childResult);
            ++n2;
        }
        try {
            result.put("Children", (Object)children);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean handlePost(HttpServletRequest request, HttpServletResponse response, IFileStore dir) throws JSONException, CoreException, ServletException, IOException {
        boolean destinationExists;
        JSONObject requestObject = OrionServlet.readJSONRequest(request);
        String name = this.computeName(request, requestObject);
        if (name.length() == 0) {
            return this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(4, 400, "File name not specified.", null));
        }
        int options = this.getCreateOptions(request);
        IFileStore toCreate = dir.getChild(name);
        if (!this.validateOptions(request, response, toCreate, destinationExists = toCreate.fetchInfo(0, null).exists(), options)) {
            return true;
        }
        if (this.performPost(request, response, requestObject, toCreate, options)) {
            URI location = URIUtil.append((URI)DirectoryHandlerV1.getURI(request), (String)name);
            JSONObject result = ServletFileStoreHandler.toJSON(toCreate, toCreate.fetchInfo(0, null), location);
            OrionServlet.writeJSONResponse(request, response, result);
            response.setHeader("Location", ServletResourceHandler.resovleOrionURI(request, location).toString());
            response.setStatus(destinationExists ? 200 : 201);
        }
        return true;
    }

    private boolean performPost(HttpServletRequest request, HttpServletResponse response, JSONObject requestObject, IFileStore toCreate, int options) throws CoreException, IOException, ServletException {
        boolean isMove;
        boolean isCopy = (options & 1) != 0;
        boolean bl = isMove = (options & 2) != 0;
        if (isCopy || isMove) {
            return this.performCopyMove(request, response, requestObject, toCreate, isCopy, options);
        }
        if (requestObject.optBoolean("Directory")) {
            toCreate.mkdir(0, null);
        } else {
            toCreate.openOutputStream(0, null).close();
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean performCopyMove(HttpServletRequest request, HttpServletResponse response, JSONObject requestObject, IFileStore toCreate, boolean isCopy, int options) throws ServletException, CoreException {
        String locationString = requestObject.optString("Location", null);
        if (locationString == null) {
            this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(4, 400, "Copy or move request must specify source location", null));
            return false;
        }
        try {
            IFileStore source = this.resolveSourceLocation(request, locationString);
            if (source == null) {
                this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(4, 404, NLS.bind((String)"Source does not exist: ", (Object)locationString), null));
                return false;
            }
            boolean allowOverwrite = (options & 4) == 0;
            int efsOptions = allowOverwrite ? 2 : 0;
            try {
                if (isCopy) {
                    source.copy(toCreate, efsOptions, null);
                    return true;
                }
                source.move(toCreate, efsOptions, null);
                return true;
            }
            catch (CoreException e) {
                if (!source.fetchInfo(0, null).exists()) {
                    this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(4, 404, NLS.bind((String)"Source does not exist: ", (Object)locationString), (Throwable)e));
                    return false;
                }
                if (e.getStatus().getCode() != 268) throw e;
                this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(4, 412, "A file or folder with the same name already exists at this location", null));
                return false;
            }
        }
        catch (URISyntaxException e) {
            this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(4, 400, NLS.bind((String)"Bad source location in request: ", (Object)locationString), (Throwable)e));
            return false;
        }
    }

    private IFileStore resolveSourceLocation(HttpServletRequest request, String locationString) throws URISyntaxException, CoreException {
        URI sourceLocation = new URI(locationString);
        String sourcePath = sourceLocation.getPath().substring(request.getContextPath().length());
        IPath path = new Path(sourcePath).removeFirstSegments(1);
        return NewFileServlet.getFileStore(request, path);
    }

    private String computeName(HttpServletRequest request, JSONObject requestObject) {
        String location;
        int lastSlash;
        String name = request.getHeader("Slug");
        if (requestObject.has("Name")) {
            try {
                name = requestObject.getString("Name");
            }
            catch (JSONException jSONException) {}
        }
        if ((name == null || name.length() == 0) && (lastSlash = (location = requestObject.optString("Location")).lastIndexOf(47)) >= 0) {
            name = location.substring(lastSlash + 1);
        }
        if (name == null || name.length() == 0) {
            name = requestObject.optString("Name");
        }
        return name;
    }

    private boolean validateOptions(HttpServletRequest request, HttpServletResponse response, IFileStore toCreate, boolean destinationExists, int options) throws ServletException {
        boolean noOverwrite;
        int copyMove = 3;
        if ((options & copyMove) == copyMove) {
            this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(4, 400, "Syntax error in request", null));
            return false;
        }
        boolean bl = noOverwrite = (options & 4) != 0;
        if ((options & copyMove) == 0 && noOverwrite && destinationExists) {
            this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(4, 412, "A file or folder with the same name already exists at this location", null));
            return false;
        }
        return true;
    }

    private int getCreateOptions(HttpServletRequest request) {
        int result = 0;
        String optionString = request.getHeader("X-Create-Options");
        if (optionString != null) {
            String[] stringArray = optionString.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String option = stringArray[n2];
                if ("copy".equalsIgnoreCase(option)) {
                    result |= 1;
                } else if ("move".equalsIgnoreCase(option)) {
                    result |= 2;
                } else if ("no-overwrite".equalsIgnoreCase(option)) {
                    result |= 4;
                }
                ++n2;
            }
        }
        return result;
    }

    private boolean handleDelete(HttpServletRequest request, HttpServletResponse response, IFileStore dir) throws JSONException, CoreException, ServletException, IOException {
        dir.delete(0, null);
        return true;
    }

    private boolean handlePut(HttpServletRequest request, HttpServletResponse response, IFileStore dir) throws JSONException, IOException, CoreException {
        IFileInfo info = ServletFileStoreHandler.fromJSON(request);
        dir.putInfo(info, 0, null);
        return true;
    }

    @Override
    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, IFileStore dir) throws ServletException {
        try {
            switch (DirectoryHandlerV1.getMethod(request)) {
                case GET: {
                    return this.handleGet(request, response, dir);
                }
                case PUT: {
                    return this.handlePut(request, response, dir);
                }
                case POST: {
                    return this.handlePost(request, response, dir);
                }
                case DELETE: {
                    return this.handleDelete(request, response, dir);
                }
            }
        }
        catch (JSONException e) {
            return this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(4, 400, "Syntax error in request", (Throwable)e));
        }
        catch (CoreException e) {
            return this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(4, 500, e.getMessage(), (Throwable)e));
        }
        catch (Exception e) {
            if (this.handleAuthFailure(request, response, e)) {
                return true;
            }
            LogHelper.log((Throwable)e);
            return this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(4, 500, "An unknown failure occurred. Consult your server log or contact your system administrator.", (Throwable)e));
        }
        return false;
    }
}

