/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.task;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.tasks.TaskInfo;
import org.eclipse.orion.server.core.tasks.TaskJob;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskJobHandler {
    public static final long WAIT_TIME = 100L;

    private static URI createTaskLocation(URI baseLocation, String taskId, boolean keep) throws URISyntaxException {
        return new URI(baseLocation.getScheme(), baseLocation.getAuthority(), String.valueOf(keep ? "/task/id/" : "/task/temp/") + taskId, null, null);
    }

    public static final String getUserId(HttpServletRequest req) {
        if (req.getRemoteUser() != null) {
            return req.getRemoteUser();
        }
        return req.getSession(true).getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean handleTaskJob(HttpServletRequest request, HttpServletResponse response, TaskJob job, ServletResourceHandler<IStatus> statusHandler) throws IOException, ServletException, URISyntaxException, JSONException {
        job.schedule();
        final Object jobIsDone = new Object();
        JobChangeAdapter jobListener = new JobChangeAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void done(IJobChangeEvent event) {
                Object object = jobIsDone;
                synchronized (object) {
                    jobIsDone.notify();
                }
            }
        };
        job.addJobChangeListener((IJobChangeListener)jobListener);
        try {
            Object object = jobIsDone;
            synchronized (object) {
                if (job.getState() != 0) {
                    jobIsDone.wait(100L);
                }
            }
        }
        catch (InterruptedException interruptedException) {}
        job.removeJobChangeListener((IJobChangeListener)jobListener);
        if (job.getState() == 0 || job.getRealResult() != null) {
            return TaskJobHandler.writeResult(request, response, job, statusHandler);
        }
        TaskInfo task = job.startTask();
        JSONObject result = task.toJSON();
        URI taskLocation = TaskJobHandler.createTaskLocation(ServletResourceHandler.getURI(request), task.getId(), task.isKeep());
        result.put("Location", (Object)taskLocation);
        if (!task.isRunning()) {
            job.removeTask();
            return TaskJobHandler.writeResult(request, response, job, statusHandler);
        }
        response.setHeader("Location", ServletResourceHandler.resovleOrionURI(request, taskLocation).toString());
        OrionServlet.writeJSONResponse(request, response, result);
        response.setStatus(202);
        return true;
    }

    private static boolean writeResult(HttpServletRequest request, HttpServletResponse response, TaskJob job, ServletResourceHandler<IStatus> statusHandler) throws ServletException, IOException, JSONException {
        IStatus result = job.getRealResult();
        if (!result.isOK()) {
            return statusHandler.handleRequest(request, response, result);
        }
        if (result instanceof ServerStatus) {
            ServerStatus status = (ServerStatus)result;
            OrionServlet.writeJSONResponse(request, response, status.getJsonData());
            return true;
        }
        OrionServlet.writeJSONResponse(request, response, job.getFinalResult());
        return true;
    }
}

