/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.sftpfile;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.eclipse.orion.internal.server.core.IOUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedChannel {
    private final ChannelSftp inner;

    public SynchronizedChannel(ChannelSftp channel) {
        this.inner = channel;
    }

    public synchronized void disconnect() throws JSchException {
        try {
            this.inner.disconnect();
        }
        finally {
            this.inner.getSession().disconnect();
        }
    }

    synchronized void doPut(InputStream in, String path) throws SftpException {
        this.inner.put(in, path);
    }

    public synchronized InputStream get(String path) throws SftpException, IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        IOUtilities.pipe((InputStream)this.inner.get(path), (OutputStream)bytesOut, (boolean)true, (boolean)true);
        return new ByteArrayInputStream(bytesOut.toByteArray());
    }

    public synchronized String getHome() throws SftpException {
        return this.inner.getHome();
    }

    public synchronized boolean isConnected() {
        return this.inner.isConnected() && !this.inner.isClosed();
    }

    public synchronized Vector<ChannelSftp.LsEntry> ls(String path) throws SftpException {
        Vector result = this.inner.ls(path);
        return result;
    }

    public synchronized void mkdir(String path) throws SftpException {
        this.inner.mkdir(path);
    }

    public synchronized OutputStream put(final String path) {
        final ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        return new OutputStream(){

            public void close() throws IOException {
                try {
                    SynchronizedChannel.this.doPut(new ByteArrayInputStream(bytesOut.toByteArray()), path);
                }
                catch (SftpException e) {
                    throw new IOException(e.getMessage());
                }
            }

            public void write(byte[] b) throws IOException {
                bytesOut.write(b);
            }

            public void write(byte[] b, int off, int len) throws IOException {
                bytesOut.write(b, off, len);
            }

            public void write(int b) throws IOException {
                bytesOut.write(b);
            }
        };
    }

    public synchronized void rm(String path) throws SftpException {
        this.inner.rm(path);
    }

    public synchronized void rmdir(String path) throws SftpException {
        this.inner.rmdir(path);
    }

    public synchronized void setStat(String path, SftpATTRS attr) throws SftpException {
        this.inner.setStat(path, attr);
    }

    public synchronized SftpATTRS stat(String path) throws SftpException {
        return this.inner.stat(path);
    }
}

