/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.util.FS;
import org.eclipse.orion.internal.server.servlets.file.NewFileServlet;

public abstract class BaseToIndexConverter {
    public static final BaseToIndexConverter CLONE = new BaseToIndexConverter(){

        @Override
        public IPath getFilePath(URI base) throws URISyntaxException {
            return new Path(base.getPath()).removeFirstSegments(2).makeRelative();
        }
    };

    public static URI getIndexLocation(URI base, BaseToIndexConverter converter) throws URISyntaxException {
        IPath filePath = converter.getFilePath(base);
        IPath clonePath = BaseToIndexConverter.findClonePath(filePath);
        if (clonePath == null) {
            return null;
        }
        IPath p = new Path("/gitapi").append("index").append("file").append(clonePath).addTrailingSeparator();
        return new URI(base.getScheme(), base.getUserInfo(), base.getHost(), base.getPort(), p.toString(), base.getQuery(), base.getFragment());
    }

    public abstract IPath getFilePath(URI var1) throws URISyntaxException;

    private static IPath findClonePath(IPath filePath) {
        IPath p = filePath.removeFirstSegments(1);
        while (p.segmentCount() > 0) {
            File file;
            IFileStore fileStore = NewFileServlet.getFileStore(null, (IPath)p);
            if (fileStore == null) {
                return null;
            }
            try {
                file = fileStore.toLocalFile(0, null);
            }
            catch (CoreException coreException) {
                return null;
            }
            if (RepositoryCache.FileKey.isGitRepository((File)new File(file, ".git"), (FS)FS.DETECTED)) {
                return p;
            }
            p = p.removeLastSegments(1);
        }
        return null;
    }
}

