/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.jobs;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.git.jobs.GitJob;
import org.eclipse.orion.server.git.objects.Log;
import org.eclipse.orion.server.git.objects.Remote;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONObject;

public class RemoteDetailsJob
extends GitJob {
    private IPath path;
    private URI cloneLocation;
    private int commitsSize;
    private int pageNo;
    private int pageSize;
    private String baseLocation;
    private String configName;

    public RemoteDetailsJob(String userRunningTask, String configName, IPath repositoryPath, URI cloneLocation, int commitsSize, int pageNo, int pageSize, String baseLocation) {
        super(userRunningTask, false);
        this.path = repositoryPath;
        this.cloneLocation = cloneLocation;
        this.commitsSize = commitsSize;
        this.pageNo = pageNo;
        this.pageSize = pageSize;
        this.baseLocation = baseLocation;
        this.configName = configName;
    }

    public RemoteDetailsJob(String userRunningTask, String configName, IPath repositoryPath, URI cloneLocation) {
        this(userRunningTask, configName, repositoryPath, cloneLocation, 0, 0, -1, null);
    }

    public RemoteDetailsJob(String userRunningTask, String configName, IPath repositoryPath, URI cloneLocation, int commitsSize) {
        this(userRunningTask, configName, repositoryPath, cloneLocation, commitsSize, 0, -1, null);
    }

    private ObjectId getCommitObjectId(Repository db, ObjectId oid) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevWalk walk = new RevWalk(db);
        try {
            RevCommit revCommit = walk.parseCommit((AnyObjectId)oid);
            return revCommit;
        }
        finally {
            walk.release();
        }
    }

    protected IStatus performJob() {
        try {
            File gitDir = GitUtils.getGitDir(this.path);
            FileRepository db = new FileRepository(gitDir);
            Git git = new Git((Repository)db);
            Set configNames = db.getConfig().getSubsections("remote");
            for (String configN : configNames) {
                if (!configN.equals(this.configName)) continue;
                Remote remote = new Remote(this.cloneLocation, (Repository)db, configN);
                JSONObject result = remote.toJSON();
                if (!result.has("Children")) {
                    return new ServerStatus(Status.OK_STATUS, 200, result);
                }
                JSONArray children = result.getJSONArray("Children");
                if (children.length() == 0 || this.commitsSize == 0 && this.pageSize < 0) {
                    return new ServerStatus(Status.OK_STATUS, 200, result);
                }
                int firstChild = this.pageSize > 0 ? this.pageSize * (this.pageNo - 1) : 0;
                int lastChild = this.pageSize > 0 ? firstChild + this.pageSize - 1 : children.length() - 1;
                int n = lastChild = lastChild > children.length() - 1 ? children.length() - 1 : lastChild;
                if (this.pageNo > 1 && this.baseLocation != null) {
                    String prev = String.valueOf(this.baseLocation) + "?page=" + (this.pageNo - 1) + "&pageSize=" + this.pageSize;
                    if (this.commitsSize > 0) {
                        prev = String.valueOf(prev) + "&commits=" + this.commitsSize;
                    }
                    result.put("PreviousLocation", (Object)prev);
                }
                if (lastChild < children.length() - 1) {
                    String next = String.valueOf(this.baseLocation) + "?page=" + (this.pageNo + 1) + "&pageSize=" + this.pageSize;
                    if (this.commitsSize > 0) {
                        next = String.valueOf(next) + "&commits=" + this.commitsSize;
                    }
                    result.put("NextLocation", (Object)next);
                }
                JSONArray newChildren = new JSONArray();
                int i = firstChild;
                while (i <= lastChild) {
                    JSONObject branch = children.getJSONObject(i);
                    if (this.commitsSize == 0) {
                        newChildren.put((Object)branch);
                    } else {
                        LogCommand lc = git.log();
                        String branchName = branch.getString("Id");
                        ObjectId toObjectId = db.resolve(branchName);
                        Ref toRefId = db.getRef(branchName);
                        if (toObjectId == null) {
                            String msg = NLS.bind((String)"No ref or commit found: {0}", (Object)branchName);
                            return new ServerStatus(4, 404, msg, null);
                        }
                        toObjectId = this.getCommitObjectId((Repository)db, toObjectId);
                        lc.add((AnyObjectId)toObjectId);
                        lc.setMaxCount(this.commitsSize);
                        Iterable commits = lc.call();
                        Log log = new Log(this.cloneLocation, (Repository)db, commits, null, null, toRefId);
                        log.setPaging(1, this.commitsSize);
                        branch.put("Commit", (Object)log.toJSON());
                        newChildren.put((Object)branch);
                    }
                    ++i;
                }
                result.put("Children", (Object)newChildren);
                return new ServerStatus(Status.OK_STATUS, 200, result);
            }
            String msg = NLS.bind((String)"Couldn't find remote : {0}", (Object)this.configName);
            return new ServerStatus(4, 404, msg, null);
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"Couldn't get remote details : {0}", (Object)this.configName);
            return new Status(4, "org.eclipse.orion.server.git", msg, (Throwable)e);
        }
    }
}

