/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.servlets;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.task.TaskJobHandler;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.tasks.TaskJob;
import org.eclipse.orion.server.git.BaseToCloneConverter;
import org.eclipse.orion.server.git.GitCredentialsProvider;
import org.eclipse.orion.server.git.jobs.FetchJob;
import org.eclipse.orion.server.git.jobs.PushJob;
import org.eclipse.orion.server.git.jobs.RemoteDetailsJob;
import org.eclipse.orion.server.git.objects.Remote;
import org.eclipse.orion.server.git.objects.RemoteBranch;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GitRemoteHandlerV1
extends ServletResourceHandler<String> {
    private ServletResourceHandler<IStatus> statusHandler;
    public static int PAGE_SIZE = 50;

    GitRemoteHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        this.statusHandler = statusHandler;
    }

    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException {
        try {
            switch (GitRemoteHandlerV1.getMethod((HttpServletRequest)request)) {
                case GET: {
                    return this.handleGet(request, response, path);
                }
                case POST: {
                    return this.handlePost(request, response, path);
                }
                case DELETE: {
                    return this.handleDelete(request, response, path);
                }
            }
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"Failed to handle /git/remote request for {0}", (Object)path);
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, msg, (Throwable)e));
        }
        return false;
    }

    private boolean handleGet(HttpServletRequest request, HttpServletResponse response, String path) throws IOException, JSONException, ServletException, URISyntaxException, CoreException {
        Path p = new Path(path);
        if (p.segment(0).equals("file")) {
            File gitDir = GitUtils.getGitDir((IPath)p);
            FileRepository db = new FileRepository(gitDir);
            Set configNames = db.getConfig().getSubsections("remote");
            JSONObject result = new JSONObject();
            JSONArray children = new JSONArray();
            URI cloneLocation = BaseToCloneConverter.getCloneLocation(GitRemoteHandlerV1.getURI((HttpServletRequest)request), BaseToCloneConverter.REMOTE_LIST);
            for (String configName : configNames) {
                Remote remote = new Remote(cloneLocation, (Repository)db, configName);
                children.put((Object)remote.toJSON(false));
            }
            result.put("Children", (Object)children);
            result.put("Type", (Object)"Remote");
            OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result);
            return true;
        }
        if (p.segment(1).equals("file")) {
            RemoteDetailsJob job;
            String commits = request.getParameter("commits");
            int commitsNumber = commits == null ? 0 : Integer.parseInt(commits);
            String page = request.getParameter("page");
            if (page != null) {
                int pageNo = Integer.parseInt(page);
                int pageSize = request.getParameter("pageSize") == null ? PAGE_SIZE : Integer.parseInt(request.getParameter("pageSize"));
                job = new RemoteDetailsJob(TaskJobHandler.getUserId((HttpServletRequest)request), p.segment(0), p.removeFirstSegments(1), BaseToCloneConverter.getCloneLocation(GitRemoteHandlerV1.getURI((HttpServletRequest)request), BaseToCloneConverter.REMOTE), commitsNumber, pageNo, pageSize, request.getRequestURI());
            } else {
                job = new RemoteDetailsJob(TaskJobHandler.getUserId((HttpServletRequest)request), p.segment(0), p.removeFirstSegments(1), BaseToCloneConverter.getCloneLocation(GitRemoteHandlerV1.getURI((HttpServletRequest)request), BaseToCloneConverter.REMOTE), commitsNumber);
            }
            return TaskJobHandler.handleTaskJob((HttpServletRequest)request, (HttpServletResponse)response, (TaskJob)job, this.statusHandler);
        }
        if (p.segment(2).equals("file")) {
            Remote remote;
            File gitDir = GitUtils.getGitDir(p.removeFirstSegments(2));
            FileRepository db = new FileRepository(gitDir);
            URI cloneLocation = BaseToCloneConverter.getCloneLocation(GitRemoteHandlerV1.getURI((HttpServletRequest)request), BaseToCloneConverter.REMOTE_BRANCH);
            RemoteBranch remoteBranch = new RemoteBranch(cloneLocation, (Repository)db, remote = new Remote(cloneLocation, (Repository)db, p.segment(0)), GitUtils.decode(p.segment(1)));
            if (remoteBranch.exists()) {
                JSONObject result = remoteBranch.toJSON();
                OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result);
                return true;
            }
            JSONObject errorData = new JSONObject();
            errorData.put("CloneLocation", (Object)cloneLocation);
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus((IStatus)new Status(4, "org.eclipse.orion.server.git", "No remote branch found: " + p.uptoSegment(2).removeTrailingSeparator()), 404, errorData));
        }
        return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "Bad request, \"/git/remote/{remote}/{branch}/file/{path}\" expected", null));
    }

    private boolean handleDelete(HttpServletRequest request, HttpServletResponse response, String path) throws CoreException, IOException, URISyntaxException, JSONException, ServletException {
        Path p = new Path(path);
        if (p.segment(1).equals("file")) {
            String remoteName = p.segment(0);
            File gitDir = GitUtils.getGitDir(p.removeFirstSegments(1));
            FileRepository db = new FileRepository(gitDir);
            StoredConfig config = db.getConfig();
            config.unsetSection("remote", remoteName);
            config.save();
            return true;
        }
        return false;
    }

    private boolean handlePost(HttpServletRequest request, HttpServletResponse response, String path) throws IOException, JSONException, ServletException, URISyntaxException, CoreException {
        Path p = new Path(path);
        if (p.segment(0).equals("file")) {
            return this.addRemote(request, response, path);
        }
        JSONObject requestObject = OrionServlet.readJSONRequest((HttpServletRequest)request);
        boolean fetch = Boolean.parseBoolean(requestObject.optString("Fetch", null));
        String srcRef = requestObject.optString("PushSrcRef", null);
        boolean tags = requestObject.optBoolean("PushTags", false);
        boolean force = requestObject.optBoolean("Force", false);
        GitCredentialsProvider cp = GitUtils.createGitCredentialsProvider(requestObject);
        if (fetch) {
            return this.fetch(request, response, cp, path, force);
        }
        if (srcRef != null) {
            return this.push(request, response, path, cp, srcRef, tags, force);
        }
        return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "Only Fetch:true is currently supported.", null));
    }

    private boolean addRemote(HttpServletRequest request, HttpServletResponse response, String path) throws IOException, JSONException, ServletException, CoreException, URISyntaxException {
        Path p = new Path(path);
        JSONObject toPut = OrionServlet.readJSONRequest((HttpServletRequest)request);
        String remoteName = toPut.optString("Remote", null);
        if (remoteName == null || remoteName.isEmpty()) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "Remote name must be provided", null));
        }
        String remoteURI = toPut.optString("RemoteURI", null);
        if (remoteURI == null || remoteURI.isEmpty()) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "Remote URI must be provided", null));
        }
        try {
            URIish uri = new URIish(remoteURI);
            String scheme = uri.getScheme();
            if (GitUtils.isForbiddenUriScheme(scheme)) {
                this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, NLS.bind((String)"Remote URI {0} cannot use prohibited scheme {1}", (Object)remoteURI, (Object)scheme), null));
                return false;
            }
        }
        catch (URISyntaxException e) {
            this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, NLS.bind((String)"Invalid remote URI: {0}", (Object)remoteURI), (Throwable)e));
            return false;
        }
        String fetchRefSpec = toPut.optString("FetchRefSpec", null);
        String remotePushURI = toPut.optString("PushURI", null);
        String pushRefSpec = toPut.optString("PushRefSpec", null);
        File gitDir = GitUtils.getGitDir((IPath)p);
        FileRepository db = new FileRepository(gitDir);
        StoredConfig config = db.getConfig();
        RemoteConfig rc = new RemoteConfig((Config)config, remoteName);
        rc.addURI(new URIish(remoteURI));
        if (fetchRefSpec == null || fetchRefSpec.isEmpty()) {
            fetchRefSpec = String.format("+refs/heads/*:refs/remotes/%s/*", remoteName);
        }
        rc.addFetchRefSpec(new RefSpec(fetchRefSpec));
        if (remotePushURI != null && !remotePushURI.isEmpty()) {
            rc.addPushURI(new URIish(remotePushURI));
        }
        if (pushRefSpec != null && !pushRefSpec.isEmpty()) {
            rc.addPushRefSpec(new RefSpec(pushRefSpec));
        }
        rc.update((Config)config);
        config.save();
        URI cloneLocation = BaseToCloneConverter.getCloneLocation(GitRemoteHandlerV1.getURI((HttpServletRequest)request), BaseToCloneConverter.REMOTE_LIST);
        Remote remote = new Remote(cloneLocation, (Repository)db, remoteName);
        JSONObject result = new JSONObject();
        result.put("Location", (Object)remote.getLocation());
        OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result);
        response.setHeader("Location", result.getString("Location"));
        response.setStatus(201);
        return true;
    }

    private boolean fetch(HttpServletRequest request, HttpServletResponse response, GitCredentialsProvider cp, String path, boolean force) throws URISyntaxException, JSONException, IOException, ServletException {
        Path p = new Path(path);
        FetchJob job = new FetchJob(TaskJobHandler.getUserId((HttpServletRequest)request), (CredentialsProvider)cp, p, force);
        return TaskJobHandler.handleTaskJob((HttpServletRequest)request, (HttpServletResponse)response, (TaskJob)job, this.statusHandler);
    }

    private boolean push(HttpServletRequest request, HttpServletResponse response, String path, GitCredentialsProvider cp, String srcRef, boolean tags, boolean force) throws ServletException, CoreException, IOException, JSONException, URISyntaxException {
        Path p = new Path(path);
        if (p.segment(2).equals("file")) {
            PushJob job = new PushJob(TaskJobHandler.getUserId((HttpServletRequest)request), (CredentialsProvider)cp, p, srcRef, tags, force);
            return TaskJobHandler.handleTaskJob((HttpServletRequest)request, (HttpServletResponse)response, (TaskJob)job, this.statusHandler);
        }
        return false;
    }
}

