/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.authentication.openid;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.server.authentication.openid.OpenIdException;
import org.eclipse.orion.server.authentication.openid.OpenIdHelper;
import org.openid4java.OpenIDException;
import org.openid4java.consumer.ConsumerAssociationStore;
import org.openid4java.consumer.ConsumerException;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.InMemoryConsumerAssociationStore;
import org.openid4java.consumer.InMemoryNonceVerifier;
import org.openid4java.consumer.NonceVerifier;
import org.openid4java.consumer.VerificationResult;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.ParameterList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenidConsumer {
    final Logger log = LoggerFactory.getLogger((String)"org.eclipse.orion.server.login");
    private ConsumerManager manager;
    private String returnToUrl;

    public OpenidConsumer(String returnToUrl) throws ConsumerException {
        this.returnToUrl = returnToUrl;
        this.manager = new ConsumerManager();
        this.manager.setAssociations((ConsumerAssociationStore)new InMemoryConsumerAssociationStore());
        this.manager.setNonceVerifier((NonceVerifier)new InMemoryNonceVerifier(5000));
        this.manager.getRealmVerifier().setEnforceRpId(false);
    }

    public String authRequest(String userSuppliedString, HttpServletRequest httpReq, HttpServletResponse httpResp) throws CoreException {
        List discoveries;
        AuthRequest authReq = null;
        try {
            discoveries = this.manager.discover(userSuppliedString);
        }
        catch (DiscoveryException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.authentication", 1, "Could not discover: " + userSuppliedString, (Throwable)e));
        }
        DiscoveryInformation discovered = this.manager.associate(discoveries);
        httpReq.getSession().setAttribute("openid-disc", (Object)discovered);
        try {
            URL returnURL = new URL(this.returnToUrl);
            authReq = this.manager.authenticate(discovered, this.returnToUrl, new URL(returnURL.getProtocol(), returnURL.getHost(), returnURL.getPort(), "").toString());
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.authentication", 1, "An error occured when authenticating request for " + userSuppliedString, (Throwable)e));
        }
        try {
            httpResp.sendRedirect(authReq.getDestinationUrl(true));
            httpResp.flushBuffer();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.authentication", 1, "An error occured when trying to redirect to " + authReq.getDestinationUrl(true), (Throwable)e));
        }
        return null;
    }

    public Identifier verifyResponse(HttpServletRequest httpReq) throws OpenIdException {
        ParameterList response = new ParameterList(httpReq.getParameterMap());
        DiscoveryInformation discovered = (DiscoveryInformation)httpReq.getSession().getAttribute("openid-disc");
        try {
            VerificationResult verification;
            Identifier verified;
            StringBuffer receivingURL = OpenIdHelper.getAuthServerRequest(httpReq);
            String queryString = httpReq.getQueryString();
            if (queryString != null && queryString.length() > 0) {
                receivingURL.append("?").append(httpReq.getQueryString());
            }
            if ((verified = (verification = this.manager.verify(receivingURL.toString(), response, discovered)).getVerifiedId()) != null) {
                AuthSuccess authSuccess = (AuthSuccess)verification.getAuthResponse();
                HttpSession session = httpReq.getSession(true);
                session.setAttribute("openid_identifier", (Object)authSuccess.getIdentity());
                if (this.log.isInfoEnabled()) {
                    this.log.info("Login success: " + verified.getIdentifier());
                }
                return verified;
            }
        }
        catch (OpenIDException e) {
            this.log.error("An error occured when verifyng response.", (Throwable)e);
        }
        if (this.log.isInfoEnabled()) {
            Identifier claimedId;
            Identifier identifier = claimedId = discovered == null ? null : discovered.getClaimedIdentifier();
            if (claimedId != null) {
                this.log.info("Login failed: " + claimedId.getIdentifier());
            } else {
                this.log.info("Login failed: expired OpenID session state");
            }
        }
        return null;
    }
}

