/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.workspace;

import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.internal.server.core.IWebResourceDecorator;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.metastore.ProjectInfo;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ProjectParentDecorator
implements IWebResourceDecorator {
    public void addAtributesFor(HttpServletRequest request, URI resource, JSONObject representation) {
        if (!"/file".equals(request.getServletPath())) {
            return;
        }
        try {
            String projectName;
            URI base = new URI(resource.getScheme(), resource.getUserInfo(), resource.getHost(), resource.getPort(), String.valueOf(request.getServletPath()) + "/", null, null);
            Path basePath = new Path(base.getPath());
            Path resourcePath = new Path(resource.getPath());
            if (resourcePath.hasTrailingSeparator() && !representation.getBoolean("Directory")) {
                resourcePath = resourcePath.append(representation.getString("Name"));
            }
            IPath path = resourcePath.makeRelativeTo((IPath)basePath);
            ProjectInfo project = OrionConfiguration.getMetaStore().readProject(path.segment(0), path.segment(1));
            this.addParents(base, representation, project, path);
            if (path.segmentCount() == 2 && (projectName = project.getFullName()) != null) {
                representation.put("Name", (Object)projectName);
            }
        }
        catch (Exception e) {
            LogHelper.log((Throwable)e);
        }
    }

    private void addParents(URI resource, JSONObject representation, ProjectInfo project, IPath resourcePath) throws JSONException {
        URI uri;
        resourcePath = resourcePath.removeLastSegments(1).addTrailingSeparator();
        JSONArray parents = new JSONArray();
        while (resourcePath.segmentCount() > 2) {
            try {
                uri = resource.resolve(new URI(null, resourcePath.toString(), null));
                this.addParent(parents, resourcePath.lastSegment(), new URI(resource.getScheme(), resource.getAuthority(), uri.getPath(), uri.getQuery(), uri.getFragment()));
            }
            catch (URISyntaxException e) {
                LogHelper.log((Throwable)e);
            }
            resourcePath = resourcePath.removeLastSegments(1);
        }
        if (resourcePath.segmentCount() == 2) {
            try {
                uri = resource.resolve(new URI(null, resourcePath.toString(), null));
                this.addParent(parents, project.getFullName(), new URI(resource.getScheme(), resource.getAuthority(), uri.getPath(), uri.getQuery(), uri.getFragment()));
            }
            catch (URISyntaxException e) {
                LogHelper.log((Throwable)e);
            }
        }
        representation.put("Parents", (Object)parents);
    }

    private void addParent(JSONArray parents, String name, URI location) throws JSONException {
        URI childLocation;
        JSONObject parent = new JSONObject();
        parent.put("Name", (Object)name);
        parent.put("Location", (Object)location);
        try {
            childLocation = new URI(location.getScheme(), location.getUserInfo(), location.getHost(), location.getPort(), location.getPath(), "depth=1", location.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        parent.put("ChildrenLocation", (Object)childLocation);
        parents.put((Object)parent);
    }
}

