/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.servlets;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.internal.server.core.IOUtilities;
import org.eclipse.orion.internal.server.core.IWebResourceDecorator;
import org.eclipse.orion.internal.server.servlets.Activator;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.ServletStatusHandler;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.servlets.JsonURIUnqualificationStrategy;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OrionServlet
extends HttpServlet {
    protected static final boolean DEBUG_VEBOSE = false;
    private static final long serialVersionUID = 1L;
    private static final ServletResourceHandler<IStatus> statusHandler = new ServletStatusHandler();

    private static String prettyPrint(Object result) {
        try {
            if (result instanceof JSONObject) {
                return ((JSONObject)result).toString(2);
            }
        }
        catch (JSONException jSONException) {}
        return result.toString();
    }

    public static void writeJSONResponse(HttpServletRequest req, HttpServletResponse resp, Object result) throws IOException {
        OrionServlet.writeJSONResponse(req, resp, result, JsonURIUnqualificationStrategy.ALL);
    }

    public static void writeJSONResponse(HttpServletRequest req, HttpServletResponse resp, Object result, JsonURIUnqualificationStrategy strategy) throws IOException {
        Assert.isLegal((result instanceof JSONObject || result instanceof JSONArray ? 1 : 0) != 0);
        resp.setCharacterEncoding("UTF-8");
        resp.setStatus(200);
        resp.setHeader("Cache-Control", "no-cache");
        resp.setHeader("Cache-Control", "no-store");
        if (result instanceof JSONObject) {
            OrionServlet.decorateResponse(req, (JSONObject)result);
        }
        strategy.run(req, result);
        resp.setContentType("application/json; charset=UTF-8");
        String response = OrionServlet.prettyPrint(result);
        resp.getWriter().print(response);
        LoggerFactory.getLogger(OrionServlet.class).debug(response);
    }

    public static void decorateResponse(HttpServletRequest req, JSONObject result, JsonURIUnqualificationStrategy strategy) {
        OrionServlet.decorateResponse(req, result);
        strategy.run(req, result);
    }

    public static void decorateResponse(HttpServletRequest req, JSONObject result) {
        Collection<IWebResourceDecorator> decorators = Activator.getDefault().getWebResourceDecorators();
        URI requestURI = ServletResourceHandler.getURI(req);
        for (IWebResourceDecorator decorator : decorators) {
            decorator.addAtributesFor(req, requestURI, result);
        }
    }

    public static JSONObject readJSONRequest(HttpServletRequest request) throws IOException, JSONException {
        StringWriter writer = new StringWriter();
        IOUtilities.pipe((Reader)request.getReader(), (Writer)writer, (boolean)false, (boolean)false);
        String resultString = writer.toString();
        if (resultString.length() == 0) {
            return new JSONObject();
        }
        return new JSONObject(resultString);
    }

    protected ServletResourceHandler<IStatus> getStatusHandler() {
        return statusHandler;
    }

    protected void handleException(HttpServletResponse response, IStatus status) throws ServletException {
        statusHandler.handleRequest(null, response, status);
    }

    protected void handleException(HttpServletResponse response, IStatus status, int httpCode) throws ServletException {
        this.handleException(response, (IStatus)new ServerStatus(status, httpCode));
    }

    protected void handleException(HttpServletResponse resp, String msg, Exception e) throws ServletException {
        this.handleException(resp, msg, e, 500);
    }

    protected void handleException(HttpServletResponse resp, String msg, Exception e, int httpCode) throws ServletException {
        this.handleException(resp, (IStatus)new Status(4, "org.eclipse.orion.server.servlets", msg, (Throwable)e), httpCode);
    }

    protected void printHeaders(HttpServletRequest req, StringBuffer out) {
        for (String header : Collections.list(req.getHeaderNames())) {
            out.append(String.valueOf(header) + ": " + req.getHeader(header) + "\n");
        }
    }

    protected void traceRequest(HttpServletRequest req) {
        StringBuffer result = new StringBuffer(req.getMethod());
        result.append(' ');
        result.append(req.getRequestURI());
        String query = req.getQueryString();
        if (query != null) {
            result.append('?').append(query);
        }
        LoggerFactory.getLogger(OrionServlet.class).debug(result.toString());
    }
}

