/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.user.guest;

import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.internal.server.user.guest.GuestUser;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.useradmin.IOrionGuestCredentialsService;
import org.eclipse.orion.server.useradmin.Role;
import org.eclipse.orion.server.useradmin.User;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.useradmin.Authorization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuestCredentialsService
implements IOrionGuestCredentialsService {
    static final String USER_UID = "uid";
    static final String USER_LOGIN = "login";
    static final String USER_NAME = "name";
    static final String USER_PASSWORD = "password";
    static final String USER_BLOCKED = "blocked";
    static final String USER_EMAIL = "email";
    static final String USER_EMAIL_CONFIRMATION = "email_confirmation";
    static final String USER_ROLES = "roles";
    static final String USER_ROLE_NAME = "name";
    static final String USER_PROPERTIES = "properties";
    private Map<String, User> userTable = new HashMap<String, User>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private User findUser(String uid) {
        Map<String, User> map = this.userTable;
        synchronized (map) {
            return this.userTable.get(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private User internalCreateUser(User user) {
        Map<String, User> map = this.userTable;
        synchronized (map) {
            String uid;
            String login = uid = user.getUid();
            String name = user.getName();
            String password = null;
            GuestUser newUser = new GuestUser(uid, login, name, password);
            this.userTable.put(newUser.getUid(), newUser);
            return this.findUser(newUser.getUid());
        }
    }

    private void internalUpdateUser(User target, User source) {
        if (source.getLogin() != null) {
            target.setLogin(source.getLogin());
        }
        if (source.getName() != null) {
            target.setName(source.getName());
        }
        if (source.getPassword() != null) {
            target.setPassword(source.getPassword());
        }
        target.setBlocked(source.getBlocked());
        if (source.getEmail() != null) {
            if (source.getEmail().length() > 0 && !source.getEmail().equals(target.getEmail())) {
                source.setConfirmationId();
            }
            target.setEmail(source.getEmail());
        }
        Dictionary sourceProperties = source.getProperties();
        Dictionary targetProperties = target.getProperties();
        Enumeration sourceKeys = sourceProperties.keys();
        while (sourceKeys.hasMoreElements()) {
            String property = (String)sourceKeys.nextElement();
            targetProperties.put(property, sourceProperties.get(property));
        }
        Enumeration targetKeys = targetProperties.keys();
        while (targetKeys.hasMoreElements()) {
            String property = (String)targetKeys.nextElement();
            if (sourceProperties.get(property) != null) continue;
            targetProperties.remove(property);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteUser(User user) {
        if (user == null) {
            return false;
        }
        Map<String, User> map = this.userTable;
        synchronized (map) {
            return this.userTable.remove(user.getUid()) != null;
        }
    }

    public IStatus updateUser(String uid, User user) {
        User existingUser = this.findUser(uid);
        if (existingUser == null) {
            return new ServerStatus(4, 404, "User not found: " + uid, null);
        }
        try {
            this.internalUpdateUser(existingUser, user);
            return new Status(0, "org.eclipse.orion.server.user.guest", "User updated " + user.getLogin());
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipse.orion.server.user.guest", 4, "Can not update user: " + user.getLogin(), (Throwable)e);
            LogHelper.log((IStatus)status);
            return status;
        }
    }

    public User createUser(User newUser) {
        try {
            return this.internalCreateUser(newUser);
        }
        catch (Exception e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.core.useradmin", 4, "Cannot create user: " + newUser.getName(), (Throwable)e));
            return null;
        }
    }

    public String getStoreName() {
        return "OrionGuestUserStore";
    }

    public boolean canCreateUsers() {
        return true;
    }

    public Collection<User> getUsers() {
        return this.userTable.values();
    }

    public Role createRole(String name, int type) {
        throw new UnsupportedOperationException();
    }

    public IStatus removeRole(String name) {
        return new Status(4, "org.eclipse.orion.server.core.useradmin", "Removing roles not supported");
    }

    public Role getRole(String name) {
        return null;
    }

    public Role[] getRoles(String filter) throws InvalidSyntaxException {
        return new Role[0];
    }

    public User getUser(String key, String value) {
        if (USER_UID.equals(key)) {
            return this.userTable.get(value);
        }
        if (USER_LOGIN.equals(key)) {
            for (User user : this.userTable.values()) {
                if (!user.getLogin().equals(value)) continue;
                return user;
            }
        }
        return null;
    }

    public Authorization getAuthorization(User user) {
        return null;
    }

    public Set<User> getUsersByProperty(String key, String value, boolean regExp, boolean ignoreCase) {
        return null;
    }
}

