/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.configurator.servlet;

import java.io.IOException;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationService;
import org.eclipse.orion.server.configurator.ConfiguratorActivator;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.authentication.IAuthenticationService;
import org.osgi.framework.Version;

public class AuthorizedUserFilter
implements Filter {
    private IAuthenticationService authenticationService;
    private Properties authProperties;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.authenticationService = ConfiguratorActivator.getDefault().getAuthService();
        if (this.authenticationService == null) {
            String msg = "Authentication service is missing. The server configuration must specify an authentication scheme, or use \"None\" to indicate no authentication";
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.configurator", msg, null));
            throw new ServletException(msg);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String remoteUser = httpRequest.getRemoteUser();
        String userName = remoteUser;
        if (userName == null && (userName = this.authenticationService.getAuthenticatedUser(httpRequest, httpResponse, this.authProperties)) == null) {
            userName = "anonymous";
        }
        try {
            String requestPath = String.valueOf(httpRequest.getServletPath()) + (httpRequest.getPathInfo() == null ? "" : httpRequest.getPathInfo());
            if (!AuthorizationService.checkRights((String)userName, (String)requestPath, (String)httpRequest.getMethod())) {
                if ("anonymous".equals(userName)) {
                    userName = this.authenticationService.authenticateUser(httpRequest, httpResponse, this.authProperties);
                    if (userName == null) {
                        return;
                    }
                } else {
                    this.setNotAuthorized(httpRequest, httpResponse);
                    return;
                }
            }
            if (remoteUser == null && !"anonymous".equals(userName)) {
                request.setAttribute("org.osgi.service.http.authentication.remote.user", (Object)userName);
                request.setAttribute("org.osgi.service.http.authentication.type", (Object)this.authenticationService.getAuthType());
            }
        }
        catch (CoreException coreException) {
            httpResponse.sendError(500);
            return;
        }
        chain.doFilter(request, response);
    }

    private void setNotAuthorized(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String versionString = req.getHeader("Orion-Version");
        Version version = versionString == null ? null : new Version(versionString);
        String xRequestedWith = req.getHeader("X-Requested-With");
        String msg = "You are not authorized to access " + req.getRequestURL();
        if (version == null && !"XMLHttpRequest".equals(xRequestedWith)) {
            resp.sendError(403, msg);
        } else {
            resp.setContentType("application/json; charset=UTF-8");
            ServerStatus serverStatus = new ServerStatus(4, 403, msg, null);
            resp.setStatus(403);
            resp.getWriter().print(serverStatus.toJSON().toString());
        }
    }

    public void destroy() {
    }
}

