/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScreen;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSValue;

class AccessibleTableHeader
extends Accessible {
    public AccessibleTableHeader(Accessible accessible, int childID) {
        super(accessible);
        this.index = childID;
        this.addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getChildren(AccessibleControlEvent e) {
                int validColumnCount = Math.max(1, AccessibleTableHeader.this.parent.getColumnCount());
                Accessible[] children = new Accessible[validColumnCount];
                AccessibleControlEvent event = new AccessibleControlEvent(this);
                for (int i = 0; i < validColumnCount; ++i) {
                    event.childID = i;
                    event.detail = -4;
                    for (int j = 0; j < AccessibleTableHeader.this.parent.accessibleControlListeners.size(); ++j) {
                        AccessibleControlListener listener = (AccessibleControlListener)AccessibleTableHeader.this.parent.accessibleControlListeners.elementAt(j);
                        listener.getChild(event);
                    }
                    event.accessible.parent = AccessibleTableHeader.this;
                    children[i] = event.accessible;
                }
                e.children = children;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = Math.max(1, AccessibleTableHeader.this.parent.getColumnCount());
            }

            public void getLocation(AccessibleControlEvent e) {
                int validColumnCount = Math.max(1, AccessibleTableHeader.this.parent.getColumnCount());
                Accessible[] children = new Accessible[validColumnCount];
                AccessibleControlEvent event = new AccessibleControlEvent(this);
                for (int i = 0; i < validColumnCount; ++i) {
                    event.childID = i;
                    event.detail = -4;
                    for (int j = 0; j < AccessibleTableHeader.this.parent.accessibleControlListeners.size(); ++j) {
                        AccessibleControlListener listener = (AccessibleControlListener)AccessibleTableHeader.this.parent.accessibleControlListeners.elementAt(j);
                        listener.getChild(event);
                    }
                    event.accessible.parent = AccessibleTableHeader.this;
                    children[i] = event.accessible;
                }
                NSValue positionObj = (NSValue)children[0].getPositionAttribute(-1);
                NSPoint position = positionObj.pointValue();
                int height = 0;
                int width = 0;
                for (int j = 0; j < children.length; ++j) {
                    NSValue sizeObj = (NSValue)children[j].getSizeAttribute(-1);
                    NSSize size = sizeObj.sizeValue();
                    if (size.height > (float)height) {
                        height = (int)size.height;
                    }
                    width = (int)((float)width + size.width);
                }
                e.x = (int)position.x;
                NSArray screens = NSScreen.screens();
                NSScreen screen = new NSScreen(screens.objectAtIndex(0));
                NSRect frame = screen.frame();
                e.y = (int)(frame.height - position.y - (float)height);
                e.width = width;
                e.height = height;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 25;
            }
        });
    }
}

