/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleTableAdapter;
import org.eclipse.swt.accessibility.AccessibleTableEvent;
import org.eclipse.swt.accessibility.AccessibleTableListener;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScreen;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSValue;

class AccessibleTableRow
extends Accessible {
    public AccessibleTableRow(Accessible accessible, int childID) {
        super(accessible);
        this.index = childID;
        this.addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = Math.max(1, AccessibleTableRow.this.parent.getColumnCount());
            }

            public void getChildren(AccessibleControlEvent e) {
                int validColumnCount = Math.max(1, AccessibleTableRow.this.parent.getColumnCount());
                Object[] children = new Object[validColumnCount];
                AccessibleTableEvent event = new AccessibleTableEvent(this);
                for (int i = 0; i < validColumnCount; ++i) {
                    event.column = i;
                    event.row = AccessibleTableRow.this.index;
                    for (int j = 0; j < AccessibleTableRow.this.parent.accessibleTableListeners.size(); ++j) {
                        AccessibleTableListener listener = (AccessibleTableListener)AccessibleTableRow.this.parent.accessibleTableListeners.elementAt(j);
                        listener.getCell(event);
                    }
                    if (event.accessible != null) {
                        event.accessible.parent = AccessibleTableRow.this;
                    }
                    children[i] = event.accessible;
                }
                e.children = children;
            }

            public void getLocation(AccessibleControlEvent e) {
                int validColumnCount = Math.max(1, AccessibleTableRow.this.parent.getColumnCount());
                Accessible[] children = new Accessible[validColumnCount];
                AccessibleTableEvent event = new AccessibleTableEvent(this);
                for (int i = 0; i < validColumnCount; ++i) {
                    event.column = i;
                    event.row = AccessibleTableRow.this.index;
                    for (int j = 0; j < AccessibleTableRow.this.parent.accessibleTableListeners.size(); ++j) {
                        AccessibleTableListener listener = (AccessibleTableListener)AccessibleTableRow.this.parent.accessibleTableListeners.elementAt(j);
                        listener.getCell(event);
                    }
                    children[i] = event.accessible;
                }
                NSValue positionObj = (NSValue)children[0].getPositionAttribute(-1);
                NSPoint position = positionObj.pointValue();
                int height = 0;
                int width = 0;
                for (int j = 0; j < children.length; ++j) {
                    NSValue sizeObj = (NSValue)children[j].getSizeAttribute(-1);
                    NSSize size = sizeObj.sizeValue();
                    if (size.height > (float)height) {
                        height = (int)size.height;
                    }
                    width = (int)((float)width + size.width);
                }
                e.x = (int)position.x;
                NSArray screens = NSScreen.screens();
                NSScreen screen = new NSScreen(screens.objectAtIndex(0));
                NSRect frame = screen.frame();
                e.y = (int)(frame.height - position.y - (float)height);
                e.width = width;
                e.height = height;
            }

            public void getRole(AccessibleControlEvent e) {
                int childID = e.childID;
                e.detail = childID == -1 ? 28 : 29;
            }

            public void getFocus(AccessibleControlEvent e) {
                NSNumber focusedObj;
                AccessibleTableEvent event = new AccessibleTableEvent(this);
                event.column = 0;
                event.row = AccessibleTableRow.this.index;
                for (int j = 0; j < AccessibleTableRow.this.parent.accessibleTableListeners.size(); ++j) {
                    AccessibleTableListener listener = (AccessibleTableListener)AccessibleTableRow.this.parent.accessibleTableListeners.elementAt(j);
                    listener.getCell(event);
                }
                e.childID = event.accessible != null ? ((focusedObj = (NSNumber)event.accessible.getFocusedAttribute(-1)).boolValue() ? -1 : -2) : -2;
            }
        });
        this.addAccessibleTableListener(new AccessibleTableAdapter(){

            public void isColumnSelected(AccessibleTableEvent e) {
                e.isSelected = false;
            }

            public void isRowSelected(AccessibleTableEvent e) {
                AccessibleTableEvent event = new AccessibleTableEvent(this);
                event.row = e.row;
                for (int i = 0; i < AccessibleTableRow.this.parent.accessibleTableListeners.size(); ++i) {
                    AccessibleTableListener listener = (AccessibleTableListener)AccessibleTableRow.this.parent.accessibleTableListeners.elementAt(i);
                    listener.isRowSelected(event);
                }
                e.isSelected = event.isSelected;
            }
        });
    }

    void getChildAtPoint(AccessibleControlEvent e) {
        int validColumnCount = Math.max(1, this.parent.getColumnCount());
        Accessible[] children = new Accessible[validColumnCount];
        AccessibleTableEvent event = new AccessibleTableEvent(this);
        for (int i = 0; i < validColumnCount; ++i) {
            event.column = i;
            event.row = this.index;
            for (int j = 0; j < this.parent.accessibleTableListeners.size(); ++j) {
                AccessibleTableListener listener = (AccessibleTableListener)this.parent.accessibleTableListeners.elementAt(j);
                listener.getCell(event);
            }
            children[i] = event.accessible;
        }
        for (int j = 0; j < children.length; ++j) {
            NSValue positionObj = (NSValue)children[j].getPositionAttribute(this.index);
            NSPoint position = positionObj.pointValue();
            NSValue sizeObj = (NSValue)children[j].getSizeAttribute(this.index);
            NSSize size = sizeObj.sizeValue();
            if (!(position.x <= (float)e.x) || !((float)e.x <= position.x + size.width)) continue;
            children[j].parent = this;
            e.accessible = children[j];
            break;
        }
    }
}

