/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSData;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPasteboard;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSURL;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.widgets.Display;

public class Clipboard {
    Display display;
    static /* synthetic */ Class class$org$eclipse$swt$dnd$Clipboard;

    public Clipboard(Display display) {
        this.checkSubclass();
        if (display == null && (display = Display.getCurrent()) == null) {
            display = Display.getDefault();
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        this.display = display;
    }

    protected void checkSubclass() {
        String name = this.getClass().getName();
        String validName = (class$org$eclipse$swt$dnd$Clipboard == null ? (class$org$eclipse$swt$dnd$Clipboard = Clipboard.class$("org.eclipse.swt.dnd.Clipboard")) : class$org$eclipse$swt$dnd$Clipboard).getName();
        if (!validName.equals(name)) {
            DND.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            DND.error(24);
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        if (display.isDisposed()) {
            DND.error(24);
        }
    }

    public void clearContents() {
        this.clearContents(1);
    }

    public void clearContents(int clipboards) {
        this.checkWidget();
        if ((clipboards & 1) == 0) {
            return;
        }
        NSPasteboard pasteboard = NSPasteboard.generalPasteboard();
        if (pasteboard != null) {
            pasteboard.declareTypes(NSMutableArray.arrayWithCapacity(0), null);
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (this.display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        this.display = null;
    }

    public Object getContents(Transfer transfer) {
        return this.getContents(transfer, 1);
    }

    public Object getContents(Transfer transfer, int clipboards) {
        this.checkWidget();
        if (transfer == null) {
            DND.error(4);
        }
        if ((clipboards & 1) == 0) {
            return null;
        }
        NSPasteboard pasteboard = NSPasteboard.generalPasteboard();
        if (pasteboard == null) {
            return null;
        }
        String[] typeNames = transfer.getTypeNames();
        NSMutableArray types = NSMutableArray.arrayWithCapacity(typeNames.length);
        for (int i = 0; i < typeNames.length; ++i) {
            types.addObject(NSString.stringWith(typeNames[i]));
        }
        NSString type = pasteboard.availableTypeFromArray(types);
        if (type != null) {
            TransferData tdata = new TransferData();
            tdata.type = Transfer.registerType(type.getString());
            tdata.data = type.isEqual(OS.NSStringPboardType) || type.isEqual(OS.NSRTFPboardType) || type.isEqual(OS.NSHTMLPboardType) ? pasteboard.stringForType(type) : (type.isEqual(OS.NSFilenamesPboardType) || type.isEqual(OS.kUTTypeFileURL) ? new NSArray(pasteboard.propertyListForType((NSString)OS.NSFilenamesPboardType).id) : (type.isEqual(OS.NSURLPboardType) || type.isEqual(OS.kUTTypeURL) ? NSURL.URLFromPasteboard(pasteboard) : pasteboard.dataForType(type)));
            if (tdata.data != null) {
                return transfer.nativeToJava(tdata);
            }
        }
        return null;
    }

    public boolean isDisposed() {
        return this.display == null;
    }

    public void setContents(Object[] data, Transfer[] dataTypes) {
        this.setContents(data, dataTypes, 1);
    }

    public void setContents(Object[] data, Transfer[] dataTypes, int clipboards) {
        this.checkWidget();
        if (data == null || dataTypes == null || data.length != dataTypes.length || data.length == 0) {
            DND.error(5);
        }
        for (int i = 0; i < data.length; ++i) {
            if (data[i] != null && dataTypes[i] != null && dataTypes[i].validate(data[i])) continue;
            DND.error(5);
        }
        if ((clipboards & 1) == 0) {
            return;
        }
        NSPasteboard pasteboard = NSPasteboard.generalPasteboard();
        if (pasteboard == null) {
            DND.error(2002);
        }
        pasteboard.declareTypes(NSMutableArray.arrayWithCapacity(0), null);
        for (int i = 0; i < dataTypes.length; ++i) {
            String[] typeNames = dataTypes[i].getTypeNames();
            for (int j = 0; j < typeNames.length; ++j) {
                TransferData transferData = new TransferData();
                transferData.type = Transfer.registerType(typeNames[j]);
                dataTypes[i].javaToNative(data[i], transferData);
                NSObject tdata = transferData.data;
                NSString dataType = NSString.stringWith(typeNames[j]);
                pasteboard.addTypes(NSArray.arrayWithObject(dataType), null);
                if (dataType.isEqual(OS.NSStringPboardType) || dataType.isEqual(OS.NSRTFPboardType) || dataType.isEqual(OS.NSHTMLPboardType)) {
                    pasteboard.setString((NSString)tdata, dataType);
                    continue;
                }
                if (dataType.isEqual(OS.NSURLPboardType) || dataType.isEqual(OS.kUTTypeURL)) {
                    NSURL url = (NSURL)tdata;
                    url.writeToPasteboard(pasteboard);
                    continue;
                }
                if (dataType.isEqual(OS.NSFilenamesPboardType) || dataType.isEqual(OS.kUTTypeFileURL)) {
                    pasteboard.setPropertyList((NSArray)tdata, OS.NSFilenamesPboardType);
                    continue;
                }
                pasteboard.setData((NSData)tdata, dataType);
            }
        }
    }

    public TransferData[] getAvailableTypes() {
        return this.getAvailableTypes(1);
    }

    public TransferData[] getAvailableTypes(int clipboards) {
        this.checkWidget();
        if ((clipboards & 1) == 0) {
            return new TransferData[0];
        }
        NSPasteboard pasteboard = NSPasteboard.generalPasteboard();
        if (pasteboard == null) {
            return new TransferData[0];
        }
        NSArray types = pasteboard.types();
        if (types == null) {
            return new TransferData[0];
        }
        int count = types.count();
        TransferData[] result = new TransferData[count];
        for (int i = 0; i < count; ++i) {
            result[i] = new TransferData();
            result[i].type = Transfer.registerType(new NSString(types.objectAtIndex(i)).getString());
        }
        return result;
    }

    public String[] getAvailableTypeNames() {
        this.checkWidget();
        NSPasteboard pasteboard = NSPasteboard.generalPasteboard();
        if (pasteboard == null) {
            return new String[0];
        }
        NSArray types = pasteboard.types();
        if (types == null) {
            return new String[0];
        }
        int count = types.count();
        String[] result = new String[count];
        for (int i = 0; i < count; ++i) {
            result[i] = new NSString(types.objectAtIndex(i)).getString();
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

