/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSGradient;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSThread;

public class Pattern
extends Resource {
    NSColor color;
    NSGradient gradient;
    NSPoint pt1;
    NSPoint pt2;
    Image image;
    float[] color1;
    float[] color2;
    int alpha1;
    int alpha2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Pattern(Device device, Image image) {
        super(device);
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.image = image;
            this.color = NSColor.colorWithPatternImage(image.handle);
            this.color.retain();
            this.init();
            Object var5_4 = null;
            if (pool == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (pool == null) throw throwable;
            pool.release();
            throw throwable;
        }
        pool.release();
    }

    public Pattern(Device device, float x1, float y1, float x2, float y2, Color color1, Color color2) {
        this(device, x1, y1, x2, y2, color1, 255, color2, 255);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Pattern(Device device, float x1, float y1, float x2, float y2, Color color1, int alpha1, Color color2, int alpha2) {
        super(device);
        if (color1 == null) {
            SWT.error(4);
        }
        if (color1.isDisposed()) {
            SWT.error(5);
        }
        if (color2 == null) {
            SWT.error(4);
        }
        if (color2.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.pt1 = new NSPoint();
            this.pt2 = new NSPoint();
            this.pt1.x = x1;
            this.pt1.y = y1;
            this.pt2.x = x2;
            this.pt2.y = y2;
            this.color1 = color1.handle;
            this.color2 = color2.handle;
            this.alpha1 = alpha1;
            this.alpha2 = alpha2;
            NSColor start = NSColor.colorWithDeviceRed(color1.handle[0], color1.handle[1], color1.handle[2], (float)alpha1 / 255.0f);
            NSColor end = NSColor.colorWithDeviceRed(color2.handle[0], color2.handle[1], color2.handle[2], (float)alpha2 / 255.0f);
            this.gradient = ((NSGradient)new NSGradient().alloc()).initWithStartingColor(start, end);
            this.init();
            Object var14_13 = null;
            if (pool == null) return;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            if (pool == null) throw throwable;
            pool.release();
            throw throwable;
        }
        pool.release();
    }

    void destroy() {
        if (this.color != null) {
            this.color.release();
        }
        this.color = null;
        if (this.gradient != null) {
            this.gradient.release();
        }
        this.gradient = null;
        this.image = null;
        this.color2 = null;
        this.color1 = null;
    }

    public boolean isDisposed() {
        return this.device == null;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Pattern {*DISPOSED*}";
        }
        return "Pattern {" + (this.color != null ? this.color.id : this.gradient.id) + "}";
    }
}

