/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSLayoutManager;
import org.eclipse.swt.internal.cocoa.NSMutableAttributedString;
import org.eclipse.swt.internal.cocoa.NSMutableParagraphStyle;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTextAttachment;
import org.eclipse.swt.internal.cocoa.NSTextContainer;
import org.eclipse.swt.internal.cocoa.NSTextStorage;
import org.eclipse.swt.internal.cocoa.NSTextTab;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTTextAttachmentCell;

public final class TextLayout
extends Resource {
    NSTextStorage textStorage;
    NSLayoutManager layoutManager;
    NSTextContainer textContainer;
    Font font;
    String text = "";
    StyleItem[] styles = new StyleItem[2];
    int stylesCount;
    int spacing;
    int ascent = -1;
    int descent = -1;
    int indent;
    int wrapIndent;
    boolean justify;
    int alignment = 16384;
    int[] tabs;
    int[] segments;
    char[] segmentsChars;
    int wrapWidth = -1;
    int orientation = 0x2000000;
    int[] lineOffsets;
    NSRect[] lineBounds;
    static Callback textLayoutCallback2;
    static final byte[] SWT_OBJECT;
    static final int TAB_COUNT = 32;
    static final int UNDERLINE_THICK = 65536;
    static final RGB LINK_FOREGROUND;
    int[] invalidOffsets;
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';

    public TextLayout(Device device) {
        super(device);
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.stylesCount = 2;
        this.init();
    }

    void checkLayout() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    float[] computePolyline(int left, int top, int right, int bottom) {
        int length;
        int height = bottom - top;
        int width = 2 * height;
        int peaks = Compatibility.ceil(right - left, width);
        if (peaks == 0 && right - left > 2) {
            peaks = 1;
        }
        if ((length = (2 * peaks + 1) * 2) < 0) {
            return new float[0];
        }
        float[] coordinates = new float[length];
        for (int i = 0; i < peaks; ++i) {
            int index = 4 * i;
            coordinates[index] = left + width * i;
            coordinates[index + 1] = bottom;
            coordinates[index + 2] = coordinates[index] + (float)(width / 2);
            coordinates[index + 3] = top;
        }
        coordinates[length - 2] = left + width * peaks;
        coordinates[length - 1] = bottom;
        return coordinates;
    }

    void computeRuns() {
        int i;
        if (this.lineBounds != null) {
            return;
        }
        String segmentsText = this.getSegmentsText();
        char[] chars = new char[segmentsText.length()];
        segmentsText.getChars(0, chars.length, chars, 0);
        NSString str = (NSString)new NSString().alloc();
        str = str.initWithCharacters(chars, chars.length);
        NSMutableAttributedString attrStr = (NSMutableAttributedString)new NSMutableAttributedString().alloc();
        attrStr.id = attrStr.initWithString((NSString)str).id;
        str.release();
        attrStr.beginEditing();
        Font defaultFont = this.font != null ? this.font : this.device.systemFont;
        NSRange range = new NSRange();
        range.length = attrStr.length();
        attrStr.addAttribute(OS.NSFontAttributeName, defaultFont.handle, range);
        attrStr.addAttribute(OS.NSLigatureAttributeName, NSNumber.numberWithInt(0), range);
        defaultFont.addTraits(attrStr, range);
        NSMutableParagraphStyle paragraph = (NSMutableParagraphStyle)new NSMutableParagraphStyle().alloc().init();
        int align = 0;
        if (this.wrapWidth != -1) {
            if (this.justify) {
                align = 3;
            } else {
                switch (this.alignment) {
                    case 0x1000000: {
                        align = 2;
                        break;
                    }
                    case 131072: {
                        align = 1;
                    }
                }
            }
        }
        if ((this.orientation & 0x4000000) != 0) {
            paragraph.setBaseWritingDirection(1);
        } else {
            paragraph.setBaseWritingDirection(0);
        }
        paragraph.setAlignment(align);
        paragraph.setLineSpacing(this.spacing);
        paragraph.setFirstLineHeadIndent(this.indent);
        paragraph.setHeadIndent(this.wrapIndent);
        paragraph.setLineBreakMode(this.wrapWidth != -1 ? 0 : 2);
        paragraph.setTabStops(NSArray.array());
        if (this.tabs != null && this.tabs.length > 0) {
            int count = this.tabs.length;
            if (count == 1) {
                paragraph.setDefaultTabInterval(this.tabs[0]);
            } else {
                int pos = 0;
                for (i = 0; i < count; ++i) {
                    pos = this.tabs[i];
                    NSTextTab tab = (NSTextTab)new NSTextTab().alloc();
                    tab = tab.initWithType(0, pos);
                    paragraph.addTabStop(tab);
                    tab.release();
                }
                int width = this.tabs[count - 1] - this.tabs[count - 2];
                while (i < 32) {
                    NSTextTab tab = (NSTextTab)new NSTextTab().alloc();
                    tab = tab.initWithType(0, pos += width);
                    paragraph.addTabStop(tab);
                    tab.release();
                    ++i;
                }
            }
        }
        attrStr.addAttribute(OS.NSParagraphStyleAttributeName, paragraph, range);
        paragraph.release();
        int textLength = attrStr.length();
        for (i = 0; i < this.stylesCount - 1; ++i) {
            NSColor color;
            Color background;
            Color foreground;
            StyleItem run = this.styles[i];
            if (run.style == null) continue;
            TextStyle style = run.style;
            range.location = textLength != 0 ? this.translateOffset(run.start) : 0;
            range.length = this.translateOffset(this.styles[i + 1].start) - range.location;
            Font font = style.font;
            if (font != null) {
                attrStr.addAttribute(OS.NSFontAttributeName, font.handle, range);
                font.addTraits(attrStr, range);
            }
            if ((foreground = style.foreground) != null) {
                NSColor color2 = NSColor.colorWithDeviceRed(foreground.handle[0], foreground.handle[1], foreground.handle[2], 1.0f);
                attrStr.addAttribute(OS.NSForegroundColorAttributeName, color2, range);
            }
            if ((background = style.background) != null) {
                NSColor color3 = NSColor.colorWithDeviceRed(background.handle[0], background.handle[1], background.handle[2], 1.0f);
                attrStr.addAttribute(OS.NSBackgroundColorAttributeName, color3, range);
            }
            if (style.strikeout) {
                attrStr.addAttribute(OS.NSStrikethroughStyleAttributeName, NSNumber.numberWithInt(1), range);
                Color strikeColor = style.strikeoutColor;
                if (strikeColor != null) {
                    color = NSColor.colorWithDeviceRed(strikeColor.handle[0], strikeColor.handle[1], strikeColor.handle[2], 1.0f);
                    attrStr.addAttribute(OS.NSStrikethroughColorAttributeName, color, range);
                }
            }
            if (this.isUnderlineSupported(style)) {
                int underlineStyle = 0;
                switch (style.underlineStyle) {
                    case 0: {
                        underlineStyle = 1;
                        break;
                    }
                    case 1: {
                        underlineStyle = 9;
                        break;
                    }
                    case 65536: {
                        underlineStyle = 2;
                        break;
                    }
                    case 4: {
                        underlineStyle = 1;
                        if (foreground != null) break;
                        color = NSColor.colorWithDeviceRed((float)TextLayout.LINK_FOREGROUND.red / 255.0f, (float)TextLayout.LINK_FOREGROUND.green / 255.0f, (float)TextLayout.LINK_FOREGROUND.blue / 255.0f, 1.0f);
                        attrStr.addAttribute(OS.NSForegroundColorAttributeName, color, range);
                    }
                }
                if (underlineStyle != 0) {
                    attrStr.addAttribute(OS.NSUnderlineStyleAttributeName, NSNumber.numberWithInt(underlineStyle), range);
                    Color underlineColor = style.underlineColor;
                    if (underlineColor != null) {
                        NSColor color4 = NSColor.colorWithDeviceRed(underlineColor.handle[0], underlineColor.handle[1], underlineColor.handle[2], 1.0f);
                        attrStr.addAttribute(OS.NSUnderlineColorAttributeName, color4, range);
                    }
                }
            }
            if (style.rise != 0) {
                attrStr.addAttribute(OS.NSBaselineOffsetAttributeName, NSNumber.numberWithInt(style.rise), range);
            }
            if (style.metrics == null) continue;
            this.initClasses();
            char[] buffer = new char[range.length];
            for (int j = 0; j < buffer.length; ++j) {
                buffer[j] = 65532;
            }
            NSString string = (NSString)new NSString().alloc();
            string = string.initWithCharacters(buffer, buffer.length);
            attrStr.replaceCharactersInRange(range, string);
            string.release();
            run.jniRef = OS.NewGlobalRef(run);
            if (run.jniRef == 0) {
                SWT.error(2);
            }
            run.cell = (SWTTextAttachmentCell)new SWTTextAttachmentCell().alloc().init();
            OS.object_setInstanceVariable(run.cell.id, SWT_OBJECT, run.jniRef);
            NSTextAttachment attachment = ((NSTextAttachment)new NSTextAttachment().alloc()).initWithFileWrapper(null);
            attachment.setAttachmentCell(run.cell);
            attrStr.addAttribute(OS.NSAttachmentAttributeName, attachment, range);
            attachment.release();
        }
        attrStr.endEditing();
        NSSize size = new NSSize();
        size.width = this.wrapWidth != -1 ? (float)this.wrapWidth : 5000000.0f;
        size.height = 5000000.0f;
        if (this.textStorage == null) {
            this.textStorage = (NSTextStorage)new NSTextStorage().alloc().init();
            this.layoutManager = (NSLayoutManager)new NSLayoutManager().alloc().init();
            this.layoutManager.setBackgroundLayoutEnabled(NSThread.isMainThread());
            this.textContainer = (NSTextContainer)new NSTextContainer().alloc();
            this.textContainer = this.textContainer.initWithContainerSize(size);
            this.textContainer.setLineFragmentPadding(0.0f);
            this.textStorage.addLayoutManager(this.layoutManager);
            this.layoutManager.addTextContainer(this.textContainer);
            this.layoutManager.release();
            this.textContainer.release();
        } else {
            this.textContainer.setContainerSize(size);
        }
        this.textStorage.setAttributedString(attrStr);
        attrStr.release();
        this.layoutManager.glyphRangeForTextContainer(this.textContainer);
        int numberOfGlyphs = this.layoutManager.numberOfGlyphs();
        int rangePtr = OS.malloc(NSRange.sizeof);
        NSRange lineRange = new NSRange();
        int numberOfLines = 0;
        int index = 0;
        while (index < numberOfGlyphs) {
            this.layoutManager.lineFragmentUsedRectForGlyphAtIndex(index, rangePtr, true);
            OS.memmove(lineRange, rangePtr, NSRange.sizeof);
            index = lineRange.location + lineRange.length;
            ++numberOfLines;
        }
        if (numberOfLines == 0) {
            ++numberOfLines;
        }
        int[] offsets = new int[numberOfLines + 1];
        NSRect[] bounds = new NSRect[numberOfLines];
        numberOfLines = 0;
        index = 0;
        while (index < numberOfGlyphs) {
            bounds[numberOfLines] = this.layoutManager.lineFragmentUsedRectForGlyphAtIndex(index, rangePtr, true);
            if (numberOfLines < bounds.length - 1) {
                bounds[numberOfLines].height -= (float)this.spacing;
            }
            OS.memmove(lineRange, rangePtr, NSRange.sizeof);
            offsets[numberOfLines] = lineRange.location;
            index = lineRange.location + lineRange.length;
            ++numberOfLines;
        }
        if (numberOfLines == 0) {
            Font font = this.font != null ? this.font : this.device.systemFont;
            NSFont nsFont = font.handle;
            bounds[0] = new NSRect();
            bounds[0].height = Math.max(this.layoutManager.defaultLineHeightForFont(nsFont), (float)(this.ascent + this.descent));
        }
        OS.free(rangePtr);
        offsets[numberOfLines] = this.textStorage.length();
        this.lineOffsets = offsets;
        this.lineBounds = bounds;
    }

    void destroy() {
        this.freeRuns();
        if (this.textStorage != null) {
            this.textStorage.release();
        }
        this.textStorage = null;
        this.layoutManager = null;
        this.textContainer = null;
        this.font = null;
        this.text = null;
        this.styles = null;
        this.segments = null;
        this.segmentsChars = null;
    }

    public void draw(GC gc, int x, int y) {
        this.draw(gc, x, y, -1, -1, null, null);
    }

    public void draw(GC gc, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground) {
        this.draw(gc, x, y, selectionStart, selectionEnd, selectionForeground, selectionBackground, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(GC gc, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground, int flags) {
        this.checkLayout();
        if (gc == null) {
            SWT.error(4);
        }
        if (gc.isDisposed()) {
            SWT.error(5);
        }
        if (selectionForeground != null && selectionForeground.isDisposed()) {
            SWT.error(5);
        }
        if (selectionBackground != null && selectionBackground.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool pool = gc.checkGC(3073);
        try {
            boolean hasSelection;
            this.computeRuns();
            int length = this.translateOffset(this.text.length());
            if (length == 0 && flags == 0) {
                Object var44_11 = null;
                gc.uncheckGC(pool);
                return;
            }
            gc.handle.saveGraphicsState();
            NSPoint pt = new NSPoint();
            pt.x = x;
            pt.y = y;
            NSRange range = new NSRange();
            int numberOfGlyphs = this.layoutManager.numberOfGlyphs();
            if (numberOfGlyphs > 0) {
                range.location = 0;
                range.length = numberOfGlyphs;
                this.layoutManager.drawBackgroundForGlyphRange(range, pt);
            }
            boolean bl = hasSelection = selectionStart <= selectionEnd && selectionStart != -1 && selectionEnd != -1;
            if (hasSelection || (flags & 0x100000) != 0 && (flags & 0x30000) != 0) {
                if (selectionBackground == null) {
                    selectionBackground = this.device.getSystemColor(26);
                }
                NSColor selectionColor = NSColor.colorWithDeviceRed(selectionBackground.handle[0], selectionBackground.handle[1], selectionBackground.handle[2], selectionBackground.handle[3]);
                NSBezierPath path = NSBezierPath.bezierPath();
                NSRect rect = new NSRect();
                if (hasSelection) {
                    range.location = this.translateOffset(selectionStart);
                    range.length = this.translateOffset(selectionEnd - selectionStart + 1);
                    int[] rectCount = new int[1];
                    int pArray = this.layoutManager.rectArrayForCharacterRange(range, range, this.textContainer, rectCount);
                    int k = 0;
                    while (k < rectCount[0]) {
                        OS.memmove(rect, pArray, NSRect.sizeof);
                        this.fixRect(rect);
                        rect.x += pt.x;
                        rect.y += pt.y;
                        rect.height = Math.max(rect.height, (float)(this.ascent + this.descent));
                        path.appendBezierPathWithRect(rect);
                        ++k;
                        pArray += NSRect.sizeof;
                    }
                }
                if ((flags & 0x30000) != 0 && (flags & 0x100000) != 0) {
                    NSRect bounds = this.lineBounds[this.lineBounds.length - 1];
                    rect.x = pt.x + bounds.x + bounds.width;
                    rect.y = (float)y + bounds.y;
                    rect.width = (flags & 0x10000) != 0 ? 2.1474836E9f : bounds.height / 3.0f;
                    rect.height = Math.max(bounds.height, (float)(this.ascent + this.descent));
                    path.appendBezierPathWithRect(rect);
                }
                selectionColor.setFill();
                path.fill();
            }
            if (numberOfGlyphs > 0) {
                boolean defaultFg;
                range.location = 0;
                range.length = numberOfGlyphs;
                float[] fg = gc.data.foreground;
                boolean bl2 = defaultFg = fg[0] == 0.0f && fg[1] == 0.0f && fg[2] == 0.0f && fg[3] == 1.0f && gc.data.alpha == 255;
                if (!defaultFg) {
                    for (int i = 0; i < this.stylesCount - 1; ++i) {
                        StyleItem run = this.styles[i];
                        if (run.style != null && run.style.foreground != null || run.style != null && run.style.underline && run.style.underlineStyle == 4) continue;
                        range.location = length != 0 ? this.translateOffset(run.start) : 0;
                        range.length = this.translateOffset(this.styles[i + 1].start) - range.location;
                        this.layoutManager.addTemporaryAttribute(OS.NSForegroundColorAttributeName, gc.data.fg, range);
                    }
                }
                range.location = 0;
                range.length = numberOfGlyphs;
                this.layoutManager.drawGlyphsForGlyphRange(range, pt);
                if (!defaultFg) {
                    range.location = 0;
                    range.length = length;
                    this.layoutManager.removeTemporaryAttribute(OS.NSForegroundColorAttributeName, range);
                }
                NSPoint point = new NSPoint();
                for (int j = 0; j < this.stylesCount; ++j) {
                    StyleItem run = this.styles[j];
                    TextStyle style = run.style;
                    if (style == null) continue;
                    boolean drawUnderline = style.underline && !this.isUnderlineSupported(style);
                    drawUnderline = drawUnderline && (j + 1 == this.stylesCount || !style.isAdherentUnderline(this.styles[j + 1].style));
                    boolean drawBorder = style.borderStyle != 0;
                    boolean bl3 = drawBorder = drawBorder && (j + 1 == this.stylesCount || !style.isAdherentBorder(this.styles[j + 1].style));
                    if (!drawUnderline && !drawBorder) continue;
                    int end = j + 1 < this.stylesCount ? this.translateOffset(this.styles[j + 1].start - 1) : length;
                    for (int i = 0; i < this.lineOffsets.length - 1; ++i) {
                        NSBezierPath path;
                        NSRect rect;
                        int pArray;
                        int k;
                        int start;
                        int lineStart = this.untranslateOffset(this.lineOffsets[i]);
                        int lineEnd = this.untranslateOffset(this.lineOffsets[i + 1] - 1);
                        if (drawUnderline) {
                            start = run.start;
                            for (k = j; k > 0 && style.isAdherentUnderline(this.styles[k - 1].style); --k) {
                                start = this.styles[k - 1].start;
                            }
                            if ((start = this.translateOffset(start)) <= lineEnd && end >= lineStart) {
                                range.location = Math.max(lineStart, start);
                                range.length = Math.min(lineEnd, end) + 1 - range.location;
                                if (range.length > 0) {
                                    int[] rectCount = new int[1];
                                    pArray = this.layoutManager.rectArrayForCharacterRange(range, range, this.textContainer, rectCount);
                                    rect = new NSRect();
                                    gc.handle.saveGraphicsState();
                                    float baseline = this.layoutManager.typesetter().baselineOffsetInLayoutManager(this.layoutManager, lineStart);
                                    float[] color = null;
                                    if (style.underlineColor != null) {
                                        color = style.underlineColor.handle;
                                    }
                                    if (color == null && style.foreground != null) {
                                        color = style.foreground.handle;
                                    }
                                    if (color != null) {
                                        NSColor.colorWithDeviceRed(color[0], color[1], color[2], color[3]).setStroke();
                                    }
                                    int k2 = 0;
                                    while (k2 < rectCount[0]) {
                                        OS.memmove(rect, pArray, NSRect.sizeof);
                                        this.fixRect(rect);
                                        float underlineX = pt.x + rect.x;
                                        float underlineY = pt.y + rect.y + rect.height - baseline + 1.0f;
                                        path = NSBezierPath.bezierPath();
                                        switch (style.underlineStyle) {
                                            case 2: {
                                                path.setLineWidth(2.0f);
                                                path.setLineCapStyle(1);
                                                path.setLineJoinStyle(1);
                                                path.setLineDash(new float[]{1.0f, 3.0f}, 2, 0.0f);
                                                point.x = underlineX;
                                                point.y = underlineY + 0.5f;
                                                path.moveToPoint(point);
                                                point.x = underlineX + rect.width;
                                                point.y = underlineY + 0.5f;
                                                path.lineToPoint(point);
                                                break;
                                            }
                                            case 3: {
                                                gc.handle.setShouldAntialias(false);
                                                path.setLineWidth(1.0f);
                                                path.setLineCapStyle(0);
                                                path.setLineJoinStyle(0);
                                                float lineBottom = pt.y + rect.y + rect.height;
                                                float squigglyThickness = 1.0f;
                                                float squigglyHeight = 2.0f * squigglyThickness;
                                                float squigglyY = Math.min(underlineY - squigglyHeight / 2.0f, lineBottom - squigglyHeight - 1.0f);
                                                float[] points = this.computePolyline((int)underlineX, (int)squigglyY, (int)(underlineX + rect.width), (int)(squigglyY + squigglyHeight));
                                                point.x = points[0] + 0.5f;
                                                point.y = points[1] + 0.5f;
                                                path.moveToPoint(point);
                                                for (int p = 2; p < points.length; p += 2) {
                                                    point.x = points[p] + 0.5f;
                                                    point.y = points[p + 1] + 0.5f;
                                                    path.lineToPoint(point);
                                                }
                                                break;
                                            }
                                        }
                                        path.stroke();
                                        ++k2;
                                        pArray += NSRect.sizeof;
                                    }
                                    gc.handle.restoreGraphicsState();
                                }
                            }
                        }
                        if (!drawBorder) continue;
                        start = run.start;
                        for (k = j; k > 0 && style.isAdherentBorder(this.styles[k - 1].style); --k) {
                            start = this.styles[k - 1].start;
                        }
                        if ((start = this.translateOffset(start)) > lineEnd || end < lineStart) continue;
                        range.location = Math.max(lineStart, start);
                        range.length = Math.min(lineEnd, end) + 1 - range.location;
                        if (range.length <= 0) continue;
                        int[] rectCount = new int[1];
                        pArray = this.layoutManager.rectArrayForCharacterRange(range, range, this.textContainer, rectCount);
                        rect = new NSRect();
                        gc.handle.saveGraphicsState();
                        float[] color = null;
                        if (style.borderColor != null) {
                            color = style.borderColor.handle;
                        }
                        if (color == null && style.foreground != null) {
                            color = style.foreground.handle;
                        }
                        if (color != null) {
                            NSColor.colorWithDeviceRed(color[0], color[1], color[2], color[3]).setStroke();
                        }
                        boolean width = true;
                        float[] dashes = null;
                        switch (style.borderStyle) {
                            case 1: {
                                break;
                            }
                            case 2: {
                                dashes = width ? GC.LINE_DASH : GC.LINE_DASH_ZERO;
                                break;
                            }
                            case 4: {
                                dashes = width ? GC.LINE_DOT : GC.LINE_DOT_ZERO;
                            }
                        }
                        float[] lengths = null;
                        if (dashes != null) {
                            lengths = new float[dashes.length];
                            for (int k3 = 0; k3 < lengths.length; ++k3) {
                                lengths[k3] = !width ? dashes[k3] : dashes[k3] * (float)width;
                            }
                        }
                        int k4 = 0;
                        while (k4 < rectCount[0]) {
                            OS.memmove(rect, pArray, NSRect.sizeof);
                            this.fixRect(rect);
                            rect.x += pt.x + 0.5f;
                            rect.y += pt.y + 0.5f;
                            rect.width -= 0.5f;
                            rect.height -= 0.5f;
                            path = NSBezierPath.bezierPath();
                            path.setLineDash(lengths, lengths != null ? lengths.length : 0, 0.0f);
                            path.appendBezierPathWithRect(rect);
                            path.stroke();
                            ++k4;
                            pArray += NSRect.sizeof;
                        }
                        gc.handle.restoreGraphicsState();
                    }
                }
            }
            gc.handle.restoreGraphicsState();
        }
        catch (Throwable throwable) {
            Object var44_13 = null;
            gc.uncheckGC(pool);
            throw throwable;
        }
        Object var44_12 = null;
        gc.uncheckGC(pool);
    }

    void fixRect(NSRect rect) {
        float right = -1.0f;
        for (int j = 0; j < this.lineBounds.length; ++j) {
            NSRect line = this.lineBounds[j];
            if (!(rect.y <= line.y) || !(line.y <= rect.y + rect.height)) continue;
            right = Math.max(right, line.x + line.width);
        }
        if (right != -1.0f && rect.x + rect.width > right) {
            rect.width = right - rect.x;
        }
    }

    void freeRuns() {
        this.lineBounds = null;
        this.lineOffsets = null;
        for (int i = 0; i < this.stylesCount - 1; ++i) {
            StyleItem run = this.styles[i];
            if (run.cell == null) continue;
            OS.object_setInstanceVariable(run.cell.id, SWT_OBJECT, 0);
            run.cell.release();
            run.cell = null;
            OS.DeleteGlobalRef(run.jniRef);
            run.jniRef = 0;
        }
    }

    public int getAlignment() {
        this.checkLayout();
        return this.alignment;
    }

    public int getAscent() {
        this.checkLayout();
        return this.ascent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getBounds() {
        Rectangle rectangle;
        block5: {
            this.checkLayout();
            NSAutoreleasePool pool = null;
            if (!NSThread.isMainThread()) {
                pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                this.computeRuns();
                NSRect rect = this.layoutManager.usedRectForTextContainer(this.textContainer);
                if (this.wrapWidth != -1) {
                    rect.width = this.wrapWidth;
                }
                if (this.text.length() == 0) {
                    Font font = this.font != null ? this.font : this.device.systemFont;
                    NSFont nsFont = font.handle;
                    rect.height = this.layoutManager.defaultLineHeightForFont(nsFont);
                }
                rect.height = Math.max(rect.height, (float)(this.ascent + this.descent)) + (float)this.spacing;
                rectangle = new Rectangle(0, 0, (int)Math.ceil(rect.width), (int)Math.ceil(rect.height));
                Object var6_5 = null;
                if (pool == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var6_6 = null;
                    if (pool == null) break block6;
                    pool.release();
                }
                throw throwable;
            }
            pool.release();
        }
        return rectangle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getBounds(int start, int end) {
        Rectangle rectangle;
        block10: {
            int length;
            NSAutoreleasePool pool;
            block8: {
                Rectangle rectangle2;
                block9: {
                    block6: {
                        Rectangle rectangle3;
                        block7: {
                            this.checkLayout();
                            pool = null;
                            if (!NSThread.isMainThread()) {
                                pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                            }
                            this.computeRuns();
                            length = this.text.length();
                            if (length != 0) break block6;
                            rectangle3 = new Rectangle(0, 0, 0, 0);
                            Object var15_8 = null;
                            if (pool == null) break block7;
                            pool.release();
                        }
                        return rectangle3;
                    }
                    if (start <= end) break block8;
                    rectangle2 = new Rectangle(0, 0, 0, 0);
                    Object var15_9 = null;
                    if (pool == null) break block9;
                    pool.release();
                }
                return rectangle2;
            }
            try {
                start = Math.min(Math.max(0, start), length - 1);
                end = Math.min(Math.max(0, end), length - 1);
                start = this.translateOffset(start);
                end = this.translateOffset(end);
                NSRange range = new NSRange();
                range.location = start;
                range.length = end - start + 1;
                int[] rectCount = new int[1];
                int pArray = this.layoutManager.rectArrayForCharacterRange(range, range, this.textContainer, rectCount);
                NSRect rect = new NSRect();
                int left = Integer.MAX_VALUE;
                int right = 0;
                int top = Integer.MAX_VALUE;
                int bottom = 0;
                int i = 0;
                while (i < rectCount[0]) {
                    OS.memmove(rect, pArray, NSRect.sizeof);
                    this.fixRect(rect);
                    left = Math.min(left, (int)rect.x);
                    right = Math.max(right, (int)Math.ceil(rect.x + rect.width));
                    top = Math.min(top, (int)rect.y);
                    bottom = Math.max(bottom, (int)Math.ceil(rect.y + rect.height));
                    ++i;
                    pArray += NSRect.sizeof;
                }
                rectangle = new Rectangle(left, top, right - left, bottom - top);
                Object var15_10 = null;
                if (pool == null) break block10;
            }
            catch (Throwable throwable) {
                block11: {
                    Object var15_11 = null;
                    if (pool == null) break block11;
                    pool.release();
                }
                throw throwable;
            }
            pool.release();
        }
        return rectangle;
    }

    public int getDescent() {
        this.checkLayout();
        return this.descent;
    }

    public Font getFont() {
        this.checkLayout();
        return this.font;
    }

    public int getIndent() {
        this.checkLayout();
        return this.indent;
    }

    public boolean getJustify() {
        this.checkLayout();
        return this.justify;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLevel(int offset) {
        byte by;
        block4: {
            this.checkLayout();
            NSAutoreleasePool pool = null;
            if (!NSThread.isMainThread()) {
                pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                this.computeRuns();
                int length = this.text.length();
                if (0 > offset || offset > length) {
                    SWT.error(6);
                }
                offset = this.translateOffset(offset);
                int glyphOffset = this.layoutManager.glyphIndexForCharacterAtIndex(offset);
                NSRange range = new NSRange();
                range.location = glyphOffset;
                range.length = 1;
                byte[] bidiLevels = new byte[1];
                this.layoutManager.getGlyphsInRange(range, 0, 0, 0, 0, bidiLevels);
                by = bidiLevels[0];
                Object var9_8 = null;
                if (pool == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var9_9 = null;
                    if (pool == null) break block5;
                    pool.release();
                }
                throw throwable;
            }
            pool.release();
        }
        return by;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getLineOffsets() {
        int[] nArray;
        block4: {
            this.checkLayout();
            NSAutoreleasePool pool = null;
            if (!NSThread.isMainThread()) {
                pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                this.computeRuns();
                int[] offsets = new int[this.lineOffsets.length];
                for (int i = 0; i < offsets.length; ++i) {
                    offsets[i] = this.untranslateOffset(this.lineOffsets[i]);
                }
                nArray = offsets;
                Object var5_5 = null;
                if (pool == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var5_6 = null;
                    if (pool == null) break block5;
                    pool.release();
                }
                throw throwable;
            }
            pool.release();
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getLineIndex(int offset) {
        int n;
        NSAutoreleasePool pool;
        block6: {
            int n2;
            block5: {
                this.checkLayout();
                pool = null;
                if (!NSThread.isMainThread()) {
                    pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                }
                try {
                    this.computeRuns();
                    int length = this.text.length();
                    if (0 > offset || offset > length) {
                        SWT.error(6);
                    }
                    offset = this.translateOffset(offset);
                    for (int line = 0; line < this.lineOffsets.length - 1; ++line) {
                        if (this.lineOffsets[line + 1] <= offset) continue;
                        n2 = line;
                        Object var7_6 = null;
                        if (pool == null) return n2;
                        break block5;
                    }
                    n = this.lineBounds.length - 1;
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    if (pool == null) throw throwable;
                    pool.release();
                    throw throwable;
                }
            }
            pool.release();
            return n2;
        }
        Object var7_7 = null;
        if (pool == null) return n;
        pool.release();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getLineBounds(int lineIndex) {
        Rectangle rectangle;
        block4: {
            this.checkLayout();
            NSAutoreleasePool pool = null;
            if (!NSThread.isMainThread()) {
                pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                this.computeRuns();
                if (0 > lineIndex || lineIndex >= this.lineBounds.length) {
                    SWT.error(6);
                }
                NSRect rect = this.lineBounds[lineIndex];
                int height = Math.max((int)Math.ceil(rect.height), this.ascent + this.descent);
                rectangle = new Rectangle((int)rect.x, (int)rect.y, (int)Math.ceil(rect.width), height);
                Object var7_6 = null;
                if (pool == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var7_7 = null;
                    if (pool == null) break block5;
                    pool.release();
                }
                throw throwable;
            }
            pool.release();
        }
        return rectangle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineCount() {
        int n;
        block3: {
            this.checkLayout();
            NSAutoreleasePool pool = null;
            if (!NSThread.isMainThread()) {
                pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                this.computeRuns();
                n = this.lineOffsets.length - 1;
                Object var4_3 = null;
                if (pool == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var4_4 = null;
                    if (pool == null) break block4;
                    pool.release();
                }
                throw throwable;
            }
            pool.release();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FontMetrics getLineMetrics(int lineIndex) {
        FontMetrics fontMetrics;
        block7: {
            NSAutoreleasePool pool;
            block5: {
                FontMetrics fontMetrics2;
                block6: {
                    this.checkLayout();
                    pool = null;
                    if (!NSThread.isMainThread()) {
                        pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                    }
                    try {
                        int length;
                        this.computeRuns();
                        int lineCount = this.getLineCount();
                        if (0 > lineIndex || lineIndex >= lineCount) {
                            SWT.error(6);
                        }
                        if ((length = this.text.length()) != 0) break block5;
                        Font font = this.font != null ? this.font : this.device.systemFont;
                        int ascent = (int)this.layoutManager.defaultBaselineOffsetForFont(font.handle);
                        int descent = (int)this.layoutManager.defaultLineHeightForFont(font.handle) - ascent;
                        ascent = Math.max(ascent, this.ascent);
                        descent = Math.max(descent, this.descent);
                        fontMetrics2 = FontMetrics.cocoa_new(ascent, descent, 0, 0, ascent + descent);
                        Object var10_12 = null;
                        if (pool == null) break block6;
                    }
                    catch (Throwable throwable) {
                        block8: {
                            Object var10_14 = null;
                            if (pool == null) break block8;
                            pool.release();
                        }
                        throw throwable;
                    }
                    pool.release();
                }
                return fontMetrics2;
            }
            Rectangle rect = this.getLineBounds(lineIndex);
            int baseline = (int)this.layoutManager.typesetter().baselineOffsetInLayoutManager(this.layoutManager, this.getLineOffsets()[lineIndex]);
            fontMetrics = FontMetrics.cocoa_new(rect.height - baseline, baseline, 0, 0, rect.height);
            Object var10_13 = null;
            if (pool == null) break block7;
            pool.release();
        }
        return fontMetrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point getLocation(int offset, boolean trailing) {
        Point point;
        block13: {
            NSAutoreleasePool pool;
            block11: {
                Point point2;
                block12: {
                    int length;
                    block9: {
                        Point point3;
                        block10: {
                            this.checkLayout();
                            pool = null;
                            if (!NSThread.isMainThread()) {
                                pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                            }
                            try {
                                this.computeRuns();
                                length = this.text.length();
                                if (0 > offset || offset > length) {
                                    SWT.error(6);
                                }
                                if (length != 0) break block9;
                                point3 = new Point(0, 0);
                                Object var16_8 = null;
                                if (pool == null) break block10;
                            }
                            catch (Throwable throwable) {
                                block14: {
                                    Object var16_11 = null;
                                    if (pool == null) break block14;
                                    pool.release();
                                }
                                throw throwable;
                            }
                            pool.release();
                        }
                        return point3;
                    }
                    if (offset != length) break block11;
                    NSRect rect = this.lineBounds[this.lineBounds.length - 1];
                    point2 = new Point((int)(rect.x + rect.width), (int)rect.y);
                    Object var16_9 = null;
                    if (pool == null) break block12;
                    pool.release();
                }
                return point2;
            }
            offset = this.translateOffset(offset);
            int glyphIndex = this.layoutManager.glyphIndexForCharacterAtIndex(offset);
            NSRect rect = this.layoutManager.lineFragmentUsedRectForGlyphAtIndex(glyphIndex, 0);
            NSPoint point4 = this.layoutManager.locationForGlyphAtIndex(glyphIndex);
            boolean rtl = false;
            NSRange range = new NSRange();
            range.location = glyphIndex;
            range.length = 1;
            byte[] bidiLevels = new byte[1];
            int result = this.layoutManager.getGlyphsInRange(range, 0, 0, 0, 0, bidiLevels);
            if (result > 0) {
                boolean bl = rtl = (bidiLevels[0] & 1) != 0;
            }
            if (trailing != rtl) {
                int[] rectCount = new int[1];
                int pArray = this.layoutManager.rectArrayForGlyphRange(range, range, this.textContainer, rectCount);
                if (rectCount[0] > 0) {
                    NSRect bounds = new NSRect();
                    OS.memmove(bounds, pArray, NSRect.sizeof);
                    this.fixRect(bounds);
                    point4.x += bounds.width;
                }
            }
            point = new Point((int)point4.x, (int)rect.y);
            Object var16_10 = null;
            if (pool == null) break block13;
            pool.release();
        }
        return point;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextOffset(int offset, int movement) {
        int n;
        block3: {
            NSAutoreleasePool pool = null;
            if (!NSThread.isMainThread()) {
                pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                n = this._getOffset(offset, movement, true);
                Object var6_5 = null;
                if (pool == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var6_6 = null;
                    if (pool == null) break block4;
                    pool.release();
                }
                throw throwable;
            }
            pool.release();
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int _getOffset(int offset, int movement, boolean forward) {
        int step;
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (0 > offset || offset > length) {
            SWT.error(6);
        }
        if (forward && offset == length) {
            return length;
        }
        if (!forward && offset == 0) {
            return 0;
        }
        int n = step = forward ? 1 : -1;
        if ((movement & 1) != 0) {
            return offset + step;
        }
        switch (movement) {
            case 2: {
                char ch;
                if (0 > (offset += step) || offset >= length || '\udc00' > (ch = this.text.charAt(offset)) || ch > '\udfff' || offset <= 0 || '\ud800' > (ch = this.text.charAt(offset - 1)) || ch > '\udbff') return offset;
                offset += step;
                return offset;
            }
            case 4: {
                offset = this.translateOffset(offset);
                offset = this.textStorage.nextWordFromIndex(offset, forward);
                return this.untranslateOffset(offset);
            }
            case 8: {
                offset = this.translateOffset(offset);
                if (forward) {
                    offset = this.textStorage.nextWordFromIndex(offset, true);
                    return this.untranslateOffset(offset);
                } else {
                    length = this.translateOffset(length);
                    int result = 0;
                    while (result < length) {
                        int wordEnd = this.textStorage.nextWordFromIndex(result, true);
                        if (wordEnd >= offset) {
                            offset = result;
                            return this.untranslateOffset(offset);
                        }
                        result = wordEnd;
                    }
                }
                return this.untranslateOffset(offset);
            }
            case 16: {
                offset = this.translateOffset(offset);
                if (forward) {
                    int result = this.translateOffset(length);
                    while (result > 0) {
                        int wordStart = this.textStorage.nextWordFromIndex(result, false);
                        if (wordStart <= offset) {
                            offset = result;
                            return this.untranslateOffset(offset);
                        }
                        result = wordStart;
                    }
                    return this.untranslateOffset(offset);
                }
                offset = this.textStorage.nextWordFromIndex(offset, false);
                return this.untranslateOffset(offset);
            }
        }
        return offset;
    }

    public int getOffset(Point point, int[] trailing) {
        this.checkLayout();
        if (point == null) {
            SWT.error(4);
        }
        return this.getOffset(point.x, point.y, trailing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOffset(int x, int y, int[] trailing) {
        int n;
        block9: {
            int length;
            NSAutoreleasePool pool;
            block7: {
                int n2;
                block8: {
                    this.checkLayout();
                    pool = null;
                    if (!NSThread.isMainThread()) {
                        pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                    }
                    try {
                        this.computeRuns();
                        if (trailing != null && trailing.length < 1) {
                            SWT.error(5);
                        }
                        if ((length = this.text.length()) != 0) break block7;
                        n2 = 0;
                        Object var12_8 = null;
                        if (pool == null) break block8;
                    }
                    catch (Throwable throwable) {
                        block10: {
                            Object var12_10 = null;
                            if (pool == null) break block10;
                            pool.release();
                        }
                        throw throwable;
                    }
                    pool.release();
                }
                return n2;
            }
            NSPoint pt = new NSPoint();
            pt.x = x;
            pt.y = y;
            float[] partialFraction = new float[1];
            int glyphIndex = this.layoutManager.glyphIndexForPoint(pt, this.textContainer, partialFraction);
            int offset = this.layoutManager.characterIndexForGlyphAtIndex(glyphIndex);
            offset = Math.min(this.untranslateOffset(offset), length - 1);
            if (trailing != null) {
                char ch;
                trailing[0] = Math.round(partialFraction[0]);
                if ((double)partialFraction[0] >= 0.5 && '\ud800' <= (ch = this.text.charAt(offset)) && ch <= '\udbff' && offset + 1 < length && '\udc00' <= (ch = this.text.charAt(offset + 1)) && ch <= '\udfff') {
                    trailing[0] = trailing[0] + 1;
                }
            }
            n = offset;
            Object var12_9 = null;
            if (pool == null) break block9;
            pool.release();
        }
        return n;
    }

    public int getOrientation() {
        this.checkLayout();
        return this.orientation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPreviousOffset(int offset, int movement) {
        int n;
        block3: {
            NSAutoreleasePool pool = null;
            if (!NSThread.isMainThread()) {
                pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                n = this._getOffset(offset, movement, false);
                Object var6_5 = null;
                if (pool == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var6_6 = null;
                    if (pool == null) break block4;
                    pool.release();
                }
                throw throwable;
            }
            pool.release();
        }
        return n;
    }

    public int[] getRanges() {
        this.checkLayout();
        int[] result = new int[this.stylesCount * 2];
        int count = 0;
        for (int i = 0; i < this.stylesCount - 1; ++i) {
            if (this.styles[i].style == null) continue;
            result[count++] = this.styles[i].start;
            result[count++] = this.styles[i + 1].start - 1;
        }
        if (count != result.length) {
            int[] newResult = new int[count];
            System.arraycopy(result, 0, newResult, 0, count);
            result = newResult;
        }
        return result;
    }

    public int[] getSegments() {
        this.checkLayout();
        return this.segments;
    }

    public char[] getSegmentsChars() {
        this.checkLayout();
        return this.segmentsChars;
    }

    String getSegmentsText() {
        int separator;
        int defaultSeparator;
        int length = this.text.length();
        if (length == 0) {
            return this.text;
        }
        if (this.segments == null) {
            return this.text;
        }
        int nSegments = this.segments.length;
        if (nSegments == 0) {
            return this.text;
        }
        if (this.segmentsChars == null) {
            if (nSegments == 1) {
                return this.text;
            }
            if (nSegments == 2 && this.segments[0] == 0 && this.segments[1] == length) {
                return this.text;
            }
        }
        char[] oldChars = new char[length];
        this.text.getChars(0, length, oldChars, 0);
        char[] newChars = new char[length + nSegments];
        int charCount = 0;
        int segmentCount = 0;
        int n = defaultSeparator = this.orientation == 0x4000000 ? 8207 : 8206;
        while (charCount < length) {
            if (segmentCount < nSegments && charCount == this.segments[segmentCount]) {
                separator = this.segmentsChars != null && this.segmentsChars.length > segmentCount ? this.segmentsChars[segmentCount] : defaultSeparator;
                newChars[charCount + segmentCount++] = separator;
                continue;
            }
            newChars[charCount + segmentCount] = oldChars[charCount++];
        }
        while (segmentCount < nSegments) {
            this.segments[segmentCount] = charCount;
            separator = this.segmentsChars != null && this.segmentsChars.length > segmentCount ? this.segmentsChars[segmentCount] : defaultSeparator;
            newChars[charCount + segmentCount++] = separator;
        }
        return new String(newChars, 0, newChars.length);
    }

    public int getSpacing() {
        this.checkLayout();
        return this.spacing;
    }

    public TextStyle getStyle(int offset) {
        this.checkLayout();
        int length = this.text.length();
        if (0 > offset || offset >= length) {
            SWT.error(6);
        }
        for (int i = 1; i < this.stylesCount; ++i) {
            StyleItem item = this.styles[i];
            if (item.start <= offset) continue;
            return this.styles[i - 1].style;
        }
        return null;
    }

    public TextStyle[] getStyles() {
        this.checkLayout();
        TextStyle[] result = new TextStyle[this.stylesCount];
        int count = 0;
        for (int i = 0; i < this.stylesCount; ++i) {
            if (this.styles[i].style == null) continue;
            result[count++] = this.styles[i].style;
        }
        if (count != result.length) {
            TextStyle[] newResult = new TextStyle[count];
            System.arraycopy(result, 0, newResult, 0, count);
            result = newResult;
        }
        return result;
    }

    public int[] getTabs() {
        this.checkLayout();
        return this.tabs;
    }

    public String getText() {
        this.checkLayout();
        return this.text;
    }

    public int getWidth() {
        this.checkLayout();
        return this.wrapWidth;
    }

    public int getWrapIndent() {
        this.checkLayout();
        return this.wrapIndent;
    }

    void initClasses() {
        String className = "SWTTextAttachmentCell";
        if (OS.objc_lookUpClass(className) != 0) {
            return;
        }
        textLayoutCallback2 = new Callback(this.getClass(), "textLayoutProc", 2);
        int proc2 = textLayoutCallback2.getAddress();
        if (proc2 == 0) {
            SWT.error(3);
        }
        int cellBaselineOffsetProc = OS.CALLBACK_cellBaselineOffset(proc2);
        int cellSizeProc = OS.CALLBACK_NSTextAttachmentCell_cellSize(proc2);
        byte[] types = new byte[]{42, 0};
        int size = C.PTR_SIZEOF;
        int align = C.PTR_SIZEOF == 4 ? 2 : 3;
        int cls = OS.objc_allocateClassPair(OS.class_NSCell, className, 0);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addProtocol(cls, OS.protocol_NSTextAttachmentCell);
        OS.class_addMethod(cls, OS.sel_cellSize, cellSizeProc, "@:");
        OS.class_addMethod(cls, OS.sel_cellBaselineOffset, cellBaselineOffsetProc, "@:");
        OS.objc_registerClassPair(cls);
    }

    public boolean isDisposed() {
        return this.device == null;
    }

    boolean isUnderlineSupported(TextStyle style) {
        if (style != null && style.underline) {
            int uStyle = style.underlineStyle;
            return uStyle == 0 || uStyle == 1 || uStyle == 4 || uStyle == 65536;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAlignment(int alignment) {
        this.checkLayout();
        int mask = 16924672;
        if ((alignment &= mask) == 0) {
            return;
        }
        if ((alignment & 0x4000) != 0) {
            alignment = 16384;
        }
        if ((alignment & 0x20000) != 0) {
            alignment = 131072;
        }
        if (this.alignment == alignment) {
            return;
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.alignment = alignment;
            Object var5_4 = null;
            if (pool == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (pool == null) throw throwable;
            pool.release();
            throw throwable;
        }
        pool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAscent(int ascent) {
        this.checkLayout();
        if (ascent < -1) {
            SWT.error(5);
        }
        if (this.ascent == ascent) {
            return;
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.ascent = ascent;
            Object var4_3 = null;
            if (pool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (pool == null) throw throwable;
            pool.release();
            throw throwable;
        }
        pool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setDescent(int descent) {
        this.checkLayout();
        if (descent < -1) {
            SWT.error(5);
        }
        if (this.descent == descent) {
            return;
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.descent = descent;
            Object var4_3 = null;
            if (pool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (pool == null) throw throwable;
            pool.release();
            throw throwable;
        }
        pool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setFont(Font font) {
        Font oldFont;
        this.checkLayout();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if ((oldFont = this.font) == font) {
            return;
        }
        this.font = font;
        if (oldFont != null && oldFont.equals(font)) {
            return;
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            Object var5_4 = null;
            if (pool == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (pool == null) throw throwable;
            pool.release();
            throw throwable;
        }
        pool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setIndent(int indent) {
        this.checkLayout();
        if (indent < 0) {
            return;
        }
        if (this.indent == indent) {
            return;
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.indent = indent;
            Object var4_3 = null;
            if (pool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (pool == null) throw throwable;
            pool.release();
            throw throwable;
        }
        pool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setWrapIndent(int wrapIndent) {
        this.checkLayout();
        if (wrapIndent < 0) {
            return;
        }
        if (this.wrapIndent == wrapIndent) {
            return;
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.wrapIndent = wrapIndent;
            Object var4_3 = null;
            if (pool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (pool == null) throw throwable;
            pool.release();
            throw throwable;
        }
        pool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setJustify(boolean justify) {
        this.checkLayout();
        if (justify == this.justify) {
            return;
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.justify = justify;
            Object var4_3 = null;
            if (pool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (pool == null) throw throwable;
            pool.release();
            throw throwable;
        }
        pool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setOrientation(int orientation) {
        this.checkLayout();
        int mask = 0x6000000;
        if ((orientation &= mask) == 0) {
            return;
        }
        if ((orientation & 0x2000000) != 0) {
            orientation = 0x2000000;
        }
        if (this.orientation == orientation) {
            return;
        }
        this.orientation = orientation;
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            Object var5_4 = null;
            if (pool == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (pool == null) throw throwable;
            pool.release();
            throw throwable;
        }
        pool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSegments(int[] segments) {
        this.checkLayout();
        if (this.segments == null && segments == null) {
            return;
        }
        if (this.segments != null && segments != null && this.segments.length == segments.length) {
            int i;
            for (i = 0; i < segments.length && this.segments[i] == segments[i]; ++i) {
            }
            if (i == segments.length) {
                return;
            }
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.segments = segments;
            Object var4_4 = null;
            if (pool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (pool == null) throw throwable;
            pool.release();
            throw throwable;
        }
        pool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSegmentsChars(char[] segmentsChars) {
        this.checkLayout();
        if (this.segmentsChars == null && segmentsChars == null) {
            return;
        }
        if (this.segmentsChars != null && segmentsChars != null && this.segmentsChars.length == segmentsChars.length) {
            int i;
            for (i = 0; i < segmentsChars.length && this.segmentsChars[i] == segmentsChars[i]; ++i) {
            }
            if (i == segmentsChars.length) {
                return;
            }
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.segmentsChars = segmentsChars;
            Object var4_4 = null;
            if (pool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (pool == null) throw throwable;
            pool.release();
            throw throwable;
        }
        pool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSpacing(int spacing) {
        this.checkLayout();
        if (spacing < 0) {
            SWT.error(5);
        }
        if (this.spacing == spacing) {
            return;
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.spacing = spacing;
            Object var4_3 = null;
            if (pool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (pool == null) throw throwable;
            pool.release();
            throw throwable;
        }
        pool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setStyle(TextStyle style, int start, int end) {
        NSAutoreleasePool pool;
        block27: {
            block26: {
                block25: {
                    block24: {
                        block23: {
                            block22: {
                                block21: {
                                    this.checkLayout();
                                    pool = null;
                                    if (!NSThread.isMainThread()) {
                                        pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                                    }
                                    try {
                                        int newLength;
                                        int modifyStart;
                                        int modifyEnd;
                                        int length = this.text.length();
                                        if (length == 0) {
                                            Object var16_6 = null;
                                            if (pool == null) return;
                                            break block21;
                                        }
                                        if (start > end) {
                                            break block22;
                                        }
                                        start = Math.min(Math.max(0, start), length - 1);
                                        end = Math.min(Math.max(0, end), length - 1);
                                        int low = -1;
                                        int high = this.stylesCount;
                                        while (high - low > 1) {
                                            int index = (high + low) / 2;
                                            if (this.styles[index + 1].start > start) {
                                                high = index;
                                                continue;
                                            }
                                            low = index;
                                        }
                                        if (0 <= high && high < this.stylesCount) {
                                            StyleItem item = this.styles[high];
                                            if (item.start == start && this.styles[high + 1].start - 1 == end) {
                                                if (style == null) {
                                                    if (item.style == null) {
                                                        break block23;
                                                    }
                                                } else if (style.equals(item.style)) {
                                                    break block24;
                                                }
                                            }
                                        }
                                        this.freeRuns();
                                        for (modifyEnd = modifyStart = high; modifyEnd < this.stylesCount && this.styles[modifyEnd + 1].start <= end; ++modifyEnd) {
                                        }
                                        if (modifyStart == modifyEnd) {
                                            int styleStart = this.styles[modifyStart].start;
                                            int styleEnd = this.styles[modifyEnd + 1].start - 1;
                                            if (styleStart == start && styleEnd == end) {
                                                this.styles[modifyStart].style = style;
                                                break block25;
                                            }
                                            if (styleStart != start && styleEnd != end) {
                                                int newLength2 = this.stylesCount + 2;
                                                if (newLength2 > this.styles.length) {
                                                    int newSize = Math.min(newLength2 + 1024, Math.max(64, newLength2 * 2));
                                                    StyleItem[] newStyles = new StyleItem[newSize];
                                                    System.arraycopy(this.styles, 0, newStyles, 0, this.stylesCount);
                                                    this.styles = newStyles;
                                                }
                                                System.arraycopy(this.styles, modifyEnd + 1, this.styles, modifyEnd + 3, this.stylesCount - modifyEnd - 1);
                                                StyleItem item = new StyleItem();
                                                item.start = start;
                                                item.style = style;
                                                this.styles[modifyStart + 1] = item;
                                                item = new StyleItem();
                                                item.start = end + 1;
                                                item.style = this.styles[modifyStart].style;
                                                this.styles[modifyStart + 2] = item;
                                                this.stylesCount = newLength2;
                                                break block26;
                                            }
                                        }
                                        if (start == this.styles[modifyStart].start) {
                                            --modifyStart;
                                        }
                                        if (end == this.styles[modifyEnd + 1].start - 1) {
                                            ++modifyEnd;
                                        }
                                        if ((newLength = this.stylesCount + 1 - (modifyEnd - modifyStart - 1)) > this.styles.length) {
                                            int newSize = Math.min(newLength + 1024, Math.max(64, newLength * 2));
                                            StyleItem[] newStyles = new StyleItem[newSize];
                                            System.arraycopy(this.styles, 0, newStyles, 0, this.stylesCount);
                                            this.styles = newStyles;
                                        }
                                        System.arraycopy(this.styles, modifyEnd, this.styles, modifyStart + 2, this.stylesCount - modifyEnd);
                                        StyleItem item = new StyleItem();
                                        item.start = start;
                                        item.style = style;
                                        this.styles[modifyStart + 1] = item;
                                        this.styles[modifyStart + 2].start = end + 1;
                                        this.stylesCount = newLength;
                                        break block27;
                                    }
                                    catch (Throwable throwable) {
                                        Object var16_13 = null;
                                        if (pool == null) throw throwable;
                                        pool.release();
                                        throw throwable;
                                    }
                                }
                                pool.release();
                                return;
                            }
                            Object var16_7 = null;
                            if (pool == null) return;
                            pool.release();
                            return;
                        }
                        Object var16_8 = null;
                        if (pool == null) return;
                        pool.release();
                        return;
                    }
                    Object var16_9 = null;
                    if (pool == null) return;
                    pool.release();
                    return;
                }
                Object var16_10 = null;
                if (pool == null) return;
                pool.release();
                return;
            }
            Object var16_11 = null;
            if (pool == null) return;
            pool.release();
            return;
        }
        Object var16_12 = null;
        if (pool == null) return;
        pool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTabs(int[] tabs) {
        this.checkLayout();
        if (this.tabs == null && tabs == null) {
            return;
        }
        if (this.tabs != null && tabs != null && this.tabs.length == tabs.length) {
            int i;
            for (i = 0; i < tabs.length && this.tabs[i] == tabs[i]; ++i) {
            }
            if (i == tabs.length) {
                return;
            }
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.tabs = tabs;
            Object var4_4 = null;
            if (pool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (pool == null) throw throwable;
            pool.release();
            throw throwable;
        }
        pool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setText(String text) {
        this.checkLayout();
        if (text == null) {
            SWT.error(4);
        }
        if (text.equals(this.text)) {
            return;
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.text = text;
            this.styles = new StyleItem[2];
            this.styles[0] = new StyleItem();
            this.styles[1] = new StyleItem();
            this.styles[1].start = text.length();
            this.stylesCount = 2;
            Object var4_3 = null;
            if (pool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (pool == null) throw throwable;
            pool.release();
            throw throwable;
        }
        pool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setWidth(int width) {
        this.checkLayout();
        if (width < -1 || width == 0) {
            SWT.error(5);
        }
        if (this.wrapWidth == width) {
            return;
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.wrapWidth = width;
            Object var4_3 = null;
            if (pool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (pool == null) throw throwable;
            pool.release();
            throw throwable;
        }
        pool.release();
    }

    public String toString() {
        if (this.isDisposed()) {
            return "TextLayout {*DISPOSED*}";
        }
        return "TextLayout {" + this.text + "}";
    }

    static int textLayoutProc(int id2, int sel) {
        int[] jniRef = new int[1];
        OS.object_getInstanceVariable(id2, SWT_OBJECT, jniRef);
        if (jniRef[0] == 0) {
            return 0;
        }
        StyleItem run = (StyleItem)OS.JNIGetObject(jniRef[0]);
        if (run == null) {
            return 0;
        }
        TextStyle style = run.style;
        if (style == null) {
            return 0;
        }
        GlyphMetrics metrics = style.metrics;
        if (metrics == null) {
            return 0;
        }
        if (sel == OS.sel_cellSize) {
            NSSize size = new NSSize();
            size.width = metrics.width;
            size.height = metrics.ascent + metrics.descent;
            int result = OS.malloc(NSSize.sizeof);
            OS.memmove(result, size, NSSize.sizeof);
            return result;
        }
        if (sel == OS.sel_cellBaselineOffset) {
            NSPoint point = new NSPoint();
            point.y = -metrics.descent;
            int result = OS.malloc(NSPoint.sizeof);
            OS.memmove(result, point, NSPoint.sizeof);
            return result;
        }
        return 0;
    }

    int translateOffset(int offset) {
        int length = this.text.length();
        if (length == 0) {
            return offset;
        }
        if (this.segments == null) {
            return offset;
        }
        int nSegments = this.segments.length;
        if (nSegments == 0) {
            return offset;
        }
        if (this.segmentsChars == null) {
            if (nSegments == 1) {
                return offset;
            }
            if (nSegments == 2 && this.segments[0] == 0 && this.segments[1] == length) {
                return offset;
            }
        }
        for (int i = 0; i < nSegments && offset - i >= this.segments[i]; ++i) {
            ++offset;
        }
        return offset;
    }

    int untranslateOffset(int offset) {
        int length = this.text.length();
        if (length == 0) {
            return offset;
        }
        if (this.segments == null) {
            return offset;
        }
        int nSegments = this.segments.length;
        if (nSegments == 0) {
            return offset;
        }
        if (this.segmentsChars == null) {
            if (nSegments == 1) {
                return offset;
            }
            if (nSegments == 2 && this.segments[0] == 0 && this.segments[1] == length) {
                return offset;
            }
        }
        for (int i = 0; i < nSegments && offset > this.segments[i]; --offset, ++i) {
        }
        return offset;
    }

    static {
        SWT_OBJECT = new byte[]{83, 87, 84, 95, 79, 66, 74, 69, 67, 84, 0};
        LINK_FOREGROUND = new RGB(0, 51, 153);
    }

    static class StyleItem {
        TextStyle style;
        int start;
        int jniRef;
        NSCell cell;

        StyleItem() {
        }

        public String toString() {
            return "StyleItem {" + this.start + ", " + this.style + "}";
        }
    }
}

