/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSAffineTransformStruct;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSThread;

public class Transform
extends Resource {
    public NSAffineTransform handle;

    public Transform(Device device) {
        this(device, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
    }

    public Transform(Device device, float[] elements) {
        this(device, Transform.checkTransform(elements)[0], elements[1], elements[2], elements[3], elements[4], elements[5]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Transform(Device device, float m11, float m12, float m21, float m22, float dx, float dy) {
        super(device);
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.handle = NSAffineTransform.transform();
            if (this.handle == null) {
                SWT.error(2);
            }
            this.handle.retain();
            this.setElements(m11, m12, m21, m22, dx, dy);
            this.init();
            Object var10_9 = null;
            if (pool == null) return;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (pool == null) throw throwable;
            pool.release();
            throw throwable;
        }
        pool.release();
    }

    static float[] checkTransform(float[] elements) {
        if (elements == null) {
            SWT.error(4);
        }
        if (elements.length < 6) {
            SWT.error(5);
        }
        return elements;
    }

    void destroy() {
        this.handle.release();
        this.handle = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void getElements(float[] elements) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (elements == null) {
            SWT.error(4);
        }
        if (elements.length < 6) {
            SWT.error(5);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSAffineTransformStruct struct = this.handle.transformStruct();
            elements[0] = struct.m11;
            elements[1] = struct.m12;
            elements[2] = struct.m21;
            elements[3] = struct.m22;
            elements[4] = struct.tX;
            elements[5] = struct.tY;
            Object var5_4 = null;
            if (pool == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (pool == null) throw throwable;
            pool.release();
            throw throwable;
        }
        pool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void identity() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSAffineTransformStruct struct = new NSAffineTransformStruct();
            struct.m11 = 1.0f;
            struct.m22 = 1.0f;
            this.handle.setTransformStruct(struct);
            Object var4_3 = null;
            if (pool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (pool == null) throw throwable;
            pool.release();
            throw throwable;
        }
        pool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void invert() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSAffineTransformStruct struct = this.handle.transformStruct();
            if (struct.m11 * struct.m22 - struct.m12 * struct.m21 == 0.0f) {
                SWT.error(10);
            }
            this.handle.invert();
            Object var4_3 = null;
            if (pool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (pool == null) throw throwable;
            pool.release();
            throw throwable;
        }
        pool.release();
    }

    public boolean isDisposed() {
        return this.handle == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIdentity() {
        boolean bl;
        block4: {
            if (this.isDisposed()) {
                SWT.error(44);
            }
            NSAutoreleasePool pool = null;
            if (!NSThread.isMainThread()) {
                pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                NSAffineTransformStruct struct = this.handle.transformStruct();
                bl = struct.m11 == 1.0f && struct.m12 == 0.0f && struct.m21 == 0.0f && struct.m22 == 1.0f && struct.tX == 0.0f && struct.tY == 0.0f;
                Object var5_4 = null;
                if (pool == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var5_5 = null;
                    if (pool == null) break block5;
                    pool.release();
                }
                throw throwable;
            }
            pool.release();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void multiply(Transform matrix) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (matrix == null) {
            SWT.error(4);
        }
        if (matrix.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.handle.prependTransform(matrix.handle);
            Object var4_3 = null;
            if (pool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (pool == null) throw throwable;
            pool.release();
            throw throwable;
        }
        pool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void rotate(float angle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.handle.rotateByDegrees(angle);
            Object var4_3 = null;
            if (pool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (pool == null) throw throwable;
            pool.release();
            throw throwable;
        }
        pool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void scale(float scaleX, float scaleY) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.handle.scaleXBy(scaleX, scaleY);
            Object var5_4 = null;
            if (pool == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (pool == null) throw throwable;
            pool.release();
            throw throwable;
        }
        pool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setElements(float m11, float m12, float m21, float m22, float dx, float dy) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSAffineTransformStruct struct = new NSAffineTransformStruct();
            struct.m11 = m11;
            struct.m12 = m12;
            struct.m21 = m21;
            struct.m22 = m22;
            struct.tX = dx;
            struct.tY = dy;
            this.handle.setTransformStruct(struct);
            Object var10_9 = null;
            if (pool == null) return;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (pool == null) throw throwable;
            pool.release();
            throw throwable;
        }
        pool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void shear(float shearX, float shearY) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSAffineTransformStruct struct = new NSAffineTransformStruct();
            struct.m11 = 1.0f;
            struct.m12 = shearX;
            struct.m21 = shearY;
            struct.m22 = 1.0f;
            NSAffineTransform matrix = NSAffineTransform.transform();
            matrix.setTransformStruct(struct);
            this.handle.prependTransform(matrix);
            Object var7_6 = null;
            if (pool == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (pool == null) throw throwable;
            pool.release();
            throw throwable;
        }
        pool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void transform(float[] pointArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSPoint point = new NSPoint();
            int length = pointArray.length / 2;
            int i = 0;
            int j = 0;
            while (i < length) {
                point.x = pointArray[j];
                point.y = pointArray[j + 1];
                point = this.handle.transformPoint(point);
                pointArray[j] = point.x;
                pointArray[j + 1] = point.y;
                ++i;
                j += 2;
            }
            Object var8_7 = null;
            if (pool == null) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (pool == null) throw throwable;
            pool.release();
            throw throwable;
        }
        pool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void translate(float offsetX, float offsetY) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.handle.translateXBy(offsetX, offsetY);
            Object var5_4 = null;
            if (pool == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (pool == null) throw throwable;
            pool.release();
            throw throwable;
        }
        pool.release();
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Transform {*DISPOSED*}";
        }
        float[] elements = new float[6];
        this.getElements(elements);
        return "Transform {" + elements[0] + ", " + elements[1] + ", " + elements[2] + ", " + elements[3] + ", " + elements[4] + ", " + elements[5] + "}";
    }
}

