/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.cocoa.NSData;
import org.eclipse.swt.internal.cocoa.NSKeyedArchiver;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSPrintInfo;
import org.eclipse.swt.internal.cocoa.NSPrintPanel;
import org.eclipse.swt.internal.cocoa.NSPrinter;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTPrintPanelDelegate;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PrintDialog
extends Dialog {
    PrinterData printerData = new PrinterData();
    int returnCode;
    static Callback dialogCallback5;
    static final byte[] SWT_OBJECT;
    static final String SET_MODAL_DIALOG = "org.eclipse.swt.internal.modalDialog";
    static /* synthetic */ Class class$org$eclipse$swt$printing$PrintDialog;

    public PrintDialog(Shell parent) {
        this(parent, 32768);
    }

    public PrintDialog(Shell parent, int style) {
        super(parent, PrintDialog.checkStyle(parent, style));
        this.checkSubclass();
    }

    static int checkStyle(Shell parent, int style) {
        int mask = 229376;
        if ((style & 0x10000000) != 0) {
            if (PrintDialog.getSheetEnabled()) {
                if (parent == null) {
                    style &= 0xEFFFFFFF;
                }
            } else {
                style &= 0xEFFFFFFF;
            }
            if ((style & mask) == 0) {
                style |= parent == null ? 65536 : 32768;
            }
        }
        return style;
    }

    public void setPrinterData(PrinterData data) {
        if (data == null) {
            data = new PrinterData();
        }
        this.printerData = data;
    }

    public PrinterData getPrinterData() {
        return this.printerData;
    }

    public PrinterData open() {
        int response;
        Display display;
        NSPrinter printer;
        PrinterData data = null;
        NSPrintPanel panel = NSPrintPanel.printPanel();
        NSPrintInfo printInfo = new NSPrintInfo(NSPrintInfo.sharedPrintInfo().copy());
        if (this.printerData.duplex != -1) {
            int settings = printInfo.PMPrintSettings();
            int duplex = this.printerData.duplex == 2 ? 3 : (this.printerData.duplex == 1 ? 2 : 1);
            OS.PMSetDuplex(settings, duplex);
        }
        printInfo.updateFromPMPrintSettings();
        if (this.printerData.name != null && (printer = NSPrinter.printerWithName(NSString.stringWith(this.printerData.name))) != null) {
            printInfo.setPrinter(printer);
        }
        NSMutableDictionary dict = printInfo.dictionary();
        dict.setValue(NSNumber.numberWithBool(this.printerData.collate), OS.NSPrintMustCollate);
        dict.setValue(NSNumber.numberWithInt(this.printerData.copyCount), OS.NSPrintCopies);
        dict.setValue(NSNumber.numberWithInt(this.printerData.orientation == 2 ? 1 : 0), OS.NSPrintOrientation);
        if (this.printerData.printToFile) {
            dict.setValue(OS.NSPrintSaveJob, OS.NSPrintJobDisposition);
        }
        if (this.printerData.fileName != null && this.printerData.fileName.length() > 0) {
            dict.setValue(NSString.stringWith(this.printerData.fileName), OS.NSPrintSavePath);
        }
        dict.setValue(NSNumber.numberWithBool(this.printerData.scope == 0), OS.NSPrintAllPages);
        if (this.printerData.scope == 1) {
            dict.setValue(NSNumber.numberWithInt(this.printerData.startPage), OS.NSPrintFirstPage);
            dict.setValue(NSNumber.numberWithInt(this.printerData.endPage), OS.NSPrintLastPage);
        }
        panel.setOptions(0x100 | panel.options());
        Shell parent = this.getParent();
        Display display2 = display = parent != null ? parent.getDisplay() : Display.getCurrent();
        if ((this.getStyle() & 0x10000000) != 0) {
            this.initClasses();
            SWTPrintPanelDelegate delegate = (SWTPrintPanelDelegate)new SWTPrintPanelDelegate().alloc().init();
            int jniRef = OS.NewGlobalRef(this);
            if (jniRef == 0) {
                SWT.error(2);
            }
            OS.object_setInstanceVariable(delegate.id, SWT_OBJECT, jniRef);
            this.returnCode = -1;
            panel.beginSheetWithPrintInfo(printInfo, parent.view.window(), delegate, OS.sel_panelDidEnd_returnCode_contextInfo_, 0);
            while (this.returnCode == -1) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            if (delegate != null) {
                delegate.release();
            }
            if (jniRef != 0) {
                OS.DeleteGlobalRef(jniRef);
            }
            response = this.returnCode;
        } else {
            display.setData(SET_MODAL_DIALOG, this);
            response = panel.runModalWithPrintInfo(printInfo);
        }
        display.setData(SET_MODAL_DIALOG, null);
        if (response != 0) {
            NSPrinter printer2 = printInfo.printer();
            NSString str = printer2.name();
            data = new PrinterData("Mac", str.getString());
            data.printToFile = printInfo.jobDisposition().isEqual(OS.NSPrintSaveJob);
            if (data.printToFile) {
                NSString filename = new NSString(dict.objectForKey(OS.NSPrintSavePath));
                data.fileName = filename.getString();
            }
            int n = data.scope = new NSNumber(dict.objectForKey(OS.NSPrintAllPages)).intValue() != 0 ? 0 : 1;
            if (data.scope == 1) {
                data.startPage = new NSNumber(dict.objectForKey(OS.NSPrintFirstPage)).intValue();
                data.endPage = new NSNumber(dict.objectForKey(OS.NSPrintLastPage)).intValue();
            }
            data.collate = new NSNumber(dict.objectForKey(OS.NSPrintMustCollate)).intValue() != 0;
            data.collate = false;
            data.copyCount = new NSNumber(dict.objectForKey(OS.NSPrintCopies)).intValue();
            data.copyCount = 1;
            data.orientation = new NSNumber(dict.objectForKey(OS.NSPrintOrientation)).intValue() == 1 ? 2 : 1;
            int settings = printInfo.PMPrintSettings();
            int[] outDuplexSetting = new int[1];
            OS.PMGetDuplex(settings, outDuplexSetting);
            data.duplex = outDuplexSetting[0] == 3 ? 2 : (outDuplexSetting[0] == 2 ? 1 : 0);
            NSData nsData = NSKeyedArchiver.archivedDataWithRootObject(printInfo);
            data.otherData = new byte[nsData.length()];
            OS.memmove(data.otherData, nsData.bytes(), data.otherData.length);
            this.printerData = data;
        }
        printInfo.release();
        return data;
    }

    public int getScope() {
        return this.printerData.scope;
    }

    static boolean getSheetEnabled() {
        return !"false".equals(System.getProperty("org.eclipse.swt.sheet"));
    }

    static int dialogProc(int id2, int sel, int arg0, int arg1, int arg2) {
        int[] jniRef = new int[1];
        OS.object_getInstanceVariable(id2, SWT_OBJECT, jniRef);
        if (jniRef[0] == 0) {
            return 0;
        }
        if (sel == OS.sel_panelDidEnd_returnCode_contextInfo_) {
            PrintDialog dialog = (PrintDialog)OS.JNIGetObject(jniRef[0]);
            if (dialog == null) {
                return 0;
            }
            dialog.panelDidEnd_returnCode_contextInfo(id2, sel, arg0, arg1, arg2);
        }
        return 0;
    }

    void initClasses() {
        String className = "SWTPrintPanelDelegate";
        if (OS.objc_lookUpClass(className) != 0) {
            return;
        }
        dialogCallback5 = new Callback(this.getClass(), "dialogProc", 5);
        int dialogProc5 = dialogCallback5.getAddress();
        if (dialogProc5 == 0) {
            SWT.error(3);
        }
        byte[] types = new byte[]{42, 0};
        int size = C.PTR_SIZEOF;
        int align = C.PTR_SIZEOF == 4 ? 2 : 3;
        int cls = OS.objc_allocateClassPair(OS.class_NSObject, className, 0);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_panelDidEnd_returnCode_contextInfo_, dialogProc5, "@:@i@");
        OS.objc_registerClassPair(cls);
    }

    void panelDidEnd_returnCode_contextInfo(int id2, int sel, int alert, int returnCode, int contextInfo) {
        this.returnCode = returnCode;
    }

    public void setScope(int scope) {
        this.printerData.scope = scope;
    }

    public int getStartPage() {
        return this.printerData.startPage;
    }

    public void setStartPage(int startPage) {
        this.printerData.startPage = startPage;
    }

    public int getEndPage() {
        return this.printerData.endPage;
    }

    public void setEndPage(int endPage) {
        this.printerData.endPage = endPage;
    }

    public boolean getPrintToFile() {
        return this.printerData.printToFile;
    }

    public void setPrintToFile(boolean printToFile) {
        this.printerData.printToFile = printToFile;
    }

    protected void checkSubclass() {
        String name = this.getClass().getName();
        String validName = (class$org$eclipse$swt$printing$PrintDialog == null ? (class$org$eclipse$swt$printing$PrintDialog = PrintDialog.class$("org.eclipse.swt.printing.PrintDialog")) : class$org$eclipse$swt$printing$PrintDialog).getName();
        if (!validName.equals(name)) {
            SWT.error(43);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        SWT_OBJECT = new byte[]{83, 87, 84, 95, 79, 66, 74, 69, 67, 84, 0};
    }
}

