/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleTableAdapter;
import org.eclipse.swt.accessibility.AccessibleTableEvent;
import org.eclipse.swt.accessibility.AccessibleTableListener;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSValue;

class AccessibleTableColumn
extends Accessible {
    public AccessibleTableColumn(Accessible accessible, int childID) {
        super(accessible);
        this.index = childID;
        this.addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getLocation(AccessibleControlEvent e) {
                Accessible[] cells = AccessibleTableColumn.this.getColumnCells();
                AccessibleControlEvent event = new AccessibleControlEvent(this);
                event.childID = -1;
                event.width = -1;
                Accessible child = cells[0];
                for (int i = 0; i < child.accessibleControlListeners.size(); ++i) {
                    AccessibleControlListener listener = (AccessibleControlListener)child.accessibleControlListeners.elementAt(i);
                    listener.getLocation(event);
                }
                int height = 0;
                int width = 0;
                for (int j = 0; j < cells.length; ++j) {
                    NSValue sizeObj = (NSValue)cells[j].getSizeAttribute(-1);
                    NSSize size = sizeObj.sizeValue();
                    if (size.width > (double)width) {
                        width = (int)size.width;
                    }
                    height = (int)((double)height + size.height);
                }
                e.x = event.x;
                e.y = event.y;
                e.width = width;
                e.height = height;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 27;
            }
        });
        this.addAccessibleTableListener(new AccessibleTableAdapter(){

            public void getRowCount(AccessibleTableEvent e) {
                e.count = AccessibleTableColumn.this.getColumnCells().length;
            }

            public void getRow(AccessibleTableEvent e) {
                int index = e.row;
                Accessible[] children = AccessibleTableColumn.this.getColumnCells();
                int count = children.length;
                if (0 <= index && index < count) {
                    e.accessible = children[index];
                }
            }

            public void getRows(AccessibleTableEvent e) {
                e.accessibles = AccessibleTableColumn.this.getColumnCells();
            }
        });
    }

    private Accessible[] getColumnCells() {
        int validRowCount = Math.max(1, this.parent.getRowCount());
        Accessible[] cells = new Accessible[validRowCount];
        AccessibleTableEvent event = new AccessibleTableEvent(this);
        for (int i = 0; i < validRowCount; ++i) {
            event.column = this.index;
            event.row = i;
            for (int j = 0; j < this.parent.accessibleTableListeners.size(); ++j) {
                AccessibleTableListener listener = (AccessibleTableListener)this.parent.accessibleTableListeners.elementAt(j);
                listener.getCell(event);
            }
            cells[i] = event.accessible;
        }
        return cells;
    }
}

