/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.cocoa.CGPoint;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSBundle;
import org.eclipse.swt.internal.cocoa.NSButton;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSColorPanel;
import org.eclipse.swt.internal.cocoa.NSColorSpace;
import org.eclipse.swt.internal.cocoa.NSComboBox;
import org.eclipse.swt.internal.cocoa.NSDate;
import org.eclipse.swt.internal.cocoa.NSDictionary;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSImageView;
import org.eclipse.swt.internal.cocoa.NSLocale;
import org.eclipse.swt.internal.cocoa.NSMenu;
import org.eclipse.swt.internal.cocoa.NSMenuItem;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSNotificationCenter;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPanel;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSPopUpButton;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSResponder;
import org.eclipse.swt.internal.cocoa.NSRunLoop;
import org.eclipse.swt.internal.cocoa.NSScreen;
import org.eclipse.swt.internal.cocoa.NSSearchField;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSSlider;
import org.eclipse.swt.internal.cocoa.NSStepper;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTextField;
import org.eclipse.swt.internal.cocoa.NSTextView;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.NSTimer;
import org.eclipse.swt.internal.cocoa.NSTouch;
import org.eclipse.swt.internal.cocoa.NSUserDefaults;
import org.eclipse.swt.internal.cocoa.NSValue;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTApplicationDelegate;
import org.eclipse.swt.internal.cocoa.SWTWindowDelegate;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.internal.cocoa.objc_super;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.swt.widgets.TaskBar;
import org.eclipse.swt.widgets.TaskItem;
import org.eclipse.swt.widgets.TouchSource;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.Widget;

public class Display
extends Device {
    static byte[] types = new byte[]{42, 0};
    static int size = C.PTR_SIZEOF;
    static int align = C.PTR_SIZEOF == 4 ? 2 : 3;
    Event[] eventQueue;
    EventTable eventTable;
    EventTable filterTable;
    boolean disposing;
    int sendEventCount;
    double rotation;
    double magnification;
    boolean gestureActive;
    int touchCounter;
    long primaryIdentifier;
    NSMutableArray currentTouches;
    TouchSource[] touchSources;
    Synchronizer synchronizer;
    Thread thread;
    boolean allowTimers = true;
    boolean runAsyncMessages = true;
    GCData[] contexts;
    Caret currentCaret;
    boolean ignoreFocus;
    boolean sendEvent;
    int clickCountButton;
    int clickCount;
    int blinkTime;
    Control currentControl;
    Control trackingControl;
    Control tooltipControl;
    Widget tooltipTarget;
    NSMutableArray isPainting;
    NSMutableArray needsDisplay;
    NSMutableArray needsDisplayInRect;
    NSMutableArray runLoopModes;
    NSDictionary markedAttributes;
    boolean smallFonts;
    NSFont buttonFont;
    NSFont popUpButtonFont;
    NSFont textFieldFont;
    NSFont secureTextFieldFont;
    NSFont searchFieldFont;
    NSFont comboBoxFont;
    NSFont sliderFont;
    NSFont scrollerFont;
    NSFont textViewFont;
    NSFont tableViewFont;
    NSFont outlineViewFont;
    NSFont datePickerFont;
    NSFont boxFont;
    NSFont tabViewFont;
    NSFont progressIndicatorFont;
    Shell[] modalShells;
    Dialog modalDialog;
    NSPanel modalPanel;
    Menu menuBar;
    Menu[] menus;
    Menu[] popups;
    NSApplication application;
    long applicationClass;
    NSImage dockImage;
    boolean isEmbedded;
    static boolean launched = false;
    int systemUIMode;
    int systemUIOptions;
    Control focusControl;
    Control currentFocusControl;
    int focusEvent;
    NSWindow screenWindow;
    NSWindow keyWindow;
    NSAutoreleasePool[] pools;
    int poolCount;
    int loopCount;
    int[] screenID = new int[32];
    NSPoint[] screenCascade = new NSPoint[32];
    long runLoopObserver;
    Callback observerCallback;
    boolean lockCursor = true;
    long oldCursorSetProc;
    Callback cursorSetCallback;
    Combo currentCombo;
    boolean mozillaRunning;
    static final String MOZILLA_RUNNING = "org.eclipse.swt.internal.mozillaRunning";
    static Callback windowCallback2;
    static Callback windowCallback3;
    static Callback windowCallback4;
    static Callback windowCallback5;
    static Callback windowCallback6;
    static Callback dialogCallback3;
    static Callback dialogCallback4;
    static Callback dialogCallback5;
    static Callback applicationCallback2;
    static Callback applicationCallback3;
    static Callback applicationCallback4;
    static Callback applicationCallback6;
    Runnable[] disposeList;
    Composite[] layoutDeferred;
    int layoutDeferredCount;
    Tray tray;
    TrayItem currentTrayItem;
    Menu trayItemMenu;
    Menu appMenuBar;
    Menu appMenu;
    TaskBar taskBar;
    Image errorImage;
    Image infoImage;
    Image warningImage;
    Cursor[] cursors = new Cursor[22];
    double[][] colors;
    double[] alternateSelectedControlTextColor;
    double[] selectedControlTextColor;
    double[] alternateSelectedControlColor;
    double[] secondarySelectedControlColor;
    static int[][] KeyTable;
    static String APP_NAME;
    static String APP_VERSION;
    static final String ADD_WIDGET_KEY = "org.eclipse.swt.internal.addWidget";
    static final byte[] SWT_OBJECT;
    static final byte[] SWT_EMBED_FRAMES;
    static final byte[] SWT_IMAGE;
    static final byte[] SWT_ROW;
    static final byte[] SWT_COLUMN;
    static final String SET_MODAL_DIALOG = "org.eclipse.swt.internal.modalDialog";
    static Display Default;
    static Display[] Displays;
    static final int GROW_SIZE = 1024;
    Widget[] skinList = new Widget[1024];
    int skinCount;
    static final String PACKAGE_PREFIX = "org.eclipse.swt.widgets.";
    Runnable[] timerList;
    NSTimer[] nsTimers;
    SWTWindowDelegate timerDelegate;
    static SWTApplicationDelegate applicationDelegate;
    static NSObject currAppDelegate;
    boolean runSettings;
    SWTWindowDelegate settingsDelegate;
    static final int DEFAULT_BUTTON_INTERVAL = 30;
    Object data;
    String[] keys;
    Object[] values;
    static Map dynamicObjectMap;
    NSPoint hoverLastLocation;
    Runnable hoverTimer = new Runnable(){

        public void run() {
            if (Display.this.currentControl != null && !Display.this.currentControl.isDisposed()) {
                Display.this.currentControl.sendMouseEvent(null, 32, Display.this.trackingControl != null && !Display.this.trackingControl.isDisposed());
            }
        }
    };
    Runnable caretTimer = new Runnable(){

        public void run() {
            if (Display.this.currentCaret != null) {
                if (Display.this.currentCaret == null || Display.this.currentCaret.isDisposed()) {
                    return;
                }
                if (Display.this.currentCaret.blinkCaret()) {
                    int blinkRate = Display.this.currentCaret.blinkRate;
                    if (blinkRate != 0) {
                        Display.this.timerExec(blinkRate, this);
                    }
                } else {
                    Display.this.currentCaret = null;
                }
            }
        }
    };
    Runnable defaultButtonTimer = new Runnable(){

        public void run() {
            Button defaultButton;
            if (Display.this.isDisposed()) {
                return;
            }
            Shell shell = Display.this.getActiveShell();
            if (shell != null && !shell.isDisposed() && (defaultButton = shell.defaultButton) != null && !defaultButton.isDisposed()) {
                NSView view = defaultButton.view;
                view.display();
            }
            if (Display.this.isDisposed()) {
                return;
            }
            if (Display.this.hasDefaultButton()) {
                Display.this.timerExec(30, this);
            }
        }
    };
    static /* synthetic */ Class class$org$eclipse$swt$graphics$Device;

    static void setDevice(Device device) {
        CurrentDevice = device;
    }

    static byte[] ascii(String name) {
        int length = name.length();
        char[] chars = new char[length];
        name.getChars(0, length, chars, 0);
        byte[] buffer = new byte[length + 1];
        for (int i = 0; i < length; ++i) {
            buffer[i] = (byte)chars[i];
        }
        return buffer;
    }

    static int translateKey(int key) {
        for (int i = 0; i < KeyTable.length; ++i) {
            if (KeyTable[i][0] != key) continue;
            return KeyTable[i][1];
        }
        return 0;
    }

    static int untranslateKey(int key) {
        for (int i = 0; i < KeyTable.length; ++i) {
            if (KeyTable[i][1] != key) continue;
            return KeyTable[i][0];
        }
        return 0;
    }

    void addContext(GCData context) {
        if (this.contexts == null) {
            this.contexts = new GCData[12];
        }
        for (int i = 0; i < this.contexts.length; ++i) {
            if (this.contexts[i] != null && this.contexts[i] != context) continue;
            this.contexts[i] = context;
            return;
        }
        GCData[] newContexts = new GCData[this.contexts.length + 12];
        newContexts[this.contexts.length] = context;
        System.arraycopy(this.contexts, 0, newContexts, 0, this.contexts.length);
        this.contexts = newContexts;
    }

    public void addFilter(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            this.filterTable = new EventTable();
        }
        this.filterTable.hook(eventType, listener);
    }

    void addLayoutDeferred(Composite comp) {
        if (this.layoutDeferred == null) {
            this.layoutDeferred = new Composite[64];
        }
        if (this.layoutDeferredCount == this.layoutDeferred.length) {
            Composite[] temp = new Composite[this.layoutDeferred.length + 64];
            System.arraycopy(this.layoutDeferred, 0, temp, 0, this.layoutDeferred.length);
            this.layoutDeferred = temp;
        }
        this.layoutDeferred[this.layoutDeferredCount++] = comp;
    }

    public void addListener(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(eventType, listener);
    }

    void addMenu(Menu menu) {
        if (this.menus == null) {
            this.menus = new Menu[12];
        }
        for (int i = 0; i < this.menus.length; ++i) {
            if (this.menus[i] != null) continue;
            this.menus[i] = menu;
            return;
        }
        Menu[] newMenus = new Menu[this.menus.length + 12];
        newMenus[this.menus.length] = menu;
        System.arraycopy(this.menus, 0, newMenus, 0, this.menus.length);
        this.menus = newMenus;
    }

    void addPool() {
        this.addPool((NSAutoreleasePool)new NSAutoreleasePool().alloc().init());
    }

    void addPool(NSAutoreleasePool pool) {
        if (this.pools == null) {
            this.pools = new NSAutoreleasePool[4];
        }
        if (this.poolCount == this.pools.length) {
            NSAutoreleasePool[] temp = new NSAutoreleasePool[this.poolCount + 4];
            System.arraycopy(this.pools, 0, temp, 0, this.poolCount);
            this.pools = temp;
        }
        if (this.poolCount == 0) {
            NSMutableDictionary dictionary = NSThread.currentThread().threadDictionary();
            dictionary.setObject(NSNumber.numberWithInteger(pool.id), NSString.stringWith("SWT_NSAutoreleasePool"));
        }
        this.pools[this.poolCount++] = pool;
    }

    void addPopup(Menu menu) {
        int index;
        if (this.popups == null) {
            this.popups = new Menu[4];
        }
        int length = this.popups.length;
        for (int i = 0; i < length; ++i) {
            if (this.popups[i] != menu) continue;
            return;
        }
        for (index = 0; index < length && this.popups[index] != null; ++index) {
        }
        if (index == length) {
            Menu[] newPopups = new Menu[length + 4];
            System.arraycopy(this.popups, 0, newPopups, 0, length);
            this.popups = newPopups;
        }
        this.popups[index] = menu;
    }

    void addSkinnableWidget(Widget widget) {
        if (this.skinCount >= this.skinList.length) {
            Widget[] newSkinWidgets = new Widget[this.skinList.length + 1024];
            System.arraycopy(this.skinList, 0, newSkinWidgets, 0, this.skinList.length);
            this.skinList = newSkinWidgets;
        }
        this.skinList[this.skinCount++] = widget;
    }

    void addWidget(NSObject view, Widget widget) {
        if (view == null) {
            return;
        }
        long ivar = OS.object_setInstanceVariable(view.id, SWT_OBJECT, widget.jniRef);
        if (ivar == 0L) {
            if (dynamicObjectMap == null) {
                dynamicObjectMap = new HashMap();
            }
            LONG JNIRef = new LONG(widget.jniRef);
            dynamicObjectMap.put(view, JNIRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncExec(Runnable runnable) {
        Class clazz = class$org$eclipse$swt$graphics$Device == null ? (class$org$eclipse$swt$graphics$Device = Display.class$("org.eclipse.swt.graphics.Device")) : class$org$eclipse$swt$graphics$Device;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            this.synchronizer.asyncExec(runnable);
        }
    }

    public void beep() {
        this.checkDevice();
        OS.NSBeep();
    }

    void cascadeWindow(NSWindow window, NSScreen screen) {
        NSDictionary dictionary = screen.deviceDescription();
        int screenNumber = new NSNumber(dictionary.objectForKey((id)NSString.stringWith((String)"NSScreenNumber")).id).intValue();
        int index = 0;
        while (this.screenID[index] != 0 && this.screenID[index] != screenNumber) {
            ++index;
        }
        this.screenID[index] = screenNumber;
        NSPoint cascade = this.screenCascade[index];
        if (cascade == null) {
            NSRect frame = screen.frame();
            cascade = new NSPoint();
            cascade.x = frame.x;
            cascade.y = frame.y + frame.height;
        }
        this.screenCascade[index] = window.cascadeTopLeftFromPoint(cascade);
    }

    protected void checkDevice() {
        if (this.thread == null) {
            this.error(24);
        }
        if (this.thread != Thread.currentThread()) {
            this.error(22);
        }
        if (this.isDisposed()) {
            this.error(45);
        }
    }

    void checkEnterExit(Control control, NSEvent nsEvent, boolean send) {
        if (control != this.currentControl) {
            if (this.currentControl != null && !this.currentControl.isDisposed()) {
                this.currentControl.sendMouseEvent(nsEvent, 7, send);
            }
            if (control != null && control.isDisposed()) {
                control = null;
            }
            this.currentControl = control;
            if (control != null) {
                control.sendMouseEvent(nsEvent, 6, send);
            }
            this.setCursor(control);
        }
        NSPoint location = NSEvent.mouseLocation();
        if (control == null || control != this.currentControl || this.hoverLastLocation == null || location.x != this.hoverLastLocation.x || location.y != this.hoverLastLocation.y) {
            this.hoverLastLocation = location;
            this.timerExec(control != null && !control.isDisposed() ? this.getToolTipTime() : -1, this.hoverTimer);
        }
    }

    void checkFocus() {
        if (this.ignoreFocus) {
            return;
        }
        Control oldControl = this.currentFocusControl;
        Control newControl = this.getFocusControl();
        if (oldControl != newControl) {
            if (oldControl != null && !oldControl.isDisposed()) {
                oldControl.sendFocusEvent(16);
            }
            this.currentFocusControl = newControl;
            if (newControl != null && !newControl.isDisposed()) {
                newControl.sendFocusEvent(15);
            }
        }
    }

    protected void checkSubclass() {
        if (!Display.isValidClass(this.getClass())) {
            this.error(43);
        }
    }

    public Display() {
        this(null);
    }

    public Display(DeviceData data) {
        super(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkDisplay(Thread thread, boolean multiple) {
        Class clazz = class$org$eclipse$swt$graphics$Device == null ? (class$org$eclipse$swt$graphics$Device = Display.class$("org.eclipse.swt.graphics.Device")) : class$org$eclipse$swt$graphics$Device;
        synchronized (clazz) {
            for (int i = 0; i < Displays.length; ++i) {
                if (Displays[i] == null) continue;
                if (!multiple) {
                    SWT.error(20, null, " [multiple displays]");
                }
                if (Display.Displays[i].thread != thread) continue;
                SWT.error(22);
            }
        }
    }

    static NSRect convertRect(NSScreen screen, NSRect frame) {
        double scaleFactor = screen.userSpaceScaleFactor();
        frame.x /= scaleFactor;
        frame.y /= scaleFactor;
        frame.width /= scaleFactor;
        frame.height /= scaleFactor;
        return frame;
    }

    static String convertToLf(String text) {
        char Cr = '\r';
        char Lf = '\n';
        int length = text.length();
        if (length == 0) {
            return text;
        }
        int i = text.indexOf(Lf, 0);
        if (i == -1 || i == 0) {
            return text;
        }
        if (text.charAt(i - 1) != Cr) {
            return text;
        }
        i = 0;
        StringBuffer result = new StringBuffer();
        while (i < length) {
            int j = text.indexOf(Cr, i);
            if (j == -1) {
                j = length;
            }
            String s = text.substring(i, j);
            result.append(s);
            i = j + 2;
            result.append(Lf);
        }
        return result.toString();
    }

    void clearModal(Shell shell) {
        int index;
        if (this.modalShells == null) {
            return;
        }
        int length = this.modalShells.length;
        for (index = 0; index < length && this.modalShells[index] != shell; ++index) {
            if (this.modalShells[index] != null) continue;
            return;
        }
        if (index == length) {
            return;
        }
        System.arraycopy(this.modalShells, index + 1, this.modalShells, index, --length - index);
        this.modalShells[length] = null;
        if (index == 0 && this.modalShells[0] == null) {
            this.modalShells = null;
        }
        Shell[] shells = this.getShells();
        for (int i = 0; i < shells.length; ++i) {
            shells[i].updateModal();
        }
    }

    void clearPool() {
        if (this.sendEventCount == 0 && this.loopCount == this.poolCount - 1 && Callback.getEntryCount() == 0) {
            this.removePool();
            this.addPool();
        }
    }

    public void close() {
        this.checkDevice();
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit) {
            this.dispose();
        }
    }

    protected void create(DeviceData data) {
        this.checkSubclass();
        this.thread = Thread.currentThread();
        Display.checkDisplay(this.thread, false);
        this.createDisplay(data);
        Display.register(this);
        this.synchronizer = new Synchronizer(this);
        if (Default == null) {
            Default = this;
        }
    }

    void createDisplay(DeviceData data) {
        String className;
        long cls;
        if (OS.VERSION < 4176) {
            System.out.println("***WARNING: SWT requires MacOS X version 10.5 or greater");
            System.out.println("***WARNING: Detected: " + Integer.toHexString((OS.VERSION & 0xFF00) >> 8) + "." + Integer.toHexString((OS.VERSION & 0xF0) >> 4) + "." + Integer.toHexString(OS.VERSION & 0xF));
            this.error(20);
        }
        NSThread nsthread = NSThread.currentThread();
        if (!NSThread.isMainThread()) {
            System.out.println("***WARNING: Display must be created on main thread due to Cocoa restrictions.");
            this.error(22);
        }
        NSMutableDictionary dictionary = nsthread.threadDictionary();
        NSString key = NSString.stringWith("SWT_NSAutoreleasePool");
        NSNumber id2 = new NSNumber(dictionary.objectForKey(key));
        this.addPool(new NSAutoreleasePool(id2.integerValue()));
        this.application = NSApplication.sharedApplication();
        this.isEmbedded = this.application.isRunning();
        int[] psn = new int[2];
        if (OS.GetCurrentProcess(psn) == 0) {
            int pid = OS.getpid();
            long ptr = Display.getApplicationName().UTF8String();
            if (ptr != 0L) {
                OS.CPSSetProcessName(psn, ptr);
            }
            if (!this.isBundled()) {
                OS.TransformProcessType(psn, 1);
                OS.SetFrontProcess(psn);
            }
            if ((ptr = OS.getenv(Display.ascii("APP_ICON_" + pid))) != 0L) {
                NSString path = NSString.stringWithUTF8String(ptr);
                NSImage image = (NSImage)new NSImage().alloc();
                this.dockImage = image = image.initByReferencingFile(path);
                this.application.setApplicationIconImage(image);
            }
        }
        if ((cls = OS.objc_lookUpClass(className = "SWTApplication")) == 0L) {
            long proc6;
            long proc4;
            long proc3;
            Class<?> clazz = this.getClass();
            applicationCallback2 = new Callback(clazz, "applicationProc", 2);
            long proc2 = applicationCallback2.getAddress();
            if (proc2 == 0L) {
                this.error(3);
            }
            if ((proc3 = (applicationCallback3 = new Callback(clazz, "applicationProc", 3)).getAddress()) == 0L) {
                this.error(3);
            }
            if ((proc4 = (applicationCallback4 = new Callback(clazz, "applicationProc", 4)).getAddress()) == 0L) {
                this.error(3);
            }
            if ((proc6 = (applicationCallback6 = new Callback(clazz, "applicationProc", 6)).getAddress()) == 0L) {
                this.error(3);
            }
            cls = OS.objc_allocateClassPair(OS.object_getClass(this.application.id), className, 0L);
            OS.class_addMethod(cls, OS.sel_sendEvent_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_nextEventMatchingMask_untilDate_inMode_dequeue_, proc6, "@:i@@B");
            OS.class_addMethod(cls, OS.sel_isRunning, proc2, "@:");
            OS.class_addMethod(cls, OS.sel_finishLaunching, proc2, "@:");
            OS.objc_registerClassPair(cls);
        }
        this.applicationClass = OS.object_setClass(this.application.id, cls);
        className = "SWTApplicationDelegate";
        if (OS.objc_lookUpClass(className) == 0L) {
            long appProc3 = applicationCallback3.getAddress();
            if (appProc3 == 0L) {
                this.error(3);
            }
            cls = OS.objc_allocateClassPair(OS.class_NSObject, className, 0L);
            long appProc4 = applicationCallback4.getAddress();
            if (appProc4 == 0L) {
                this.error(3);
            }
            cls = OS.objc_allocateClassPair(OS.class_NSObject, className, 0L);
            OS.class_addMethod(cls, OS.sel_applicationWillFinishLaunching_, appProc3, "@:@");
            OS.class_addMethod(cls, OS.sel_terminate_, appProc3, "@:@");
            OS.class_addMethod(cls, OS.sel_orderFrontStandardAboutPanel_, appProc3, "@:@");
            OS.class_addMethod(cls, OS.sel_hideOtherApplications_, appProc3, "@:@");
            OS.class_addMethod(cls, OS.sel_hide_, appProc3, "@:@");
            OS.class_addMethod(cls, OS.sel_unhideAllApplications_, appProc3, "@:@");
            OS.class_addMethod(cls, OS.sel_applicationDidBecomeActive_, appProc3, "@:@");
            OS.class_addMethod(cls, OS.sel_applicationDidResignActive_, appProc3, "@:@");
            OS.class_addMethod(cls, OS.sel_applicationDockMenu_, appProc3, "@:@");
            OS.class_addMethod(cls, OS.sel_application_openFile_, appProc4, "@:@@");
            OS.class_addMethod(cls, OS.sel_application_openFiles_, appProc4, "@:@@");
            OS.class_addMethod(cls, OS.sel_applicationShouldHandleReopen_hasVisibleWindows_, appProc4, "@:@B");
            OS.class_addMethod(cls, OS.sel_applicationShouldTerminate_, appProc3, "@:@");
            OS.objc_registerClassPair(cls);
        }
        int[] bufferMode = new int[1];
        int[] bufferOptions = new int[1];
        OS.GetSystemUIMode(bufferMode, bufferOptions);
        this.systemUIMode = bufferMode[0];
        this.systemUIOptions = bufferOptions[0];
    }

    void createMainMenu() {
        NSMenuItem menuItem;
        NSString appName = Display.getApplicationName();
        NSString emptyStr = NSString.string();
        NSMenu mainMenu = (NSMenu)new NSMenu().alloc();
        mainMenu.initWithTitle(emptyStr);
        NSString format = NSString.stringWith("%@ %@");
        NSMenuItem appItem = menuItem = mainMenu.addItemWithTitle(emptyStr, 0L, emptyStr);
        NSMenu appleMenu = (NSMenu)new NSMenu().alloc();
        appleMenu.initWithTitle(emptyStr);
        OS.objc_msgSend(this.application.id, OS.sel_registerName("setAppleMenu:"), appleMenu.id);
        NSString title = new NSString(OS.objc_msgSend(OS.class_NSString, OS.sel_stringWithFormat_, format.id, NSString.stringWith((String)SWT.getMessage((String)"About")).id, appName.id));
        menuItem = appleMenu.addItemWithTitle(title, OS.sel_orderFrontStandardAboutPanel_, emptyStr);
        menuItem.setTarget(applicationDelegate);
        appleMenu.addItem(NSMenuItem.separatorItem());
        title = NSString.stringWith(SWT.getMessage("Preferences..."));
        menuItem = appleMenu.addItemWithTitle(title, 0L, NSString.stringWith(","));
        menuItem.setTag(42L);
        appleMenu.addItem(NSMenuItem.separatorItem());
        title = NSString.stringWith(SWT.getMessage("Services"));
        menuItem = appleMenu.addItemWithTitle(title, 0L, emptyStr);
        NSMenu servicesMenu = (NSMenu)new NSMenu().alloc();
        servicesMenu.initWithTitle(emptyStr);
        appleMenu.setSubmenu(servicesMenu, menuItem);
        servicesMenu.release();
        this.application.setServicesMenu(servicesMenu);
        appleMenu.addItem(NSMenuItem.separatorItem());
        title = new NSString(OS.objc_msgSend(OS.class_NSString, OS.sel_stringWithFormat_, format.id, NSString.stringWith((String)SWT.getMessage((String)"Hide")).id, appName.id));
        menuItem = appleMenu.addItemWithTitle(title, OS.sel_hide_, NSString.stringWith("h"));
        menuItem.setTarget(applicationDelegate);
        title = NSString.stringWith(SWT.getMessage("Hide Others"));
        menuItem = appleMenu.addItemWithTitle(title, OS.sel_hideOtherApplications_, NSString.stringWith("h"));
        menuItem.setKeyEquivalentModifierMask(0x180000L);
        menuItem.setTarget(applicationDelegate);
        title = NSString.stringWith(SWT.getMessage("Show All"));
        menuItem = appleMenu.addItemWithTitle(title, OS.sel_unhideAllApplications_, emptyStr);
        menuItem.setTarget(applicationDelegate);
        appleMenu.addItem(NSMenuItem.separatorItem());
        title = new NSString(OS.objc_msgSend(OS.class_NSString, OS.sel_stringWithFormat_, format.id, NSString.stringWith((String)SWT.getMessage((String)"Quit")).id, appName.id));
        menuItem = appleMenu.addItemWithTitle(title, OS.sel_applicationShouldTerminate_, NSString.stringWith("q"));
        menuItem.setTarget(applicationDelegate);
        mainMenu.setSubmenu(appleMenu, appItem);
        appleMenu.release();
        this.application.setMainMenu(mainMenu);
        mainMenu.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NSMutableArray currentTouches() {
        Class clazz = class$org$eclipse$swt$graphics$Device == null ? (class$org$eclipse$swt$graphics$Device = Display.class$("org.eclipse.swt.graphics.Device")) : class$org$eclipse$swt$graphics$Device;
        synchronized (clazz) {
            if (this.currentTouches == null) {
                this.currentTouches = (NSMutableArray)new NSMutableArray().alloc();
                this.currentTouches = this.currentTouches.initWithCapacity(5L);
            }
        }
        return this.currentTouches;
    }

    long cursorSetProc(long id2, long sel) {
        Cursor cursor;
        if (this.lockCursor && this.currentControl != null && (cursor = this.currentControl.findCursor()) != null && cursor.handle.id != id2) {
            return 0L;
        }
        OS.call(this.oldCursorSetProc, id2, sel);
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deregister(Display display) {
        Class clazz = class$org$eclipse$swt$graphics$Device == null ? (class$org$eclipse$swt$graphics$Device = Display.class$("org.eclipse.swt.graphics.Device")) : class$org$eclipse$swt$graphics$Device;
        synchronized (clazz) {
            for (int i = 0; i < Displays.length; ++i) {
                if (display != Displays[i]) continue;
                Display.Displays[i] = null;
            }
        }
    }

    protected void destroy() {
        if (this == Default) {
            Default = null;
        }
        Display.deregister(this);
        this.destroyDisplay();
    }

    void destroyDisplay() {
        this.application = null;
    }

    public void disposeExec(Runnable runnable) {
        this.checkDevice();
        if (this.disposeList == null) {
            this.disposeList = new Runnable[4];
        }
        for (int i = 0; i < this.disposeList.length; ++i) {
            if (this.disposeList[i] != null) continue;
            this.disposeList[i] = runnable;
            return;
        }
        Runnable[] newDisposeList = new Runnable[this.disposeList.length + 4];
        System.arraycopy(this.disposeList, 0, newDisposeList, 0, this.disposeList.length);
        newDisposeList[this.disposeList.length] = runnable;
        this.disposeList = newDisposeList;
    }

    void error(int code) {
        SWT.error(code);
    }

    boolean filterEvent(Event event) {
        if (this.filterTable != null) {
            this.filterTable.sendEvent(event);
        }
        return false;
    }

    boolean filters(int eventType) {
        if (this.filterTable == null) {
            return false;
        }
        return this.filterTable.hooks(eventType);
    }

    public Widget findWidget(long handle) {
        this.checkDevice();
        return this.getWidget(handle);
    }

    public Widget findWidget(long handle, long id2) {
        this.checkDevice();
        return this.getWidget(handle);
    }

    public Widget findWidget(Widget widget, long id2) {
        this.checkDevice();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display findDisplay(Thread thread) {
        Class clazz = class$org$eclipse$swt$graphics$Device == null ? (class$org$eclipse$swt$graphics$Device = Display.class$("org.eclipse.swt.graphics.Device")) : class$org$eclipse$swt$graphics$Device;
        synchronized (clazz) {
            for (int i = 0; i < Displays.length; ++i) {
                Display display = Displays[i];
                if (display == null || display.thread != thread) continue;
                return display;
            }
            return null;
        }
    }

    TouchSource findTouchSource(NSTouch touch) {
        int index;
        if (this.touchSources == null) {
            this.touchSources = new TouchSource[4];
        }
        int length = this.touchSources.length;
        id touchDevice = touch.device();
        TouchSource source = null;
        for (index = 0; index < length && this.touchSources[index] != null; ++index) {
            if (this.touchSources[index].handle != touchDevice.id) continue;
            source = this.touchSources[index];
            break;
        }
        if (source != null) {
            return source;
        }
        if (index == length) {
            TouchSource[] newList = new TouchSource[length + 4];
            System.arraycopy(this.touchSources, 0, newList, 0, length);
            this.touchSources = newList;
        }
        Rectangle bounds = new Rectangle(0, 0, (int)Math.ceil(touch.deviceSize().width), (int)Math.ceil(touch.deviceSize().height));
        this.touchSources[index] = source = new TouchSource(touchDevice.id, false, bounds);
        return source;
    }

    public Shell getActiveShell() {
        NSWindow window;
        this.checkDevice();
        NSWindow nSWindow = window = this.keyWindow != null ? this.keyWindow : this.application.keyWindow();
        if (window != null) {
            Widget widget = this.getWidget(window.contentView());
            if (widget instanceof Shell) {
                return (Shell)widget;
            }
            NSPoint windowLocation = window.mouseLocationOutsideOfEventStream();
            for (NSView hitView = window.contentView().hitTest(windowLocation); hitView != null && !((widget = this.getWidget(hitView.id)) instanceof Shell); hitView = hitView.superview()) {
            }
            return (Shell)widget;
        }
        return null;
    }

    public Rectangle getBounds() {
        this.checkDevice();
        NSArray screens = NSScreen.screens();
        return this.getBounds(screens);
    }

    Rectangle getBounds(NSArray screens) {
        NSScreen screen = new NSScreen(screens.objectAtIndex(0L));
        NSRect primaryFrame = Display.convertRect(screen, screen.frame());
        double minX = 3.4028234663852886E38;
        double maxX = 1.4E-45f;
        double minY = 3.4028234663852886E38;
        double maxY = 1.4E-45f;
        long count = screens.count();
        int i = 0;
        while ((long)i < count) {
            screen = new NSScreen(screens.objectAtIndex(i));
            NSRect frame = Display.convertRect(screen, screen.frame());
            double x1 = frame.x;
            double x2 = frame.x + frame.width;
            double y1 = primaryFrame.height - frame.y;
            double y2 = primaryFrame.height - (frame.y + frame.height);
            if (x1 < minX) {
                minX = x1;
            }
            if (x2 < minX) {
                minX = x2;
            }
            if (x1 > maxX) {
                maxX = x1;
            }
            if (x2 > maxX) {
                maxX = x2;
            }
            if (y1 < minY) {
                minY = y1;
            }
            if (y2 < minY) {
                minY = y2;
            }
            if (y1 > maxY) {
                maxY = y1;
            }
            if (y2 > maxY) {
                maxY = y2;
            }
            ++i;
        }
        return new Rectangle((int)minX, (int)minY, (int)(maxX - minX), (int)(maxY - minY));
    }

    public static Display getCurrent() {
        return Display.findDisplay(Thread.currentThread());
    }

    int getCaretBlinkTime() {
        return this.blinkTime;
    }

    public Rectangle getClientArea() {
        this.checkDevice();
        NSArray screens = NSScreen.screens();
        if (screens.count() != 1L) {
            return this.getBounds(screens);
        }
        NSScreen screen = new NSScreen(screens.objectAtIndex(0L));
        NSRect frame = Display.convertRect(screen, screen.frame());
        NSRect visibleFrame = Display.convertRect(screen, screen.visibleFrame());
        double y = frame.height - (visibleFrame.y + visibleFrame.height);
        return new Rectangle((int)visibleFrame.x, (int)y, (int)visibleFrame.width, (int)visibleFrame.height);
    }

    public Control getCursorControl() {
        this.checkDevice();
        return this.findControl(false);
    }

    public Point getCursorLocation() {
        this.checkDevice();
        NSPoint location = NSEvent.mouseLocation();
        NSRect primaryFrame = this.getPrimaryFrame();
        return new Point((int)location.x, (int)(primaryFrame.height - location.y));
    }

    public Point[] getCursorSizes() {
        this.checkDevice();
        return new Point[]{new Point(16, 16)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display getDefault() {
        Class clazz = class$org$eclipse$swt$graphics$Device == null ? (class$org$eclipse$swt$graphics$Device = Display.class$("org.eclipse.swt.graphics.Device")) : class$org$eclipse$swt$graphics$Device;
        synchronized (clazz) {
            if (Default == null) {
                Default = new Display();
            }
            return Default;
        }
    }

    public Object getData(String key) {
        this.checkDevice();
        if (key == null) {
            this.error(4);
        }
        if (this.keys == null) {
            return null;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.keys[i].equals(key)) continue;
            return this.values[i];
        }
        return null;
    }

    public Object getData() {
        this.checkDevice();
        return this.data;
    }

    public int getDismissalAlignment() {
        this.checkDevice();
        return 131072;
    }

    public int getDoubleClickTime() {
        this.checkDevice();
        return OS.GetDblTime() * 1000 / 60;
    }

    public Control getFocusControl() {
        this.checkDevice();
        if (this.focusControl != null && !this.focusControl.isDisposed()) {
            return this.focusControl;
        }
        NSWindow window = this.keyWindow != null ? this.keyWindow : this.application.keyWindow();
        return this._getFocusControl(window);
    }

    Control _getFocusControl(NSWindow window) {
        if (window != null) {
            NSResponder responder = window.firstResponder();
            if (responder != null && !responder.respondsToSelector(OS.sel_superview)) {
                return null;
            }
            NSView view = new NSView(responder.id);
            if (view != null) {
                do {
                    Widget widget;
                    if (!((widget = Display.GetWidget(view.id)) instanceof Control)) continue;
                    return (Control)widget;
                } while ((view = view.superview()) != null);
            }
        }
        return null;
    }

    public boolean getHighContrast() {
        this.checkDevice();
        return false;
    }

    public int getIconDepth() {
        return this.getDepth();
    }

    public Point[] getIconSizes() {
        this.checkDevice();
        return new Point[]{new Point(16, 16), new Point(32, 32), new Point(64, 64), new Point(128, 128)};
    }

    int getLastEventTime() {
        double timestamp;
        NSEvent event = this.application.currentEvent();
        if (event == null) {
            return 0;
        }
        for (timestamp = event.timestamp() * 1000.0; timestamp > 2.147483647E9; timestamp -= 2.147483647E9) {
        }
        return (int)timestamp;
    }

    Menu[] getMenus(Decorations shell) {
        if (this.menus == null) {
            return new Menu[0];
        }
        int count = 0;
        for (int i = 0; i < this.menus.length; ++i) {
            Menu menu = this.menus[i];
            if (menu == null || menu.parent != shell) continue;
            ++count;
        }
        int index = 0;
        Menu[] result = new Menu[count];
        for (int i = 0; i < this.menus.length; ++i) {
            Menu menu = this.menus[i];
            if (menu == null || menu.parent != shell) continue;
            result[index++] = menu;
        }
        return result;
    }

    int getMessageCount() {
        return this.synchronizer.getMessageCount();
    }

    Dialog getModalDialog() {
        return this.modalDialog;
    }

    NSPanel getModalPanel() {
        return this.modalPanel;
    }

    public Monitor[] getMonitors() {
        this.checkDevice();
        NSArray screens = NSScreen.screens();
        NSScreen screen = new NSScreen(screens.objectAtIndex(0L));
        NSRect primaryFrame = Display.convertRect(screen, screen.frame());
        int count = (int)screens.count();
        Monitor[] monitors = new Monitor[count];
        for (int i = 0; i < count; ++i) {
            Monitor monitor = new Monitor();
            screen = new NSScreen(screens.objectAtIndex(i));
            NSRect frame = Display.convertRect(screen, screen.frame());
            monitor.handle = screen.id;
            monitor.x = (int)frame.x;
            monitor.y = (int)(primaryFrame.height - (frame.y + frame.height));
            monitor.width = (int)frame.width;
            monitor.height = (int)frame.height;
            NSRect visibleFrame = Display.convertRect(screen, screen.visibleFrame());
            monitor.clientX = (int)visibleFrame.x;
            monitor.clientY = (int)(primaryFrame.height - (visibleFrame.y + visibleFrame.height));
            monitor.clientWidth = (int)visibleFrame.width;
            monitor.clientHeight = (int)visibleFrame.height;
            monitors[i] = monitor;
        }
        return monitors;
    }

    NSRect getPrimaryFrame() {
        NSArray screens = NSScreen.screens();
        return new NSScreen(screens.objectAtIndex(0L)).frame();
    }

    public Monitor getPrimaryMonitor() {
        this.checkDevice();
        Monitor monitor = new Monitor();
        NSArray screens = NSScreen.screens();
        NSScreen screen = new NSScreen(screens.objectAtIndex(0L));
        NSRect frame = Display.convertRect(screen, screen.frame());
        monitor.handle = screen.id;
        monitor.x = (int)frame.x;
        monitor.y = (int)(frame.height - (frame.y + frame.height));
        monitor.width = (int)frame.width;
        monitor.height = (int)frame.height;
        NSRect visibleFrame = Display.convertRect(screen, screen.visibleFrame());
        monitor.clientX = (int)visibleFrame.x;
        monitor.clientY = (int)(frame.height - (visibleFrame.y + visibleFrame.height));
        monitor.clientWidth = (int)visibleFrame.width;
        monitor.clientHeight = (int)visibleFrame.height;
        return monitor;
    }

    public Shell[] getShells() {
        this.checkDevice();
        NSArray windows = this.application.windows();
        int index = 0;
        Shell[] result = new Shell[(int)windows.count()];
        for (int i = 0; i < result.length; ++i) {
            NSWindow window = new NSWindow(windows.objectAtIndex(i));
            Widget widget = this.getWidget(window.contentView());
            if (!(widget instanceof Shell)) continue;
            result[index++] = (Shell)widget;
        }
        if (index == result.length) {
            return result;
        }
        Shell[] newResult = new Shell[index];
        System.arraycopy(result, 0, newResult, 0, index);
        return newResult;
    }

    static boolean getSheetEnabled() {
        return !"false".equals(System.getProperty("org.eclipse.swt.sheet"));
    }

    public Synchronizer getSynchronizer() {
        this.checkDevice();
        return this.synchronizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getSyncThread() {
        Class clazz = class$org$eclipse$swt$graphics$Device == null ? (class$org$eclipse$swt$graphics$Device = Display.class$("org.eclipse.swt.graphics.Device")) : class$org$eclipse$swt$graphics$Device;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            return this.synchronizer.syncThread;
        }
    }

    public Color getSystemColor(int id2) {
        this.checkDevice();
        Color color = this.getWidgetColor(id2);
        if (color != null) {
            return color;
        }
        return super.getSystemColor(id2);
    }

    Color getWidgetColor(int id2) {
        if (0 <= id2 && id2 < this.colors.length && this.colors[id2] != null) {
            return Color.cocoa_new(this, this.colors[id2]);
        }
        return null;
    }

    double[] getWidgetColorRGB(int id2) {
        NSColor color = null;
        switch (id2) {
            case 28: {
                color = NSColor.blackColor();
                break;
            }
            case 29: {
                return new double[]{0.984f, 0.988f, 0.773f, 1.0};
            }
            case 30: {
                color = NSColor.windowFrameTextColor();
                break;
            }
            case 31: {
                color = NSColor.alternateSelectedControlColor();
                break;
            }
            case 32: {
                color = NSColor.selectedControlColor();
                break;
            }
            case 33: {
                color = NSColor.disabledControlTextColor();
                break;
            }
            case 34: {
                color = NSColor.secondarySelectedControlColor();
                break;
            }
            case 35: {
                color = NSColor.secondarySelectedControlColor();
                break;
            }
            case 17: {
                color = NSColor.controlDarkShadowColor();
                break;
            }
            case 18: {
                color = NSColor.controlShadowColor();
                break;
            }
            case 19: {
                color = NSColor.controlHighlightColor();
                break;
            }
            case 20: {
                color = NSColor.controlLightHighlightColor();
                break;
            }
            case 22: {
                color = NSColor.controlHighlightColor();
                break;
            }
            case 21: {
                color = NSColor.controlTextColor();
                break;
            }
            case 23: {
                color = NSColor.blackColor();
                break;
            }
            case 24: {
                color = NSColor.textColor();
                break;
            }
            case 25: {
                color = NSColor.textBackgroundColor();
                break;
            }
            case 27: {
                color = NSColor.selectedTextColor();
                break;
            }
            case 26: {
                color = NSColor.selectedTextBackgroundColor();
                break;
            }
            case 36: {
                NSTextView textView = (NSTextView)new NSTextView().alloc();
                textView.init();
                NSDictionary dict = textView.linkTextAttributes();
                color = new NSColor(dict.valueForKey(OS.NSForegroundColorAttributeName));
                textView.release();
            }
        }
        return this.getNSColorRGB(color);
    }

    double[] getNSColorRGB(NSColor color) {
        if (color == null) {
            return null;
        }
        NSColorSpace colorSpace = color.colorSpace();
        if (colorSpace == null || colorSpace.colorSpaceModel() != 1L) {
            color = color.colorUsingColorSpaceName(OS.NSDeviceRGBColorSpace);
        }
        if (color == null) {
            return null;
        }
        double[] components = new double[(int)color.numberOfComponents()];
        color.getComponents(components);
        return new double[]{components[0], components[1], components[2], components[3]};
    }

    public Cursor getSystemCursor(int id2) {
        this.checkDevice();
        if (0 > id2 || id2 >= this.cursors.length) {
            return null;
        }
        if (this.cursors[id2] == null) {
            this.cursors[id2] = new Cursor(this, id2);
        }
        return this.cursors[id2];
    }

    NSImage getSystemImageForID(int osType) {
        long[] iconRef = new long[1];
        OS.GetIconRefFromTypeInfo(1835098995, osType, 0L, 0L, 0, iconRef);
        NSImage nsImage = (NSImage)new NSImage().alloc();
        nsImage = nsImage.initWithIconRef(iconRef[0]);
        NSSize size = new NSSize();
        size.height = 32.0;
        size.width = 32.0;
        nsImage.setSize(size);
        nsImage.setScalesWhenResized(true);
        return nsImage;
    }

    public Image getSystemImage(int id2) {
        this.checkDevice();
        switch (id2) {
            case 1: {
                if (this.errorImage != null) {
                    return this.errorImage;
                }
                NSImage img = this.getSystemImageForID(1937010544);
                this.errorImage = Image.cocoa_new(this, 1, img);
                return this.errorImage;
            }
            case 2: 
            case 4: 
            case 16: {
                if (this.infoImage != null) {
                    return this.infoImage;
                }
                NSImage img = this.getSystemImageForID(1852798053);
                this.infoImage = Image.cocoa_new(this, 1, img);
                return this.infoImage;
            }
            case 8: {
                if (this.warningImage != null) {
                    return this.warningImage;
                }
                NSImage img = this.getSystemImageForID(1667331444);
                this.warningImage = Image.cocoa_new(this, 1, img);
                return this.warningImage;
            }
        }
        return null;
    }

    public Menu getMenuBar() {
        this.checkDevice();
        if (this.appMenuBar != null) {
            return this.appMenuBar;
        }
        this.appMenuBar = new Menu(this);
        return this.appMenuBar;
    }

    public Menu getSystemMenu() {
        this.checkDevice();
        if (this.appMenu == null) {
            NSMenu mainMenu = NSApplication.sharedApplication().mainMenu();
            NSMenu nsAppMenu = mainMenu.itemAtIndex(0L).submenu();
            this.appMenu = new Menu(this, nsAppMenu);
            long nsCount = nsAppMenu.numberOfItems();
            int j = 0;
            while ((long)j < nsCount) {
                NSMenuItem currMenuItem = nsAppMenu.itemAtIndex(j);
                new MenuItem(this.appMenu, currMenuItem);
                ++j;
            }
        }
        return this.appMenu;
    }

    public Tray getSystemTray() {
        this.checkDevice();
        if (this.tray != null) {
            return this.tray;
        }
        this.tray = new Tray(this, 0);
        return this.tray;
    }

    public TaskBar getSystemTaskBar() {
        this.checkDevice();
        if (this.taskBar != null) {
            return this.taskBar;
        }
        this.taskBar = new TaskBar(this, 0);
        return this.taskBar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getThread() {
        Class clazz = class$org$eclipse$swt$graphics$Device == null ? (class$org$eclipse$swt$graphics$Device = Display.class$("org.eclipse.swt.graphics.Device")) : class$org$eclipse$swt$graphics$Device;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            return this.thread;
        }
    }

    public boolean getTouchEnabled() {
        this.checkDevice();
        return OS.VERSION > 4179;
    }

    int getToolTipTime() {
        this.checkDevice();
        return 560;
    }

    Widget getWidget(long id2) {
        return Display.GetWidget(id2);
    }

    static Widget GetWidget(long id2) {
        NSObject key;
        LONG dynJNIRef;
        if (id2 == 0L) {
            return null;
        }
        long[] jniRef = new long[1];
        long iVar = OS.object_getInstanceVariable(id2, SWT_OBJECT, jniRef);
        if (iVar == 0L && dynamicObjectMap != null && (dynJNIRef = (LONG)dynamicObjectMap.get(key = new NSObject(id2))) != null) {
            jniRef[0] = dynJNIRef.value;
        }
        if (jniRef[0] == 0L) {
            return null;
        }
        return (Widget)OS.JNIGetObject(jniRef[0]);
    }

    Widget getWidget(NSView view) {
        if (view == null) {
            return null;
        }
        return this.getWidget(view.id);
    }

    boolean hasDefaultButton() {
        NSArray windows = this.application.windows();
        long count = windows.count();
        int i = 0;
        while ((long)i < count) {
            NSWindow window = new NSWindow(windows.objectAtIndex(i));
            if (window.defaultButtonCell() != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void init() {
        long method;
        long mode;
        NSMenu appleMenu;
        NSMenuItem prefsItem;
        super.init();
        this.initClasses();
        this.initColors();
        this.initFonts();
        if (applicationDelegate == null) {
            applicationDelegate = (SWTApplicationDelegate)new SWTApplicationDelegate().alloc().init();
            if (currAppDelegate == null) {
                long currDelegatePtr;
                if (OS.class_JRSAppKitAWT != 0L && (currDelegatePtr = OS.objc_msgSend(OS.class_JRSAppKitAWT, OS.sel_awtAppDelegate)) != 0L) {
                    currAppDelegate = new NSObject(currDelegatePtr);
                    currAppDelegate.retain();
                }
                this.application.setDelegate(applicationDelegate);
            }
        }
        if (!launched) {
            this.application.finishLaunching();
            launched = true;
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    NSApplication.sharedApplication().terminate(null);
                }
            });
        }
        if ((prefsItem = (appleMenu = this.application.mainMenu().itemAtIndex(0L).submenu()).itemWithTag(-2L)) != null) {
            prefsItem.setTag(42L);
        }
        if (currAppDelegate != null) {
            currAppDelegate.init();
        }
        if (prefsItem != null) {
            prefsItem.setTag(-2L);
        }
        this.observerCallback = new Callback(this, "observerProc", 3);
        long observerProc = this.observerCallback.getAddress();
        if (observerProc == 0L) {
            this.error(3);
        }
        int activities = 32;
        this.runLoopObserver = OS.CFRunLoopObserverCreate(0L, activities, true, 0L, observerProc, 0L);
        if (this.runLoopObserver == 0L) {
            this.error(2);
        }
        OS.CFRunLoopAddObserver(OS.CFRunLoopGetCurrent(), this.runLoopObserver, OS.kCFRunLoopCommonModes());
        long cls = OS.objc_lookUpClass("JNFRunLoop");
        if (cls != 0L && (mode = OS.objc_msgSend(cls, OS.sel_javaRunLoopMode)) != 0L) {
            OS.CFRunLoopAddObserver(OS.CFRunLoopGetCurrent(), this.runLoopObserver, mode);
        }
        this.cursorSetCallback = new Callback(this, "cursorSetProc", 2);
        long cursorSetProc = this.cursorSetCallback.getAddress();
        if (cursorSetProc == 0L) {
            this.error(3);
        }
        if ((method = OS.class_getInstanceMethod(OS.class_NSCursor, OS.sel_set)) != 0L) {
            this.oldCursorSetProc = OS.method_setImplementation(method, cursorSetProc);
        }
        this.timerDelegate = (SWTWindowDelegate)new SWTWindowDelegate().alloc().init();
        this.settingsDelegate = (SWTWindowDelegate)new SWTWindowDelegate().alloc().init();
        NSNotificationCenter defaultCenter = NSNotificationCenter.defaultCenter();
        defaultCenter.addObserver(this.settingsDelegate, OS.sel_systemSettingsChanged_, OS.NSSystemColorsDidChangeNotification, null);
        defaultCenter.addObserver(this.settingsDelegate, OS.sel_systemSettingsChanged_, OS.NSApplicationDidChangeScreenParametersNotification, null);
        NSTextView textView = (NSTextView)new NSTextView().alloc();
        textView.init();
        this.markedAttributes = textView.markedTextAttributes();
        this.markedAttributes.retain();
        textView.release();
        NSUserDefaults defaults = NSUserDefaults.standardUserDefaults();
        defaults.setInteger(0L, NSString.stringWith(OS.VERSION >= 4224 ? "NSScrollAnimationEnabled" : "AppleScrollAnimationEnabled"));
        id blink = defaults.objectForKey(NSString.stringWith("NSTextInsertionPointBlinkPeriod"));
        if (blink != null) {
            this.blinkTime = (int)new NSNumber(blink).integerValue();
        }
        if (this.blinkTime == 0) {
            this.blinkTime = 560;
        }
        this.isPainting = (NSMutableArray)new NSMutableArray().alloc();
        this.isPainting = this.isPainting.initWithCapacity(12L);
    }

    void addEventMethods(long cls, long proc2, long proc3, long drawRectProc, long hitTestProc, long needsDisplayInRectProc) {
        if (proc3 != 0L) {
            OS.class_addMethod(cls, OS.sel_mouseDown_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_mouseUp_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_scrollWheel_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_rightMouseDown_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_rightMouseUp_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_rightMouseDragged_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_otherMouseDown_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_otherMouseUp_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_otherMouseDragged_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_mouseDragged_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_mouseMoved_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_mouseEntered_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_mouseExited_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_menuForEvent_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_keyDown_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_keyUp_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_flagsChanged_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_cursorUpdate_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_setNeedsDisplay_, proc3, "@:B");
            OS.class_addMethod(cls, OS.sel_shouldDelayWindowOrderingForEvent_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_acceptsFirstMouse_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_changeColor_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_cancelOperation_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_touchesBeganWithEvent_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_touchesMovedWithEvent_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_touchesEndedWithEvent_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_touchesCancelledWithEvent_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_beginGestureWithEvent_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_endGestureWithEvent_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_swipeWithEvent_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_rotateWithEvent_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_magnifyWithEvent_, proc3, "@:@");
        }
        if (proc2 != 0L) {
            OS.class_addMethod(cls, OS.sel_resignFirstResponder, proc2, "@:");
            OS.class_addMethod(cls, OS.sel_becomeFirstResponder, proc2, "@:");
            OS.class_addMethod(cls, OS.sel_resetCursorRects, proc2, "@:");
            OS.class_addMethod(cls, OS.sel_updateTrackingAreas, proc2, "@:");
            OS.class_addMethod(cls, OS.sel_getImageView, proc2, "@:");
            OS.class_addMethod(cls, OS.sel_mouseDownCanMoveWindow, proc2, "@:");
        }
        if (needsDisplayInRectProc != 0L) {
            OS.class_addMethod(cls, OS.sel_setNeedsDisplayInRect_, needsDisplayInRectProc, "@:{NSRect}");
        }
        if (drawRectProc != 0L) {
            OS.class_addMethod(cls, OS.sel_drawRect_, drawRectProc, "@:{NSRect}");
        }
        if (hitTestProc != 0L) {
            OS.class_addMethod(cls, OS.sel_hitTest_, hitTestProc, "@:{NSPoint}");
        }
    }

    void addFrameMethods(long cls, long setFrameOriginProc, long setFrameSizeProc) {
        OS.class_addMethod(cls, OS.sel_setFrameOrigin_, setFrameOriginProc, "@:{NSPoint}");
        OS.class_addMethod(cls, OS.sel_setFrameSize_, setFrameSizeProc, "@:{NSSize}");
    }

    void addAccessibilityMethods(long cls, long proc2, long proc3, long proc4, long accessibilityHitTestProc) {
        OS.class_addMethod(cls, OS.sel_accessibilityActionNames, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_accessibilityAttributeNames, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_accessibilityParameterizedAttributeNames, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_accessibilityFocusedUIElement, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_accessibilityIsIgnored, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_accessibilityAttributeValue_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_accessibilityHitTest_, accessibilityHitTestProc, "@:{NSPoint}");
        OS.class_addMethod(cls, OS.sel_accessibilityAttributeValue_forParameter_, proc4, "@:@@");
        OS.class_addMethod(cls, OS.sel_accessibilityPerformAction_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_accessibilityActionDescription_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_accessibilityIsAttributeSettable_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_accessibilitySetValue_forAttribute_, proc4, "@:@@");
        OS.class_addMethod(cls, OS.sel_accessibleHandle, proc2, "@:");
    }

    long registerCellSubclass(long cellClass, int size, int align, byte[] types) {
        String cellClassName = OS.class_getName(cellClass);
        long cls = OS.objc_allocateClassPair(cellClass, "SWTAccessible" + cellClassName, 0L);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.objc_registerClassPair(cls);
        return cls;
    }

    long createWindowSubclass(long baseClass, String newClass, boolean isDynamic) {
        long cls = OS.objc_lookUpClass(newClass);
        if (cls != 0L) {
            return cls;
        }
        cls = OS.objc_allocateClassPair(baseClass, newClass, 0L);
        long proc3 = windowCallback3.getAddress();
        long proc2 = windowCallback2.getAddress();
        long proc4 = windowCallback4.getAddress();
        long proc6 = windowCallback6.getAddress();
        long view_stringForToolTip_point_userDataProc = OS.CALLBACK_view_stringForToolTip_point_userData_(proc6);
        long accessibilityHitTestProc = OS.CALLBACK_accessibilityHitTest_(proc3);
        if (!isDynamic) {
            OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        }
        OS.class_addMethod(cls, OS.sel_sendEvent_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_helpRequested_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_canBecomeKeyWindow, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_becomeKeyWindow, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_makeFirstResponder_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_noResponderFor_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_view_stringForToolTip_point_userData_, view_stringForToolTip_point_userDataProc, "@:@i{NSPoint}@");
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.objc_registerClassPair(cls);
        return cls;
    }

    long createMenuSubclass(long baseClass, String newClass, boolean isDynamic) {
        long cls = OS.objc_lookUpClass(newClass);
        if (cls != 0L) {
            return cls;
        }
        cls = OS.objc_allocateClassPair(baseClass, newClass, 0L);
        long proc3 = windowCallback3.getAddress();
        long proc4 = windowCallback4.getAddress();
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_menuWillOpen_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_menuDidClose_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_menu_willHighlightItem_, proc4, "@:@@");
        OS.class_addMethod(cls, OS.sel_menuNeedsUpdate_, proc3, "@:@");
        OS.objc_registerClassPair(cls);
        return cls;
    }

    long createMenuItemSubclass(long baseClass, String newClass, boolean isDynamic) {
        long cls = OS.objc_lookUpClass(newClass);
        if (cls != 0L) {
            return cls;
        }
        cls = OS.objc_allocateClassPair(baseClass, newClass, 0L);
        long proc2 = windowCallback2.getAddress();
        if (!isDynamic) {
            OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        }
        OS.class_addMethod(cls, OS.sel_sendSelection, proc2, "@:");
        OS.objc_registerClassPair(cls);
        return cls;
    }

    void initClasses() {
        long proc6;
        long proc5;
        long proc4;
        long proc2;
        long proc3;
        long dialogProc5;
        long dialogProc4;
        if (OS.objc_lookUpClass("SWTView") != 0L) {
            return;
        }
        Class<?> clazz = this.getClass();
        dialogCallback3 = new Callback(clazz, "dialogProc", 3);
        long dialogProc3 = dialogCallback3.getAddress();
        if (dialogProc3 == 0L) {
            this.error(3);
        }
        if ((dialogProc4 = (dialogCallback4 = new Callback(clazz, "dialogProc", 4)).getAddress()) == 0L) {
            this.error(3);
        }
        if ((dialogProc5 = (dialogCallback5 = new Callback(clazz, "dialogProc", 5)).getAddress()) == 0L) {
            this.error(3);
        }
        if ((proc3 = (windowCallback3 = new Callback(clazz, "windowProc", 3)).getAddress()) == 0L) {
            this.error(3);
        }
        if ((proc2 = (windowCallback2 = new Callback(clazz, "windowProc", 2)).getAddress()) == 0L) {
            this.error(3);
        }
        if ((proc4 = (windowCallback4 = new Callback(clazz, "windowProc", 4)).getAddress()) == 0L) {
            this.error(3);
        }
        if ((proc5 = (windowCallback5 = new Callback(clazz, "windowProc", 5)).getAddress()) == 0L) {
            this.error(3);
        }
        if ((proc6 = (windowCallback6 = new Callback(clazz, "windowProc", 6)).getAddress()) == 0L) {
            this.error(3);
        }
        long isFlippedProc = OS.isFlipped_CALLBACK();
        long drawRectProc = OS.CALLBACK_drawRect_(proc3);
        long drawInteriorWithFrameInViewProc = OS.CALLBACK_drawInteriorWithFrame_inView_(proc4);
        long drawWithExpansionFrameProc = OS.CALLBACK_drawWithExpansionFrame_inView_(proc4);
        long imageRectForBoundsProc = OS.CALLBACK_imageRectForBounds_(proc3);
        long titleRectForBoundsProc = OS.CALLBACK_titleRectForBounds_(proc3);
        long cellSizeForBoundsProc = OS.CALLBACK_cellSizeForBounds_(proc3);
        long hitTestForEvent_inRect_ofViewProc = OS.CALLBACK_hitTestForEvent_inRect_ofView_(proc5);
        long cellSizeProc = OS.CALLBACK_cellSize(proc2);
        long drawImageWithFrameInViewProc = OS.CALLBACK_drawImage_withFrame_inView_(proc5);
        long drawTitleWithFrameInViewProc = OS.CALLBACK_drawTitle_withFrame_inView_(proc5);
        long setFrameOriginProc = OS.CALLBACK_setFrameOrigin_(proc3);
        long setFrameSizeProc = OS.CALLBACK_setFrameSize_(proc3);
        long hitTestProc = OS.CALLBACK_hitTest_(proc3);
        long markedRangeProc = OS.CALLBACK_markedRange(proc2);
        long selectedRangeProc = OS.CALLBACK_selectedRange(proc2);
        long highlightSelectionInClipRectProc = OS.CALLBACK_highlightSelectionInClipRect_(proc3);
        long setMarkedText_selectedRangeProc = OS.CALLBACK_setMarkedText_selectedRange_(proc4);
        long attributedSubstringFromRangeProc = OS.CALLBACK_attributedSubstringFromRange_(proc3);
        long characterIndexForPointProc = OS.CALLBACK_characterIndexForPoint_(proc3);
        long firstRectForCharacterRangeProc = OS.CALLBACK_firstRectForCharacterRange_(proc3);
        long textWillChangeSelectionProc = OS.CALLBACK_textView_willChangeSelectionFromCharacterRange_toCharacterRange_(proc5);
        long accessibilityHitTestProc = OS.CALLBACK_accessibilityHitTest_(proc3);
        long shouldChangeTextInRange_replacementString_Proc = OS.CALLBACK_shouldChangeTextInRange_replacementString_(proc4);
        long view_stringForToolTip_point_userDataProc = OS.CALLBACK_view_stringForToolTip_point_userData_(proc6);
        long canDragRowsWithIndexes_atPoint_Proc = OS.CALLBACK_canDragRowsWithIndexes_atPoint_(proc4);
        long setNeedsDisplayInRectProc = OS.CALLBACK_setNeedsDisplayInRect_(proc3);
        long expansionFrameWithFrameProc = OS.CALLBACK_expansionFrameWithFrame_inView_(proc4);
        long sizeOfLabelProc = OS.CALLBACK_sizeOfLabel_(proc3);
        long drawLabelInRectProc = OS.CALLBACK_drawLabel_inRect_(proc4);
        long drawViewBackgroundInRectProc = OS.CALLBACK_drawViewBackgroundInRect_(proc3);
        long drawBackgroundInClipRectProc = OS.CALLBACK_drawBackgroundInClipRect_(proc3);
        long scrollClipView_ToPointProc = OS.CALLBACK_scrollClipView_toPoint_(proc4);
        long headerRectOfColumnProc = OS.CALLBACK_headerRectOfColumn_(proc3);
        long columnAtPointProc = OS.CALLBACK_columnAtPoint_(proc3);
        String className = "SWTBox";
        long cls = OS.objc_allocateClassPair(OS.class_NSBox, className, 0L);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        this.addEventMethods(cls, proc2, proc3, drawRectProc, hitTestProc, setNeedsDisplayInRectProc);
        this.addFrameMethods(cls, setFrameOriginProc, setFrameSizeProc);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.objc_registerClassPair(cls);
        className = "SWTButton";
        cls = OS.objc_allocateClassPair(OS.class_NSButton, className, 0L);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_sendSelection, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_validateMenuItem_, proc3, "@:@");
        this.addEventMethods(cls, proc2, proc3, drawRectProc, hitTestProc, setNeedsDisplayInRectProc);
        this.addFrameMethods(cls, setFrameOriginProc, setFrameSizeProc);
        OS.objc_registerClassPair(cls);
        OS.class_addMethod(OS.object_getClass(cls), OS.sel_cellClass, proc2, "@:");
        cls = this.registerCellSubclass(NSButton.cellClass(), size, align, types);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.class_addMethod(cls, OS.sel_nextState, proc2, "@:");
        className = "SWTButtonCell";
        cls = OS.objc_allocateClassPair(OS.class_NSButtonCell, className, 0L);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.class_addMethod(cls, OS.sel_drawImage_withFrame_inView_, drawImageWithFrameInViewProc, "@:@{NSRect}@");
        OS.class_addMethod(cls, OS.sel_drawTitle_withFrame_inView_, drawTitleWithFrameInViewProc, "@:@{NSRect}@");
        OS.class_addMethod(cls, OS.sel_drawInteriorWithFrame_inView_, drawInteriorWithFrameInViewProc, "@:{NSRect}@");
        OS.class_addMethod(cls, OS.sel_titleRectForBounds_, titleRectForBoundsProc, "@:{NSRect}");
        OS.class_addMethod(cls, OS.sel_cellSizeForBounds_, cellSizeForBoundsProc, "@:{NSRect}");
        OS.objc_registerClassPair(cls);
        className = "SWTCanvasView";
        cls = OS.objc_allocateClassPair(OS.class_NSView, className, 0L);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addProtocol(cls, OS.protocol_NSTextInput);
        OS.class_addMethod(cls, OS.sel_hasMarkedText, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_markedRange, markedRangeProc, "@:");
        OS.class_addMethod(cls, OS.sel_selectedRange, selectedRangeProc, "@:");
        OS.class_addMethod(cls, OS.sel_setMarkedText_selectedRange_, setMarkedText_selectedRangeProc, "@:@{NSRange}");
        OS.class_addMethod(cls, OS.sel_unmarkText, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_validAttributesForMarkedText, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_attributedSubstringFromRange_, attributedSubstringFromRangeProc, "@:{NSRange}");
        OS.class_addMethod(cls, OS.sel_insertText_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_characterIndexForPoint_, characterIndexForPointProc, "@:{NSPoint}");
        OS.class_addMethod(cls, OS.sel_firstRectForCharacterRange_, firstRectForCharacterRangeProc, "@:{NSRange}");
        OS.class_addMethod(cls, OS.sel_doCommandBySelector_, proc3, "@::");
        OS.class_addMethod(cls, OS.sel_canBecomeKeyView, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_isFlipped, isFlippedProc, "@:");
        OS.class_addMethod(cls, OS.sel_acceptsFirstResponder, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_isOpaque, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_updateOpenGLContext_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_clearDeferFlushing, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_validRequestorForSendType_returnType_, proc4, "@:@@");
        OS.class_addMethod(cls, OS.sel_readSelectionFromPasteboard_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_writeSelectionToPasteboard_types_, proc4, "@:@@");
        OS.class_addMethod(cls, OS.sel_viewWillMoveToWindow_, proc3, "@:@");
        this.addEventMethods(cls, proc2, proc3, drawRectProc, hitTestProc, setNeedsDisplayInRectProc);
        this.addFrameMethods(cls, setFrameOriginProc, setFrameSizeProc);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.objc_registerClassPair(cls);
        className = "SWTComboBox";
        cls = OS.objc_allocateClassPair(OS.class_NSComboBox, className, 0L);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_sendSelection, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_textDidChange_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_textViewDidChangeSelection_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_comboBoxSelectionDidChange_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_comboBoxWillDismiss_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_comboBoxWillPopUp_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_textView_willChangeSelectionFromCharacterRange_toCharacterRange_, textWillChangeSelectionProc, "@:@{NSRange}{NSRange}");
        this.addEventMethods(cls, proc2, proc3, drawRectProc, hitTestProc, setNeedsDisplayInRectProc);
        this.addFrameMethods(cls, setFrameOriginProc, setFrameSizeProc);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.objc_registerClassPair(cls);
        OS.class_addMethod(OS.object_getClass(cls), OS.sel_cellClass, proc2, "@:");
        cls = this.registerCellSubclass(NSComboBox.cellClass(), size, align, types);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.class_addMethod(cls, OS.sel_setObjectValue_, proc3, "@:@");
        className = "SWTDatePicker";
        cls = OS.objc_allocateClassPair(OS.class_NSDatePicker, className, 0L);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_isFlipped, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_sendSelection, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_sendVerticalSelection, proc2, "@:");
        this.addEventMethods(cls, proc2, proc3, drawRectProc, hitTestProc, setNeedsDisplayInRectProc);
        this.addFrameMethods(cls, setFrameOriginProc, setFrameSizeProc);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.objc_registerClassPair(cls);
        className = "SWTEditorView";
        cls = OS.objc_allocateClassPair(OS.class_NSTextView, className, 0L);
        this.addEventMethods(cls, 0L, proc3, drawRectProc, 0L, 0L);
        OS.class_addMethod(cls, OS.sel_insertText_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_doCommandBySelector_, proc3, "@::");
        OS.class_addMethod(cls, OS.sel_shouldChangeTextInRange_replacementString_, shouldChangeTextInRange_replacementString_Proc, "@:{NSRange}@");
        OS.objc_registerClassPair(cls);
        className = "SWTImageView";
        cls = OS.objc_allocateClassPair(OS.class_NSImageView, className, 0L);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_isFlipped, isFlippedProc, "@:");
        this.addEventMethods(cls, proc2, proc3, drawRectProc, hitTestProc, setNeedsDisplayInRectProc);
        this.addFrameMethods(cls, setFrameOriginProc, setFrameSizeProc);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.objc_registerClassPair(cls);
        OS.class_addMethod(OS.object_getClass(cls), OS.sel_cellClass, proc2, "@:");
        cls = this.registerCellSubclass(NSImageView.cellClass(), size, align, types);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        className = "SWTImageTextCell";
        cls = OS.objc_allocateClassPair(OS.class_NSTextFieldCell, className, 0L);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addIvar(cls, SWT_IMAGE, size, (byte)align, types);
        OS.class_addIvar(cls, SWT_ROW, size, (byte)align, types);
        OS.class_addIvar(cls, SWT_COLUMN, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_drawInteriorWithFrame_inView_, drawInteriorWithFrameInViewProc, "@:{NSRect}@");
        OS.class_addMethod(cls, OS.sel_drawWithExpansionFrame_inView_, drawWithExpansionFrameProc, "@:{NSRect}@");
        OS.class_addMethod(cls, OS.sel_imageRectForBounds_, imageRectForBoundsProc, "@:{NSRect}");
        OS.class_addMethod(cls, OS.sel_titleRectForBounds_, titleRectForBoundsProc, "@:{NSRect}");
        OS.class_addMethod(cls, OS.sel_hitTestForEvent_inRect_ofView_, hitTestForEvent_inRect_ofViewProc, "@:@{NSRect}@");
        OS.class_addMethod(cls, OS.sel_cellSize, cellSizeProc, "@:");
        OS.class_addMethod(cls, OS.sel_image, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_setImage_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_expansionFrameWithFrame_inView_, expansionFrameWithFrameProc, "@:{NSRect}@");
        OS.objc_registerClassPair(cls);
        this.createMenuSubclass(OS.class_NSMenu, "SWTMenu", false);
        this.createMenuItemSubclass(OS.class_NSMenuItem, "SWTMenuItem", false);
        className = "SWTOutlineView";
        cls = OS.objc_allocateClassPair(OS.class_NSOutlineView, className, 0L);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_highlightSelectionInClipRect_, highlightSelectionInClipRectProc, "@:{NSRect}");
        OS.class_addMethod(cls, OS.sel_sendDoubleSelection, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_outlineViewSelectionDidChange_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_outlineViewSelectionIsChanging_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_outlineView_child_ofItem_, proc5, "@:@i@");
        OS.class_addMethod(cls, OS.sel_outlineView_isItemExpandable_, proc4, "@:@@");
        OS.class_addMethod(cls, OS.sel_outlineView_numberOfChildrenOfItem_, proc4, "@:@@");
        OS.class_addMethod(cls, OS.sel_selectRowIndexes_byExtendingSelection_, proc4, "@:@Z");
        OS.class_addMethod(cls, OS.sel_deselectRow_, proc3, "@:i");
        OS.class_addMethod(cls, OS.sel_deselectAll_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_outlineView_objectValueForTableColumn_byItem_, proc5, "@:@@@");
        OS.class_addMethod(cls, OS.sel_outlineView_willDisplayCell_forTableColumn_item_, proc6, "@:@@@@");
        OS.class_addMethod(cls, OS.sel_outlineView_shouldReorderColumn_toColumn_, proc5, "@:@ii");
        OS.class_addMethod(cls, OS.sel_outlineView_setObjectValue_forTableColumn_byItem_, proc6, "@:@@@@");
        OS.class_addMethod(cls, OS.sel_outlineView_shouldEditTableColumn_item_, proc5, "@:@@@");
        OS.class_addMethod(cls, OS.sel_outlineView_shouldTrackCell_forTableColumn_item_, proc6, "@:@@@@@@");
        OS.class_addMethod(cls, OS.sel_outlineView_shouldExpandItem_, proc4, "@:@@");
        OS.class_addMethod(cls, OS.sel_setShouldExpandItem_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_setShouldScrollClipView_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_outlineViewColumnDidMove_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_outlineViewColumnDidResize_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_outlineView_didClickTableColumn_, proc4, "@:@@");
        OS.class_addMethod(cls, OS.sel_canDragRowsWithIndexes_atPoint_, canDragRowsWithIndexes_atPoint_Proc, "@:@{NSPoint=ff}");
        OS.class_addMethod(cls, OS.sel_outlineView_writeItems_toPasteboard_, proc5, "@:@@@");
        OS.class_addMethod(cls, OS.sel_expandItem_expandChildren_, proc4, "@:@Z");
        OS.class_addMethod(cls, OS.sel_collapseItem_collapseChildren_, proc4, "@:@Z");
        OS.class_addMethod(cls, OS.sel_drawBackgroundInClipRect_, drawBackgroundInClipRectProc, "@:{NSRect}");
        OS.class_addMethod(cls, OS.sel_acceptsFirstResponder, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_needsPanelToBecomeKey, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_canBecomeKeyView, proc2, "@:");
        this.addEventMethods(cls, proc2, proc3, drawRectProc, hitTestProc, setNeedsDisplayInRectProc);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.objc_registerClassPair(cls);
        className = "SWTPanelDelegate";
        cls = OS.objc_allocateClassPair(OS.class_NSObject, className, 0L);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_windowWillClose_, dialogProc3, "@:@");
        OS.class_addMethod(cls, OS.sel_changeColor_, dialogProc3, "@:@");
        OS.class_addMethod(cls, OS.sel_setColor_forAttribute_, dialogProc4, "@:@@");
        OS.class_addMethod(cls, OS.sel_changeFont_, dialogProc3, "@:@");
        OS.class_addMethod(cls, OS.sel_validModesForFontPanel_, dialogProc3, "@:@");
        OS.class_addMethod(cls, OS.sel_sendSelection_, dialogProc3, "@:@");
        OS.class_addMethod(cls, OS.sel_panel_shouldShowFilename_, dialogProc4, "@:@@");
        OS.class_addMethod(cls, OS.sel_panelDidEnd_returnCode_contextInfo_, dialogProc5, "@:@i@");
        OS.objc_registerClassPair(cls);
        className = "SWTPopUpButton";
        cls = OS.objc_allocateClassPair(OS.class_NSPopUpButton, className, 0L);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_sendSelection, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_menuWillOpen_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_menuDidClose_, proc3, "@:@");
        this.addEventMethods(cls, proc2, proc3, drawRectProc, hitTestProc, setNeedsDisplayInRectProc);
        this.addFrameMethods(cls, setFrameOriginProc, setFrameSizeProc);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.objc_registerClassPair(cls);
        OS.class_addMethod(OS.object_getClass(cls), OS.sel_cellClass, proc2, "@:");
        cls = this.registerCellSubclass(NSPopUpButton.cellClass(), size, align, types);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        className = "SWTProgressIndicator";
        cls = OS.objc_allocateClassPair(OS.class_NSProgressIndicator, className, 0L);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_viewDidMoveToWindow, proc2, "@:");
        OS.class_addMethod(cls, OS.sel__drawThemeProgressArea_, proc3, "@:c");
        this.addEventMethods(cls, proc2, proc3, drawRectProc, hitTestProc, setNeedsDisplayInRectProc);
        this.addFrameMethods(cls, setFrameOriginProc, setFrameSizeProc);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.objc_registerClassPair(cls);
        className = "SWTScroller";
        cls = OS.objc_allocateClassPair(OS.class_NSScroller, className, 0L);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_sendSelection, proc2, "@:");
        this.addEventMethods(cls, proc2, proc3, drawRectProc, hitTestProc, setNeedsDisplayInRectProc);
        this.addFrameMethods(cls, setFrameOriginProc, setFrameSizeProc);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.objc_registerClassPair(cls);
        if (OS.VERSION >= 4208) {
            long metaClass = OS.objc_getMetaClass(className);
            OS.class_addMethod(metaClass, OS.sel_isCompatibleWithOverlayScrollers, isFlippedProc, "@:");
        }
        className = "SWTScrollView";
        cls = OS.objc_allocateClassPair(OS.class_NSScrollView, className, 0L);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_sendVerticalSelection, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_sendHorizontalSelection, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_pageDown_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_pageUp_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_reflectScrolledClipView_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_scrollClipView_toPoint_, scrollClipView_ToPointProc, "@:@{NSPoint}");
        this.addEventMethods(cls, proc2, proc3, drawRectProc, hitTestProc, setNeedsDisplayInRectProc);
        this.addFrameMethods(cls, setFrameOriginProc, setFrameSizeProc);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.objc_registerClassPair(cls);
        className = "SWTSearchField";
        cls = OS.objc_allocateClassPair(OS.class_NSSearchField, className, 0L);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        this.addEventMethods(cls, proc2, proc3, drawRectProc, hitTestProc, setNeedsDisplayInRectProc);
        this.addFrameMethods(cls, setFrameOriginProc, setFrameSizeProc);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.class_addMethod(cls, OS.sel_textDidChange_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_textViewDidChangeSelection_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_textView_willChangeSelectionFromCharacterRange_toCharacterRange_, textWillChangeSelectionProc, "@:@{NSRange}{NSRange}");
        OS.class_addMethod(cls, OS.sel_sendSearchSelection, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_sendCancelSelection, proc2, "@:");
        OS.objc_registerClassPair(cls);
        OS.class_addMethod(OS.object_getClass(cls), OS.sel_cellClass, proc2, "@:");
        cls = this.registerCellSubclass(NSSearchField.cellClass(), size, align, types);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        className = "SWTSecureTextField";
        cls = OS.objc_allocateClassPair(OS.class_NSSecureTextField, className, 0L);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        this.addEventMethods(cls, proc2, proc3, drawRectProc, hitTestProc, setNeedsDisplayInRectProc);
        this.addFrameMethods(cls, setFrameOriginProc, setFrameSizeProc);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.class_addMethod(cls, OS.sel_textDidChange_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_textViewDidChangeSelection_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_textView_willChangeSelectionFromCharacterRange_toCharacterRange_, textWillChangeSelectionProc, "@:@{NSRange}{NSRange}");
        OS.objc_registerClassPair(cls);
        long nsSecureTextViewClass = OS.objc_lookUpClass("NSSecureTextView");
        if (nsSecureTextViewClass != 0L) {
            className = "SWTSecureEditorView";
            cls = OS.objc_allocateClassPair(nsSecureTextViewClass, className, 0L);
            this.addEventMethods(cls, 0L, proc3, drawRectProc, 0L, 0L);
            OS.class_addMethod(cls, OS.sel_insertText_, proc3, "@:@");
            OS.class_addMethod(cls, OS.sel_doCommandBySelector_, proc3, "@::");
            OS.class_addMethod(cls, OS.sel_shouldChangeTextInRange_replacementString_, shouldChangeTextInRange_replacementString_Proc, "@:{NSRange}@");
            OS.objc_registerClassPair(cls);
        }
        className = "SWTSlider";
        cls = OS.objc_allocateClassPair(OS.class_NSSlider, className, 0L);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_sendSelection, proc2, "@:");
        this.addEventMethods(cls, proc2, proc3, drawRectProc, hitTestProc, setNeedsDisplayInRectProc);
        this.addFrameMethods(cls, setFrameOriginProc, setFrameSizeProc);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.objc_registerClassPair(cls);
        OS.class_addMethod(OS.object_getClass(cls), OS.sel_cellClass, proc2, "@:");
        cls = this.registerCellSubclass(NSSlider.cellClass(), size, align, types);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        className = "SWTStepper";
        cls = OS.objc_allocateClassPair(OS.class_NSStepper, className, 0L);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_sendSelection, proc2, "@:");
        this.addEventMethods(cls, proc2, proc3, drawRectProc, hitTestProc, setNeedsDisplayInRectProc);
        this.addFrameMethods(cls, setFrameOriginProc, setFrameSizeProc);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.objc_registerClassPair(cls);
        OS.class_addMethod(OS.object_getClass(cls), OS.sel_cellClass, proc2, "@:");
        cls = this.registerCellSubclass(NSStepper.cellClass(), size, align, types);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        className = "SWTTableHeaderCell";
        cls = OS.objc_allocateClassPair(OS.class_NSTableHeaderCell, className, 0L);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_drawInteriorWithFrame_inView_, drawInteriorWithFrameInViewProc, "@:{NSRect}@");
        OS.objc_registerClassPair(cls);
        className = "SWTTableHeaderView";
        cls = OS.objc_allocateClassPair(OS.class_NSTableHeaderView, className, 0L);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_mouseDown_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_resetCursorRects, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_updateTrackingAreas, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_menuForEvent_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_headerRectOfColumn_, headerRectOfColumnProc, "@:i");
        OS.class_addMethod(cls, OS.sel_columnAtPoint_, columnAtPointProc, "@:{NSPoint}");
        OS.objc_registerClassPair(cls);
        className = "SWTTableView";
        cls = OS.objc_allocateClassPair(OS.class_NSTableView, className, 0L);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_highlightSelectionInClipRect_, highlightSelectionInClipRectProc, "@:{NSRect}");
        OS.class_addMethod(cls, OS.sel_sendDoubleSelection, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_numberOfRowsInTableView_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_tableView_objectValueForTableColumn_row_, proc5, "@:@@i");
        OS.class_addMethod(cls, OS.sel_tableView_shouldEditTableColumn_row_, proc5, "@:@@i");
        OS.class_addMethod(cls, OS.sel_tableView_shouldReorderColumn_toColumn_, proc5, "@:@ii");
        OS.class_addMethod(cls, OS.sel_tableView_shouldTrackCell_forTableColumn_row_, proc6, "@:@@@i");
        OS.class_addMethod(cls, OS.sel_tableViewSelectionIsChanging_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_tableViewSelectionDidChange_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_tableView_willDisplayCell_forTableColumn_row_, proc6, "@:@@@i");
        OS.class_addMethod(cls, OS.sel_tableView_setObjectValue_forTableColumn_row_, proc6, "@:@@@i");
        OS.class_addMethod(cls, OS.sel_tableViewColumnDidMove_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_tableViewColumnDidResize_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_setShouldScrollClipView_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_tableView_didClickTableColumn_, proc4, "@:@@");
        OS.class_addMethod(cls, OS.sel_canDragRowsWithIndexes_atPoint_, canDragRowsWithIndexes_atPoint_Proc, "@:@{NSPoint=ff}");
        OS.class_addMethod(cls, OS.sel_selectRowIndexes_byExtendingSelection_, proc4, "@:@Z");
        OS.class_addMethod(cls, OS.sel_deselectRow_, proc3, "@:i");
        OS.class_addMethod(cls, OS.sel_deselectAll_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_tableView_writeRowsWithIndexes_toPasteboard_, proc5, "@:@@@");
        OS.class_addMethod(cls, OS.sel_drawBackgroundInClipRect_, drawBackgroundInClipRectProc, "@:{NSRect}");
        OS.class_addMethod(cls, OS.sel_acceptsFirstResponder, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_needsPanelToBecomeKey, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_canBecomeKeyView, proc2, "@:");
        this.addEventMethods(cls, proc2, proc3, drawRectProc, hitTestProc, setNeedsDisplayInRectProc);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.objc_registerClassPair(cls);
        className = "SWTTabView";
        cls = OS.objc_allocateClassPair(OS.class_NSTabView, className, 0L);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_tabView_willSelectTabViewItem_, proc4, "@:@@");
        OS.class_addMethod(cls, OS.sel_tabView_didSelectTabViewItem_, proc4, "@:@@");
        this.addEventMethods(cls, proc2, proc3, drawRectProc, hitTestProc, setNeedsDisplayInRectProc);
        this.addFrameMethods(cls, setFrameOriginProc, setFrameSizeProc);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.objc_registerClassPair(cls);
        className = "SWTTabViewItem";
        cls = OS.objc_allocateClassPair(OS.class_NSTabViewItem, className, 0L);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_sizeOfLabel_, sizeOfLabelProc, "@::");
        OS.class_addMethod(cls, OS.sel_drawLabel_inRect_, drawLabelInRectProc, "@::{NSRect}");
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.objc_registerClassPair(cls);
        className = "SWTTextView";
        cls = OS.objc_allocateClassPair(OS.class_NSTextView, className, 0L);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        this.addEventMethods(cls, proc2, proc3, drawRectProc, hitTestProc, setNeedsDisplayInRectProc);
        this.addFrameMethods(cls, setFrameOriginProc, setFrameSizeProc);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.class_addMethod(cls, OS.sel_insertText_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_doCommandBySelector_, proc3, "@::");
        OS.class_addMethod(cls, OS.sel_textDidChange_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_textView_clickedOnLink_atIndex_, proc5, "@:@@@");
        OS.class_addMethod(cls, OS.sel_dragSelectionWithEvent_offset_slideBack_, proc5, "@:@@@");
        OS.class_addMethod(cls, OS.sel_shouldChangeTextInRange_replacementString_, shouldChangeTextInRange_replacementString_Proc, "@:{NSRange}@");
        OS.class_addMethod(cls, OS.sel_drawViewBackgroundInRect_, drawViewBackgroundInRectProc, "@:{NSRect}");
        OS.class_addMethod(cls, OS.sel_shouldDrawInsertionPoint, proc2, "@:");
        OS.objc_registerClassPair(cls);
        className = "SWTTextField";
        cls = OS.objc_allocateClassPair(OS.class_NSTextField, className, 0L);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        this.addEventMethods(cls, proc2, proc3, drawRectProc, hitTestProc, setNeedsDisplayInRectProc);
        this.addFrameMethods(cls, setFrameOriginProc, setFrameSizeProc);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.class_addMethod(cls, OS.sel_acceptsFirstResponder, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_textDidChange_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_textDidEndEditing_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_textViewDidChangeSelection_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_textView_willChangeSelectionFromCharacterRange_toCharacterRange_, textWillChangeSelectionProc, "@:@{NSRange}{NSRange}");
        OS.objc_registerClassPair(cls);
        OS.class_addMethod(OS.object_getClass(cls), OS.sel_cellClass, proc2, "@:");
        cls = this.registerCellSubclass(NSTextField.cellClass(), size, align, types);
        OS.class_addMethod(cls, OS.sel_drawInteriorWithFrame_inView_, drawInteriorWithFrameInViewProc, "@:{NSRect}@");
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        className = "SWTTreeItem";
        cls = OS.objc_allocateClassPair(OS.class_NSObject, className, 0L);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_dealloc, proc2, "@:");
        OS.objc_registerClassPair(cls);
        className = "SWTView";
        cls = OS.objc_allocateClassPair(OS.class_NSView, className, 0L);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_canBecomeKeyView, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_isFlipped, isFlippedProc, "@:");
        OS.class_addMethod(cls, OS.sel_acceptsFirstResponder, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_isOpaque, proc2, "@:");
        this.addEventMethods(cls, proc2, proc3, drawRectProc, hitTestProc, setNeedsDisplayInRectProc);
        this.addFrameMethods(cls, setFrameOriginProc, setFrameSizeProc);
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.objc_registerClassPair(cls);
        className = "SWTWindow";
        this.createWindowSubclass(OS.class_NSWindow, className, false);
        className = "SWTPanel";
        cls = OS.objc_allocateClassPair(OS.class_NSPanel, className, 0L);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_sendEvent_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_helpRequested_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_canBecomeKeyWindow, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_becomeKeyWindow, proc2, "@:");
        OS.class_addMethod(cls, OS.sel_makeFirstResponder_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_noResponderFor_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_view_stringForToolTip_point_userData_, view_stringForToolTip_point_userDataProc, "@:@i{NSPoint}@");
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.objc_registerClassPair(cls);
        className = "SWTToolbar";
        cls = OS.objc_allocateClassPair(OS.class_NSToolbar, className, 0L);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_toolbar_itemForItemIdentifier_willBeInsertedIntoToolbar_, proc5, "@:@@Z");
        OS.class_addMethod(cls, OS.sel_toolbarAllowedItemIdentifiers_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_toolbarDefaultItemIdentifiers_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_toolbarSelectableItemIdentifiers_, proc3, "@:@");
        this.addAccessibilityMethods(cls, proc2, proc3, proc4, accessibilityHitTestProc);
        OS.objc_registerClassPair(cls);
        className = "SWTToolbarView";
        cls = OS.objc_allocateClassPair(OS.class_NSToolbarView, className, 0L);
        this.addEventMethods(cls, proc2, proc3, drawRectProc, hitTestProc, setNeedsDisplayInRectProc);
        this.addFrameMethods(cls, setFrameOriginProc, setFrameSizeProc);
        OS.objc_registerClassPair(cls);
        className = "SWTWindowDelegate";
        cls = OS.objc_allocateClassPair(OS.class_NSObject, className, 0L);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_windowDidResize_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_windowDidMove_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_windowShouldClose_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_windowWillClose_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_windowDidResignKey_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_windowDidBecomeKey_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_timerProc_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_systemSettingsChanged_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_windowDidMiniaturize_, proc3, "@:@");
        OS.class_addMethod(cls, OS.sel_windowDidDeminiaturize_, proc3, "@:@");
        OS.objc_registerClassPair(cls);
    }

    NSFont getFont(long cls, long sel) {
        long widget = OS.objc_msgSend(OS.objc_msgSend(cls, OS.sel_alloc), OS.sel_initWithFrame_, new NSRect());
        long font = 0L;
        if (OS.objc_msgSend_bool(widget, OS.sel_respondsToSelector_, sel)) {
            font = OS.objc_msgSend(widget, sel);
        }
        NSFont result = null;
        result = font != 0L ? new NSFont(font) : NSFont.systemFontOfSize(NSFont.systemFontSizeForControlSize(0L));
        result.retain();
        OS.objc_msgSend(widget, OS.sel_release);
        return result;
    }

    void initColors() {
        this.colors = new double[37][];
        this.colors[28] = this.getWidgetColorRGB(28);
        this.colors[29] = this.getWidgetColorRGB(29);
        this.colors[30] = this.getWidgetColorRGB(30);
        this.colors[31] = this.getWidgetColorRGB(31);
        this.colors[32] = this.getWidgetColorRGB(32);
        this.colors[33] = this.getWidgetColorRGB(33);
        this.colors[34] = this.getWidgetColorRGB(34);
        this.colors[35] = this.getWidgetColorRGB(35);
        this.colors[17] = this.getWidgetColorRGB(17);
        this.colors[18] = this.getWidgetColorRGB(18);
        this.colors[19] = this.getWidgetColorRGB(19);
        this.colors[20] = this.getWidgetColorRGB(20);
        this.colors[22] = this.getWidgetColorRGB(22);
        this.colors[21] = this.getWidgetColorRGB(21);
        this.colors[23] = this.getWidgetColorRGB(23);
        this.colors[24] = this.getWidgetColorRGB(24);
        this.colors[25] = this.getWidgetColorRGB(25);
        this.colors[27] = this.getWidgetColorRGB(27);
        this.colors[26] = this.getWidgetColorRGB(26);
        this.colors[36] = this.getWidgetColorRGB(36);
        this.alternateSelectedControlColor = this.getNSColorRGB(NSColor.alternateSelectedControlColor());
        this.alternateSelectedControlTextColor = this.getNSColorRGB(NSColor.alternateSelectedControlTextColor());
        this.secondarySelectedControlColor = this.getNSColorRGB(NSColor.secondarySelectedControlColor());
        this.selectedControlTextColor = this.getNSColorRGB(NSColor.selectedControlTextColor());
    }

    void initFonts() {
        this.smallFonts = System.getProperty("org.eclipse.swt.internal.carbon.smallFonts") != null;
        this.buttonFont = this.getFont(OS.class_NSButton, OS.sel_font);
        this.popUpButtonFont = this.getFont(OS.class_NSPopUpButton, OS.sel_font);
        this.textFieldFont = this.getFont(OS.class_NSTextField, OS.sel_font);
        this.secureTextFieldFont = this.getFont(OS.class_NSSecureTextField, OS.sel_font);
        this.searchFieldFont = this.getFont(OS.class_NSSearchField, OS.sel_font);
        this.comboBoxFont = this.getFont(OS.class_NSComboBox, OS.sel_font);
        this.sliderFont = this.getFont(OS.class_NSSlider, OS.sel_font);
        this.scrollerFont = this.getFont(OS.class_NSScroller, OS.sel_font);
        this.textViewFont = this.getFont(OS.class_NSTextView, OS.sel_font);
        this.tableViewFont = this.getFont(OS.class_NSTableView, OS.sel_font);
        this.outlineViewFont = this.getFont(OS.class_NSOutlineView, OS.sel_font);
        this.datePickerFont = this.getFont(OS.class_NSDatePicker, OS.sel_font);
        this.boxFont = this.getFont(OS.class_NSBox, OS.sel_titleFont);
        this.tabViewFont = this.getFont(OS.class_NSTabView, OS.sel_font);
        this.progressIndicatorFont = this.getFont(OS.class_NSProgressIndicator, OS.sel_font);
    }

    public long internal_new_GC(GCData data) {
        if (this.isDisposed()) {
            this.error(45);
        }
        if (this.screenWindow == null) {
            NSWindow window = (NSWindow)new NSWindow().alloc();
            NSRect rect = new NSRect();
            window = window.initWithContentRect(rect, 0L, 2L, false);
            window.setReleasedWhenClosed(false);
            this.screenWindow = window;
        }
        NSGraphicsContext context = this.screenWindow.graphicsContext();
        if (data != null) {
            int mask = 0x6000000;
            if ((data.style & mask) == 0) {
                data.style |= 0x2000000;
            }
            data.device = this;
            data.background = this.getSystemColor((int)1).handle;
            data.foreground = this.getSystemColor((int)2).handle;
            data.font = this.getSystemFont();
        }
        return context.id;
    }

    public void internal_dispose_GC(long hDC, GCData data) {
        if (this.isDisposed()) {
            this.error(45);
        }
    }

    boolean isBundled() {
        NSDictionary info;
        NSBundle mainBundle = NSBundle.mainBundle();
        if (mainBundle != null && (info = mainBundle.infoDictionary()) != null) {
            return NSString.stringWith("APPL").isEqual(info.objectForKey(NSString.stringWith("CFBundlePackageType")));
        }
        return false;
    }

    static boolean isValidClass(Class clazz) {
        String name = clazz.getName();
        int index = name.lastIndexOf(46);
        return name.substring(0, index + 1).equals(PACKAGE_PREFIX);
    }

    boolean isValidThread() {
        return this.thread == Thread.currentThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean post(Event event) {
        Class clazz = class$org$eclipse$swt$graphics$Device == null ? (class$org$eclipse$swt$graphics$Device = Display.class$("org.eclipse.swt.graphics.Device")) : class$org$eclipse$swt$graphics$Device;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            if (event == null) {
                this.error(4);
            }
            long eventRef = 0L;
            long eventSource = OS.CGEventSourceCreate(1);
            if (eventSource == 0L) {
                return false;
            }
            boolean returnValue = false;
            int[] deadKeyState = new int[1];
            int type = event.type;
            switch (type) {
                case 1: 
                case 2: {
                    int vKey = Display.untranslateKey(event.keyCode);
                    if (vKey == 0) {
                        int i;
                        long uchrPtr = 0L;
                        long currentKbd = OS.TISCopyCurrentKeyboardInputSource();
                        long uchrCFData = OS.TISGetInputSourceProperty(currentKbd, OS.kTISPropertyUnicodeKeyLayoutData());
                        if (uchrCFData == 0L) {
                            return false;
                        }
                        uchrPtr = OS.CFDataGetBytePtr(uchrCFData);
                        if (uchrPtr == 0L) {
                            return false;
                        }
                        if (OS.CFDataGetLength(uchrCFData) == 0L) {
                            return false;
                        }
                        int maxStringLength = 256;
                        vKey = -1;
                        char[] output = new char[maxStringLength];
                        int[] actualStringLength = new int[1];
                        for (i = 0; i <= 127; i = (int)((short)(i + 1))) {
                            deadKeyState[0] = 0;
                            OS.UCKeyTranslate(uchrPtr, (short)i, (short)(type != 1 ? 1 : 0), 0, OS.LMGetKbdType(), 0, deadKeyState, maxStringLength, actualStringLength, output);
                            if (output[0] != event.character) continue;
                            vKey = i;
                            break;
                        }
                        if (vKey == -1) {
                            for (i = 0; i <= 127; i = (int)((short)(i + 1))) {
                                deadKeyState[0] = 0;
                                OS.UCKeyTranslate(uchrPtr, (short)i, (short)(type != 1 ? 1 : 0), 2, OS.LMGetKbdType(), 0, deadKeyState, maxStringLength, actualStringLength, output);
                                if (output[0] != event.character) continue;
                                vKey = i;
                                break;
                            }
                        }
                    }
                    if (vKey == -1 && event.character == '\u0000') {
                        vKey = 127;
                    }
                    if (vKey == -1) break;
                    if (OS.VERSION < 4192) {
                        returnValue = OS.CGPostKeyboardEvent((short)0, (short)vKey, type == 1) == 0;
                        break;
                    }
                    eventRef = OS.CGEventCreateKeyboardEvent(eventSource, (short)vKey, type == 1);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    int cgButton;
                    CGPoint mouseCursorPosition = new CGPoint();
                    if (type == 5) {
                        mouseCursorPosition.x = event.x;
                        mouseCursorPosition.y = event.y;
                        eventRef = OS.CGEventCreateMouseEvent(eventSource, 5, mouseCursorPosition, 0);
                        break;
                    }
                    NSPoint nsCursorPosition = NSEvent.mouseLocation();
                    NSRect primaryFrame = this.getPrimaryFrame();
                    mouseCursorPosition.x = nsCursorPosition.x;
                    mouseCursorPosition.y = (int)(primaryFrame.height - nsCursorPosition.y);
                    int eventType = 0;
                    switch (event.button) {
                        case 1: {
                            eventType = event.type == 3 ? 1 : 2;
                            cgButton = 0;
                            break;
                        }
                        case 2: {
                            eventType = event.type == 3 ? 25 : 26;
                            cgButton = 2;
                            break;
                        }
                        case 3: {
                            eventType = event.type == 3 ? 3 : 4;
                            cgButton = 1;
                            break;
                        }
                        default: {
                            eventType = event.type == 3 ? 25 : 26;
                            cgButton = event.button - 1;
                        }
                    }
                    if (cgButton < 0) break;
                    eventRef = OS.CGEventCreateMouseEvent(eventSource, eventType, mouseCursorPosition, cgButton);
                    break;
                }
                case 37: {
                    eventRef = OS.CGEventCreateScrollWheelEvent(eventSource, 1, 1, event.count);
                }
            }
            if (!returnValue && eventRef != 0L) {
                OS.CGEventPost(0, eventRef);
                OS.CFRelease(eventRef);
                try {
                    Thread.sleep(1L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                returnValue = true;
            }
            if (eventSource != 0L) {
                OS.CFRelease(eventSource);
            }
            return returnValue;
        }
    }

    void postEvent(Event event) {
        int index;
        if (this.eventQueue == null) {
            this.eventQueue = new Event[4];
        }
        int length = this.eventQueue.length;
        for (index = 0; index < length && this.eventQueue[index] != null; ++index) {
        }
        if (index == length) {
            Event[] newQueue = new Event[length + 4];
            System.arraycopy(this.eventQueue, 0, newQueue, 0, length);
            this.eventQueue = newQueue;
        }
        this.eventQueue[index] = event;
    }

    public Point map(Control from, Control to, Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        return this.map(from, to, point.x, point.y);
    }

    public Point map(Control from, Control to, int x, int y) {
        NSWindow toWindow;
        this.checkDevice();
        if (from != null && from.isDisposed()) {
            this.error(5);
        }
        if (to != null && to.isDisposed()) {
            this.error(5);
        }
        Point point = new Point(x, y);
        if (from == to) {
            return point;
        }
        NSPoint pt = new NSPoint();
        pt.x = x;
        pt.y = y;
        NSWindow fromWindow = from != null ? from.view.window() : null;
        NSWindow nSWindow = toWindow = to != null ? to.view.window() : null;
        if (toWindow != null && fromWindow != null && toWindow.id == fromWindow.id) {
            if (!from.view.isFlipped()) {
                pt.y = from.view.bounds().height - pt.y;
            }
            pt = from.view.convertPoint_toView_(pt, to.view);
            if (!to.view.isFlipped()) {
                pt.y = to.view.bounds().height - pt.y;
            }
        } else {
            double scaleFactor;
            NSView view;
            NSRect primaryFrame = this.getPrimaryFrame();
            if (from != null) {
                view = from.eventView();
                if (!view.isFlipped()) {
                    pt.y = view.bounds().height - pt.y;
                }
                pt = view.convertPoint_toView_(pt, null);
                pt = fromWindow.convertBaseToScreen(pt);
                pt.y = primaryFrame.height - pt.y;
                scaleFactor = fromWindow.userSpaceScaleFactor();
                pt.x /= scaleFactor;
                pt.y /= scaleFactor;
            }
            if (to != null) {
                view = to.eventView();
                scaleFactor = toWindow.userSpaceScaleFactor();
                pt.x *= scaleFactor;
                pt.y = primaryFrame.height - pt.y * scaleFactor;
                pt = toWindow.convertScreenToBase(pt);
                pt = view.convertPoint_fromView_(pt, null);
                if (!view.isFlipped()) {
                    pt.y = view.bounds().height - pt.y;
                }
            }
        }
        point.x = (int)pt.x;
        point.y = (int)pt.y;
        return point;
    }

    public Rectangle map(Control from, Control to, Rectangle rectangle) {
        this.checkDevice();
        if (rectangle == null) {
            this.error(4);
        }
        return this.map(from, to, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Rectangle map(Control from, Control to, int x, int y, int width, int height) {
        NSWindow toWindow;
        this.checkDevice();
        if (from != null && from.isDisposed()) {
            this.error(5);
        }
        if (to != null && to.isDisposed()) {
            this.error(5);
        }
        Rectangle rectangle = new Rectangle(x, y, width, height);
        if (from == to) {
            return rectangle;
        }
        NSPoint pt = new NSPoint();
        pt.x = x;
        pt.y = y;
        NSWindow fromWindow = from != null ? from.view.window() : null;
        NSWindow nSWindow = toWindow = to != null ? to.view.window() : null;
        if (toWindow != null && fromWindow != null && toWindow.id == fromWindow.id) {
            if (!from.view.isFlipped()) {
                pt.y = from.view.bounds().height - pt.y;
            }
            pt = from.view.convertPoint_toView_(pt, to.view);
            if (!to.view.isFlipped()) {
                pt.y = to.view.bounds().height - pt.y;
            }
        } else {
            double scaleFactor;
            NSView view;
            NSRect primaryFrame = this.getPrimaryFrame();
            if (from != null) {
                view = from.eventView();
                if (!view.isFlipped()) {
                    pt.y = view.bounds().height - pt.y;
                }
                pt = view.convertPoint_toView_(pt, null);
                pt = fromWindow.convertBaseToScreen(pt);
                pt.y = primaryFrame.height - pt.y;
                scaleFactor = fromWindow.userSpaceScaleFactor();
                pt.x /= scaleFactor;
                pt.y /= scaleFactor;
            }
            if (to != null) {
                view = to.eventView();
                scaleFactor = toWindow.userSpaceScaleFactor();
                pt.x *= scaleFactor;
                pt.y = primaryFrame.height - pt.y * scaleFactor;
                pt = toWindow.convertScreenToBase(pt);
                pt = view.convertPoint_fromView_(pt, null);
                if (!view.isFlipped()) {
                    pt.y = view.bounds().height - pt.y;
                }
            }
        }
        rectangle.x = (int)pt.x;
        rectangle.y = (int)pt.y;
        return rectangle;
    }

    long observerProc(long observer, long activity, long info) {
        switch ((int)activity) {
            case 32: {
                if (!this.runAsyncMessages || !this.runAsyncMessages(false)) break;
                this.wakeThread();
            }
        }
        return 0L;
    }

    boolean performKeyEquivalent(NSWindow window, NSEvent nsEvent) {
        if (this.modalDialog == null) {
            return false;
        }
        if (nsEvent.type() != 10L) {
            return false;
        }
        int stateMask = 0;
        long selector = 0L;
        long modifierFlags = nsEvent.modifierFlags();
        if ((modifierFlags & 0x80000L) != 0L) {
            stateMask |= 0x10000;
        }
        if ((modifierFlags & 0x20000L) != 0L) {
            stateMask |= 0x20000;
        }
        if ((modifierFlags & 0x40000L) != 0L) {
            stateMask |= 0x40000;
        }
        if ((modifierFlags & 0x100000L) != 0L) {
            stateMask |= 0x400000;
        }
        if (stateMask == 0x400000) {
            short keyCode = nsEvent.keyCode();
            switch (keyCode) {
                case 7: {
                    selector = OS.sel_cut_;
                    break;
                }
                case 8: {
                    selector = OS.sel_copy_;
                    break;
                }
                case 9: {
                    selector = OS.sel_paste_;
                    break;
                }
                case 0: {
                    selector = OS.sel_selectAll_;
                }
            }
            if (selector != 0L) {
                NSApplication.sharedApplication().sendAction(selector, null, NSApplication.sharedApplication());
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readAndDispatch() {
        this.checkDevice();
        if (this.sendEventCount == 0 && this.loopCount == this.poolCount - 1 && Callback.getEntryCount() == 0) {
            this.removePool();
        }
        this.addPool();
        this.runSkin();
        this.runDeferredLayouts();
        ++this.loopCount;
        boolean events = false;
        try {
            events |= this.runSettings();
            events |= this.runTimers();
            events |= this.runContexts();
            events |= this.runPopups();
            NSEvent event = this.application.nextEventMatchingMask(0L, null, OS.NSDefaultRunLoopMode, true);
            if (event != null) {
                events = true;
                this.application.sendEvent(event);
            }
            events |= this.runPaint();
            if (!(events |= this.runDeferredEvents())) {
                events = this.isDisposed() || this.runAsyncMessages(false);
            }
        }
        finally {
            this.removePool();
            --this.loopCount;
            if (this.sendEventCount == 0 && this.loopCount == this.poolCount && Callback.getEntryCount() == 0) {
                this.addPool();
            }
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void register(Display display) {
        Class clazz = class$org$eclipse$swt$graphics$Device == null ? (class$org$eclipse$swt$graphics$Device = Display.class$("org.eclipse.swt.graphics.Device")) : class$org$eclipse$swt$graphics$Device;
        synchronized (clazz) {
            for (int i = 0; i < Displays.length; ++i) {
                if (Displays[i] != null) continue;
                Display.Displays[i] = display;
                return;
            }
            Display[] newDisplays = new Display[Displays.length + 4];
            System.arraycopy(Displays, 0, newDisplays, 0, Displays.length);
            newDisplays[Display.Displays.length] = display;
            Displays = newDisplays;
        }
    }

    protected void release() {
        int i;
        this.disposing = true;
        this.sendEvent(12, new Event());
        Shell[] shells = this.getShells();
        for (i = 0; i < shells.length; ++i) {
            Shell shell = shells[i];
            if (shell.isDisposed()) continue;
            shell.dispose();
        }
        if (this.tray != null) {
            this.tray.dispose();
        }
        this.tray = null;
        if (this.taskBar != null) {
            this.taskBar.dispose();
        }
        this.taskBar = null;
        while (this.readAndDispatch()) {
        }
        if (this.disposeList != null) {
            for (i = 0; i < this.disposeList.length; ++i) {
                if (this.disposeList[i] == null) continue;
                this.disposeList[i].run();
            }
        }
        this.disposeList = null;
        this.synchronizer.releaseSynchronizer();
        this.synchronizer = null;
        if (this.appMenu != null) {
            this.appMenu.dispose();
        }
        this.appMenu = null;
        if (this.appMenuBar != null) {
            this.appMenuBar.dispose();
        }
        this.appMenuBar = null;
        this.releaseDisplay();
        super.release();
    }

    void releaseDisplay() {
        int i;
        if (this.errorImage != null) {
            this.errorImage.dispose();
        }
        if (this.infoImage != null) {
            this.infoImage.dispose();
        }
        if (this.warningImage != null) {
            this.warningImage.dispose();
        }
        this.warningImage = null;
        this.infoImage = null;
        this.errorImage = null;
        this.currentCaret = null;
        if (this.hoverTimer != null) {
            this.timerExec(-1, this.hoverTimer);
        }
        this.hoverTimer = null;
        if (this.caretTimer != null) {
            this.timerExec(-1, this.caretTimer);
        }
        this.caretTimer = null;
        if (this.nsTimers != null) {
            for (i = 0; i < this.nsTimers.length; ++i) {
                if (this.nsTimers[i] == null) continue;
                this.nsTimers[i].invalidate();
                this.nsTimers[i].release();
            }
        }
        this.nsTimers = null;
        if (this.timerDelegate != null) {
            this.timerDelegate.release();
        }
        this.timerDelegate = null;
        for (i = 0; i < this.cursors.length; ++i) {
            if (this.cursors[i] == null) continue;
            this.cursors[i].dispose();
        }
        this.cursors = null;
        if (this.buttonFont != null) {
            this.buttonFont.release();
        }
        if (this.popUpButtonFont != null) {
            this.popUpButtonFont.release();
        }
        if (this.textFieldFont != null) {
            this.textFieldFont.release();
        }
        if (this.secureTextFieldFont != null) {
            this.secureTextFieldFont.release();
        }
        if (this.searchFieldFont != null) {
            this.searchFieldFont.release();
        }
        if (this.comboBoxFont != null) {
            this.comboBoxFont.release();
        }
        if (this.sliderFont != null) {
            this.sliderFont.release();
        }
        if (this.scrollerFont != null) {
            this.scrollerFont.release();
        }
        if (this.textViewFont != null) {
            this.textViewFont.release();
        }
        if (this.tableViewFont != null) {
            this.tableViewFont.release();
        }
        if (this.outlineViewFont != null) {
            this.outlineViewFont.release();
        }
        if (this.datePickerFont != null) {
            this.datePickerFont.release();
        }
        if (this.boxFont != null) {
            this.boxFont.release();
        }
        if (this.tabViewFont != null) {
            this.tabViewFont.release();
        }
        if (this.progressIndicatorFont != null) {
            this.progressIndicatorFont.release();
        }
        this.secureTextFieldFont = null;
        this.textFieldFont = null;
        this.popUpButtonFont = null;
        this.buttonFont = null;
        this.comboBoxFont = this.sliderFont = this.scrollerFont;
        this.searchFieldFont = this.sliderFont;
        this.datePickerFont = null;
        this.outlineViewFont = null;
        this.tableViewFont = null;
        this.textViewFont = null;
        this.progressIndicatorFont = null;
        this.tabViewFont = null;
        this.boxFont = null;
        if (this.dockImage != null) {
            this.dockImage.release();
        }
        this.dockImage = null;
        if (this.screenWindow != null) {
            this.screenWindow.release();
        }
        this.screenWindow = null;
        if (this.needsDisplay != null) {
            this.needsDisplay.release();
        }
        if (this.needsDisplayInRect != null) {
            this.needsDisplayInRect.release();
        }
        if (this.isPainting != null) {
            this.isPainting.release();
        }
        if (this.runLoopModes != null) {
            this.runLoopModes.release();
        }
        this.runLoopModes = null;
        this.isPainting = null;
        this.needsDisplayInRect = null;
        this.needsDisplay = null;
        this.modalShells = null;
        this.modalDialog = null;
        this.menuBar = null;
        this.menus = null;
        if (this.markedAttributes != null) {
            this.markedAttributes.release();
        }
        this.markedAttributes = null;
        if (this.oldCursorSetProc != 0L) {
            long method = OS.class_getInstanceMethod(OS.class_NSCursor, OS.sel_set);
            OS.method_setImplementation(method, this.oldCursorSetProc);
        }
        if (this.cursorSetCallback != null) {
            this.cursorSetCallback.dispose();
        }
        this.cursorSetCallback = null;
        if (this.settingsDelegate != null) {
            NSNotificationCenter.defaultCenter().removeObserver(this.settingsDelegate);
            this.settingsDelegate.release();
        }
        this.settingsDelegate = null;
        if (!this.isEmbedded) {
            NSMenu menubar = this.application.mainMenu();
            for (long count = menubar.numberOfItems(); count > 1L; --count) {
                menubar.removeItemAtIndex(count - 1L);
            }
        }
        if (dynamicObjectMap != null) {
            dynamicObjectMap.clear();
            dynamicObjectMap = null;
        }
        if (this.application != null && this.applicationClass != 0L) {
            OS.object_setClass(this.application.id, this.applicationClass);
        }
        this.application = null;
        this.applicationClass = 0L;
        if (this.runLoopObserver != 0L) {
            OS.CFRunLoopObserverInvalidate(this.runLoopObserver);
            OS.CFRelease(this.runLoopObserver);
        }
        this.runLoopObserver = 0L;
        if (this.observerCallback != null) {
            this.observerCallback.dispose();
        }
        this.observerCallback = null;
    }

    void removeContext(GCData context) {
        if (this.contexts == null) {
            return;
        }
        int count = 0;
        for (int i = 0; i < this.contexts.length; ++i) {
            if (this.contexts[i] == null) continue;
            if (this.contexts[i] == context) {
                this.contexts[i] = null;
                continue;
            }
            ++count;
        }
        if (count == 0) {
            this.contexts = null;
        }
    }

    public void removeFilter(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            return;
        }
        this.filterTable.unhook(eventType, listener);
        if (this.filterTable.size() == 0) {
            this.filterTable = null;
        }
    }

    public void removeListener(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, listener);
    }

    Widget removeWidget(NSObject view) {
        if (view == null) {
            return null;
        }
        long[] jniRef = new long[1];
        long iVar = OS.object_getInstanceVariable(view.id, SWT_OBJECT, jniRef);
        if (iVar == 0L && dynamicObjectMap != null) {
            LONG dynJNIRef = (LONG)dynamicObjectMap.get(view);
            if (dynJNIRef != null) {
                jniRef[0] = dynJNIRef.value;
            }
            dynamicObjectMap.remove(view);
        }
        if (jniRef[0] == 0L) {
            return null;
        }
        Widget widget = (Widget)OS.JNIGetObject(jniRef[0]);
        OS.object_setInstanceVariable(view.id, SWT_OBJECT, 0L);
        return widget;
    }

    void removeMenu(Menu menu) {
        if (this.menus == null) {
            return;
        }
        for (int i = 0; i < this.menus.length; ++i) {
            if (this.menus[i] != menu) continue;
            this.menus[i] = null;
            break;
        }
    }

    void removePool() {
        NSAutoreleasePool pool = this.pools[this.poolCount - 1];
        this.pools[--this.poolCount] = null;
        if (this.poolCount == 0) {
            NSMutableDictionary dictionary = NSThread.currentThread().threadDictionary();
            dictionary.removeObjectForKey(NSString.stringWith("SWT_NSAutoreleasePool"));
        }
        pool.release();
    }

    void removePopup(Menu menu) {
        if (this.popups == null) {
            return;
        }
        for (int i = 0; i < this.popups.length; ++i) {
            if (this.popups[i] != menu) continue;
            this.popups[i] = null;
            return;
        }
    }

    boolean runAsyncMessages(boolean all) {
        return this.synchronizer.runAsyncMessages(all);
    }

    boolean runContexts() {
        if (this.contexts != null) {
            for (int i = 0; i < this.contexts.length; ++i) {
                if (this.contexts[i] == null || this.contexts[i].flippedContext == null) continue;
                this.contexts[i].flippedContext.flushGraphics();
            }
        }
        return false;
    }

    boolean runDeferredEvents() {
        Event event;
        boolean run = false;
        while (this.eventQueue != null && (event = this.eventQueue[0]) != null) {
            Widget item;
            int length = this.eventQueue.length;
            System.arraycopy(this.eventQueue, 1, this.eventQueue, 0, --length);
            this.eventQueue[length] = null;
            Widget widget = event.widget;
            if (widget == null || widget.isDisposed() || (item = event.item) != null && item.isDisposed()) continue;
            run = true;
            widget.notifyListeners(event.type, event);
        }
        this.eventQueue = null;
        return run;
    }

    boolean runDeferredLayouts() {
        if (this.layoutDeferredCount != 0) {
            Composite[] temp = this.layoutDeferred;
            int count = this.layoutDeferredCount;
            this.layoutDeferred = null;
            this.layoutDeferredCount = 0;
            for (int i = 0; i < count; ++i) {
                Composite comp = temp[i];
                if (comp.isDisposed()) continue;
                comp.setLayoutDeferred(false);
            }
            return true;
        }
        return false;
    }

    NSArray runLoopModes() {
        if (this.runLoopModes == null) {
            this.runLoopModes = NSMutableArray.arrayWithCapacity(3L);
            this.runLoopModes.addObject(OS.NSEventTrackingRunLoopMode);
            this.runLoopModes.addObject(OS.NSDefaultRunLoopMode);
            this.runLoopModes.addObject(OS.NSModalPanelRunLoopMode);
            this.runLoopModes.retain();
        }
        this.runLoopModes.retain();
        this.runLoopModes.autorelease();
        return this.runLoopModes;
    }

    boolean runPaint() {
        int i;
        long count;
        if (this.needsDisplay == null && this.needsDisplayInRect == null) {
            return false;
        }
        if (this.needsDisplay != null) {
            count = this.needsDisplay.count();
            i = 0;
            while ((long)i < count) {
                OS.objc_msgSend(this.needsDisplay.objectAtIndex((long)((long)i)).id, OS.sel_setNeedsDisplay_, true);
                ++i;
            }
            this.needsDisplay.release();
            this.needsDisplay = null;
        }
        if (this.needsDisplayInRect != null) {
            count = this.needsDisplayInRect.count();
            i = 0;
            while ((long)i < count) {
                NSValue value = new NSValue(this.needsDisplayInRect.objectAtIndex(i + 1));
                OS.objc_msgSend(this.needsDisplayInRect.objectAtIndex((long)((long)i)).id, OS.sel_setNeedsDisplayInRect_, value.rectValue());
                i += 2;
            }
            this.needsDisplayInRect.release();
            this.needsDisplayInRect = null;
        }
        return true;
    }

    boolean runPopups() {
        Menu menu;
        if (this.popups == null) {
            return false;
        }
        boolean result = false;
        while (this.popups != null && (menu = this.popups[0]) != null) {
            int length = this.popups.length;
            System.arraycopy(this.popups, 1, this.popups, 0, --length);
            this.popups[length] = null;
            this.runDeferredEvents();
            if (!menu.isDisposed()) {
                menu._setVisible(true);
            }
            result = true;
        }
        this.popups = null;
        return result;
    }

    boolean runSettings() {
        if (!this.runSettings) {
            return false;
        }
        this.runSettings = false;
        this.initColors();
        this.sendEvent(39, null);
        Shell[] shells = this.getShells();
        for (int i = 0; i < shells.length; ++i) {
            Shell shell = shells[i];
            if (shell.isDisposed()) continue;
            shell.redraw(true);
            shell.layout(true, true);
        }
        return true;
    }

    boolean runSkin() {
        if (this.skinCount > 0) {
            Widget[] oldSkinWidgets = this.skinList;
            int count = this.skinCount;
            this.skinList = new Widget[1024];
            this.skinCount = 0;
            if (this.eventTable != null && this.eventTable.hooks(45)) {
                for (int i = 0; i < count; ++i) {
                    Widget widget = oldSkinWidgets[i];
                    if (widget == null || widget.isDisposed()) continue;
                    widget.state &= 0xFFDFFFFF;
                    oldSkinWidgets[i] = null;
                    Event event = new Event();
                    event.widget = widget;
                    this.sendEvent(45, event);
                }
            }
            return true;
        }
        return false;
    }

    boolean runTimers() {
        if (this.timerList == null) {
            return false;
        }
        boolean result = false;
        for (int i = 0; i < this.timerList.length; ++i) {
            if (this.nsTimers[i] != null || this.timerList[i] == null) continue;
            Runnable runnable = this.timerList[i];
            this.timerList[i] = null;
            if (runnable == null) continue;
            result = true;
            runnable.run();
        }
        return result;
    }

    void sendEvent(int eventType, Event event) {
        if (this.eventTable == null && this.filterTable == null) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.display = this;
        event.type = eventType;
        if (event.time == 0) {
            event.time = this.getLastEventTime();
        }
        this.sendEvent(this.eventTable, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendEvent(EventTable table, Event event) {
        try {
            ++this.sendEventCount;
            if (!this.filterEvent(event) && table != null) {
                table.sendEvent(event);
            }
        }
        finally {
            --this.sendEventCount;
        }
    }

    static NSString getApplicationName() {
        String macAppName;
        id value;
        NSString name = null;
        int pid = OS.getpid();
        long ptr = OS.getenv(Display.ascii("APP_NAME_" + pid));
        if (ptr != 0L) {
            name = NSString.stringWithUTF8String(ptr);
        }
        if (name == null && APP_NAME != null) {
            name = NSString.stringWith(APP_NAME);
        }
        if (name == null && (value = NSBundle.mainBundle().objectForInfoDictionaryKey(NSString.stringWith("CFBundleName"))) != null) {
            name = new NSString(value);
        }
        if (name == null && (macAppName = System.getProperty("com.apple.mrj.application.apple.menu.about.name")) != null) {
            name = NSString.stringWith(macAppName);
        }
        if (name == null) {
            name = NSString.stringWith("SWT");
        }
        return name;
    }

    public static String getAppName() {
        return APP_NAME;
    }

    public static String getAppVersion() {
        return APP_VERSION;
    }

    public static void setAppName(String name) {
        APP_NAME = name;
    }

    public static void setAppVersion(String version) {
        APP_VERSION = version;
    }

    void setCurrentCaret(Caret caret) {
        this.currentCaret = caret;
        int blinkRate = this.currentCaret != null ? this.currentCaret.blinkRate : -1;
        this.timerExec(blinkRate, this.caretTimer);
    }

    void setCursor(Control control) {
        Cursor cursor = null;
        if (control != null && !control.isDisposed()) {
            cursor = control.findCursor();
        }
        if (cursor == null) {
            NSWindow window = this.application.keyWindow();
            if (window != null) {
                if (window.areCursorRectsEnabled()) {
                    window.disableCursorRects();
                    window.enableCursorRects();
                }
                return;
            }
            cursor = this.getSystemCursor(0);
        }
        this.lockCursor = false;
        cursor.handle.set();
        this.lockCursor = true;
    }

    public void setCursorLocation(int x, int y) {
        this.checkDevice();
        Event e = new Event();
        e.type = 5;
        e.x = x;
        e.y = y;
        this.post(e);
    }

    public void setCursorLocation(Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        this.setCursorLocation(point.x, point.y);
    }

    public void setData(String key, Object value) {
        this.checkDevice();
        if (key == null) {
            this.error(4);
        }
        if (key.equals(ADD_WIDGET_KEY)) {
            Object[] data = (Object[])value;
            NSObject object = (NSObject)data[0];
            Widget widget = (Widget)data[1];
            if (widget == null) {
                this.removeWidget(object);
            } else {
                this.addWidget(object, widget);
            }
        }
        if (key.equals(SET_MODAL_DIALOG)) {
            this.setModalDialog(value != null ? (Dialog)value : null);
        }
        if (key.equals(MOZILLA_RUNNING)) {
            this.mozillaRunning = (Boolean)value;
        }
        if (value == null) {
            int index;
            if (this.keys == null) {
                return;
            }
            for (index = 0; index < this.keys.length && !this.keys[index].equals(key); ++index) {
            }
            if (index == this.keys.length) {
                return;
            }
            if (this.keys.length == 1) {
                this.keys = null;
                this.values = null;
            } else {
                String[] newKeys = new String[this.keys.length - 1];
                Object[] newValues = new Object[this.values.length - 1];
                System.arraycopy(this.keys, 0, newKeys, 0, index);
                System.arraycopy(this.keys, index + 1, newKeys, index, newKeys.length - index);
                System.arraycopy(this.values, 0, newValues, 0, index);
                System.arraycopy(this.values, index + 1, newValues, index, newValues.length - index);
                this.keys = newKeys;
                this.values = newValues;
            }
            return;
        }
        if (this.keys == null) {
            this.keys = new String[]{key};
            this.values = new Object[]{value};
            return;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.keys[i].equals(key)) continue;
            this.values[i] = value;
            return;
        }
        String[] newKeys = new String[this.keys.length + 1];
        Object[] newValues = new Object[this.values.length + 1];
        System.arraycopy(this.keys, 0, newKeys, 0, this.keys.length);
        System.arraycopy(this.values, 0, newValues, 0, this.values.length);
        newKeys[this.keys.length] = key;
        newValues[this.values.length] = value;
        this.keys = newKeys;
        this.values = newValues;
    }

    void setMenuBar(Menu menu) {
        if (menu == null) {
            menu = this.appMenuBar;
        }
        if (menu == this.menuBar) {
            return;
        }
        this.menuBar = menu;
        NSMenu menubar = this.application.mainMenu();
        OS.CancelMenuTracking(OS.AcquireRootMenu(), true, 0);
        for (long count = menubar.numberOfItems(); count > 1L; --count) {
            menubar.removeItemAtIndex(count - 1L);
        }
        if (menu != null) {
            MenuItem[] items = menu.getItems();
            for (int i = 0; i < items.length; ++i) {
                MenuItem item = items[i];
                NSMenuItem nsItem = item.nsItem;
                NSMenu submenu = nsItem.submenu();
                if (submenu != null && submenu.title().getString().equals(SWT.getMessage("SWT_Help"))) {
                    this.application.setHelpMenu(submenu);
                }
                nsItem.setMenu(null);
                menubar.addItem(nsItem);
                boolean enabled = menu.getEnabled() && item.getEnabled();
                nsItem.setEnabled(!enabled);
                nsItem.setEnabled(enabled);
            }
        }
    }

    void setModalDialog(Dialog modalDialog) {
        this.setModalDialog(modalDialog, null);
    }

    void setModalDialog(Dialog modalDialog, NSPanel panel) {
        this.modalDialog = modalDialog;
        this.modalPanel = panel;
    }

    void setModalShell(Shell shell) {
        int index;
        if (this.modalShells == null) {
            this.modalShells = new Shell[4];
        }
        int length = this.modalShells.length;
        for (index = 0; index < length; ++index) {
            if (this.modalShells[index] == shell) {
                return;
            }
            if (this.modalShells[index] == null) break;
        }
        if (index == length) {
            Shell[] newModalShells = new Shell[length + 4];
            System.arraycopy(this.modalShells, 0, newModalShells, 0, length);
            this.modalShells = newModalShells;
        }
        this.modalShells[index] = shell;
        Shell[] shells = this.getShells();
        for (int i = 0; i < shells.length; ++i) {
            shells[i].updateModal();
        }
    }

    public void setData(Object data) {
        this.checkDevice();
        this.data = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSynchronizer(Synchronizer synchronizer) {
        Synchronizer oldSynchronizer;
        this.checkDevice();
        if (synchronizer == null) {
            this.error(4);
        }
        if (synchronizer == this.synchronizer) {
            return;
        }
        Class clazz = class$org$eclipse$swt$graphics$Device == null ? (class$org$eclipse$swt$graphics$Device = Display.class$("org.eclipse.swt.graphics.Device")) : class$org$eclipse$swt$graphics$Device;
        synchronized (clazz) {
            oldSynchronizer = this.synchronizer;
            this.synchronizer = synchronizer;
        }
        if (oldSynchronizer != null) {
            oldSynchronizer.runAsyncMessages(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sleep() {
        this.checkDevice();
        if (this.getMessageCount() != 0) {
            return true;
        }
        try {
            this.addPool();
            this.runAsyncMessages = false;
            this.allowTimers = false;
            NSRunLoop.currentRunLoop().runMode(OS.NSDefaultRunLoopMode, NSDate.distantFuture());
            this.runAsyncMessages = true;
            this.allowTimers = true;
        }
        finally {
            this.removePool();
        }
        return true;
    }

    int sourceProc(int info) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncExec(Runnable runnable) {
        Synchronizer synchronizer;
        Class clazz = class$org$eclipse$swt$graphics$Device == null ? (class$org$eclipse$swt$graphics$Device = Display.class$("org.eclipse.swt.graphics.Device")) : class$org$eclipse$swt$graphics$Device;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            synchronizer = this.synchronizer;
        }
        synchronizer.syncExec(runnable);
    }

    public void timerExec(int milliseconds, Runnable runnable) {
        int index;
        this.checkDevice();
        if (runnable == null) {
            this.error(4);
        }
        if (this.timerList == null) {
            this.timerList = new Runnable[4];
        }
        if (this.nsTimers == null) {
            this.nsTimers = new NSTimer[4];
        }
        for (index = 0; index < this.timerList.length && this.timerList[index] != runnable; ++index) {
        }
        if (index != this.timerList.length) {
            NSTimer timer = this.nsTimers[index];
            if (timer == null) {
                this.timerList[index] = null;
            } else {
                if (milliseconds < 0) {
                    timer.invalidate();
                    timer.release();
                    this.timerList[index] = null;
                    this.nsTimers[index] = null;
                } else {
                    timer.setFireDate(NSDate.dateWithTimeIntervalSinceNow((double)milliseconds / 1000.0));
                }
                return;
            }
        }
        if (milliseconds < 0) {
            return;
        }
        for (index = 0; index < this.timerList.length && this.timerList[index] != null; ++index) {
        }
        if (index == this.timerList.length) {
            Runnable[] newTimerList = new Runnable[this.timerList.length + 4];
            System.arraycopy(this.timerList, 0, newTimerList, 0, this.timerList.length);
            this.timerList = newTimerList;
            NSTimer[] newTimerIds = new NSTimer[this.nsTimers.length + 4];
            System.arraycopy(this.nsTimers, 0, newTimerIds, 0, this.nsTimers.length);
            this.nsTimers = newTimerIds;
        }
        NSNumber userInfo = NSNumber.numberWithInt(index);
        NSTimer timer = NSTimer.scheduledTimerWithTimeInterval((double)milliseconds / 1000.0, this.timerDelegate, OS.sel_timerProc_, userInfo, false);
        NSRunLoop runLoop = NSRunLoop.currentRunLoop();
        runLoop.addTimer(timer, OS.NSModalPanelRunLoopMode);
        runLoop.addTimer(timer, OS.NSEventTrackingRunLoopMode);
        timer.retain();
        if (timer != null) {
            this.nsTimers[index] = timer;
            this.timerList[index] = runnable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long timerProc(long id2, long sel, long timerID) {
        NSTimer timer = new NSTimer(timerID);
        try {
            NSNumber number = new NSNumber(timer.userInfo());
            int index = number.intValue();
            if (this.timerList == null) {
                long l = 0L;
                return l;
            }
            if (0 <= index && index < this.timerList.length) {
                if (this.allowTimers) {
                    Runnable runnable = this.timerList[index];
                    this.timerList[index] = null;
                    this.nsTimers[index] = null;
                    if (runnable != null) {
                        runnable.run();
                    }
                } else {
                    this.nsTimers[index] = null;
                    this.wakeThread();
                }
            }
        }
        finally {
            timer.invalidate();
            timer.release();
        }
        return 0L;
    }

    public void update() {
        this.checkDevice();
        Shell[] shells = this.getShells();
        for (int i = 0; i < shells.length; ++i) {
            Shell shell = shells[i];
            if (shell.isDisposed()) continue;
            shell.update(true);
        }
    }

    void updateDefaultButton() {
        this.timerExec(this.hasDefaultButton() ? 30 : -1, this.defaultButtonTimer);
    }

    void updateQuitMenu() {
        NSMenu sm;
        long quitIndex;
        NSMenu mainmenu;
        NSMenuItem appitem;
        if (this.isEmbedded) {
            return;
        }
        boolean enabled = true;
        Shell[] shells = this.getShells();
        int mask = 229376;
        for (int i = 0; i < shells.length; ++i) {
            Shell shell = shells[i];
            if ((shell.style & mask) == 0 || !shell.isVisible()) continue;
            enabled = false;
            break;
        }
        if ((appitem = (mainmenu = this.application.mainMenu()).itemAtIndex(0L)) != null && (quitIndex = (sm = appitem.submenu()).indexOfItemWithTarget(applicationDelegate, OS.sel_applicationShouldTerminate_)) != -1L) {
            NSMenuItem quitItem = sm.itemAtIndex(quitIndex);
            quitItem.setEnabled(enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wake() {
        Class clazz = class$org$eclipse$swt$graphics$Device == null ? (class$org$eclipse$swt$graphics$Device = Display.class$("org.eclipse.swt.graphics.Device")) : class$org$eclipse$swt$graphics$Device;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            if (this.thread == Thread.currentThread()) {
                return;
            }
            this.wakeThread();
        }
    }

    void wakeThread() {
        NSObject object = new NSObject().alloc().init();
        object.performSelectorOnMainThread(OS.sel_release, null, false);
    }

    Control findControl(boolean checkTrim) {
        return this.findControl(checkTrim, null);
    }

    Control findControl(boolean checkTrim, NSView[] hitView) {
        NSView view = null;
        NSPoint screenLocation = NSEvent.mouseLocation();
        long hitWindowNumber = 0L;
        if (OS.VERSION >= 4192) {
            hitWindowNumber = NSWindow.windowNumberAtPoint(screenLocation, 0L);
        } else {
            long[] outWindow = new long[1];
            OS.FindWindow((long)screenLocation.x, (long)(this.getPrimaryFrame().height - screenLocation.y), outWindow);
            if (outWindow[0] != 0L) {
                hitWindowNumber = OS.HIWindowGetCGWindowID(outWindow[0]);
            }
        }
        NSWindow window = this.application.windowWithWindowNumber(hitWindowNumber);
        if (window != null) {
            NSPoint location;
            NSView contentView = window.contentView();
            if (contentView != null) {
                contentView = contentView.superview();
            }
            if (contentView != null && (view = contentView.hitTest(location = window.convertScreenToBase(screenLocation))) == null && !checkTrim) {
                view = contentView;
            }
        }
        Control control = null;
        if (view != null) {
            do {
                Widget widget;
                if (!((widget = this.getWidget(view)) instanceof Control)) continue;
                control = (Control)widget;
                break;
            } while ((view = view.superview()) != null);
        }
        if (checkTrim && control != null && control.isTrim(view)) {
            control = null;
        }
        if (control != null && hitView != null) {
            hitView[0] = view;
        }
        return control;
    }

    void finishLaunching(long id2, long sel) {
        if (launched) {
            return;
        }
        launched = true;
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        OS.objc_msgSendSuper(super_struct, sel);
    }

    void applicationDidBecomeActive(long id2, long sel, long notification) {
        NSWindow keyWindow = this.application.keyWindow();
        if (keyWindow != null) {
            keyWindow.orderFrontRegardless();
        } else {
            this.setMenuBar(this.menuBar);
        }
        this.checkFocus();
        this.checkEnterExit(this.findControl(true), null, false);
    }

    void applicationDidResignActive(long id2, long sel, long notification) {
        this.checkFocus();
        this.checkEnterExit(null, null, false);
    }

    long applicationNextEventMatchingMask(long id2, long sel, long mask, long expiration, long mode, long dequeue) {
        if (dequeue != 0L && this.trackingControl != null && !this.trackingControl.isDisposed()) {
            this.runDeferredEvents();
        }
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        long result = OS.objc_msgSendSuper(super_struct, sel, mask, expiration, mode, dequeue != 0L);
        if (result != 0L) {
            if (dequeue != 0L && this.currentCombo != null && !this.currentCombo.isDisposed()) {
                NSEvent nsEvent = new NSEvent(result);
                if (this.mozillaRunning && nsEvent.type() == 15L) {
                    return 0L;
                }
                if (nsEvent.type() == 10L) {
                    this.currentCombo.sendTrackingKeyEvent(nsEvent, 1);
                }
            }
            if (dequeue != 0L && this.trackingControl != null && !this.trackingControl.isDisposed()) {
                this.applicationSendTrackingEvent(new NSEvent(result), this.trackingControl);
            }
        }
        return result;
    }

    void applicationSendTrackingEvent(NSEvent nsEvent, Control trackingControl) {
        int type = (int)nsEvent.type();
        boolean runEnterExit = false;
        Control runEnterExitControl = null;
        switch (type) {
            case 1: 
            case 3: 
            case 25: {
                this.clickCount = (int)((long)this.clickCountButton == nsEvent.buttonNumber() ? nsEvent.clickCount() : 1L);
                this.clickCountButton = (int)nsEvent.buttonNumber();
                trackingControl.sendMouseEvent(nsEvent, 3, true);
                break;
            }
            case 2: 
            case 4: 
            case 26: {
                runEnterExit = true;
                runEnterExitControl = this.findControl(true);
                Control control = trackingControl;
                this.trackingControl = null;
                if (this.clickCount == 2) {
                    control.sendMouseEvent(nsEvent, 8, false);
                }
                if (control.isDisposed()) break;
                control.sendMouseEvent(nsEvent, 4, false);
                break;
            }
            case 6: 
            case 7: 
            case 27: {
                runEnterExit = true;
                runEnterExitControl = trackingControl;
            }
            case 5: {
                trackingControl.sendMouseEvent(nsEvent, 5, true);
            }
        }
        if (runEnterExit && (runEnterExitControl == null || !runEnterExitControl.isDisposed())) {
            this.checkEnterExit(runEnterExitControl, nsEvent, false);
        }
    }

    void applicationSendEvent(long id2, long sel, long event) {
        NSEvent nsEvent = new NSEvent(event);
        NSWindow window = nsEvent.window();
        if (this.performKeyEquivalent(window, nsEvent)) {
            return;
        }
        int type = (int)nsEvent.type();
        boolean activate = false;
        boolean down = false;
        switch (type) {
            case 1: 
            case 3: 
            case 25: {
                down = true;
                activate = true;
            }
            case 2: 
            case 4: 
            case 26: {
                activate = true;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 22: 
            case 27: {
                Shell modalShell;
                Shell shell;
                if (window == null || (shell = (Shell)this.getWidget(window.id)) == null || (modalShell = shell.getModalShell()) == null) break;
                if (activate) {
                    if (this.application.isActive()) {
                        modalShell.window.orderFrontRegardless();
                    } else {
                        this.application.activateIgnoringOtherApps(true);
                    }
                    if (down) {
                        NSRect rect = window.contentView().frame();
                        NSPoint pt = window.convertBaseToScreen(nsEvent.locationInWindow());
                        if (OS.NSPointInRect(pt, rect)) {
                            this.beep();
                        }
                    }
                }
                return;
            }
        }
        if (type != 13) {
            this.sendEvent = true;
        }
        if (window != null && window.isKeyWindow() && nsEvent.type() == 10L && (nsEvent.modifierFlags() & 0x400000L) != 0L) {
            window.sendEvent(nsEvent);
        }
        if (window != null && window.isKeyWindow() && nsEvent.type() == 11L && (nsEvent.modifierFlags() & 0x100000L) != 0L) {
            window.sendEvent(nsEvent);
        } else {
            objc_super super_struct = new objc_super();
            super_struct.receiver = id2;
            super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
            OS.objc_msgSendSuper(super_struct, sel, event);
        }
        if (type != 13) {
            this.sendEvent = false;
        }
    }

    void applicationWillFinishLaunching(long id2, long sel, long notification) {
        NSMenu mainmenu;
        NSMenuItem appitem;
        boolean loaded = false;
        if (this.isEmbedded) {
            long[] outMenu = new long[1];
            short[] outIndex = new short[1];
            int status = OS.GetIndMenuItemWithCommandID(0L, 1751737445, 1, outMenu, outIndex);
            if (status == 0) {
                OS.DeleteMenuItem(outMenu[0], outIndex[0]);
            }
            if ((status = OS.GetIndMenuItemWithCommandID(0L, 1751737455, 1, outMenu, outIndex)) == 0) {
                OS.DeleteMenuItem(outMenu[0], outIndex[0]);
            }
            if ((status = OS.GetIndMenuItemWithCommandID(0L, 1936220524, 1, outMenu, outIndex)) == 0) {
                OS.DeleteMenuItem(outMenu[0], outIndex[0]);
            }
            if ((status = OS.GetIndMenuItemWithCommandID(0L, 1903520116, 1, outMenu, outIndex)) == 0) {
                OS.DeleteMenuItem(outMenu[0], outIndex[0]);
            }
            if ((status = OS.GetIndMenuItemWithCommandID(0L, 1936028278, 1, outMenu, outIndex)) == 0) {
                OS.DeleteMenuItem(outMenu[0], outIndex[0]);
            }
        }
        Locale loc = Locale.getDefault();
        String languageISOValue = loc.getLanguage();
        NSLocale englishLocale = (NSLocale)new NSLocale().alloc();
        englishLocale = new NSLocale(englishLocale.initWithLocaleIdentifier(NSString.stringWith("en_US")));
        NSString languageDisplayName = englishLocale.displayNameForKey(OS.NSLocaleLanguageCode, NSString.stringWith(languageISOValue));
        if (englishLocale != null) {
            englishLocale.release();
        }
        NSBundle bundle = NSBundle.bundleWithIdentifier(NSString.stringWith("com.apple.JavaVM"));
        NSDictionary dict = NSDictionary.dictionaryWithObject(applicationDelegate, NSString.stringWith("NSOwner"));
        NSString path = bundle.pathForResource(NSString.stringWith("DefaultApp"), NSString.stringWith("nib"), null, languageDisplayName);
        if (path == null) {
            path = bundle.pathForResource(NSString.stringWith("DefaultApp"), NSString.stringWith("nib"), null, NSString.stringWith(languageISOValue));
        }
        if (path == null) {
            path = bundle.pathForResource(NSString.stringWith("DefaultApp"), NSString.stringWith("nib"));
        }
        if (!loaded) {
            boolean bl = loaded = path != null && NSBundle.loadNibFile(path, dict, 0L);
        }
        if (!loaded) {
            NSString resourcePath = bundle.resourcePath();
            path = resourcePath != null ? resourcePath.stringByAppendingString(NSString.stringWith("/English.lproj/DefaultApp.nib")) : null;
            boolean bl = loaded = path != null && NSBundle.loadNibFile(path, dict, 0L);
        }
        if (!loaded) {
            path = NSString.stringWith(System.getProperty("java.home") + "/../Resources/English.lproj/DefaultApp.nib");
            boolean bl = loaded = path != null && NSBundle.loadNibFile(path, dict, 0L);
        }
        if (!loaded) {
            this.createMainMenu();
        }
        if ((appitem = (mainmenu = this.application.mainMenu()).itemAtIndex(0L)) != null) {
            NSString name = Display.getApplicationName();
            NSString match = NSString.stringWith("%@");
            appitem.setTitle(name);
            NSMenu sm = appitem.submenu();
            NSArray ia = sm.itemArray();
            int i = 0;
            while ((long)i < ia.count()) {
                NSMenuItem ni = new NSMenuItem(ia.objectAtIndex(i));
                NSString title = ni.title().stringByReplacingOccurrencesOfString(match, name);
                ni.setTitle(title);
                long newTag = 0L;
                switch (i) {
                    case 0: {
                        newTag = -1L;
                        break;
                    }
                    case 2: {
                        newTag = -2L;
                        break;
                    }
                    case 6: {
                        newTag = -3L;
                        break;
                    }
                    case 7: {
                        newTag = -4L;
                        break;
                    }
                    case 8: {
                        newTag = -5L;
                        break;
                    }
                    case 10: {
                        newTag = -6L;
                    }
                }
                if (newTag != 0L) {
                    ni.setTag(newTag);
                }
                ++i;
            }
            long quitIndex = sm.indexOfItemWithTarget(applicationDelegate, OS.sel_terminate_);
            if (quitIndex != -1L) {
                NSMenuItem quitItem = sm.itemAtIndex(quitIndex);
                quitItem.setAction(OS.sel_applicationShouldTerminate_);
            }
        }
    }

    static long applicationProc(long id2, long sel) {
        Display display = Display.getCurrent();
        if (display == null) {
            objc_super super_struct = new objc_super();
            super_struct.receiver = id2;
            super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
            return OS.objc_msgSendSuper(super_struct, sel);
        }
        if (sel == OS.sel_isRunning) {
            return display.isDisposed() ? 0L : 1L;
        }
        if (sel == OS.sel_finishLaunching) {
            display.finishLaunching(id2, sel);
        }
        return 0L;
    }

    static long applicationProc(long id2, long sel, long arg0) {
        Display display = Display.getCurrent();
        if (display == null && id2 != Display.applicationDelegate.id) {
            objc_super super_struct = new objc_super();
            super_struct.receiver = id2;
            super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
            return OS.objc_msgSendSuper(super_struct, sel, arg0);
        }
        if (currAppDelegate != null && currAppDelegate.respondsToSelector(sel)) {
            OS.objc_msgSend(Display.currAppDelegate.id, sel, arg0);
        }
        NSApplication application = display.application;
        if (sel == OS.sel_sendEvent_) {
            display.applicationSendEvent(id2, sel, arg0);
        } else if (sel == OS.sel_applicationWillFinishLaunching_) {
            display.applicationWillFinishLaunching(id2, sel, arg0);
        } else {
            if (sel == OS.sel_applicationShouldTerminate_) {
                int returnVal = 0;
                if (!display.disposing) {
                    Event event = new Event();
                    display.sendEvent(21, event);
                    if (event.doit) {
                        display.dispose();
                        returnVal = 1;
                    }
                }
                return returnVal;
            }
            if (sel != OS.sel_orderFrontStandardAboutPanel_) {
                Menu menu;
                TaskItem item;
                TaskBar taskbar;
                if (sel == OS.sel_hideOtherApplications_) {
                    application.hideOtherApplications(application);
                } else if (sel == OS.sel_hide_) {
                    application.hide(application);
                } else if (sel == OS.sel_unhideAllApplications_) {
                    application.unhideAllApplications(application);
                } else if (sel == OS.sel_applicationDidBecomeActive_) {
                    display.applicationDidBecomeActive(id2, sel, arg0);
                } else if (sel == OS.sel_applicationDidResignActive_) {
                    display.applicationDidResignActive(id2, sel, arg0);
                } else if (sel == OS.sel_applicationDockMenu_ && (taskbar = display.taskBar) != null && taskbar.itemCount != 0 && (item = taskbar.getItem(null)) != null && (menu = item.getMenu()) != null && !menu.isDisposed()) {
                    return menu.nsMenu.id;
                }
            }
        }
        return 0L;
    }

    static long applicationProc(long id2, long sel, long arg0, long arg1) {
        Display display = Display.getCurrent();
        if (display == null && id2 != Display.applicationDelegate.id) {
            objc_super super_struct = new objc_super();
            super_struct.receiver = id2;
            super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
            return OS.objc_msgSendSuper(super_struct, sel, arg0, arg1);
        }
        if (currAppDelegate != null && currAppDelegate.respondsToSelector(sel)) {
            OS.objc_msgSend(Display.currAppDelegate.id, sel, arg0, arg1);
        }
        if (sel == OS.sel_application_openFile_) {
            String file = new NSString(arg1).getString();
            Event event = new Event();
            event.text = file;
            display.sendEvent(46, event);
            return 1L;
        }
        if (sel == OS.sel_application_openFiles_) {
            NSArray files = new NSArray(arg1);
            long count = files.count();
            int i = 0;
            while ((long)i < count) {
                String file = new NSString(files.objectAtIndex(i)).getString();
                Event event = new Event();
                event.text = file;
                display.sendEvent(46, event);
                ++i;
            }
            new NSApplication(arg0).replyToOpenOrPrint(0L);
        } else if (sel == OS.sel_applicationShouldHandleReopen_hasVisibleWindows_) {
            Event event = new Event();
            display.sendEvent(26, event);
            return event.doit ? 1L : 0L;
        }
        return 0L;
    }

    static long applicationProc(long id2, long sel, long arg0, long arg1, long arg2, long arg3) {
        Display display = Display.getCurrent();
        if (display == null && id2 != Display.applicationDelegate.id) {
            objc_super super_struct = new objc_super();
            super_struct.receiver = id2;
            super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
            return OS.objc_msgSendSuper(super_struct, sel, arg0, arg1, arg2, arg3 != 0L);
        }
        if (sel == OS.sel_nextEventMatchingMask_untilDate_inMode_dequeue_) {
            return display.applicationNextEventMatchingMask(id2, sel, arg0, arg1, arg2, arg3);
        }
        return 0L;
    }

    static long dialogProc(long id2, long sel, long arg0) {
        long[] jniRef = new long[1];
        OS.object_getInstanceVariable(id2, SWT_OBJECT, jniRef);
        if (jniRef[0] == 0L) {
            return 0L;
        }
        if (sel == OS.sel_changeColor_) {
            ColorDialog dialog = (ColorDialog)OS.JNIGetObject(jniRef[0]);
            if (dialog == null) {
                return 0L;
            }
            dialog.changeColor(id2, sel, arg0);
        } else if (sel == OS.sel_changeFont_) {
            FontDialog dialog = (FontDialog)OS.JNIGetObject(jniRef[0]);
            if (dialog == null) {
                return 0L;
            }
            dialog.changeFont(id2, sel, arg0);
        } else {
            if (sel == OS.sel_validModesForFontPanel_) {
                FontDialog dialog = (FontDialog)OS.JNIGetObject(jniRef[0]);
                if (dialog == null) {
                    return 0L;
                }
                return dialog.validModesForFontPanel(id2, sel, arg0);
            }
            if (sel == OS.sel_sendSelection_) {
                FileDialog dialog = (FileDialog)OS.JNIGetObject(jniRef[0]);
                if (dialog == null) {
                    return 0L;
                }
                dialog.sendSelection(id2, sel, arg0);
            } else if (sel == OS.sel_windowWillClose_) {
                Object object = OS.JNIGetObject(jniRef[0]);
                if (object instanceof FontDialog) {
                    ((FontDialog)object).windowWillClose(id2, sel, arg0);
                } else if (object instanceof ColorDialog) {
                    ((ColorDialog)object).windowWillClose(id2, sel, arg0);
                }
            }
        }
        return 0L;
    }

    static long dialogProc(long id2, long sel, long arg0, long arg1) {
        long[] jniRef = new long[1];
        OS.object_getInstanceVariable(id2, SWT_OBJECT, jniRef);
        if (jniRef[0] == 0L) {
            return 0L;
        }
        if (sel == OS.sel_panel_shouldShowFilename_) {
            FileDialog dialog = (FileDialog)OS.JNIGetObject(jniRef[0]);
            if (dialog == null) {
                return 0L;
            }
            return dialog.panel_shouldShowFilename(id2, sel, arg0, arg1);
        }
        if (sel == OS.sel_setColor_forAttribute_) {
            FontDialog dialog = (FontDialog)OS.JNIGetObject(jniRef[0]);
            if (dialog == null) {
                return 0L;
            }
            dialog.setColor_forAttribute(id2, sel, arg0, arg1);
            return 0L;
        }
        return 0L;
    }

    static long dialogProc(long id2, long sel, long arg0, long arg1, long arg2) {
        long[] jniRef = new long[1];
        OS.object_getInstanceVariable(id2, SWT_OBJECT, jniRef);
        if (jniRef[0] == 0L) {
            return 0L;
        }
        if (sel == OS.sel_panelDidEnd_returnCode_contextInfo_) {
            MessageBox dialog = (MessageBox)OS.JNIGetObject(jniRef[0]);
            if (dialog == null) {
                return 0L;
            }
            dialog.panelDidEnd_returnCode_contextInfo(id2, sel, arg0, arg1, arg2);
        }
        return 0L;
    }

    static Widget LookupWidget(long id2, long sel) {
        NSView view;
        Widget widget = Display.GetWidget(id2);
        if (widget == null && (view = new NSView(id2)).isKindOfClass(OS.class_NSView)) {
            while (widget == null && (view = view.superview()) != null) {
                widget = Display.GetWidget(view.id);
            }
        }
        return widget;
    }

    static long windowProc(long id2, long sel) {
        if (sel == OS.sel_cellClass) {
            long superCls = OS.objc_msgSend(OS.class_getSuperclass(id2), sel);
            long cls = OS.objc_lookUpClass("SWTAccessible" + OS.class_getName(superCls));
            return cls != 0L ? cls : superCls;
        }
        if (!NSThread.isMainThread() && sel == OS.sel_isOpaque) {
            return 1L;
        }
        Widget widget = Display.LookupWidget(id2, sel);
        if (widget == null) {
            return 0L;
        }
        if (sel == OS.sel_sendSelection) {
            widget.sendSelection();
        } else if (sel == OS.sel_dealloc) {
            widget.dealloc(id2, sel);
        } else if (sel == OS.sel_sendDoubleSelection) {
            widget.sendDoubleSelection();
        } else if (sel == OS.sel_sendVerticalSelection) {
            widget.sendVerticalSelection();
        } else if (sel == OS.sel_sendHorizontalSelection) {
            widget.sendHorizontalSelection();
        } else if (sel == OS.sel_sendSearchSelection) {
            widget.sendSearchSelection();
        } else if (sel == OS.sel_sendCancelSelection) {
            widget.sendCancelSelection();
        } else {
            if (sel == OS.sel_acceptsFirstResponder) {
                return widget.acceptsFirstResponder(id2, sel) ? 1L : 0L;
            }
            if (sel == OS.sel_becomeFirstResponder) {
                return widget.becomeFirstResponder(id2, sel) ? 1L : 0L;
            }
            if (sel == OS.sel_resignFirstResponder) {
                return widget.resignFirstResponder(id2, sel) ? 1L : 0L;
            }
            if (sel == OS.sel_isOpaque) {
                return widget.isOpaque(id2, sel) ? 1L : 0L;
            }
            if (sel == OS.sel_isFlipped) {
                return widget.isFlipped(id2, sel) ? 1L : 0L;
            }
            if (sel == OS.sel_canBecomeKeyView) {
                return widget.canBecomeKeyView(id2, sel) ? 1L : 0L;
            }
            if (sel == OS.sel_needsPanelToBecomeKey) {
                return widget.needsPanelToBecomeKey(id2, sel) ? 1L : 0L;
            }
            if (sel == OS.sel_canBecomeKeyView) {
                return widget.canBecomeKeyView(id2, sel) ? 1L : 0L;
            }
            if (sel == OS.sel_becomeKeyWindow) {
                widget.becomeKeyWindow(id2, sel);
            } else if (sel != OS.sel_unmarkText) {
                if (sel == OS.sel_validAttributesForMarkedText) {
                    return widget.validAttributesForMarkedText(id2, sel);
                }
                if (sel == OS.sel_markedRange) {
                    NSRange range = widget.markedRange(id2, sel);
                    long result = OS.malloc(NSRange.sizeof);
                    OS.memmove(result, range, (long)NSRange.sizeof);
                    return result;
                }
                if (sel == OS.sel_selectedRange) {
                    NSRange range = widget.selectedRange(id2, sel);
                    long result = OS.malloc(NSRange.sizeof);
                    OS.memmove(result, range, (long)NSRange.sizeof);
                    return result;
                }
                if (sel == OS.sel_cellSize) {
                    NSSize size = widget.cellSize(id2, sel);
                    long result = OS.malloc(NSSize.sizeof);
                    OS.memmove(result, size, (long)NSSize.sizeof);
                    return result;
                }
                if (sel == OS.sel_hasMarkedText) {
                    return widget.hasMarkedText(id2, sel) ? 1L : 0L;
                }
                if (sel == OS.sel_canBecomeKeyWindow) {
                    return widget.canBecomeKeyWindow(id2, sel) ? 1L : 0L;
                }
                if (sel == OS.sel_accessibilityActionNames) {
                    return widget.accessibilityActionNames(id2, sel);
                }
                if (sel == OS.sel_accessibilityAttributeNames) {
                    return widget.accessibilityAttributeNames(id2, sel);
                }
                if (sel == OS.sel_accessibilityParameterizedAttributeNames) {
                    return widget.accessibilityParameterizedAttributeNames(id2, sel);
                }
                if (sel == OS.sel_getImageView) {
                    return widget.imageView();
                }
                if (sel == OS.sel_mouseDownCanMoveWindow) {
                    return widget.mouseDownCanMoveWindow(id2, sel) ? 1 : 0;
                }
                if (sel == OS.sel_accessibilityFocusedUIElement) {
                    return widget.accessibilityFocusedUIElement(id2, sel);
                }
                if (sel == OS.sel_accessibilityIsIgnored) {
                    return widget.accessibilityIsIgnored(id2, sel) ? 1 : 0;
                }
                if (sel == OS.sel_nextState) {
                    return widget.nextState(id2, sel);
                }
                if (sel == OS.sel_resetCursorRects) {
                    widget.resetCursorRects(id2, sel);
                } else if (sel == OS.sel_updateTrackingAreas) {
                    widget.updateTrackingAreas(id2, sel);
                } else if (sel == OS.sel_viewDidMoveToWindow) {
                    widget.viewDidMoveToWindow(id2, sel);
                } else {
                    if (sel == OS.sel_image) {
                        return widget.image(id2, sel);
                    }
                    if (sel == OS.sel_shouldDrawInsertionPoint) {
                        return widget.shouldDrawInsertionPoint(id2, sel) ? 1L : 0L;
                    }
                    if (sel == OS.sel_accessibleHandle) {
                        return widget.accessibleHandle();
                    }
                    if (sel == OS.sel_clearDeferFlushing) {
                        widget.clearDeferFlushing(id2, sel);
                    }
                }
            }
        }
        return 0L;
    }

    static long windowProc(long id2, long sel, long arg0) {
        if (!NSThread.isMainThread() && sel == OS.sel_drawRect_) {
            return 0L;
        }
        if (sel == OS.sel_changeColor_) {
            NSColorPanel panel = NSColorPanel.sharedColorPanel();
            id delegate = panel.delegate();
            if (delegate != null && OS.objc_msgSend_bool(delegate.id, OS.sel_isKindOfClass_, OS.objc_getClass("SWTPanelDelegate"))) {
                OS.objc_msgSend(delegate.id, OS.sel_changeColor_, arg0);
            }
            return 0L;
        }
        if (sel == OS.sel_timerProc_) {
            Display display = Display.getCurrent();
            if (display == null) {
                return 0L;
            }
            return display.timerProc(id2, sel, arg0);
        }
        if (sel == OS.sel_systemSettingsChanged_) {
            Display display = Display.getCurrent();
            if (display == null) {
                return 0L;
            }
            display.runSettings = true;
            return 0L;
        }
        Widget widget = Display.LookupWidget(id2, sel);
        if (widget == null) {
            return 0L;
        }
        if (sel == OS.sel_windowWillClose_) {
            widget.windowWillClose(id2, sel, arg0);
        } else if (sel == OS.sel_drawRect_) {
            NSRect rect = new NSRect();
            OS.memmove(rect, arg0, (long)NSRect.sizeof);
            widget.drawRect(id2, sel, rect);
        } else {
            if (sel == OS.sel_columnAtPoint_) {
                NSPoint point = new NSPoint();
                OS.memmove(point, arg0, (long)NSPoint.sizeof);
                return widget.columnAtPoint(id2, sel, point);
            }
            if (sel == OS.sel__drawThemeProgressArea_) {
                widget._drawThemeProgressArea(id2, sel, arg0);
            } else if (sel == OS.sel_setFrameOrigin_) {
                NSPoint point = new NSPoint();
                OS.memmove(point, arg0, (long)NSPoint.sizeof);
                widget.setFrameOrigin(id2, sel, point);
            } else if (sel == OS.sel_setFrameSize_) {
                NSSize size = new NSSize();
                OS.memmove(size, arg0, (long)NSSize.sizeof);
                widget.setFrameSize(id2, sel, size);
            } else {
                if (sel == OS.sel_hitTest_) {
                    NSPoint point = new NSPoint();
                    OS.memmove(point, arg0, (long)NSPoint.sizeof);
                    return widget.hitTest(id2, sel, point);
                }
                if (sel == OS.sel_windowShouldClose_) {
                    return widget.windowShouldClose(id2, sel, arg0) ? 1L : 0L;
                }
                if (sel == OS.sel_mouseDown_) {
                    widget.mouseDown(id2, sel, arg0);
                } else if (sel == OS.sel_keyDown_) {
                    widget.keyDown(id2, sel, arg0);
                } else if (sel == OS.sel_keyUp_) {
                    widget.keyUp(id2, sel, arg0);
                } else if (sel == OS.sel_flagsChanged_) {
                    widget.flagsChanged(id2, sel, arg0);
                } else if (sel == OS.sel_mouseUp_) {
                    widget.mouseUp(id2, sel, arg0);
                } else if (sel == OS.sel_rightMouseDown_) {
                    widget.rightMouseDown(id2, sel, arg0);
                } else if (sel == OS.sel_rightMouseDragged_) {
                    widget.rightMouseDragged(id2, sel, arg0);
                } else if (sel == OS.sel_rightMouseUp_) {
                    widget.rightMouseUp(id2, sel, arg0);
                } else if (sel == OS.sel_otherMouseDown_) {
                    widget.otherMouseDown(id2, sel, arg0);
                } else if (sel == OS.sel_otherMouseUp_) {
                    widget.otherMouseUp(id2, sel, arg0);
                } else if (sel == OS.sel_otherMouseDragged_) {
                    widget.otherMouseDragged(id2, sel, arg0);
                } else if (sel == OS.sel_mouseMoved_) {
                    widget.mouseMoved(id2, sel, arg0);
                } else if (sel == OS.sel_mouseDragged_) {
                    widget.mouseDragged(id2, sel, arg0);
                } else if (sel == OS.sel_mouseEntered_) {
                    widget.mouseEntered(id2, sel, arg0);
                } else if (sel == OS.sel_mouseExited_) {
                    widget.mouseExited(id2, sel, arg0);
                } else if (sel == OS.sel_cursorUpdate_) {
                    widget.cursorUpdate(id2, sel, arg0);
                } else {
                    if (sel == OS.sel_menuForEvent_) {
                        return widget.menuForEvent(id2, sel, arg0);
                    }
                    if (sel == OS.sel_noResponderFor_) {
                        widget.noResponderFor(id2, sel, arg0);
                    } else {
                        if (sel == OS.sel_shouldDelayWindowOrderingForEvent_) {
                            return widget.shouldDelayWindowOrderingForEvent(id2, sel, arg0) ? 1L : 0L;
                        }
                        if (sel == OS.sel_acceptsFirstMouse_) {
                            return widget.acceptsFirstMouse(id2, sel, arg0) ? 1L : 0L;
                        }
                        if (sel == OS.sel_numberOfRowsInTableView_) {
                            return widget.numberOfRowsInTableView(id2, sel, arg0);
                        }
                        if (sel == OS.sel_tableViewSelectionDidChange_) {
                            widget.tableViewSelectionDidChange(id2, sel, arg0);
                        } else if (sel == OS.sel_tableViewSelectionIsChanging_) {
                            widget.tableViewSelectionIsChanging(id2, sel, arg0);
                        } else if (sel == OS.sel_windowDidResignKey_) {
                            widget.windowDidResignKey(id2, sel, arg0);
                        } else if (sel == OS.sel_windowDidBecomeKey_) {
                            widget.windowDidBecomeKey(id2, sel, arg0);
                        } else if (sel == OS.sel_windowDidResize_) {
                            widget.windowDidResize(id2, sel, arg0);
                        } else if (sel == OS.sel_windowDidMove_) {
                            widget.windowDidMove(id2, sel, arg0);
                        } else if (sel == OS.sel_menuWillOpen_) {
                            widget.menuWillOpen(id2, sel, arg0);
                        } else if (sel == OS.sel_menuDidClose_) {
                            widget.menuDidClose(id2, sel, arg0);
                        } else if (sel == OS.sel_menuNeedsUpdate_) {
                            widget.menuNeedsUpdate(id2, sel, arg0);
                        } else if (sel == OS.sel_outlineViewSelectionDidChange_) {
                            widget.outlineViewSelectionDidChange(id2, sel, arg0);
                        } else if (sel == OS.sel_outlineViewSelectionIsChanging_) {
                            widget.outlineViewSelectionIsChanging(id2, sel, arg0);
                        } else if (sel == OS.sel_sendEvent_) {
                            widget.windowSendEvent(id2, sel, arg0);
                        } else if (sel == OS.sel_helpRequested_) {
                            widget.helpRequested(id2, sel, arg0);
                        } else if (sel == OS.sel_scrollWheel_) {
                            widget.scrollWheel(id2, sel, arg0);
                        } else if (sel == OS.sel_pageDown_) {
                            widget.pageDown(id2, sel, arg0);
                        } else if (sel == OS.sel_pageUp_) {
                            widget.pageUp(id2, sel, arg0);
                        } else if (sel == OS.sel_textViewDidChangeSelection_) {
                            widget.textViewDidChangeSelection(id2, sel, arg0);
                        } else if (sel == OS.sel_textDidChange_) {
                            widget.textDidChange(id2, sel, arg0);
                        } else if (sel == OS.sel_textDidEndEditing_) {
                            widget.textDidEndEditing(id2, sel, arg0);
                        } else {
                            if (sel == OS.sel_attributedSubstringFromRange_) {
                                return widget.attributedSubstringFromRange(id2, sel, arg0);
                            }
                            if (sel == OS.sel_characterIndexForPoint_) {
                                return widget.characterIndexForPoint(id2, sel, arg0);
                            }
                            if (sel == OS.sel_firstRectForCharacterRange_) {
                                NSRect rect = widget.firstRectForCharacterRange(id2, sel, arg0);
                                long result = OS.malloc(NSRect.sizeof);
                                OS.memmove(result, rect, (long)NSRect.sizeof);
                                return result;
                            }
                            if (sel == OS.sel_insertText_) {
                                return widget.insertText(id2, sel, arg0) ? 1L : 0L;
                            }
                            if (sel == OS.sel_doCommandBySelector_) {
                                widget.doCommandBySelector(id2, sel, arg0);
                            } else if (sel == OS.sel_highlightSelectionInClipRect_) {
                                widget.highlightSelectionInClipRect(id2, sel, arg0);
                            } else if (sel == OS.sel_reflectScrolledClipView_) {
                                widget.reflectScrolledClipView(id2, sel, arg0);
                            } else {
                                if (sel == OS.sel_accessibilityHitTest_) {
                                    NSPoint point = new NSPoint();
                                    OS.memmove(point, arg0, (long)NSPoint.sizeof);
                                    return widget.accessibilityHitTest(id2, sel, point);
                                }
                                if (sel == OS.sel_accessibilityAttributeValue_) {
                                    return widget.accessibilityAttributeValue(id2, sel, arg0);
                                }
                                if (sel == OS.sel_accessibilityPerformAction_) {
                                    widget.accessibilityPerformAction(id2, sel, arg0);
                                } else {
                                    if (sel == OS.sel_accessibilityActionDescription_) {
                                        return widget.accessibilityActionDescription(id2, sel, arg0);
                                    }
                                    if (sel == OS.sel_accessibilityIsAttributeSettable_) {
                                        return widget.accessibilityIsAttributeSettable(id2, sel, arg0) ? 1L : 0L;
                                    }
                                    if (sel == OS.sel_makeFirstResponder_) {
                                        return widget.makeFirstResponder(id2, sel, arg0) ? 1L : 0L;
                                    }
                                    if (sel == OS.sel_tableViewColumnDidMove_) {
                                        widget.tableViewColumnDidMove(id2, sel, arg0);
                                    } else if (sel == OS.sel_tableViewColumnDidResize_) {
                                        widget.tableViewColumnDidResize(id2, sel, arg0);
                                    } else if (sel == OS.sel_outlineViewColumnDidMove_) {
                                        widget.outlineViewColumnDidMove(id2, sel, arg0);
                                    } else if (sel == OS.sel_outlineViewColumnDidResize_) {
                                        widget.outlineViewColumnDidResize(id2, sel, arg0);
                                    } else if (sel == OS.sel_setNeedsDisplay_) {
                                        widget.setNeedsDisplay(id2, sel, arg0 != 0L);
                                    } else if (sel == OS.sel_setNeedsDisplayInRect_) {
                                        widget.setNeedsDisplayInRect(id2, sel, arg0);
                                    } else if (sel == OS.sel_setImage_) {
                                        widget.setImage(id2, sel, arg0);
                                    } else {
                                        if (sel == OS.sel_headerRectOfColumn_) {
                                            NSRect rect = widget.headerRectOfColumn(id2, sel, arg0);
                                            long result = OS.malloc(NSRect.sizeof);
                                            OS.memmove(result, rect, (long)NSRect.sizeof);
                                            return result;
                                        }
                                        if (sel == OS.sel_imageRectForBounds_) {
                                            NSRect rect = new NSRect();
                                            OS.memmove(rect, arg0, (long)NSRect.sizeof);
                                            rect = widget.imageRectForBounds(id2, sel, rect);
                                            long result = OS.malloc(NSRect.sizeof);
                                            OS.memmove(result, rect, (long)NSRect.sizeof);
                                            return result;
                                        }
                                        if (sel == OS.sel_titleRectForBounds_) {
                                            NSRect rect = new NSRect();
                                            OS.memmove(rect, arg0, (long)NSRect.sizeof);
                                            rect = widget.titleRectForBounds(id2, sel, rect);
                                            long result = OS.malloc(NSRect.sizeof);
                                            OS.memmove(result, rect, (long)NSRect.sizeof);
                                            return result;
                                        }
                                        if (sel == OS.sel_cellSizeForBounds_) {
                                            NSRect rect = new NSRect();
                                            OS.memmove(rect, arg0, (long)NSRect.sizeof);
                                            NSSize size = widget.cellSizeForBounds(id2, sel, rect);
                                            long result = OS.malloc(NSSize.sizeof);
                                            OS.memmove(result, size, (long)NSSize.sizeof);
                                            return result;
                                        }
                                        if (sel == OS.sel_setObjectValue_) {
                                            widget.setObjectValue(id2, sel, arg0);
                                        } else if (sel == OS.sel_updateOpenGLContext_) {
                                            widget.updateOpenGLContext(id2, sel, arg0);
                                        } else {
                                            if (sel == OS.sel_sizeOfLabel_) {
                                                NSSize size = widget.sizeOfLabel(id2, sel, arg0 != 0L);
                                                long result = OS.malloc(NSSize.sizeof);
                                                OS.memmove(result, size, (long)NSSize.sizeof);
                                                return result;
                                            }
                                            if (sel == OS.sel_comboBoxSelectionDidChange_) {
                                                widget.comboBoxSelectionDidChange(id2, sel, arg0);
                                            } else if (sel == OS.sel_comboBoxWillDismiss_) {
                                                widget.comboBoxWillDismiss(id2, sel, arg0);
                                            } else if (sel == OS.sel_comboBoxWillPopUp_) {
                                                widget.comboBoxWillPopUp(id2, sel, arg0);
                                            } else if (sel == OS.sel_drawViewBackgroundInRect_) {
                                                NSRect rect = new NSRect();
                                                OS.memmove(rect, arg0, (long)NSRect.sizeof);
                                                widget.drawViewBackgroundInRect(id2, sel, rect);
                                            } else if (sel == OS.sel_drawBackgroundInClipRect_) {
                                                NSRect rect = new NSRect();
                                                OS.memmove(rect, arg0, (long)NSRect.sizeof);
                                                widget.drawBackgroundInClipRect(id2, sel, rect);
                                            } else if (sel == OS.sel_windowDidMiniaturize_) {
                                                widget.windowDidMiniturize(id2, sel, arg0);
                                            } else if (sel == OS.sel_windowDidDeminiaturize_) {
                                                widget.windowDidDeminiturize(id2, sel, arg0);
                                            } else if (sel == OS.sel_touchesBeganWithEvent_) {
                                                widget.touchesBeganWithEvent(id2, sel, arg0);
                                            } else if (sel == OS.sel_touchesMovedWithEvent_) {
                                                widget.touchesMovedWithEvent(id2, sel, arg0);
                                            } else if (sel == OS.sel_touchesEndedWithEvent_) {
                                                widget.touchesEndedWithEvent(id2, sel, arg0);
                                            } else if (sel == OS.sel_touchesCancelledWithEvent_) {
                                                widget.touchesCancelledWithEvent(id2, sel, arg0);
                                            } else if (sel == OS.sel_beginGestureWithEvent_) {
                                                widget.beginGestureWithEvent(id2, sel, arg0);
                                            } else if (sel == OS.sel_endGestureWithEvent_) {
                                                widget.endGestureWithEvent(id2, sel, arg0);
                                            } else if (sel == OS.sel_swipeWithEvent_) {
                                                widget.swipeWithEvent(id2, sel, arg0);
                                            } else if (sel == OS.sel_magnifyWithEvent_) {
                                                widget.magnifyWithEvent(id2, sel, arg0);
                                            } else if (sel == OS.sel_rotateWithEvent_) {
                                                widget.rotateWithEvent(id2, sel, arg0);
                                            } else {
                                                if (sel == OS.sel_toolbarAllowedItemIdentifiers_) {
                                                    return widget.toolbarAllowedItemIdentifiers(id2, sel, arg0);
                                                }
                                                if (sel == OS.sel_toolbarDefaultItemIdentifiers_) {
                                                    return widget.toolbarDefaultItemIdentifiers(id2, sel, arg0);
                                                }
                                                if (sel == OS.sel_toolbarSelectableItemIdentifiers_) {
                                                    return widget.toolbarSelectableItemIdentifiers(id2, sel, arg0);
                                                }
                                                if (sel == OS.sel_validateMenuItem_) {
                                                    return widget.validateMenuItem(id2, sel, arg0) ? 1 : 0;
                                                }
                                                if (sel == OS.sel_readSelectionFromPasteboard_) {
                                                    return widget.readSelectionFromPasteboard(id2, sel, arg0) ? 1 : 0;
                                                }
                                                if (sel == OS.sel_viewWillMoveToWindow_) {
                                                    widget.viewWillMoveToWindow(id2, sel, arg0);
                                                } else if (sel == OS.sel_cancelOperation_) {
                                                    widget.cancelOperation(id2, sel, arg0);
                                                } else if (sel == OS.sel_setShouldExpandItem_) {
                                                    widget.setShouldExpandItem(id2, sel, arg0 != 0L);
                                                } else if (sel == OS.sel_setShouldScrollClipView_) {
                                                    widget.setShouldScrollClipView(id2, sel, arg0 != 0L);
                                                } else if (sel == OS.sel_deselectRow_) {
                                                    widget.deselectRow(id2, sel, arg0);
                                                } else if (sel == OS.sel_deselectAll_) {
                                                    widget.deselectAll(id2, sel, arg0);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return 0L;
    }

    static long windowProc(long id2, long sel, long arg0, long arg1) {
        Widget widget = Display.LookupWidget(id2, sel);
        if (widget == null) {
            return 0L;
        }
        if (sel == OS.sel_tabView_willSelectTabViewItem_) {
            widget.tabView_willSelectTabViewItem(id2, sel, arg0, arg1);
        } else if (sel == OS.sel_tabView_didSelectTabViewItem_) {
            widget.tabView_didSelectTabViewItem(id2, sel, arg0, arg1);
        } else {
            if (sel == OS.sel_outlineView_isItemExpandable_) {
                return widget.outlineView_isItemExpandable(id2, sel, arg0, arg1) ? 1L : 0L;
            }
            if (sel == OS.sel_outlineView_numberOfChildrenOfItem_) {
                return widget.outlineView_numberOfChildrenOfItem(id2, sel, arg0, arg1);
            }
            if (sel == OS.sel_menu_willHighlightItem_) {
                widget.menu_willHighlightItem(id2, sel, arg0, arg1);
            } else if (sel == OS.sel_setMarkedText_selectedRange_) {
                widget.setMarkedText_selectedRange(id2, sel, arg0, arg1);
            } else if (sel == OS.sel_drawInteriorWithFrame_inView_) {
                NSRect rect = new NSRect();
                OS.memmove(rect, arg0, (long)NSRect.sizeof);
                widget.drawInteriorWithFrame_inView(id2, sel, rect, arg1);
            } else if (sel == OS.sel_drawWithExpansionFrame_inView_) {
                NSRect rect = new NSRect();
                OS.memmove(rect, arg0, (long)NSRect.sizeof);
                widget.drawWithExpansionFrame_inView(id2, sel, rect, arg1);
            } else {
                if (sel == OS.sel_accessibilityAttributeValue_forParameter_) {
                    return widget.accessibilityAttributeValue_forParameter(id2, sel, arg0, arg1);
                }
                if (sel == OS.sel_tableView_didClickTableColumn_) {
                    widget.tableView_didClickTableColumn(id2, sel, arg0, arg1);
                } else if (sel == OS.sel_outlineView_didClickTableColumn_) {
                    widget.outlineView_didClickTableColumn(id2, sel, arg0, arg1);
                } else {
                    if (sel == OS.sel_shouldChangeTextInRange_replacementString_) {
                        return widget.shouldChangeTextInRange_replacementString(id2, sel, arg0, arg1) ? 1L : 0L;
                    }
                    if (sel == OS.sel_canDragRowsWithIndexes_atPoint_) {
                        NSPoint clickPoint = new NSPoint();
                        OS.memmove(clickPoint, arg1, (long)NSPoint.sizeof);
                        return widget.canDragRowsWithIndexes_atPoint(id2, sel, arg0, clickPoint) ? 1L : 0L;
                    }
                    if (sel == OS.sel_expandItem_expandChildren_) {
                        widget.expandItem_expandChildren(id2, sel, arg0, arg1 != 0L);
                    } else if (sel == OS.sel_collapseItem_collapseChildren_) {
                        widget.collapseItem_collapseChildren(id2, sel, arg0, arg1 != 0L);
                    } else {
                        if (sel == OS.sel_expansionFrameWithFrame_inView_) {
                            NSRect rect = new NSRect();
                            OS.memmove(rect, arg0, (long)NSRect.sizeof);
                            rect = widget.expansionFrameWithFrame_inView(id2, sel, rect, arg1);
                            long result = OS.malloc(NSRect.sizeof);
                            OS.memmove(result, rect, (long)NSRect.sizeof);
                            return result;
                        }
                        if (sel == OS.sel_drawLabel_inRect_) {
                            NSRect rect = new NSRect();
                            OS.memmove(rect, arg1, (long)NSRect.sizeof);
                            widget.drawLabelInRect(id2, sel, arg0 == 1L, rect);
                        } else if (sel == OS.sel_scrollClipView_toPoint_) {
                            NSPoint point = new NSPoint();
                            OS.memmove(point, arg1, (long)NSPoint.sizeof);
                            widget.scrollClipViewToPoint(id2, sel, arg0, point);
                        } else if (sel == OS.sel_accessibilitySetValue_forAttribute_) {
                            widget.accessibilitySetValue_forAttribute(id2, sel, arg0, arg1);
                        } else {
                            if (sel == OS.sel_validRequestorForSendType_returnType_) {
                                return widget.validRequestorForSendType(id2, sel, arg0, arg1);
                            }
                            if (sel == OS.sel_writeSelectionToPasteboard_types_) {
                                return widget.writeSelectionToPasteboard(id2, sel, arg0, arg1) ? 1 : 0;
                            }
                            if (sel == OS.sel_outlineView_shouldExpandItem_) {
                                return widget.outlineView_shouldExpandItem_item(id2, sel, arg0, arg1) ? 1 : 0;
                            }
                            if (sel == OS.sel_selectRowIndexes_byExtendingSelection_) {
                                widget.selectRowIndexes_byExtendingSelection(id2, sel, arg0, arg1 != 0L);
                            }
                        }
                    }
                }
            }
        }
        return 0L;
    }

    static long windowProc(long id2, long sel, long arg0, long arg1, long arg2) {
        Widget widget = Display.LookupWidget(id2, sel);
        if (widget == null) {
            return 0L;
        }
        if (sel == OS.sel_tableView_objectValueForTableColumn_row_) {
            return widget.tableView_objectValueForTableColumn_row(id2, sel, arg0, arg1, arg2);
        }
        if (sel == OS.sel_tableView_shouldReorderColumn_toColumn_) {
            return widget.tableView_shouldReorderColumn_toColumn(id2, sel, arg0, arg1, arg2) ? 1L : 0L;
        }
        if (sel == OS.sel_tableView_shouldEditTableColumn_row_) {
            return widget.tableView_shouldEditTableColumn_row(id2, sel, arg0, arg1, arg2) ? 1L : 0L;
        }
        if (sel == OS.sel_outlineView_shouldReorderColumn_toColumn_) {
            return widget.outlineView_shouldReorderColumn_toColumn(id2, sel, arg0, arg1, arg2) ? 1L : 0L;
        }
        if (sel == OS.sel_outlineView_shouldEditTableColumn_item_) {
            return widget.outlineView_shouldEditTableColumn_row(id2, sel, arg0, arg1, arg2) ? 1L : 0L;
        }
        if (sel == OS.sel_textView_clickedOnLink_atIndex_) {
            return widget.textView_clickOnLink_atIndex(id2, sel, arg0, arg1, arg2) ? 1L : 0L;
        }
        if (sel == OS.sel_outlineView_child_ofItem_) {
            return widget.outlineView_child_ofItem(id2, sel, arg0, arg1, arg2);
        }
        if (sel == OS.sel_outlineView_objectValueForTableColumn_byItem_) {
            return widget.outlineView_objectValueForTableColumn_byItem(id2, sel, arg0, arg1, arg2);
        }
        if (sel == OS.sel_textView_willChangeSelectionFromCharacterRange_toCharacterRange_) {
            NSRange range = widget.textView_willChangeSelectionFromCharacterRange_toCharacterRange(id2, sel, arg0, arg1, arg2);
            long result = OS.malloc(NSRange.sizeof);
            OS.memmove(result, range, (long)NSRange.sizeof);
            return result;
        }
        if (sel == OS.sel_dragSelectionWithEvent_offset_slideBack_) {
            NSSize offset = new NSSize();
            OS.memmove(offset, arg0, (long)NSSize.sizeof);
            return widget.dragSelectionWithEvent(id2, sel, arg0, arg1, arg2) ? 1 : 0;
        }
        if (sel == OS.sel_drawImage_withFrame_inView_) {
            NSRect rect = new NSRect();
            OS.memmove(rect, arg1, (long)NSRect.sizeof);
            widget.drawImageWithFrameInView(id2, sel, arg0, rect, arg2);
        } else {
            if (sel == OS.sel_drawTitle_withFrame_inView_) {
                NSRect rect = new NSRect();
                OS.memmove(rect, arg1, (long)NSRect.sizeof);
                rect = widget.drawTitleWithFrameInView(id2, sel, arg0, rect, arg2);
                long result = OS.malloc(NSRect.sizeof);
                OS.memmove(result, rect, (long)NSRect.sizeof);
                return result;
            }
            if (sel == OS.sel_hitTestForEvent_inRect_ofView_) {
                NSRect rect = new NSRect();
                OS.memmove(rect, arg1, (long)NSRect.sizeof);
                return widget.hitTestForEvent(id2, sel, arg0, rect, arg2);
            }
            if (sel == OS.sel_tableView_writeRowsWithIndexes_toPasteboard_) {
                return widget.tableView_writeRowsWithIndexes_toPasteboard(id2, sel, arg0, arg1, arg2) ? 1 : 0;
            }
            if (sel == OS.sel_outlineView_writeItems_toPasteboard_) {
                return widget.outlineView_writeItems_toPasteboard(id2, sel, arg0, arg1, arg2) ? 1 : 0;
            }
            if (sel == OS.sel_toolbar_itemForItemIdentifier_willBeInsertedIntoToolbar_) {
                return widget.toolbar_itemForItemIdentifier_willBeInsertedIntoToolbar(id2, sel, arg0, arg1, arg2 != 0L);
            }
        }
        return 0L;
    }

    static long windowProc(long id2, long sel, long arg0, long arg1, long arg2, long arg3) {
        Widget widget = Display.LookupWidget(id2, sel);
        if (widget == null) {
            return 0L;
        }
        if (sel == OS.sel_tableView_willDisplayCell_forTableColumn_row_) {
            widget.tableView_willDisplayCell_forTableColumn_row(id2, sel, arg0, arg1, arg2, arg3);
        } else if (sel == OS.sel_outlineView_willDisplayCell_forTableColumn_item_) {
            widget.outlineView_willDisplayCell_forTableColumn_item(id2, sel, arg0, arg1, arg2, arg3);
        } else if (sel == OS.sel_outlineView_setObjectValue_forTableColumn_byItem_) {
            widget.outlineView_setObjectValue_forTableColumn_byItem(id2, sel, arg0, arg1, arg2, arg3);
        } else if (sel == OS.sel_tableView_setObjectValue_forTableColumn_row_) {
            widget.tableView_setObjectValue_forTableColumn_row(id2, sel, arg0, arg1, arg2, arg3);
        } else {
            if (sel == OS.sel_view_stringForToolTip_point_userData_) {
                return widget.view_stringForToolTip_point_userData(id2, sel, arg0, arg1, arg2, arg3);
            }
            if (sel == OS.sel_tableView_shouldTrackCell_forTableColumn_row_) {
                return widget.tableView_shouldTrackCell_forTableColumn_row(id2, sel, arg0, arg1, arg2, arg3) ? 1L : 0L;
            }
            if (sel == OS.sel_outlineView_shouldTrackCell_forTableColumn_item_) {
                return widget.outlineView_shouldTrackCell_forTableColumn_item(id2, sel, arg0, arg1, arg2, arg3) ? 1L : 0L;
            }
        }
        return 0L;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        KeyTable = new int[][]{{58, 65536}, {56, 131072}, {59, 262144}, {55, 0x400000}, {61, 65536}, {62, 262144}, {60, 131072}, {54, 0x400000}, {126, 0x1000001}, {125, 0x1000002}, {123, 0x1000003}, {124, 0x1000004}, {116, 0x1000005}, {121, 0x1000006}, {115, 0x1000007}, {119, 0x1000008}, {51, 8}, {36, 13}, {117, 127}, {53, 27}, {76, 10}, {48, 9}, {122, 0x100000A}, {120, 0x100000B}, {99, 0x100000C}, {118, 0x100000D}, {96, 0x100000E}, {97, 0x100000F}, {98, 0x1000010}, {100, 0x1000011}, {101, 0x1000012}, {109, 0x1000013}, {103, 0x1000014}, {111, 0x1000015}, {105, 0x1000016}, {107, 0x1000017}, {113, 0x1000018}, {106, 0x1000019}, {64, 0x100001A}, {79, 0x100001B}, {80, 0x100001C}, {67, 16777258}, {69, 16777259}, {76, 0x1000050}, {78, 16777261}, {65, 16777262}, {75, 16777263}, {82, 0x1000030}, {83, 0x1000031}, {84, 16777266}, {85, 0x1000033}, {86, 16777268}, {87, 16777269}, {88, 16777270}, {89, 16777271}, {91, 16777272}, {92, 16777273}, {81, 16777277}, {57, 16777298}, {71, 16777299}, {114, 0x1000051}};
        APP_VERSION = "";
        SWT_OBJECT = new byte[]{83, 87, 84, 95, 79, 66, 74, 69, 67, 84, 0};
        SWT_EMBED_FRAMES = new byte[]{83, 87, 84, 95, 69, 77, 66, 69, 68, 95, 70, 82, 65, 77, 69, 83, 0};
        SWT_IMAGE = new byte[]{83, 87, 84, 95, 73, 77, 65, 71, 69, 0};
        SWT_ROW = new byte[]{83, 87, 84, 95, 82, 79, 87, 0};
        SWT_COLUMN = new byte[]{83, 87, 84, 95, 67, 79, 76, 85, 77, 78, 0};
        Displays = new Display[4];
        DeviceFinder = new Runnable(){

            public void run() {
                Display device = Display.getCurrent();
                if (device == null) {
                    device = Display.getDefault();
                }
                Display.setDevice(device);
            }
        };
    }
}

