/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.xfer;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.internal.server.core.IWebResourceDecorator;
import org.eclipse.orion.internal.server.servlets.file.NewFileServlet;
import org.eclipse.orion.server.core.LogHelper;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TransferResourceDecorator
implements IWebResourceDecorator {
    public void addAtributesFor(HttpServletRequest request, URI resource, JSONObject representation) {
        String servlet = request.getServletPath();
        if (!"/file".equals(servlet) && !"/workspace".equals(servlet)) {
            return;
        }
        try {
            JSONArray children;
            if ("/file".equals(servlet)) {
                this.addTransferLinks(request, resource, representation);
            }
            if ((children = representation.optJSONArray("Children")) != null) {
                int i = 0;
                while (i < children.length()) {
                    JSONObject child = children.getJSONObject(i);
                    if (child.getBoolean("Directory")) {
                        this.addTransferLinks(request, resource, child);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            LogHelper.log((Throwable)e);
        }
    }

    private void addTransferLinks(HttpServletRequest request, URI resource, JSONObject representation) throws URISyntaxException, JSONException, UnsupportedEncodingException {
        String linkString;
        URI location = new URI(representation.getString("Location"));
        IPath targetPath = new Path(location.getPath()).removeFirstSegments(1).removeTrailingSeparator();
        IPath path = new Path("/xfer/import").append(targetPath);
        URI link = new URI(resource.getScheme(), resource.getAuthority(), path.toString(), null, null);
        if (representation.has("excludedInImport")) {
            linkString = link.toString();
            linkString = linkString.contains("?") ? String.valueOf(linkString) + "&exclude=" + URLEncoder.encode(representation.getString("excludedInImport"), "UTF-8") : String.valueOf(linkString) + "?exclude=" + URLEncoder.encode(representation.getString("excludedInImport"), "UTF-8");
            link = new URI(linkString);
            representation.remove("excludedInImport");
        }
        representation.put("ImportLocation", (Object)link);
        if (this.isEmptyDirectory(request, targetPath)) {
            return;
        }
        path = new Path("/xfer/export").append(targetPath).addFileExtension("zip");
        link = new URI(resource.getScheme(), resource.getAuthority(), path.toString(), null, null);
        if (representation.has("excludedInExport")) {
            linkString = link.toString();
            linkString = linkString.contains("?") ? String.valueOf(linkString) + "&exclude=" + URLEncoder.encode(representation.getString("excludedInExport"), "UTF-8") : String.valueOf(linkString) + "?exclude=" + URLEncoder.encode(representation.getString("excludedInExport"), "UTF-8");
            link = new URI(linkString);
            representation.remove("excludedInExport");
        }
        representation.put("ExportLocation", (Object)link);
    }

    private boolean isEmptyDirectory(HttpServletRequest request, IPath targetPath) {
        IFileStore store = NewFileServlet.getFileStore(request, targetPath);
        if (store == null) {
            return false;
        }
        try {
            return store.childNames(0, null).length == 0;
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

