/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.workspace.authorization;

import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationReader;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationService;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.metastore.UserInfo;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AuthorizationReaderV1
extends AuthorizationReader {
    JSONArray readAuthorizationInfo(UserInfo user) throws JSONException {
        JSONArray newPermissions = new JSONArray();
        this.addPermission(newPermissions, "/users/" + user.getUniqueId());
        try {
            for (String workspaceId : user.getWorkspaceIds()) {
                this.addPermission(newPermissions, "/workspace/" + workspaceId);
                this.addPermission(newPermissions, "/workspace/" + workspaceId + "/*");
                this.addPermission(newPermissions, "/file/" + workspaceId);
                this.addPermission(newPermissions, "/file/" + workspaceId + "/*");
            }
        }
        catch (JSONException e) {
            LogHelper.log((Throwable)e);
        }
        return newPermissions;
    }

    private void addPermission(JSONArray permissions, String uri) throws JSONException {
        JSONObject newPermission = AuthorizationService.createUserRight(uri);
        permissions.put((Object)newPermission);
    }
}

