/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.core.resources;

import java.lang.reflect.Method;
import org.eclipse.core.runtime.Assert;
import org.eclipse.orion.server.core.resources.Property;
import org.eclipse.orion.server.core.resources.ReflectionHelper;
import org.eclipse.orion.server.core.resources.ResourceShape;
import org.eclipse.orion.server.core.resources.Serializer;
import org.eclipse.orion.server.core.resources.annotations.PropertyDescription;
import org.eclipse.orion.server.core.resources.annotations.ResourceDescription;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONSerializer
implements Serializer<JSONObject> {
    @Override
    public JSONObject serialize(Object resource, ResourceShape resourceShape) {
        JSONObject result = new JSONObject();
        try {
            Property[] propertyArray = resourceShape.getProperties();
            int n = propertyArray.length;
            int n2 = 0;
            while (n2 < n) {
                Property property = propertyArray[n2];
                Method getter = ReflectionHelper.findGetterForPropertyName(resource.getClass(), property.getName());
                Object value = ReflectionHelper.callGetter(resource, getter);
                PropertyDescription propertyDescriptionAnnotation = ReflectionHelper.getAnnotation(getter, PropertyDescription.class);
                if (propertyDescriptionAnnotation.expandable()) {
                    ResourceShape nestedResourceShape = property.getResourceShape();
                    Assert.isNotNull((Object)nestedResourceShape, (String)("Could not find resource shape definition for: " + property.getName()));
                    result.put(property.getName(), (Object)this.serialize(value, nestedResourceShape));
                } else {
                    result.put(property.getName(), value);
                }
                ++n2;
            }
            ResourceDescription resourceShapeDescription = resource.getClass().getAnnotation(ResourceDescription.class);
            result.put("Type", (Object)resourceShapeDescription.type());
        }
        catch (JSONException jSONException) {}
        return result;
    }
}

