/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.discovery.html;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.html.dom.HTMLDocumentImpl;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.html.HtmlParser;
import org.openid4java.discovery.html.HtmlResult;
import org.openid4java.util.OpenID4JavaDOMParser;
import org.w3c.dom.NodeList;
import org.w3c.dom.html.HTMLHeadElement;
import org.w3c.dom.html.HTMLLinkElement;

public class CyberNekoDOMHtmlParser
implements HtmlParser {
    private static final Log _log = LogFactory.getLog(CyberNekoDOMHtmlParser.class);
    private static final boolean DEBUG = _log.isDebugEnabled();

    public void parseHtml(String htmlData, HtmlResult result) throws DiscoveryException {
        HTMLDocumentImpl doc;
        NodeList heads;
        if (DEBUG) {
            _log.debug((Object)("Parsing HTML data:\n" + htmlData));
        }
        if ((heads = (doc = this.parseDocument(htmlData)).getElementsByTagName("head")).getLength() != 1) {
            throw new DiscoveryException("HTML response must have exactly one HEAD element, found " + heads.getLength() + " : " + heads.toString(), 1539);
        }
        HTMLHeadElement head = (HTMLHeadElement)doc.getHead();
        NodeList linkElements = head.getElementsByTagName("LINK");
        int len = linkElements.getLength();
        for (int i = 0; i < len; ++i) {
            HTMLLinkElement linkElement = (HTMLLinkElement)linkElements.item(i);
            this.setResult(linkElement.getRel(), linkElement.getHref(), result);
        }
        if (DEBUG) {
            _log.debug((Object)("HTML discovery result:\n" + result));
        }
    }

    private HTMLDocumentImpl parseDocument(String htmlData) throws DiscoveryException {
        OpenID4JavaDOMParser parser = new OpenID4JavaDOMParser();
        try {
            parser.parse(OpenID4JavaDOMParser.createInputSource(htmlData));
        }
        catch (Exception e) {
            throw new DiscoveryException("Error parsing HTML message", 1539, e);
        }
        if (parser.isIgnoredHeadStartElement()) {
            throw new DiscoveryException("HTML response must have exactly one HEAD element.", 1539);
        }
        return (HTMLDocumentImpl)parser.getDocument();
    }

    private void setResult(String rel, String href, HtmlResult result) throws DiscoveryException {
        List<String> relations = Arrays.asList(rel.split(" "));
        if (relations.contains("openid.server")) {
            if (result.getOP1Endpoint() != null) {
                throw new DiscoveryException("More than one openid.server entries found", 1539);
            }
            if (DEBUG) {
                _log.debug((Object)("Found OpenID1 endpoint: " + href));
            }
            result.setEndpoint1(href);
        }
        if (relations.contains("openid.delegate")) {
            if (result.getDelegate1() != null) {
                throw new DiscoveryException("More than one openid.delegate entries found", 1539);
            }
            if (DEBUG) {
                _log.debug((Object)("Found OpenID1 delegate: " + href));
            }
            result.setDelegate1(href);
        }
        if (relations.contains("openid2.provider")) {
            if (result.getOP2Endpoint() != null) {
                throw new DiscoveryException("More than one openid.server entries found", 1539);
            }
            if (DEBUG) {
                _log.debug((Object)("Found OpenID2 endpoint: " + href));
            }
            result.setEndpoint2(href);
        }
        if (relations.contains("openid2.local_id")) {
            if (result.getDelegate2() != null) {
                throw new DiscoveryException("More than one openid2.local_id entries found", 1539);
            }
            if (DEBUG) {
                _log.debug((Object)("Found OpenID2 localID: " + href));
            }
            result.setDelegate2(href);
        }
    }
}

