/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.jobs;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.metastore.ProjectInfo;
import org.eclipse.orion.server.git.GitCredentialsProvider;
import org.eclipse.orion.server.git.jobs.GitJob;
import org.eclipse.orion.server.git.objects.Clone;
import org.eclipse.orion.server.git.servlets.GitCloneHandlerV1;
import org.json.JSONException;
import org.json.JSONObject;

public class CloneJob
extends GitJob {
    private final ProjectInfo project;
    private final Clone clone;
    private final String user;
    private final String gitUserName;
    private final String gitUserMail;
    private String cloneLocation;

    public CloneJob(Clone clone, String userRunningTask, CredentialsProvider credentials, String user, String cloneLocation, ProjectInfo project, String gitUserName, String gitUserMail) {
        super(userRunningTask, true, (GitCredentialsProvider)credentials);
        this.clone = clone;
        this.user = user;
        this.project = project;
        this.gitUserName = gitUserName;
        this.gitUserMail = gitUserMail;
        this.cloneLocation = cloneLocation;
        this.setFinalMessage("Clone complete.");
        this.setTaskExpirationTime(TimeUnit.DAYS.toMillis(7L));
    }

    private IStatus doClone() {
        try {
            File cloneFolder = new File(this.clone.getContentLocation().getPath());
            if (!cloneFolder.exists()) {
                cloneFolder.mkdir();
            }
            CloneCommand cc = Git.cloneRepository();
            cc.setBare(false);
            cc.setCredentialsProvider((CredentialsProvider)this.credentials);
            cc.setDirectory(cloneFolder);
            cc.setRemote("origin");
            cc.setURI(this.clone.getUrl());
            Git git = cc.call();
            GitCloneHandlerV1.doConfigureClone(git, this.user, this.gitUserName, this.gitUserMail);
            git.getRepository().close();
        }
        catch (IOException e) {
            return new Status(4, "org.eclipse.orion.server.git", "Error cloning git repository", (Throwable)e);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        catch (GitAPIException e) {
            return this.getGitAPIExceptionStatus(e, "Error cloning git repository");
        }
        catch (JGitInternalException e) {
            return this.getJGitInternalExceptionStatus(e, "Error cloning git repository");
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.orion.server.git", "Error cloning git repository", (Throwable)e);
        }
        JSONObject jsonData = new JSONObject();
        try {
            jsonData.put("Location", (Object)URI.create(this.cloneLocation));
        }
        catch (JSONException jSONException) {}
        return new ServerStatus(Status.OK_STATUS, 200, jsonData);
    }

    protected IStatus performJob() {
        IStatus result = this.doClone();
        if (result.isOK()) {
            return result;
        }
        try {
            if (this.project != null) {
                GitCloneHandlerV1.removeProject(this.user, this.project);
            } else {
                FileUtils.delete((File)URIUtil.toFile((URI)this.clone.getContentLocation()), (int)1);
            }
        }
        catch (IOException e) {
            String msg = "An error occured when cleaning up after a clone failure";
            result = new ServerStatus(4, 500, msg, (Throwable)e);
        }
        return result;
    }
}

