/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.jobs;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.orion.server.git.GitCredentialsProvider;
import org.eclipse.orion.server.git.jobs.GitJob;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.eclipse.osgi.util.NLS;

public class PushJob
extends GitJob {
    private Path path;
    private String remote;
    private String branch;
    private String srcRef;
    private boolean tags;
    private boolean force;

    public PushJob(String userRunningTask, CredentialsProvider credentials, Path path, String srcRef, boolean tags, boolean force) {
        super(userRunningTask, true, (GitCredentialsProvider)credentials);
        this.path = path;
        this.remote = path.segment(0);
        this.branch = GitUtils.decode(path.segment(1));
        this.srcRef = srcRef;
        this.tags = tags;
        this.force = force;
        this.setFinalMessage(NLS.bind((String)"Pushing {0} done", (Object)path.segment(0)));
        this.setTaskExpirationTime(TimeUnit.DAYS.toMillis(7L));
    }

    private IStatus doPush() throws IOException, CoreException, URISyntaxException, GitAPIException {
        File gitDir = GitUtils.getGitDir(this.path.removeFirstSegments(2));
        Repository db = FileRepositoryBuilder.create((File)gitDir);
        Git git = new Git(db);
        PushCommand pushCommand = git.push();
        RemoteConfig remoteConfig = new RemoteConfig((Config)git.getRepository().getConfig(), this.remote);
        this.credentials.setUri((URIish)remoteConfig.getURIs().get(0));
        pushCommand.setCredentialsProvider((CredentialsProvider)this.credentials);
        RefSpec spec = new RefSpec(String.valueOf(this.srcRef) + ':' + "refs/heads/" + this.branch);
        pushCommand.setRemote(this.remote).setRefSpecs(new RefSpec[]{spec});
        if (this.tags) {
            pushCommand.setPushTags();
        }
        pushCommand.setForce(this.force);
        Iterable resultIterable = pushCommand.call();
        PushResult pushResult = (PushResult)resultIterable.iterator().next();
        HashSet<RemoteRefUpdate.Status> statusSet = new HashSet<RemoteRefUpdate.Status>();
        for (RemoteRefUpdate rru : pushResult.getRemoteUpdates()) {
            String rm = rru.getRemoteName();
            if (!this.branch.equals(Repository.shortenRefName((String)rm)) && !rm.startsWith("refs/tags/")) continue;
            RemoteRefUpdate.Status status = rru.getStatus();
            if (status != RemoteRefUpdate.Status.OK && status != RemoteRefUpdate.Status.UP_TO_DATE) {
                return new Status(2, "org.eclipse.orion.server.git", status.name(), new Throwable(rru.getMessage()));
            }
            statusSet.add(status);
        }
        if (statusSet.contains(RemoteRefUpdate.Status.OK)) {
            return Status.OK_STATUS;
        }
        return new Status(2, "org.eclipse.orion.server.git", RemoteRefUpdate.Status.UP_TO_DATE.name());
    }

    protected IStatus performJob() {
        IStatus result = Status.OK_STATUS;
        try {
            result = this.doPush();
        }
        catch (IOException e) {
            result = new Status(4, "org.eclipse.orion.server.git", "Error pushing git remote", (Throwable)e);
        }
        catch (CoreException e) {
            result = e.getStatus();
        }
        catch (InvalidRemoteException e) {
            result = new Status(4, "org.eclipse.orion.server.git", "Error pushing git remote", (Throwable)e);
        }
        catch (GitAPIException e) {
            result = this.getGitAPIExceptionStatus(e, "Error pushing git remote");
        }
        catch (JGitInternalException e) {
            result = this.getJGitInternalExceptionStatus(e, "Error pushing git remote");
        }
        catch (Exception e) {
            result = new Status(4, "org.eclipse.orion.server.git", "Error pushing git repository", (Throwable)e);
        }
        return result;
    }
}

