/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.servlets;

import java.io.IOException;
import java.net.URI;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.api.BlameCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.blame.BlameResult;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.git.BaseToCloneConverter;
import org.eclipse.orion.server.git.objects.Blame;
import org.eclipse.orion.server.git.servlets.AbstractGitHandler;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.osgi.util.NLS;

public class GitBlameHandlerV1
extends AbstractGitHandler {
    GitBlameHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        super(statusHandler);
    }

    @Override
    protected boolean handleGet(AbstractGitHandler.RequestInfo requestInfo) throws ServletException {
        HttpServletRequest request = requestInfo.request;
        HttpServletResponse response = requestInfo.response;
        try {
            URI cloneLocation = BaseToCloneConverter.getCloneLocation(GitBlameHandlerV1.getURI((HttpServletRequest)request), BaseToCloneConverter.BLAME);
            Path Filepath = new Path(requestInfo.filePath.toString());
            if (Filepath.hasTrailingSeparator()) {
                String msg = NLS.bind((String)"Cannot get blame Information on a folder: {0}", (Object)requestInfo.filePath.toString());
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, msg, null));
            }
            Blame blame = new Blame(cloneLocation, requestInfo.db);
            String gitSegment = requestInfo.gitSegment;
            if (!gitSegment.equalsIgnoreCase("HEAD") && !gitSegment.equalsIgnoreCase("master")) {
                ObjectId id = ObjectId.fromString((String)requestInfo.gitSegment);
                blame.setStartCommit(id);
            }
            String path = requestInfo.relativePath;
            blame.setFilePath(path);
            blame.setBlameLocation(GitBlameHandlerV1.getURI((HttpServletRequest)request));
            this.doBlame(blame, requestInfo.db);
            OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)blame.toJSON());
            return true;
        }
        catch (Exception e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "Error generating blame response", (Throwable)e));
        }
    }

    public void doBlame(Blame blame, Repository db) throws GitAPIException, IOException {
        String filePath = blame.getFilePath();
        if (db != null && filePath != null) {
            BlameResult result;
            BlameCommand blameCommand = new BlameCommand(db);
            blameCommand.setFilePath(filePath);
            blameCommand.setFollowFileRenames(true);
            blameCommand.setTextComparator(RawTextComparator.WS_IGNORE_ALL);
            if (blame.getStartCommit() != null) {
                blameCommand.setStartCommit((AnyObjectId)blame.getStartCommit());
            }
            try {
                result = blameCommand.call();
            }
            catch (Exception exception) {
                return;
            }
            if (result != null) {
                blame.clearLines();
                RevCommit prevCommit = null;
                String prevPath = null;
                int i = 0;
                while (i < result.getResultContents().size()) {
                    String path;
                    RevCommit commit;
                    try {
                        prevCommit = commit = result.getSourceCommit(i);
                    }
                    catch (NullPointerException nullPointerException) {
                        commit = prevCommit;
                    }
                    if (!blame.commitExists(commit) && commit != null) {
                        blame.addCommit(commit);
                    }
                    try {
                        prevPath = path = commit.getId().getName();
                    }
                    catch (NullPointerException nullPointerException) {
                        path = prevPath;
                    }
                    blame.addLine(path);
                    ++i;
                }
            }
        }
    }
}

