/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.internal.server.core.IWebResourceDecorator;
import org.eclipse.orion.internal.server.core.metastore.SimpleMetaStore;
import org.eclipse.orion.internal.server.servlets.hosting.ISiteHostingService;
import org.eclipse.orion.internal.server.servlets.project.ProjectDecorator;
import org.eclipse.orion.internal.server.servlets.workspace.CompatibilityMetaStore;
import org.eclipse.orion.internal.server.servlets.workspace.ProjectParentDecorator;
import org.eclipse.orion.internal.server.servlets.xfer.TransferResourceDecorator;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.core.metastore.IMetaStore;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
implements BundleActivator {
    public static volatile BundleContext bundleContext;
    public static final boolean DEBUG = true;
    public static final String LOCATION_FILE_SERVLET = "/file";
    public static final String LOCATION_WORKSPACE_SERVLET = "/workspace";
    public static final String PI_SERVER_SERVLETS = "org.eclipse.orion.server.servlets";
    public static final String PROP_USER_AREA = "org.eclipse.orion.server.core.userArea";
    static Activator singleton;
    private Map<String, URI> aliases = Collections.synchronizedMap(new HashMap());
    private ServiceTracker<IWebResourceDecorator, IWebResourceDecorator> decoratorTracker;
    private ServiceTracker<ISiteHostingService, ISiteHostingService> siteHostingTracker;
    private ServiceRegistration<IWebResourceDecorator> transferDecoratorRegistration;
    private ServiceRegistration<IWebResourceDecorator> parentDecoratorRegistration;
    private ServiceRegistration<IWebResourceDecorator> projectDecoratorRegistration;
    private ServiceRegistration<IMetaStore> metastoreRegistration;

    public static Activator getDefault() {
        return singleton;
    }

    public BundleContext getContext() {
        return bundleContext;
    }

    private synchronized ServiceTracker<IWebResourceDecorator, IWebResourceDecorator> getDecoratorTracker() {
        if (this.decoratorTracker == null) {
            this.decoratorTracker = new ServiceTracker(bundleContext, IWebResourceDecorator.class, null);
            this.decoratorTracker.open();
        }
        return this.decoratorTracker;
    }

    private synchronized ServiceTracker<ISiteHostingService, ISiteHostingService> getSiteHostingTracker() {
        if (this.siteHostingTracker == null) {
            this.siteHostingTracker = new ServiceTracker(bundleContext, ISiteHostingService.class, null);
            this.siteHostingTracker.open();
        }
        return this.siteHostingTracker;
    }

    public Collection<IWebResourceDecorator> getWebResourceDecorators() {
        ServiceTracker<IWebResourceDecorator, IWebResourceDecorator> tracker = this.getDecoratorTracker();
        return tracker.getTracked().values();
    }

    public ISiteHostingService getSiteHostingService() {
        ServiceTracker<ISiteHostingService, ISiteHostingService> tracker = this.getSiteHostingTracker();
        Collection hostingServices = tracker.getTracked().values();
        return hostingServices.size() == 0 ? null : (ISiteHostingService)hostingServices.iterator().next();
    }

    private void initializeFileSystem() {
        IFileStore rootStore = OrionConfiguration.getUserHome(null);
        try {
            rootStore.mkdir(0, null);
        }
        catch (CoreException e) {
            throw new RuntimeException("Instance location is read only: " + rootStore, e);
        }
        if (System.getProperty(PROP_USER_AREA) == null) {
            System.setProperty(PROP_USER_AREA, rootStore.getFileStore((IPath)new Path(".metadata/.plugins/org.eclipse.orion.server.core/userArea")).toString());
        }
    }

    private void initializeMetaStore() {
        String metastore = PreferenceHelper.getString((String)"orion.core.metastore", (String)"legacy").toLowerCase();
        if ("simple".equals(metastore)) {
            try {
                this.metastoreRegistration = bundleContext.registerService(IMetaStore.class, (Object)new SimpleMetaStore(OrionConfiguration.getUserHome(null).toLocalFile(0, null)), null);
            }
            catch (CoreException e) {
                throw new RuntimeException("Cannot initialize MetaStore", e);
            }
        } else {
            this.metastoreRegistration = bundleContext.registerService(IMetaStore.class, (Object)new CompatibilityMetaStore(), null);
        }
    }

    private void registerServices() {
        this.transferDecoratorRegistration = bundleContext.registerService(IWebResourceDecorator.class, (Object)new TransferResourceDecorator(), null);
        this.parentDecoratorRegistration = bundleContext.registerService(IWebResourceDecorator.class, (Object)new ProjectParentDecorator(), null);
        this.projectDecoratorRegistration = bundleContext.registerService(IWebResourceDecorator.class, (Object)new ProjectDecorator(), null);
    }

    public void start(BundleContext context) throws Exception {
        singleton = this;
        bundleContext = context;
        this.initializeMetaStore();
        this.initializeFileSystem();
        this.registerServices();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.decoratorTracker != null) {
            this.decoratorTracker.close();
            this.decoratorTracker = null;
        }
        if (this.siteHostingTracker != null) {
            this.siteHostingTracker.close();
            this.siteHostingTracker = null;
        }
        this.unregisterServices();
        bundleContext = null;
    }

    public void unregisterAlias(String alias) {
        this.aliases.remove(alias);
    }

    private void unregisterServices() {
        if (this.transferDecoratorRegistration != null) {
            this.transferDecoratorRegistration.unregister();
            this.transferDecoratorRegistration = null;
        }
        if (this.parentDecoratorRegistration != null) {
            this.parentDecoratorRegistration.unregister();
            this.parentDecoratorRegistration = null;
        }
        if (this.projectDecoratorRegistration != null) {
            this.projectDecoratorRegistration.unregister();
            this.projectDecoratorRegistration = null;
        }
        if (this.metastoreRegistration != null) {
            this.metastoreRegistration.unregister();
            this.metastoreRegistration = null;
        }
    }
}

