/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.file;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.internal.server.core.metastore.SimpleMetaStore;
import org.eclipse.orion.internal.server.core.metastore.SimpleMetaStoreUtil;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.file.ServletFileStoreHandler;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.metastore.ProjectInfo;
import org.eclipse.orion.server.core.metastore.WorkspaceInfo;
import org.eclipse.orion.server.core.resources.Base64;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.osgi.util.NLS;

public class NewFileServlet
extends OrionServlet {
    private static final long serialVersionUID = 1L;
    private ServletResourceHandler<IFileStore> fileSerializer;

    public void init() throws ServletException {
        super.init();
        this.fileSerializer = new ServletFileStoreHandler(this.getStatusHandler(), this.getServletContext());
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        IFileStore file;
        Path path;
        this.traceRequest(req);
        String pathInfo = req.getPathInfo();
        Path path2 = path = pathInfo == null ? Path.ROOT : new Path(pathInfo);
        if (!pathInfo.equals(path.toString())) {
            this.handleException(resp, (IStatus)new ServerStatus(4, 403, NLS.bind((String)"Forbidden: {0}", (Object)pathInfo), null));
            return;
        }
        if (path.segmentCount() > 0 && ".metadata".equals(path.segment(0))) {
            this.handleException(resp, (IStatus)new ServerStatus(4, 403, NLS.bind((String)"Forbidden: {0}", (Object)pathInfo), null));
            return;
        }
        IFileStore testLink = file = NewFileServlet.getFileStore(req, (IPath)path);
        while (testLink != null) {
            IFileInfo info = testLink.fetchInfo();
            if (info.getAttribute(32)) {
                if (file == testLink) {
                    this.handleException(resp, (IStatus)new ServerStatus(4, 403, NLS.bind((String)"Forbidden: {0}", (Object)pathInfo), null));
                } else {
                    this.handleException(resp, (IStatus)new ServerStatus(4, 404, NLS.bind((String)"File not found: {0}", (Object)pathInfo), null));
                }
                return;
            }
            testLink = testLink.getParent();
        }
        if (file == null) {
            this.handleException(resp, (IStatus)new ServerStatus(4, 404, NLS.bind((String)"File not found: {0}", (Object)pathInfo), null));
            return;
        }
        if (this.fileSerializer.handleRequest(req, resp, file)) {
            return;
        }
        super.doGet(req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    public static IFileStore getFileStore(HttpServletRequest request, IPath path) {
        WorkspaceInfo workspace;
        block8: {
            WorkspaceInfo workspace2;
            block7: {
                try {
                    if (path.segmentCount() != 0) break block7;
                    return null;
                }
                catch (CoreException e) {
                    LogHelper.log((IStatus)new Status(2, "org.eclipse.orion.server.servlets", 1, NLS.bind((String)"An error occurred when getting file store for path {0}", (Object)path), (Throwable)e));
                    return null;
                }
            }
            if (path.segmentCount() != 1) break block8;
            if (OrionConfiguration.getMetaStore() instanceof SimpleMetaStore && (workspace2 = OrionConfiguration.getMetaStore().readWorkspace(path.segment(0))) != null) {
                return NewFileServlet.getFileStore(request, workspace2);
            }
            return null;
        }
        ProjectInfo project = OrionConfiguration.getMetaStore().readProject(path.segment(0), path.segment(1));
        if (project != null) {
            return NewFileServlet.getFileStore(request, project).getFileStore(path.removeFirstSegments(2));
        }
        if (path.segmentCount() == 2 && OrionConfiguration.getMetaStore() instanceof SimpleMetaStore && (workspace = OrionConfiguration.getMetaStore().readWorkspace(path.segment(0))) != null) {
            return NewFileServlet.getFileStore(request, workspace).getChild(path.segment(1));
        }
        return null;
    }

    public static IFileStore getFileStore(HttpServletRequest request, WorkspaceInfo workspace) {
        if (OrionConfiguration.getMetaStore() instanceof SimpleMetaStore) {
            if (workspace.getUserId() == null) {
                return null;
            }
            IFileStore userHome = OrionConfiguration.getUserHome((String)workspace.getUserId());
            String encodedWorkspaceName = SimpleMetaStoreUtil.decodeWorkspaceNameFromWorkspaceId((String)workspace.getUniqueId());
            return userHome.getChild(encodedWorkspaceName);
        }
        return null;
    }

    public static IFileStore getFileStore(HttpServletRequest request, ProjectInfo project) throws CoreException {
        URI location = project.getContentLocation();
        if (location.isAbsolute()) {
            String base64;
            String authString;
            String authHead;
            if (request != null && !"file".equals(location.getScheme()) && location.getUserInfo() == null && (authHead = request.getHeader("Authorization")) != null && authHead.toUpperCase(Locale.ENGLISH).startsWith("BASIC") && (authString = new String(Base64.decode((byte[])(base64 = authHead.substring(6)).getBytes()))).length() > 0) {
                try {
                    location = new URI(location.getScheme(), authString, location.getHost(), location.getPort(), location.getPath(), location.getQuery(), location.getFragment());
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
            return EFS.getStore((URI)location);
        }
        Path localPath = new Path(location.getPath());
        if (localPath.isAbsolute()) {
            return EFS.getLocalFileSystem().getStore((IPath)localPath);
        }
        IFileStore root = OrionConfiguration.getUserHome((String)request.getRemoteUser());
        return root.getChild(location.toString());
    }
}

