/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.jobs;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.TrackingRefUpdate;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.orion.server.git.GitCredentialsProvider;
import org.eclipse.orion.server.git.jobs.GitJob;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.eclipse.osgi.util.NLS;

public class FetchJob
extends GitJob {
    private IPath path;
    private String remote;
    private boolean force;
    private String branch;

    public FetchJob(String userRunningTask, CredentialsProvider credentials, Path path, boolean force) {
        super(userRunningTask, true, (GitCredentialsProvider)credentials);
        this.path = path;
        this.remote = path.segment(0);
        this.force = force;
        this.branch = path.segment(1).equals("file") ? null : GitUtils.decode(path.segment(1));
        this.builtMessages();
        this.setTaskExpirationTime(TimeUnit.DAYS.toMillis(7L));
    }

    private void builtMessages() {
        String cloneName = this.path.lastSegment();
        if (this.branch == null) {
            Object[] bindings = new String[]{this.remote, cloneName};
            this.setName(NLS.bind((String)"Fetching {0} for {1}", (Object[])bindings));
            this.setFinalMessage(NLS.bind((String)"Fetching {0} for {1} done.", (Object[])bindings));
        } else {
            Object[] bindings = new String[]{this.remote, this.branch, cloneName};
            this.setName(NLS.bind((String)"Fetching {0}/{1} for {2}", (Object[])bindings));
            this.setFinalMessage(NLS.bind((String)"Fetching {0}/{1} for {2} done.", (Object[])bindings));
        }
    }

    private IStatus doFetch() throws IOException, CoreException, URISyntaxException, GitAPIException {
        Repository db = this.getRepository();
        Git git = new Git(db);
        FetchCommand fc = git.fetch();
        RemoteConfig remoteConfig = new RemoteConfig((Config)git.getRepository().getConfig(), this.remote);
        this.credentials.setUri((URIish)remoteConfig.getURIs().get(0));
        fc.setCredentialsProvider((CredentialsProvider)this.credentials);
        fc.setRemote(this.remote);
        if (this.branch != null) {
            RefSpec spec = new RefSpec("refs/heads/" + this.branch + ":" + "refs/remotes/" + this.remote + "/" + this.branch);
            spec = spec.setForceUpdate(this.force);
            fc.setRefSpecs(new RefSpec[]{spec});
        }
        FetchResult fetchResult = fc.call();
        return FetchJob.handleFetchResult(fetchResult);
    }

    static IStatus handleFetchResult(FetchResult fetchResult) {
        for (TrackingRefUpdate updateRes : fetchResult.getTrackingRefUpdates()) {
            RefUpdate.Result res = updateRes.getResult();
            switch (res) {
                case NOT_ATTEMPTED: 
                case NO_CHANGE: 
                case NEW: 
                case FORCED: 
                case FAST_FORWARD: 
                case RENAMED: {
                    break;
                }
                case REJECTED: {
                    return new Status(2, "org.eclipse.orion.server.git", "Fetch rejected, not a fast-forward.");
                }
                case REJECTED_CURRENT_BRANCH: {
                    return new Status(2, "org.eclipse.orion.server.git", "Rejected because trying to delete the current branch.");
                }
                default: {
                    return new Status(4, "org.eclipse.orion.server.git", res.name());
                }
            }
        }
        return Status.OK_STATUS;
    }

    private Repository getRepository() throws IOException, CoreException {
        IPath p = null;
        p = this.path.segment(1).equals("file") ? this.path.removeFirstSegments(1) : this.path.removeFirstSegments(2);
        return FileRepositoryBuilder.create((File)GitUtils.getGitDir(p));
    }

    protected IStatus performJob() {
        IStatus result = Status.OK_STATUS;
        try {
            result = this.doFetch();
        }
        catch (IOException e) {
            result = new Status(4, "org.eclipse.orion.server.git", "Error fetching git remote", (Throwable)e);
        }
        catch (CoreException e) {
            result = e.getStatus();
        }
        catch (InvalidRemoteException e) {
            result = new Status(4, "org.eclipse.orion.server.git", "Error fetching git remote", (Throwable)e);
        }
        catch (GitAPIException e) {
            result = this.getGitAPIExceptionStatus(e, "Error fetching git remote");
        }
        catch (JGitInternalException e) {
            result = this.getJGitInternalExceptionStatus(e, "Error fetching git remote");
        }
        catch (Exception e) {
            result = new Status(4, "org.eclipse.orion.server.git", "Error fetching git remote", (Throwable)e);
        }
        return result;
    }
}

