/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.useradmin.simple;

import java.io.File;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.orion.internal.server.useradmin.simple.SimpleUserProfileRoot;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.user.profile.IOrionUserProfileNode;
import org.eclipse.orion.server.user.profile.IOrionUserProfileService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleUserProfileService
implements IOrionUserProfileService {
    private IOrionUserProfileNode root = null;

    public SimpleUserProfileService() {
        this.initStorage();
    }

    private void initStorage() {
        try {
            IFileStore fileStore = OrionConfiguration.getUserHome(null);
            File rootLocation = fileStore.toLocalFile(0, null);
            this.root = new SimpleUserProfileRoot(rootLocation);
        }
        catch (CoreException e) {
            LogHelper.log((Throwable)e);
        }
        Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
        logger.debug("Started simple user profile service.");
    }

    public IOrionUserProfileNode getUserProfileNode(String userName, String partId) {
        if (partId.equals("general")) {
            return this.root.getUserProfileNode(userName);
        }
        return null;
    }

    public IOrionUserProfileNode getUserProfileNode(String userName, boolean create) {
        if (create || this.root.userProfileNodeExists(userName)) {
            return this.root.getUserProfileNode(userName);
        }
        return null;
    }

    public String[] getUserNames() {
        return this.root.childrenNames();
    }
}

