/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSTableView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.widgets.Table;

public class TableDragSourceEffect
extends DragSourceEffect {
    Image dragSourceImage = null;

    public TableDragSourceEffect(Table table) {
        super(table);
    }

    public void dragFinished(DragSourceEvent event) {
        if (this.dragSourceImage != null) {
            this.dragSourceImage.dispose();
        }
        this.dragSourceImage = null;
    }

    public void dragStart(DragSourceEvent event) {
        event.image = this.getDragSourceImage(event);
    }

    Image getDragSourceImage(DragSourceEvent event) {
        Image image;
        if (this.dragSourceImage != null) {
            this.dragSourceImage.dispose();
        }
        this.dragSourceImage = null;
        NSPoint point = new NSPoint();
        int ptr = C.malloc(NSPoint.sizeof);
        OS.memmove(ptr, point, NSPoint.sizeof);
        NSEvent nsEvent = NSApplication.sharedApplication().currentEvent();
        NSTableView widget = (NSTableView)this.control.view;
        NSImage nsImage = widget.dragImageForRowsWithIndexes(widget.selectedRowIndexes(), widget.tableColumns(), nsEvent, ptr);
        OS.memmove(point, ptr, NSPoint.sizeof);
        C.free(ptr);
        this.dragSourceImage = image = Image.cocoa_new(this.control.getDisplay(), 0, nsImage);
        nsImage.retain();
        event.offsetX = (int)point.x;
        event.offsetY = (int)point.y;
        return image;
    }
}

