/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.configurator;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.core.authentication.IAuthenticationService;
import org.eclipse.orion.server.core.authentication.NoneAuthenticationService;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class ConfiguratorActivator
implements BundleActivator {
    public static final String PI_CONFIGURATOR = "org.eclipse.orion.server.configurator";
    static final String PROP_CONFIGURED = "configured";
    static ConfiguratorActivator singleton;
    private ServiceTracker<IAuthenticationService, IAuthenticationService> authServiceTracker;
    private ServiceTracker<PackageAdmin, PackageAdmin> packageAdminTracker;
    private ServiceTracker<Location, Location> instanceLocationTracker;
    private BundleContext bundleContext;

    Filter getAuthFilter() throws InvalidSyntaxException {
        StringBuilder sb = new StringBuilder("(");
        sb.append("orion.auth.name");
        sb.append('=');
        sb.append(this.getAuthName());
        sb.append(')');
        return FrameworkUtil.createFilter((String)sb.toString());
    }

    public static ConfiguratorActivator getDefault() {
        return singleton;
    }

    public void start(BundleContext context) throws Exception {
        singleton = this;
        this.bundleContext = context;
        this.packageAdminTracker = new ServiceTracker(context, PackageAdmin.class.getName(), null);
        this.packageAdminTracker.open();
        this.authServiceTracker = new AuthServiceTracker(context);
        this.authServiceTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.authServiceTracker != null) {
            this.authServiceTracker.close();
            this.authServiceTracker = null;
        }
        if (this.packageAdminTracker != null) {
            this.packageAdminTracker.close();
            this.packageAdminTracker = null;
        }
        if (this.instanceLocationTracker != null) {
            this.instanceLocationTracker.close();
            this.instanceLocationTracker = null;
        }
    }

    protected Bundle getBundle(String symbolicName) {
        PackageAdmin packageAdmin = (PackageAdmin)this.packageAdminTracker.getService();
        if (packageAdmin == null) {
            return null;
        }
        Bundle[] bundles = packageAdmin.getBundles(symbolicName, null);
        if (bundles == null) {
            return null;
        }
        int i = 0;
        while (i < bundles.length) {
            if ((bundles[i].getState() & 3) == 0) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    public IAuthenticationService getAuthService() {
        return (IAuthenticationService)this.authServiceTracker.getService();
    }

    public Location getInstanceLocation() {
        if (this.instanceLocationTracker == null) {
            Filter filter;
            try {
                filter = this.bundleContext.createFilter(Location.INSTANCE_FILTER);
            }
            catch (InvalidSyntaxException e) {
                LogHelper.log((Throwable)e);
                return null;
            }
            this.instanceLocationTracker = new ServiceTracker(this.bundleContext, filter, null);
            this.instanceLocationTracker.open();
        }
        return (Location)this.instanceLocationTracker.getService();
    }

    String getAuthName() {
        return PreferenceHelper.getString((String)"orion.auth.name", (String)System.getProperty("orion.tests.authtype", "FORM+OpenID"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AuthServiceTracker
    extends ServiceTracker<IAuthenticationService, IAuthenticationService> {
        public AuthServiceTracker(BundleContext context) throws InvalidSyntaxException {
            super(context, ConfiguratorActivator.this.getAuthFilter(), null);
            if ("None".equalsIgnoreCase(ConfiguratorActivator.this.getAuthName())) {
                Hashtable<String, String> properties = new Hashtable<String, String>();
                ((Dictionary)properties).put("orion.auth.name", ConfiguratorActivator.this.getAuthName());
                context.registerService(IAuthenticationService.class, (Object)new NoneAuthenticationService(), properties);
            }
        }

        public IAuthenticationService addingService(ServiceReference<IAuthenticationService> reference) {
            if ("true".equals(reference.getProperty(ConfiguratorActivator.PROP_CONFIGURED))) {
                return null;
            }
            IAuthenticationService authService = (IAuthenticationService)super.addingService(reference);
            authService.configure(new Properties());
            Properties dictionary = new Properties();
            ((Dictionary)dictionary).put(ConfiguratorActivator.PROP_CONFIGURED, "true");
            if (this.getService() != null) {
                ((IAuthenticationService)this.getService()).setRegistered(false);
            }
            authService.setRegistered(true);
            this.context.registerService(IAuthenticationService.class.getName(), (Object)authService, (Dictionary)dictionary);
            return authService;
        }
    }
}

