/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.project;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.internal.server.servlets.project.ProjectHandlerV1;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.metastore.ProjectInfo;
import org.eclipse.orion.server.core.project.Project;
import org.eclipse.orion.server.servlets.OrionServlet;

public class ProjectServlet
extends OrionServlet {
    ProjectHandlerV1 projectHandlerV1 = new ProjectHandlerV1(this.getStatusHandler());
    private static final long serialVersionUID = -1615454357717722084L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.traceRequest(req);
        String pathInfo = req.getPathInfo();
        Path path = new Path(pathInfo);
        if (path == null || path.segmentCount() != 2) {
            this.handleException(resp, (IStatus)new Status(4, "org.eclipse.orion.server.servlets", "Invalid project request"), 400);
            return;
        }
        try {
            ProjectInfo project = OrionConfiguration.getMetaStore().readProject(path.segment(0), path.segment(1));
            this.projectHandlerV1.handleRequest(req, resp, Project.fromProjectInfo((ProjectInfo)project));
        }
        catch (CoreException e) {
            this.handleException(resp, "Could not find project", (Exception)((Object)e));
        }
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }
}

