/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.diff;

import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.HashedSequence;
import org.eclipse.jgit.diff.HashedSequenceComparator;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.internal.JGitText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HistogramDiffIndex<S extends Sequence> {
    private static final int REC_NEXT_SHIFT = 36;
    private static final int REC_PTR_SHIFT = 8;
    private static final int REC_PTR_MASK = 0xFFFFFFF;
    private static final int REC_CNT_MASK = 255;
    private static final int MAX_PTR = 0xFFFFFFF;
    private static final int MAX_CNT = 255;
    private final int maxChainLength;
    private final HashedSequenceComparator<S> cmp;
    private final HashedSequence<S> a;
    private final HashedSequence<S> b;
    private final Edit region;
    private final int[] table;
    private final int keyShift;
    private long[] recs;
    private int recCnt;
    private int[] next;
    private int[] recIdx;
    private int ptrShift;
    private Edit lcs;
    private int cnt;
    private boolean hasCommon;

    HistogramDiffIndex(int maxChainLength, HashedSequenceComparator<S> cmp, HashedSequence<S> a, HashedSequence<S> b, Edit r) {
        this.maxChainLength = maxChainLength;
        this.cmp = cmp;
        this.a = a;
        this.b = b;
        this.region = r;
        if (this.region.endA >= 0xFFFFFFF) {
            throw new IllegalArgumentException(JGitText.get().sequenceTooLargeForDiffAlgorithm);
        }
        int sz = r.getLengthA();
        int tableBits = HistogramDiffIndex.tableBits(sz);
        this.table = new int[1 << tableBits];
        this.keyShift = 32 - tableBits;
        this.ptrShift = r.beginA;
        this.recs = new long[Math.max(4, sz >>> 3)];
        this.next = new int[sz];
        this.recIdx = new int[sz];
    }

    Edit findLongestCommonSequence() {
        if (!this.scanA()) {
            return null;
        }
        this.lcs = new Edit(0, 0);
        this.cnt = this.maxChainLength + 1;
        int bPtr = this.region.beginB;
        while (bPtr < this.region.endB) {
            bPtr = this.tryLongestCommonSequence(bPtr);
        }
        return this.hasCommon && this.maxChainLength < this.cnt ? null : this.lcs;
    }

    private boolean scanA() {
        block0: for (int ptr = this.region.endA - 1; this.region.beginA <= ptr; --ptr) {
            int tIdx = this.hash(this.a, ptr);
            int chainLen = 0;
            int rIdx = this.table[tIdx];
            while (rIdx != 0) {
                long rec = this.recs[rIdx];
                if (this.cmp.equals(this.a, HistogramDiffIndex.recPtr(rec), this.a, ptr)) {
                    int newCnt = HistogramDiffIndex.recCnt(rec) + 1;
                    if (255 < newCnt) {
                        newCnt = 255;
                    }
                    this.recs[rIdx] = HistogramDiffIndex.recCreate(HistogramDiffIndex.recNext(rec), ptr, newCnt);
                    this.next[ptr - this.ptrShift] = HistogramDiffIndex.recPtr(rec);
                    this.recIdx[ptr - this.ptrShift] = rIdx;
                    continue block0;
                }
                rIdx = HistogramDiffIndex.recNext(rec);
                ++chainLen;
            }
            if (chainLen == this.maxChainLength) {
                return false;
            }
            if ((rIdx = ++this.recCnt) == this.recs.length) {
                int sz = Math.min(this.recs.length << 1, 1 + this.region.getLengthA());
                long[] n = new long[sz];
                System.arraycopy(this.recs, 0, n, 0, this.recs.length);
                this.recs = n;
            }
            this.recs[rIdx] = HistogramDiffIndex.recCreate(this.table[tIdx], ptr, 1);
            this.recIdx[ptr - this.ptrShift] = rIdx;
            this.table[tIdx] = rIdx;
        }
        return true;
    }

    private int tryLongestCommonSequence(int bPtr) {
        int bNext = bPtr + 1;
        int rIdx = this.table[this.hash(this.b, bPtr)];
        while (rIdx != 0) {
            long rec = this.recs[rIdx];
            if (HistogramDiffIndex.recCnt(rec) > this.cnt) {
                if (!this.hasCommon) {
                    this.hasCommon = this.cmp.equals(this.a, HistogramDiffIndex.recPtr(rec), this.b, bPtr);
                }
            } else {
                int as = HistogramDiffIndex.recPtr(rec);
                if (this.cmp.equals(this.a, as, this.b, bPtr)) {
                    this.hasCommon = true;
                    block1: while (true) {
                        int bs;
                        int np = this.next[as - this.ptrShift];
                        int ae = as + 1;
                        int be = bs + 1;
                        int rc = HistogramDiffIndex.recCnt(rec);
                        for (bs = bPtr; this.region.beginA < as && this.region.beginB < bs && this.cmp.equals(this.a, as - 1, this.b, bs - 1); --as, --bs) {
                            if (1 >= rc) continue;
                            rc = Math.min(rc, HistogramDiffIndex.recCnt(this.recs[this.recIdx[as - this.ptrShift]]));
                        }
                        while (ae < this.region.endA && be < this.region.endB && this.cmp.equals(this.a, ae, this.b, be)) {
                            if (1 < rc) {
                                rc = Math.min(rc, HistogramDiffIndex.recCnt(this.recs[this.recIdx[ae - this.ptrShift]]));
                            }
                            ++ae;
                            ++be;
                        }
                        if (bNext < be) {
                            bNext = be;
                        }
                        if (this.lcs.getLengthA() < ae - as || rc < this.cnt) {
                            this.lcs.beginA = as;
                            this.lcs.beginB = bs;
                            this.lcs.endA = ae;
                            this.lcs.endB = be;
                            this.cnt = rc;
                        }
                        if (np == 0) break;
                        while (np < ae) {
                            if ((np = this.next[np - this.ptrShift]) != 0) continue;
                            break block1;
                        }
                        as = np;
                    }
                }
            }
            rIdx = HistogramDiffIndex.recNext(rec);
        }
        return bNext;
    }

    private int hash(HashedSequence<S> s, int idx) {
        return this.cmp.hash(s, idx) * -1640562687 >>> this.keyShift;
    }

    private static long recCreate(int next, int ptr, int cnt) {
        return (long)next << 36 | (long)ptr << 8 | (long)cnt;
    }

    private static int recNext(long rec) {
        return (int)(rec >>> 36);
    }

    private static int recPtr(long rec) {
        return (int)(rec >>> 8) & 0xFFFFFFF;
    }

    private static int recCnt(long rec) {
        return (int)rec & 0xFF;
    }

    private static int tableBits(int sz) {
        int bits = 31 - Integer.numberOfLeadingZeros(sz);
        if (bits == 0) {
            bits = 1;
        }
        if (1 << bits < sz) {
            ++bits;
        }
        return bits;
    }
}

