/*******************************************************************************
 * @license
 * Copyright (c) 2013 IBM Corporation.
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0
 * (http://www.eclipse.org/legal/epl-v10.html), and the Eclipse Distribution
 * License v1.0 (http://www.eclipse.org/org/documents/edl-v10.html).
 *
 * Contributors:
 *     Manu Sridharan (IBM) - Initial API and implementation
 ******************************************************************************/

// this file was generated by a script from the model in types.js
/*global define */
define("plugins/esprima/indexFiles/browserIndex", [], function () {
	return {
		"!name": "browser",
		"!define": {
			"WebSocket": {
				"!proto": "Object",
				"onreadystatechange": "EventHandler",
				"onopen": "EventHandler",
				"onerror": "EventHandler",
				"onclose": "EventHandler",
				"readyState": "Number",
				"extensions": "String",
				"protocol": "String",
				"close": {
					"!type": "fn(reason?: Object)"
				},
				"send": {
					"!type": "fn(data: String)"
				}
			},
			"WebSocket_obj": {
				"!type": "fn(url: String, protocols: String)",
				"prototype": "WebSocket"
			},
			"EventHandler": {
				"!proto": "Object"
			},
			"XMLHttpRequest": {
				"!proto": "Object",
				"onreadystatechange": "EventHandler",
				"open": {
					"!type": "fn(method: String, url: String, async?: Boolean, user?: String, password?: String)"
				},
				"setRequestHeader": {
					"!type": "fn(header: String, value: String)"
				},
				"timeout": "Number",
				"withCredentials": "Boolean",
				"upload": "Object",
				"send": {
					"!type": "fn(data?: String)"
				},
				"abort": {
					"!type": "fn()"
				},
				"getResponseHeader": {
					"!type": "fn(header: String) -> String"
				},
				"getAllResponseHeaders": {
					"!type": "fn() -> String"
				},
				"overrideMimeType": "Object",
				"responseType": "Object",
				"readyState": "Number",
				"response": "Object",
				"responseText": "String",
				"responseXML": "Document",
				"status": "Number",
				"statusText": "String"
			},
			"XHR_obj": {
				"!type": "fn()",
				"prototype": "XMLHttpRequest"
			},
			"Worker_proto": {
				"!proto": "Object",
				"terminate": {
					"!type": "fn()"
				},
				"postMessage": {
					"!type": "fn(message: String, transfer?: Object)"
				},
				"onmessage": {
					"!type": "fn()"
				}
			},
			"Worker_obj": {
				"!type": "fn(url: String)",
				"prototype": "Worker_proto"
			},
			"HTMLOptionElement": {
				"!proto": "HTMLElement"
			},
			"HTMLElement": {
				"!proto": "Element",
				"id": "String",
				"title": "String",
				"lang": "String",
				"dir": "String",
				"className": "String"
			},
			"HTMLImageElement": {
				"!proto": "HTMLElement"
			},
			"Event": {
				"!proto": "Object",
				"bubbles": "Boolean",
				"cancelable": "Boolean",
				"currentTarget": "Object",
				"defaultPrevented": "Boolean",
				"eventPhase": "Number",
				"explicitOriginalTarget": "Object",
				"originalTarget": "Object",
				"target": "Object",
				"timeStamp": "Number",
				"isTrusted": "Boolean",
				"initEvent": {
					"!type": "fn(type: String, bubbles: Boolean, cancelable: Boolean)"
				},
				"preventDefault": {
					"!type": "fn()"
				},
				"stopImmediatePropagation": {
					"!type": "fn()"
				},
				"stopPropagation": {
					"!type": "fn()"
				}
			},
			"Event_obj": {
				"!type": "fn(type: String)",
				"prototype": "Event"
			},
			"MediaQueryList": {
				"!proto": "Object"
			},
			"Selection": {
				"!proto": "Object",
				"anchorNode": "Node",
				"anchorOffset": "Number",
				"focusNode": "Node",
				"focusOffset": "Number",
				"rangeCount": "Number",
				"isCollapsed": "Boolean",
				"collapse": {
					"!type": "fn(node: Node, offset: Number)"
				},
				"collapseToStart": {
					"!type": "fn()"
				},
				"collapseToEnd": {
					"!type": "fn()"
				},
				"extend": {
					"!type": "fn(node: Node, offset: Number)"
				},
				"selectAllChildren": {
					"!type": "fn(node: Node)"
				},
				"deleteFromDocument": {
					"!type": "fn()"
				},
				"getRangeAt": {
					"!type": "fn(index: Number) -> Range"
				},
				"addRange": {
					"!type": "fn(range: Range)"
				},
				"removeRange": {
					"!type": "fn(range: Range)"
				},
				"removeAllRanges": {
					"!type": "fn()"
				}
			},
			"Range": {
				"!proto": "Object",
				"startContainer": "Node",
				"startOffset": "Number",
				"endContainer": "Node",
				"endOffset": "Number",
				"collapsed": "Boolean",
				"commonAncestorContainer": "Node",
				"setStart": {
					"!type": "fn(refNode: Node, offset: Number)"
				},
				"setEnd": {
					"!type": "fn(refNode: Node, offset: Number)"
				},
				"setStartBefore": {
					"!type": "fn(refNode: Node)"
				},
				"setStartAfter": {
					"!type": "fn(refNode: Node)"
				},
				"setEndBefore": {
					"!type": "fn(refNode: Node)"
				},
				"setEndAfter": {
					"!type": "fn(refNode: Node)"
				},
				"collapse": {
					"!type": "fn(toStart: Node)"
				},
				"selectNode": {
					"!type": "fn(refNode: Node)"
				},
				"selectNodeContents": {
					"!type": "fn(refNode: Node)"
				},
				"compareBoundaryPoints": {
					"!type": "fn(how: Object, sourceRange: Object) -> Number"
				},
				"deleteContents": {
					"!type": "fn()"
				},
				"extractContents": {
					"!type": "fn() -> DocumentFragment"
				},
				"cloneContents": {
					"!type": "fn() -> DocumentFragment"
				},
				"insertNode": {
					"!type": "fn(node: Node)"
				},
				"surroundContents": {
					"!type": "fn(nodeParent: Node)"
				},
				"cloneRange": {
					"!type": "fn() -> Range"
				},
				"detach": {
					"!type": "fn()"
				},
				"isPointInRange": {
					"!type": "fn(node: Node, offset: Number) -> Boolean"
				},
				"comparePoint": {
					"!type": "fn(node: Node, offset: Number) -> Number"
				},
				"intersectsNode": {
					"!type": "fn(node: Node) -> Boolean"
				}
			},
			"DocumentFragment": {
				"!proto": "Node",
				"prepend": {
					"!type": "fn(nodes: Node)"
				},
				"append": {
					"!type": "fn(nodes: Node)"
				}
			},
			"CSSStyleDeclaration": {
				"!proto": "Object"
			},
			"Node": {
				"!proto": "Object",
				"nodeType": "Number",
				"nodeName": "String",
				"baseURI": "String",
				"ownerDocument": "Document",
				"parentNode": "Node",
				"parentElement": "Element",
				"childNodes": "NodeList",
				"firstChild": "Node",
				"lastChild": "Node",
				"previousSibling": "Node",
				"nextSibling": "Node",
				"nodeValue": "String",
				"textContent": "String",
				"hasChildNodes": {
					"!type": "fn() -> Boolean"
				},
				"compareDocumentPosition": {
					"!type": "fn(other: Node) -> Number"
				},
				"contains": {
					"!type": "fn(other: Node) -> Boolean"
				},
				"insertBefore": {
					"!type": "fn(child: Node) -> Node"
				},
				"appendChild": {
					"!type": "fn(node: Node) -> Node"
				},
				"replaceChild": {
					"!type": "fn(child: Node) -> Node"
				},
				"removeChild": {
					"!type": "fn(child: Node) -> Node"
				},
				"normalize": {
					"!type": "fn()"
				},
				"cloneNode": {
					"!type": "fn(deep?: Boolean) -> Node"
				},
				"isEqualNode": {
					"!type": "fn(node: Node) -> Boolean"
				},
				"lookupPrefix": {
					"!type": "fn(namespace: String) -> String"
				},
				"lookupNamespaceURI": {
					"!type": "fn(prefix: String) -> String"
				},
				"isDefaultNamespace": {
					"!type": "fn(namespace: String) -> Boolean"
				}
			},
			"Node_obj": {
				"!type": "fn()",
				"prototype": "Node"
			},
			"NodeList": {
				"!proto": "Object",
				"item": "Node",
				"length": "Number"
			},
			"Screen": {
				"!proto": "Object",
				"availTop": "Number",
				"availLeft": "Number",
				"availHeight": "Number",
				"availWidth": "Number",
				"colorDepth": "Number",
				"height": "Number",
				"left": "Number",
				"pixelDepth": "Number",
				"top": "Number",
				"width": "Number"
			},
			"Performance": {
				"!proto": "Object"
			},
			"Navigator": {
				"!proto": "Object",
				"appName": "String",
				"appVersion": "String",
				"connection": "Connection",
				"cookieEnabled": "Boolean",
				"language": "String",
				"mimeTypes": "MimeTypeArray",
				"onLine": "Boolean",
				"oscpu": "String",
				"platform": "String",
				"plugins": "String",
				"userAgent": "String",
				"javaEnabled": {
					"!type": "fn() -> Boolean"
				},
				"registerContentHandler": {
					"!type": "fn(mimType: String, url: String, title: String)"
				},
				"registerProtocolHandler": {
					"!type": "fn(protocol: String, url: String, title: String)"
				}
			},
			"MimeTypeArray": {
				"length": "Number",
				"item": {
					"!type": "fn(index: Number) -> MimeType"
				},
				"namedItem": {
					"!type": "fn(name: String) -> MimeType"
				}
			},
			"MimeType": {
				"description": "String",
				"suffixes": "String",
				"type": "String",
				"enabledPlugin": "Plugin"
			},
			"Plugin": {
				"description": "String",
				"fileName": "String",
				"length": "Number",
				"name": "String",
				"item": {
					"!type": "fn(index: Number) -> MimeType"
				},
				"namedItem": {
					"!type": "fn(name: String) -> MimeType"
				}
			},
			"Connection": {
				"bandwidth": "Number",
				"metered": "Boolean",
				"onchange": "Function"
			},
			"Storage": {
				"!proto": "Object",
				"length": "Number",
				"key": {
					"!type": "fn(idx: Number) -> String"
				},
				"getItem": {
					"!type": "fn(key: String) -> String"
				},
				"setItem": {
					"!type": "fn(key: String, value: String)"
				},
				"removeItem": {
					"!type": "fn(key: String)"
				},
				"clear": {
					"!type": "fn()"
				}
			},
			"BarInfo": {
				"!proto": "Object",
				"visible": "Boolean"
			},
			"Location": {
				"!proto": "Object",
				"assign": {
					"!type": "fn(url: String)"
				},
				"replace": {
					"!type": "fn(url: String)"
				},
				"reload": {
					"!type": "fn()"
				},
				"href": "String",
				"protocol": "String",
				"host": "String",
				"hostname": "String",
				"port": "String",
				"pathname": "String",
				"search": "String",
				"hash": "String"
			},
			"History": {
				"!proto": "Object",
				"length": "Number",
				"state": "Object",
				"go": {
					"!type": "fn(delta: Number)"
				},
				"back": {
					"!type": "fn()"
				},
				"forward": {
					"!type": "fn()"
				},
				"pushState": {
					"!type": "fn(data: Object, title: String, url: String)"
				},
				"replaceState": {
					"!type": "fn(data: Object, title: String, url: String)"
				}
			},
			"Element": {
				"!proto": "Node",
				"namespaceURI": "String",
				"prefix": "String",
				"localName": "String",
				"tagName": "String",
				"id": "String",
				"className": "String",
				"classList": "DOMTokenList",
				"attributes": "Array",
				"childElementCount": "Number",
				"children": "HTMLCollection",
				"firstElementChild": "Element",
				"lastElementChild": "Element",
				"previousElementSibling": "Element",
				"nextElementSibling": "Element",
				"getAttribute": {
					"!type": "fn(name: String) -> String"
				},
				"getAttributeNS": {
					"!type": "fn(namespace: String, localname: String) -> String"
				},
				"setAttribute": {
					"!type": "fn(name: String, value: Object)"
				},
				"setAttributeNS": {
					"!type": "fn(namespace: String, name: String, value: Object)"
				},
				"removeAttribute": {
					"!type": "fn(name: String)"
				},
				"removeAttributeNS": {
					"!type": "fn(namespace: String, localname: String)"
				},
				"hasAttribute": {
					"!type": "fn(name: String) -> Boolean"
				},
				"hasAttributeNS": {
					"!type": "fn(namespace: String, localname: String) -> Boolean"
				},
				"getElementsByTagName": {
					"!type": "fn(localName: String) -> HTMLCollection"
				},
				"getElementsByTagNameNS": {
					"!type": "fn(namespace: String, localName: String) -> HTMLCollection"
				},
				"getElementsByClassName": {
					"!type": "fn(classname: String) -> HTMLCollection"
				},
				"prepend": {
					"!type": "fn(nodes: Node)"
				},
				"append": {
					"!type": "fn(nodes: Node)"
				},
				"before": {
					"!type": "fn(nodes: Node)"
				},
				"after": {
					"!type": "fn(nodes: Node)"
				},
				"replace": {
					"!type": "fn(nodes: Node)"
				},
				"remove": {
					"!type": "fn()"
				}
			},
			"HTMLCollection": {
				"!proto": "Object",
				"length": "Number",
				"item": {
					"!type": "fn(index: Number) -> Element"
				},
				"namedItem": {
					"!type": "fn(name: String) -> Element"
				}
			},
			"DOMTokenList": {
				"!proto": "Object",
				"length": "Number",
				"item": {
					"!type": "fn(index: Number) -> String"
				},
				"contains": {
					"!type": "fn(token: String) -> Boolean"
				},
				"add": {
					"!type": "fn(token: String)"
				},
				"remove": {
					"!type": "fn(token: String)"
				},
				"toggle": {
					"!type": "fn(token: String) -> Boolean"
				}
			},
			"Document": {
				"!proto": "Node",
				"implementation": "DOMImplementation",
				"URL": "String",
				"documentURI": "String",
				"compatMode": "String",
				"characterSet": "String",
				"contentType": "String",
				"doctype": "DocumentType",
				"documentElement": "Element",
				"getElementsByTagName": {
					"!type": "fn(localName: String) -> HTMLCollection"
				},
				"getElementsByTagNameNS": {
					"!type": "fn(namespace: String, localName: String) -> HTMLCollection"
				},
				"getElementsByClassName": {
					"!type": "fn(classNames: String) -> HTMLCollection"
				},
				"getElementById": {
					"!type": "fn(elementId: String) -> Element"
				},
				"createElement": {
					"!type": "fn(elementId: String) -> Element"
				},
				"createElementNS": {
					"!type": "fn(namespace: String, qualifiedName: String) -> Element"
				},
				"createDocumentFragment": {
					"!type": "fn() -> DocumentFragment"
				},
				"createTextNode": {
					"!type": "fn(data: String) -> Text"
				},
				"createComment": {
					"!type": "fn(data: String) -> Comment"
				},
				"createProcessingInstruction": {
					"!type": "fn(target: String, data: String) -> ProcessingInstruction"
				},
				"importNode": {
					"!type": "fn(node: Node, deep?: Boolean) -> Node"
				},
				"adoptNode": {
					"!type": "fn(node: Node) -> Node"
				},
				"createEvent": {
					"!type": "fn(eventInterfaceName: String) -> Event"
				},
				"createRange": {
					"!type": "fn() -> Range"
				},
				"createNodeIterator": {
					"!type": "fn(root: Node, whatToShow?: Object, filter?: Object) -> NodeIterator"
				},
				"createTreeWalker": {
					"!type": "fn(root: Node, whatToShow?: Object, filter?: Object) -> TreeWalker"
				}
			},
			"TreeWalker": {
				"!proto": "Object"
			},
			"NodeIterator": {
				"!proto": "Object"
			},
			"ProcessingInstruction": {
				"!proto": "Node"
			},
			"Comment": {
				"!proto": "Node"
			},
			"Text": {
				"!proto": "Node"
			},
			"DocumentType": {
				"!proto": "Node",
				"name": "String",
				"publicId": "String",
				"systemId": "String",
				"before": {
					"!type": "fn(nodeOrString: Node)"
				},
				"after": {
					"!type": "fn(nodeOrString: Node)"
				},
				"replace": {
					"!type": "fn(nodeOrString: Node)"
				},
				"remove": {
					"!type": "fn()"
				}
			},
			"DOMImplementation": {
				"!proto": "Object",
				"createDocumentType": {
					"!type": "fn(qualifiedName: String, publicId: String, systemId: String) -> DocumentType"
				},
				"createDocument": {
					"!type": "fn(namespace: String, qualifiedName: String, doctype: String) -> Document"
				},
				"createHTMLDocument": {
					"!type": "fn(title: String) -> Document"
				},
				"hasFeature": {
					"!type": "fn(feature: String) -> Boolean"
				}
			},
			"Console": {
				"debug": {
					"!type": "fn(msg: String)"
				},
				"dir": {
					"!type": "fn(obj: Object)"
				},
				"error": {
					"!type": "fn(msg: String)"
				},
				"group": {
					"!type": "fn()"
				},
				"groupCollapsed": {
					"!type": "fn()"
				},
				"groupEnd": {
					"!type": "fn()"
				},
				"info": {
					"!type": "fn(msg: String)"
				},
				"log": {
					"!type": "fn(msg: String)"
				},
				"time": {
					"!type": "fn(timerName: String)"
				},
				"timeEnd": {
					"!type": "fn(timerName: String)"
				},
				"trace": {
					"!type": "fn()"
				},
				"warn": {
					"!type": "fn(msg: String)"
				}
			},
			"DOMApplicationCache": {
				"!proto": "Object"
			}
		},
		"this": "<top>",
		"applicationCache": "DOMApplicationCache",
		"closed": "Boolean",
		"console": "Console",
		"defaultStatus": "String",
		"document": "Document",
		"frameElement": "Element",
		"frames": "Array",
		"history": "History",
		"innerHeight": "Number",
		"innerWidth": "Number",
		"length": "Number",
		"location": "Location",
		"locationbar": "BarInfo",
		"localStorage": "Storage",
		"menubar": "BarInfo",
		"name": "String",
		"navigator": "Navigator",
		"opener": "<top>",
		"outerHeight": "Number",
		"outerWidth": "Number",
		"pageXOffset": "Number",
		"pageYOffset": "Number",
		"parent": "<top>",
		"performance": "Performance",
		"personalbar": "BarInfo",
		"screen": "Screen",
		"screenX": "Number",
		"screenY": "Number",
		"scrollbars": "BarInfo",
		"scrollMaxX": "Number",
		"scrollMaxY": "Number",
		"scrollX": "Number",
		"scrollY": "Number",
		"self": "<top>",
		"sessionStorage": "Storage",
		"sidebar": "BarInfo",
		"status": "String",
		"statusbar": "BarInfo",
		"toolbar": "BarInfo",
		"top": "<top>",
		"window": "<top>",
		"addEventListener": {
			"!type": "fn()"
		},
		"alert": {
			"!type": "fn(msg: String)"
		},
		"atob": {
			"!type": "fn(val: Object) -> String"
		},
		"back": {
			"!type": "fn()"
		},
		"blur": {
			"!type": "fn()"
		},
		"btoa": {
			"!type": "fn(val: Object) -> String"
		},
		"clearInterval": {
			"!type": "fn(t: Number)"
		},
		"clearTimeout": {
			"!type": "fn(t: Number)"
		},
		"close": {
			"!type": "fn()"
		},
		"confirm": {
			"!type": "fn(msg: String) -> Boolean"
		},
		"dispatchEvent": {
			"!type": "fn(domnode: Node)"
		},
		"dump": {
			"!type": "fn(msg: String)"
		},
		"escape": {
			"!type": "fn(str: String) -> String"
		},
		"find": {
			"!type": "fn(str: String) -> Boolean"
		},
		"focus": {
			"!type": "fn()"
		},
		"forward": {
			"!type": "fn()"
		},
		"getAttention": {
			"!type": "fn()"
		},
		"getComputedStyle": {
			"!type": "fn(domnode: Node) -> CSSStyleDeclaration"
		},
		"getSelection": {
			"!type": "fn() -> Selection"
		},
		"home": {
			"!type": "fn()"
		},
		"matchMedia": {
			"!type": "fn(query: Object) -> MediaQueryList"
		},
		"moveBy": {
			"!type": "fn(deltaX: Number, deltaY: Number)"
		},
		"moveTo": {
			"!type": "fn(x: Number, y: Number)"
		},
		"open": {
			"!type": "fn(strUrl: String, strWindowName: String, strWindowFeatures?: String) -> Window"
		},
		"openDialog": {
			"!type": "fn(strUrl: String, strWindowName: String, strWindowFeatures: String, args?: String) -> Window"
		},
		"postMessage": {
			"!type": "fn(message: String, targetOrigin: String)"
		},
		"print": {
			"!type": "fn()"
		},
		"prompt": {
			"!type": "fn(message: String) -> String"
		},
		"removeEventListener": {
			"!type": "fn(type: String, listener: Object, useCapture?: Boolean)"
		},
		"resizeBy": {
			"!type": "fn(deltaX: Number, deltaY: Number)"
		},
		"resizeTo": {
			"!type": "fn(x: Number, y: Number)"
		},
		"scroll": {
			"!type": "fn(x: Number, y: Number)"
		},
		"scrollBy": {
			"!type": "fn(deltaX: Number, deltaY: Number)"
		},
		"scrollByLines": {
			"!type": "fn(lines: Number)"
		},
		"scrollByPages": {
			"!type": "fn(pages: Number)"
		},
		"scrollTo": {
			"!type": "fn(x: Number, y: Number)"
		},
		"setCursor": {
			"!type": "fn(cursor: String)"
		},
		"setInterval": {
			"!type": "fn(callback: Function, ms: Number) -> Number"
		},
		"setTimeout": {
			"!type": "fn(callback: Function, ms: Number) -> Number"
		},
		"sizeToContent": {
			"!type": "fn()"
		},
		"stop": {
			"!type": "fn()"
		},
		"unescape": {
			"!type": "fn(str: String) -> String"
		},
		"updateCommands": {
			"!type": "fn(cmdName: String)"
		},
		"onabort": {
			"!type": "fn(event: Event)"
		},
		"onbeforeunload": {
			"!type": "fn(event: Event)"
		},
		"onblur": {
			"!type": "fn(event: Event)"
		},
		"onchange": {
			"!type": "fn(event: Event)"
		},
		"onclick": {
			"!type": "fn(event: Event)"
		},
		"onclose": {
			"!type": "fn(event: Event)"
		},
		"oncontextmenu": {
			"!type": "fn(event: Event)"
		},
		"ondevicemotion": {
			"!type": "fn(event: Event)"
		},
		"ondeviceorientation": {
			"!type": "fn(event: Event)"
		},
		"ondragdrop": {
			"!type": "fn(event: Event)"
		},
		"onerror": {
			"!type": "fn(event: Event)"
		},
		"onfocus": {
			"!type": "fn(event: Event)"
		},
		"onhashchange": {
			"!type": "fn(event: Event)"
		},
		"onkeydown": {
			"!type": "fn(event: Event)"
		},
		"onkeypress": {
			"!type": "fn(event: Event)"
		},
		"onkeyup": {
			"!type": "fn(event: Event)"
		},
		"onload": {
			"!type": "fn(event: Event)"
		},
		"onmousedown": {
			"!type": "fn(event: Event)"
		},
		"onmousemove": {
			"!type": "fn(event: Event)"
		},
		"onmouseout": {
			"!type": "fn(event: Event)"
		},
		"onmouseover": {
			"!type": "fn(event: Event)"
		},
		"onmouseup": {
			"!type": "fn(event: Event)"
		},
		"onpaint": {
			"!type": "fn(event: Event)"
		},
		"onpopstate": {
			"!type": "fn(event: Event)"
		},
		"onreset": {
			"!type": "fn(event: Event)"
		},
		"onresize": {
			"!type": "fn(event: Event)"
		},
		"onscroll": {
			"!type": "fn(event: Event)"
		},
		"onselect": {
			"!type": "fn(event: Event)"
		},
		"onsubmit": {
			"!type": "fn(event: Event)"
		},
		"onunload": {
			"!type": "fn(event: Event)"
		},
		"onpageshow": {
			"!type": "fn(event: Event)"
		},
		"onpagehide": {
			"!type": "fn(event: Event)"
		},
		"Image": {
			"!type": "fn(width?: Number, height?: Number)"
		},
		"Option": {
			"!type": "fn(text?: String, value?: Object, defaultSelected?: Boolean, selected?: Boolean)"
		},
		"Worker": "Worker_obj",
		"XMLHttpRequest": "XHR_obj",
		"WebSocket": "WebSocket_obj",
		"Event": "Event_obj",
		"Node": "Node_obj"
	};
});