/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.project;

import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.internal.server.core.IWebResourceDecorator;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.metastore.ProjectInfo;
import org.eclipse.orion.server.core.project.Project;
import org.json.JSONObject;

public class ProjectDecorator
implements IWebResourceDecorator {
    public void addAtributesFor(HttpServletRequest request, URI resource, JSONObject representation) {
        if (!"/file".equals(request.getServletPath())) {
            return;
        }
        String pathInfo = request.getPathInfo();
        Path path = new Path(pathInfo);
        if (path.segmentCount() < 2) {
            return;
        }
        try {
            ProjectInfo project = OrionConfiguration.getMetaStore().readProject(path.segment(0), path.segment(1));
            Project projectData = Project.fromProjectInfo((ProjectInfo)project);
            if (projectData.exists()) {
                JSONObject projectJson = new JSONObject();
                projectJson.put("Location", (Object)URIUtil.append((URI)URIUtil.append((URI)resource.resolve("/project/"), (String)path.segment(0)), (String)path.segment(1)).toString());
                representation.put("ProjectInfo", (Object)projectJson);
            }
        }
        catch (Exception e) {
            LogHelper.log((Throwable)e);
        }
    }
}

