/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.core.metastore;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.internal.server.core.metastore.SimpleMetaStoreMigration;
import org.eclipse.orion.internal.server.core.metastore.SimpleMetaStoreUtil;
import org.eclipse.orion.server.core.metastore.IMetaStore;
import org.eclipse.orion.server.core.metastore.MetadataInfo;
import org.eclipse.orion.server.core.metastore.ProjectInfo;
import org.eclipse.orion.server.core.metastore.UserInfo;
import org.eclipse.orion.server.core.metastore.WorkspaceInfo;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMetaStore
implements IMetaStore {
    public static final String ORION_VERSION = "OrionVersion";
    public static final int VERSION = 4;
    public static final String USER = "user";
    public static final String PROJECT = "project";
    public static final String WORKSPACE = "workspace";
    public static final String ROOT = "metastore";
    private File rootLocation = null;

    public SimpleMetaStore(File rootLocation) {
        this.initializeMetaStore(rootLocation);
    }

    @Override
    public void createProject(ProjectInfo projectInfo) throws CoreException {
        WorkspaceInfo workspaceInfo;
        if (projectInfo.getWorkspaceId() == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.createProject: workspace id is null.", null));
        }
        if (projectInfo.getFullName() == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.createProject: project name is null.", null));
        }
        if (projectInfo.getFullName().equals(WORKSPACE)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.createProject: cannot create a project named \"worksspace\".", null));
        }
        try {
            workspaceInfo = this.readWorkspace(projectInfo.getWorkspaceId());
        }
        catch (CoreException coreException) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.createProject: could not find workspace with id:" + projectInfo.getWorkspaceId() + ", workspace does not exist.", null));
        }
        if (workspaceInfo == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.createProject: could not find workspace with id:" + projectInfo.getWorkspaceId() + ", workspace does not exist.", null));
        }
        String userId = SimpleMetaStoreUtil.decodeUserIdFromWorkspaceId(projectInfo.getWorkspaceId());
        String encodedWorkspaceName = SimpleMetaStoreUtil.decodeWorkspaceNameFromWorkspaceId(projectInfo.getWorkspaceId());
        String projectId = projectInfo.getFullName();
        projectInfo.setUniqueId(projectId);
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put(ORION_VERSION, 4);
            jsonObject.put("UniqueId", (Object)projectInfo.getUniqueId());
            jsonObject.put("WorkspaceId", (Object)projectInfo.getWorkspaceId());
            jsonObject.put("FullName", (Object)projectInfo.getFullName());
            jsonObject.put("ContentLocation", (Object)projectInfo.getContentLocation());
            JSONObject properties = new JSONObject(projectInfo.getProperties());
            jsonObject.put("Properties", (Object)properties);
        }
        catch (JSONException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.createProject: could not create project: " + projectInfo.getFullName() + " for user " + userId, (Throwable)e));
        }
        File userMetaFolder = SimpleMetaStoreUtil.readMetaUserFolder(this.rootLocation, userId);
        File workspaceMetaFolder = SimpleMetaStoreUtil.readMetaFolder(userMetaFolder, encodedWorkspaceName);
        if (!SimpleMetaStoreUtil.isMetaFolder(workspaceMetaFolder, projectInfo.getFullName()) && !SimpleMetaStoreUtil.createMetaFolder(workspaceMetaFolder, projectInfo.getFullName())) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.createProject: could not create project: " + projectInfo.getFullName() + " for user " + userId, null));
        }
        if (!SimpleMetaStoreUtil.createMetaFile(workspaceMetaFolder, projectInfo.getFullName(), jsonObject)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.createProject: could not create project: " + projectInfo.getFullName() + " for user " + userId, null));
        }
        ArrayList<String> newProjectNames = new ArrayList<String>();
        newProjectNames.addAll(workspaceInfo.getProjectNames());
        newProjectNames.add(projectInfo.getFullName());
        workspaceInfo.setProjectNames(newProjectNames);
        this.updateWorkspace(workspaceInfo);
    }

    @Override
    public void createUser(UserInfo userInfo) throws CoreException {
        if (userInfo.getUserName() == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.createUser: could not create user: " + userInfo.getUniqueId() + ", did not provide a userName", null));
        }
        userInfo.setUniqueId(userInfo.getUserName());
        File userMetaFolder = SimpleMetaStoreUtil.readMetaUserFolder(this.rootLocation, userInfo.getUserName());
        if (SimpleMetaStoreUtil.isMetaFolder(this.rootLocation, userInfo.getUserName())) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.createUser: could not create user: " + userInfo.getUserName() + ", user already exists", null));
        }
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put(ORION_VERSION, 4);
            jsonObject.put("UniqueId", (Object)userInfo.getUniqueId());
            jsonObject.put("UserName", (Object)userInfo.getUserName());
            jsonObject.put("FullName", (Object)userInfo.getFullName());
            jsonObject.put("WorkspaceIds", (Object)new JSONArray());
            JSONObject properties = this.getUserProperties(userInfo);
            jsonObject.put("Properties", (Object)properties);
        }
        catch (JSONException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.createUser: could not create user: " + userInfo.getUserName(), (Throwable)e));
        }
        if (!SimpleMetaStoreUtil.createMetaUserFolder(this.rootLocation, userInfo.getUserName())) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.createUser: could not create user: " + userInfo.getUserName(), null));
        }
        if (SimpleMetaStoreUtil.isMetaFile(userMetaFolder, USER) ? !SimpleMetaStoreUtil.updateMetaFile(userMetaFolder, USER, jsonObject) : !SimpleMetaStoreUtil.createMetaFile(userMetaFolder, USER, jsonObject)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.createUser: could not create user: " + userInfo.getUserName(), null));
        }
        Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
        logger.debug("Created new user " + userInfo.getUserName() + ".");
    }

    @Override
    public void createWorkspace(WorkspaceInfo workspaceInfo) throws CoreException {
        UserInfo userInfo;
        if (workspaceInfo.getUserId() == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.createWorkspace: user id is null.", null));
        }
        if (workspaceInfo.getFullName() == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.createWorkspace: workspace name is null.", null));
        }
        try {
            userInfo = this.readUser(workspaceInfo.getUserId());
        }
        catch (CoreException coreException) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.createWorkspace: could not find user with id: " + workspaceInfo.getUserId() + ", user does not exist.", null));
        }
        if (userInfo == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.createWorkspace: could not find user with id: " + workspaceInfo.getUserId() + ", user does not exist.", null));
        }
        String workspaceId = SimpleMetaStoreUtil.encodeWorkspaceId(workspaceInfo.getUserId(), workspaceInfo.getFullName());
        String encodedWorkspaceName = SimpleMetaStoreUtil.decodeWorkspaceNameFromWorkspaceId(workspaceId);
        File userMetaFolder = SimpleMetaStoreUtil.readMetaUserFolder(this.rootLocation, userInfo.getUniqueId());
        int suffix = 0;
        while (SimpleMetaStoreUtil.isMetaFolder(userMetaFolder, encodedWorkspaceName)) {
            workspaceId = SimpleMetaStoreUtil.encodeWorkspaceId(workspaceInfo.getUserId(), String.valueOf(workspaceInfo.getFullName()) + ++suffix);
            encodedWorkspaceName = SimpleMetaStoreUtil.decodeWorkspaceNameFromWorkspaceId(workspaceId);
        }
        workspaceInfo.setUniqueId(workspaceId);
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put(ORION_VERSION, 4);
            jsonObject.put("UniqueId", (Object)workspaceInfo.getUniqueId());
            jsonObject.put("UserId", (Object)workspaceInfo.getUserId());
            jsonObject.put("FullName", (Object)workspaceInfo.getFullName());
            jsonObject.put("ProjectNames", (Object)new JSONArray());
            JSONObject properties = new JSONObject(workspaceInfo.getProperties());
            jsonObject.put("Properties", (Object)properties);
        }
        catch (JSONException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.createWorkspace: could not create workspace: " + encodedWorkspaceName + " for user " + userInfo.getUserName(), (Throwable)e));
        }
        if (!SimpleMetaStoreUtil.createMetaFolder(userMetaFolder, encodedWorkspaceName)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.createWorkspace: could not create workspace: " + encodedWorkspaceName + " for user " + userInfo.getUserName(), null));
        }
        File workspaceMetaFolder = SimpleMetaStoreUtil.readMetaFolder(userMetaFolder, encodedWorkspaceName);
        if (!SimpleMetaStoreUtil.createMetaFile(workspaceMetaFolder, WORKSPACE, jsonObject)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.createWorkspace: could not create workspace: " + encodedWorkspaceName + " for user " + userInfo.getUserName(), null));
        }
        ArrayList<String> newWorkspaceIds = new ArrayList<String>();
        newWorkspaceIds.addAll(userInfo.getWorkspaceIds());
        newWorkspaceIds.add(workspaceId);
        userInfo.setWorkspaceIds(newWorkspaceIds);
        this.updateUser(userInfo);
    }

    @Override
    public void deleteProject(String workspaceId, String projectName) throws CoreException {
        WorkspaceInfo workspaceInfo;
        String userId = SimpleMetaStoreUtil.decodeUserIdFromWorkspaceId(workspaceId);
        String encodedWorkspaceName = SimpleMetaStoreUtil.decodeWorkspaceNameFromWorkspaceId(workspaceId);
        File userMetaFolder = SimpleMetaStoreUtil.readMetaUserFolder(this.rootLocation, userId);
        File workspaceMetaFolder = SimpleMetaStoreUtil.readMetaFolder(userMetaFolder, encodedWorkspaceName);
        try {
            workspaceInfo = this.readWorkspace(workspaceId);
        }
        catch (CoreException coreException) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.deleteProject: could not find project with name:" + projectName + ", workspace does not exist.", null));
        }
        ArrayList<String> newProjectIds = new ArrayList<String>();
        newProjectIds.addAll(workspaceInfo.getProjectNames());
        newProjectIds.remove(projectName);
        workspaceInfo.setProjectNames(newProjectIds);
        this.updateWorkspace(workspaceInfo);
        if (!SimpleMetaStoreUtil.deleteMetaFile(workspaceMetaFolder, projectName)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.createProject: could not create project: " + projectName + " for user " + userId, null));
        }
        if (!SimpleMetaStoreUtil.deleteMetaFolder(workspaceMetaFolder, projectName, true)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.createProject: could not create project: " + projectName + " for user " + userId, null));
        }
    }

    @Override
    public void deleteUser(String userId) throws CoreException {
        UserInfo userInfo;
        try {
            userInfo = this.readUser(userId);
        }
        catch (CoreException coreException) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.deleteUser: could not delete user with id: " + userId + ", user does not exist.", null));
        }
        for (String workspaceId : userInfo.getWorkspaceIds()) {
            this.deleteWorkspace(userId, workspaceId);
        }
        File userMetaFolder = SimpleMetaStoreUtil.readMetaUserFolder(this.rootLocation, userInfo.getUserName());
        if (!SimpleMetaStoreUtil.deleteMetaFile(userMetaFolder, USER)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.deleteUser: could not delete user: " + userInfo.getUserName(), null));
        }
        if (!SimpleMetaStoreUtil.deleteMetaUserFolder(userMetaFolder, userInfo.getUserName())) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.deleteUser: could not delete user: " + userInfo.getUserName(), null));
        }
    }

    @Override
    public void deleteWorkspace(String userId, String workspaceId) throws CoreException {
        UserInfo userInfo;
        String workspaceName = SimpleMetaStoreUtil.decodeWorkspaceNameFromWorkspaceId(workspaceId);
        File userMetaFolder = SimpleMetaStoreUtil.readMetaUserFolder(this.rootLocation, userId);
        File workspaceMetaFolder = SimpleMetaStoreUtil.readMetaFolder(userMetaFolder, workspaceName);
        WorkspaceInfo workspaceInfo = this.readWorkspace(workspaceId);
        for (String projectName : workspaceInfo.getProjectNames()) {
            this.deleteProject(workspaceId, projectName);
        }
        try {
            userInfo = this.readUser(userId);
        }
        catch (CoreException coreException) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.deleteWorkspace: could not find user with id:" + userId + ", user does not exist.", null));
        }
        ArrayList<String> newWorkspaceIds = new ArrayList<String>();
        newWorkspaceIds.addAll(userInfo.getWorkspaceIds());
        newWorkspaceIds.remove(workspaceId);
        userInfo.setWorkspaceIds(newWorkspaceIds);
        this.updateUser(userInfo);
        if (!SimpleMetaStoreUtil.deleteMetaFile(workspaceMetaFolder, WORKSPACE)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.deleteWorkspace: could not delete workspace: " + workspaceName, null));
        }
        if (!SimpleMetaStoreUtil.deleteMetaFolder(userMetaFolder, workspaceName, true)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.deleteWorkspace: could not delete workspace: " + workspaceName, null));
        }
    }

    public File getRootLocation() {
        return this.rootLocation;
    }

    private JSONObject getUserProperties(UserInfo userInfo) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        Map<String, String> properties = userInfo.getProperties();
        for (String key : properties.keySet()) {
            String value = properties.get(key);
            if ("UserRights".equals(key)) {
                JSONArray userRights = new JSONArray(value);
                jsonObject.put("UserRights", (Object)userRights);
                continue;
            }
            if ("SiteConfigurations".equals(key)) {
                JSONObject siteConfigurations = new JSONObject(value);
                jsonObject.put("SiteConfigurations", (Object)siteConfigurations);
                continue;
            }
            jsonObject.put(key, (Object)value);
        }
        return jsonObject;
    }

    private void initializeMetaStore(File rootLocation) {
        if (!SimpleMetaStoreUtil.isMetaFile(rootLocation, ROOT)) {
            SimpleMetaStoreMigration migration = new SimpleMetaStoreMigration();
            if (migration.isMigrationRequired(rootLocation)) {
                migration.doMigration(rootLocation);
            } else {
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject.put(ORION_VERSION, 4);
                }
                catch (JSONException jSONException) {
                    throw new RuntimeException("SimpleMetaStore.initializeMetaStore: could not create MetaStore");
                }
                if (!SimpleMetaStoreUtil.createMetaFile(rootLocation, ROOT, jsonObject)) {
                    throw new RuntimeException("SimpleMetaStore.initializeMetaStore: could not create MetaStore");
                }
                Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
                logger.debug("Created new simple metadata store.");
            }
        }
        JSONObject jsonObject = SimpleMetaStoreUtil.readMetaFile(rootLocation, ROOT);
        try {
            if (jsonObject == null || jsonObject.getInt(ORION_VERSION) != 4) {
                throw new RuntimeException("SimpleMetaStore.initializeMetaStore: could not read MetaStore");
            }
        }
        catch (JSONException jSONException) {
            throw new RuntimeException("SimpleMetaStore.initializeMetaStore: could not read MetaStore.");
        }
        Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
        logger.debug("Loaded simple metadata store.");
        this.rootLocation = rootLocation;
    }

    @Override
    public List<String> readAllUsers() throws CoreException {
        return SimpleMetaStoreUtil.listMetaUserFolders(this.rootLocation);
    }

    @Override
    public ProjectInfo readProject(String workspaceId, String projectName) throws CoreException {
        String userId = SimpleMetaStoreUtil.decodeUserIdFromWorkspaceId(workspaceId);
        String encodedWorkspaceName = SimpleMetaStoreUtil.decodeWorkspaceNameFromWorkspaceId(workspaceId);
        if (userId == null || encodedWorkspaceName == null) {
            return null;
        }
        File userMetaFolder = SimpleMetaStoreUtil.readMetaUserFolder(this.rootLocation, userId);
        File workspaceMetaFolder = SimpleMetaStoreUtil.readMetaFolder(userMetaFolder, encodedWorkspaceName);
        JSONObject jsonObject = SimpleMetaStoreUtil.readMetaFile(workspaceMetaFolder, projectName);
        ProjectInfo projectInfo = new ProjectInfo();
        if (jsonObject == null) {
            if (SimpleMetaStoreUtil.isMetaFolder(workspaceMetaFolder, projectName)) {
                File projectMetaFolder = SimpleMetaStoreUtil.readMetaFolder(workspaceMetaFolder, projectName);
                URI projectLocation = projectMetaFolder.toURI();
                projectInfo.setFullName(projectName);
                projectInfo.setWorkspaceId(workspaceId);
                projectInfo.setContentLocation(projectLocation);
                this.createProject(projectInfo);
                jsonObject = SimpleMetaStoreUtil.readMetaFile(workspaceMetaFolder, projectName);
            } else {
                return null;
            }
        }
        try {
            projectInfo.setUniqueId(jsonObject.getString("UniqueId"));
            projectInfo.setWorkspaceId(jsonObject.getString("WorkspaceId"));
            projectInfo.setFullName(jsonObject.getString("FullName"));
            projectInfo.setContentLocation(new URI(jsonObject.getString("ContentLocation")));
            this.setProperties(projectInfo, jsonObject.getJSONObject("Properties"));
        }
        catch (JSONException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.readProject: could not read project " + projectName + " for userId " + userId, (Throwable)e));
        }
        catch (URISyntaxException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.readProject: could not read project " + projectName + " for userId " + userId, (Throwable)e));
        }
        return projectInfo;
    }

    @Override
    public UserInfo readUser(String userId) throws CoreException {
        File userMetaFolder = SimpleMetaStoreUtil.readMetaUserFolder(this.rootLocation, userId);
        if (!SimpleMetaStoreUtil.isMetaFile(userMetaFolder, USER)) {
            UserInfo userInfo = new UserInfo();
            userInfo.setUniqueId(userId);
            userInfo.setUserName(userId);
            userInfo.setFullName("Unnamed User");
            this.createUser(userInfo);
            return userInfo;
        }
        JSONObject jsonObject = SimpleMetaStoreUtil.readMetaFile(userMetaFolder, USER);
        if (jsonObject == null) {
            Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
            logger.info("SimpleMetaStore.readUser: could not read user " + userId);
            return null;
        }
        UserInfo userInfo = new UserInfo();
        try {
            userInfo.setUniqueId(jsonObject.getString("UniqueId"));
            userInfo.setUserName(jsonObject.getString("UserName"));
            if (jsonObject.isNull("FullName")) {
                userInfo.setFullName("Unnamed User");
            } else {
                userInfo.setFullName(jsonObject.getString("FullName"));
            }
            ArrayList<String> userWorkspaceIds = new ArrayList<String>();
            JSONArray workspaceIds = jsonObject.getJSONArray("WorkspaceIds");
            if (workspaceIds.length() > 0) {
                int i = 0;
                while (i < workspaceIds.length()) {
                    userWorkspaceIds.add(workspaceIds.getString(i));
                    ++i;
                }
            }
            userInfo.setWorkspaceIds(userWorkspaceIds);
            this.setProperties(userInfo, jsonObject.getJSONObject("Properties"));
        }
        catch (JSONException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.readUser: could not read user " + userId, (Throwable)e));
        }
        return userInfo;
    }

    @Override
    public WorkspaceInfo readWorkspace(String workspaceId) throws CoreException {
        if (workspaceId == null) {
            return null;
        }
        String userName = SimpleMetaStoreUtil.decodeUserIdFromWorkspaceId(workspaceId);
        String encodedWorkspaceName = SimpleMetaStoreUtil.decodeWorkspaceNameFromWorkspaceId(workspaceId);
        if (userName == null || encodedWorkspaceName == null) {
            return null;
        }
        if (!SimpleMetaStoreUtil.isMetaUserFolder(this.rootLocation, userName)) {
            return null;
        }
        File userMetaFolder = SimpleMetaStoreUtil.readMetaUserFolder(this.rootLocation, userName);
        if (!SimpleMetaStoreUtil.isMetaFolder(userMetaFolder, encodedWorkspaceName)) {
            return null;
        }
        File workspaceMetaFolder = SimpleMetaStoreUtil.readMetaFolder(userMetaFolder, encodedWorkspaceName);
        JSONObject jsonObject = SimpleMetaStoreUtil.readMetaFile(workspaceMetaFolder, WORKSPACE);
        if (jsonObject == null) {
            return null;
        }
        WorkspaceInfo workspaceInfo = new WorkspaceInfo();
        try {
            workspaceInfo.setUniqueId(jsonObject.getString("UniqueId"));
            workspaceInfo.setUserId(jsonObject.getString("UserId"));
            workspaceInfo.setFullName(jsonObject.getString("FullName"));
            ArrayList<String> workspaceProjectNames = new ArrayList<String>();
            JSONArray projectNames = jsonObject.getJSONArray("ProjectNames");
            if (projectNames.length() > 0) {
                int i = 0;
                while (i < projectNames.length()) {
                    workspaceProjectNames.add(projectNames.getString(i));
                    ++i;
                }
            }
            workspaceInfo.setProjectNames(workspaceProjectNames);
            this.setProperties(workspaceInfo, jsonObject.getJSONObject("Properties"));
        }
        catch (JSONException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.readWorkspace: could not read workspace " + encodedWorkspaceName + " for user id " + userName, (Throwable)e));
        }
        return workspaceInfo;
    }

    private void setProperties(MetadataInfo metadataInfo, JSONObject jsonObject) throws JSONException {
        String[] properties = JSONObject.getNames((JSONObject)jsonObject);
        if (properties != null) {
            String[] stringArray = properties;
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                Object value = jsonObject.get(key);
                metadataInfo.setProperty(key, value.toString());
                ++n2;
            }
        }
    }

    @Override
    public void updateProject(ProjectInfo projectInfo) throws CoreException {
        String userId = SimpleMetaStoreUtil.decodeUserIdFromWorkspaceId(projectInfo.getWorkspaceId());
        String encodedWorkspaceName = SimpleMetaStoreUtil.decodeWorkspaceNameFromWorkspaceId(projectInfo.getWorkspaceId());
        File userMetaFolder = SimpleMetaStoreUtil.readMetaUserFolder(this.rootLocation, userId);
        File workspaceMetaFolder = SimpleMetaStoreUtil.readMetaFolder(userMetaFolder, encodedWorkspaceName);
        if (!SimpleMetaStoreUtil.isMetaFile(workspaceMetaFolder, projectInfo.getUniqueId())) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.updateProject: could not update project: " + projectInfo.getFullName() + " for workspace " + encodedWorkspaceName, null));
        }
        JSONObject jsonObject = SimpleMetaStoreUtil.readMetaFile(workspaceMetaFolder, projectInfo.getUniqueId());
        if (!projectInfo.getUniqueId().equals(projectInfo.getFullName())) {
            WorkspaceInfo workspaceInfo;
            File oldContentLocation;
            if (!SimpleMetaStoreUtil.moveMetaFile(workspaceMetaFolder, projectInfo.getUniqueId(), projectInfo.getFullName())) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.updateProject: could not move project: " + projectInfo.getUniqueId() + " to " + projectInfo.getFullName() + " for workspace " + encodedWorkspaceName, null));
            }
            if (!SimpleMetaStoreUtil.moveMetaFolder(workspaceMetaFolder, projectInfo.getUniqueId(), projectInfo.getFullName())) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.updateProject: could not move project: " + projectInfo.getUniqueId() + " to " + projectInfo.getFullName() + " for workspace " + encodedWorkspaceName, null));
            }
            if (projectInfo.getContentLocation().getScheme().equals("file") && workspaceMetaFolder.equals((oldContentLocation = new File(projectInfo.getContentLocation())).getParent())) {
                projectInfo.setContentLocation(new File(workspaceMetaFolder, projectInfo.getFullName()).toURI());
            }
            try {
                workspaceInfo = this.readWorkspace(projectInfo.getWorkspaceId());
            }
            catch (CoreException coreException) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.updateProject: could not find workspace with id:" + projectInfo.getWorkspaceId() + ".", null));
            }
            ArrayList<String> newProjectNames = new ArrayList<String>();
            newProjectNames.addAll(workspaceInfo.getProjectNames());
            newProjectNames.remove(projectInfo.getUniqueId());
            newProjectNames.add(projectInfo.getFullName());
            workspaceInfo.setProjectNames(newProjectNames);
            this.updateWorkspace(workspaceInfo);
            projectInfo.setUniqueId(projectInfo.getFullName());
        } else if (projectInfo.getProperty("newUserId") != null) {
            String newUserId = projectInfo.getProperty("newUserId");
            String newWorkspaceId = projectInfo.getProperty("newWorkspaceId");
            projectInfo.setWorkspaceId(newWorkspaceId);
            if (projectInfo.getContentLocation().getScheme().equals("file")) {
                try {
                    File oldContentLocation = new File(projectInfo.getContentLocation());
                    if (workspaceMetaFolder.getCanonicalPath().equals(oldContentLocation.getParent())) {
                        String newEncodedWorkspaceName = SimpleMetaStoreUtil.decodeWorkspaceNameFromWorkspaceId(newWorkspaceId);
                        File newUserMetaFolder = SimpleMetaStoreUtil.readMetaUserFolder(this.rootLocation, newUserId);
                        File newWorkspaceMetaFolder = new File(newUserMetaFolder, newEncodedWorkspaceName);
                        projectInfo.setContentLocation(new File(newWorkspaceMetaFolder, projectInfo.getFullName()).toURI());
                    }
                }
                catch (IOException iOException) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.updateProject: could not update project: " + projectInfo.getFullName() + " for workspace " + encodedWorkspaceName, null));
                }
            }
            projectInfo.setProperty("newUserId", null);
            projectInfo.setProperty("newWorkspaceId", null);
        }
        try {
            jsonObject.put(ORION_VERSION, 4);
            jsonObject.put("UniqueId", (Object)projectInfo.getUniqueId());
            jsonObject.put("WorkspaceId", (Object)projectInfo.getWorkspaceId());
            jsonObject.put("FullName", (Object)projectInfo.getFullName());
            jsonObject.put("ContentLocation", (Object)projectInfo.getContentLocation());
            JSONObject properties = new JSONObject(projectInfo.getProperties());
            jsonObject.put("Properties", (Object)properties);
        }
        catch (JSONException jSONException) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.updateProject: could not update project: " + projectInfo.getFullName() + " for workspace " + encodedWorkspaceName, null));
        }
        if (!SimpleMetaStoreUtil.updateMetaFile(workspaceMetaFolder, projectInfo.getFullName(), jsonObject)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.updateProject: could not update project: " + projectInfo.getFullName() + " for workspace " + encodedWorkspaceName, null));
        }
    }

    @Override
    public void updateUser(UserInfo userInfo) throws CoreException {
        File userMetaFolder;
        JSONObject jsonObject;
        if (userInfo.getUserName() == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.updateUser: user name is null.", null));
        }
        if (!userInfo.getUniqueId().equals(userInfo.getUserName())) {
            String oldUserId = userInfo.getUniqueId();
            String newUserId = userInfo.getUserName();
            List<String> oldWorkspaceIds = userInfo.getWorkspaceIds();
            ArrayList<String> newWorkspaceIds = new ArrayList<String>();
            for (String oldWorkspaceId : oldWorkspaceIds) {
                WorkspaceInfo workspaceInfo = this.readWorkspace(oldWorkspaceId);
                workspaceInfo.setUserId(newUserId);
                this.updateWorkspace(workspaceInfo);
                String newWorkspaceId = workspaceInfo.getUniqueId();
                newWorkspaceIds.add(newWorkspaceId);
                List<String> projectNames = workspaceInfo.getProjectNames();
                for (String projectName : projectNames) {
                    ProjectInfo projectInfo = this.readProject(oldWorkspaceId, projectName);
                    projectInfo.setProperty("newUserId", newUserId);
                    projectInfo.setProperty("newWorkspaceId", newWorkspaceId);
                    this.updateProject(projectInfo);
                }
            }
            try {
                JSONObject properties = this.getUserProperties(userInfo);
                if (properties.has("UserRights")) {
                    JSONArray userRights = properties.getJSONArray("UserRights");
                    int i = 0;
                    while (i < userRights.length()) {
                        JSONObject userRight = userRights.getJSONObject(i);
                        String uri = userRight.getString("Uri");
                        if (uri.contains(oldUserId)) {
                            uri = uri.replace(oldUserId, newUserId);
                            userRight.put("Uri", (Object)uri);
                        }
                        ++i;
                    }
                    properties.put("UserRights", (Object)userRights);
                }
                this.setProperties(userInfo, properties);
            }
            catch (JSONException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.updateUser: user name " + userInfo.getUserName() + " already exists, cannot rename from " + userInfo.getUniqueId(), (Throwable)e));
            }
            userInfo.setWorkspaceIds(newWorkspaceIds);
            if (SimpleMetaStoreUtil.isMetaUserFolder(this.rootLocation, newUserId)) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.updateUser: user name " + userInfo.getUserName() + " already exists, cannot rename from " + userInfo.getUniqueId(), null));
            }
            if (!SimpleMetaStoreUtil.isMetaUserFolder(this.rootLocation, oldUserId)) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.updateUser: user name " + userInfo.getUniqueId() + " does not exist, cannot rename to " + userInfo.getUserName(), null));
            }
            File oldUserMetaFolder = SimpleMetaStoreUtil.readMetaUserFolder(this.rootLocation, oldUserId);
            File newUserMetaFolder = SimpleMetaStoreUtil.readMetaUserFolder(this.rootLocation, newUserId);
            SimpleMetaStoreUtil.moveUserMetaFolder(oldUserMetaFolder, newUserMetaFolder);
            userInfo.setUniqueId(newUserId);
            Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
            logger.debug("Moved MetaStore for user " + oldUserId + " to user " + newUserId + ".");
        }
        if ((jsonObject = SimpleMetaStoreUtil.readMetaFile(userMetaFolder = SimpleMetaStoreUtil.readMetaUserFolder(this.rootLocation, userInfo.getUserName()), USER)) == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.updateUser: could not find user " + userInfo.getUserName(), null));
        }
        try {
            jsonObject.put("UniqueId", (Object)userInfo.getUniqueId());
            jsonObject.put("UserName", (Object)userInfo.getUserName());
            jsonObject.put("FullName", (Object)userInfo.getFullName());
            JSONArray workspaceIds = new JSONArray(userInfo.getWorkspaceIds());
            jsonObject.put("WorkspaceIds", (Object)workspaceIds);
            JSONObject properties = this.getUserProperties(userInfo);
            jsonObject.put("Properties", (Object)properties);
        }
        catch (JSONException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.updateUser: could not update user: " + userInfo.getUserName(), (Throwable)e));
        }
        if (!SimpleMetaStoreUtil.updateMetaFile(userMetaFolder, USER, jsonObject)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.updateUser: could not update user: " + userInfo.getUserName(), null));
        }
    }

    @Override
    public void updateWorkspace(WorkspaceInfo workspaceInfo) throws CoreException {
        String userName = SimpleMetaStoreUtil.decodeUserIdFromWorkspaceId(workspaceInfo.getUniqueId());
        String workspaceName = SimpleMetaStoreUtil.decodeWorkspaceNameFromWorkspaceId(workspaceInfo.getUniqueId());
        boolean renameUser = false;
        String newWorkspaceId = null;
        if (!workspaceInfo.getUserId().equals(userName)) {
            renameUser = true;
            newWorkspaceId = SimpleMetaStoreUtil.encodeWorkspaceId(workspaceInfo.getUserId(), workspaceName);
        }
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put(ORION_VERSION, 4);
            if (renameUser) {
                jsonObject.put("UniqueId", (Object)newWorkspaceId);
            } else {
                jsonObject.put("UniqueId", (Object)workspaceInfo.getUniqueId());
            }
            jsonObject.put("UserId", (Object)workspaceInfo.getUserId());
            jsonObject.put("FullName", (Object)workspaceInfo.getFullName());
            JSONArray projectNames = new JSONArray(workspaceInfo.getProjectNames());
            jsonObject.put("ProjectNames", (Object)projectNames);
            JSONObject properties = new JSONObject(workspaceInfo.getProperties());
            jsonObject.put("Properties", (Object)properties);
        }
        catch (JSONException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.updateWorkspace: could not update workspace: " + workspaceName + " for user " + userName, (Throwable)e));
        }
        File userMetaFolder = SimpleMetaStoreUtil.readMetaUserFolder(this.rootLocation, userName);
        File workspaceMetaFolder = SimpleMetaStoreUtil.readMetaFolder(userMetaFolder, workspaceName);
        if (!SimpleMetaStoreUtil.updateMetaFile(workspaceMetaFolder, WORKSPACE, jsonObject)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.updateWorkspace: could not update workspace: " + workspaceName + " for user " + userName, null));
        }
        if (renameUser) {
            workspaceInfo.setUniqueId(newWorkspaceId);
        }
    }
}

