/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.core.metastore;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMetaStoreUtil {
    public static final String METAFILE_EXTENSION = ".json";
    public static final String SEPARATOR = "-";
    public static final String USER = "user";

    public static boolean createMetaFile(File parent, String name, JSONObject jsonObject) {
        try {
            if (SimpleMetaStoreUtil.isMetaFile(parent, name)) {
                throw new RuntimeException("Meta File Error, already exists, use update");
            }
            if (!parent.exists()) {
                throw new RuntimeException("Meta File Error, parent folder does not exist");
            }
            if (!parent.isDirectory()) {
                throw new RuntimeException("Meta File Error, parent is not a folder");
            }
            File newFile = SimpleMetaStoreUtil.retrieveMetaFile(parent, name);
            FileWriter fileWriter = new FileWriter(newFile);
            fileWriter.write(jsonObject.toString(4));
            fileWriter.write("\n");
            fileWriter.flush();
            fileWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
            logger.warn("Meta File Error, cannot create file under " + parent.toString() + ": invalid file name: " + name);
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException("Meta File Error, file IO error", e);
        }
        catch (JSONException e) {
            throw new RuntimeException("Meta File Error, JSON error", e);
        }
        return true;
    }

    public static boolean createMetaFolder(File parent, String name) {
        if (!parent.exists()) {
            throw new RuntimeException("Meta File Error, parent folder does not exist");
        }
        if (!parent.isDirectory()) {
            throw new RuntimeException("Meta File Error, parent is not a folder");
        }
        File newFolder = new File(parent, name);
        if (newFolder.exists()) {
            return true;
        }
        if (!newFolder.mkdir()) {
            Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
            logger.warn("Meta File Error, cannot create folder under " + newFolder.toString() + ": invalid folder name: " + name);
            return false;
        }
        return true;
    }

    public static boolean createMetaUserFolder(File parent, String userName) {
        if (!parent.exists()) {
            throw new RuntimeException("Meta File Error, parent folder does not exist");
        }
        if (!parent.isDirectory()) {
            throw new RuntimeException("Meta File Error, parent is not a folder");
        }
        String userPrefix = userName.substring(0, Math.min(2, userName.length()));
        File orgFolder = new File(parent, userPrefix);
        if (!orgFolder.exists() && !orgFolder.mkdir()) {
            throw new RuntimeException("Meta File Error, cannot create folder");
        }
        return SimpleMetaStoreUtil.createMetaFolder(orgFolder, userName);
    }

    public static String decodeUserIdFromWorkspaceId(String workspaceId) {
        if (workspaceId.indexOf(SEPARATOR) == -1) {
            return null;
        }
        return workspaceId.substring(0, workspaceId.indexOf(SEPARATOR));
    }

    public static String decodeWorkspaceNameFromWorkspaceId(String workspaceId) {
        if (workspaceId.indexOf(SEPARATOR) == -1) {
            return null;
        }
        return workspaceId.substring(workspaceId.indexOf(SEPARATOR) + 1);
    }

    public static boolean deleteMetaFile(File parent, String name) {
        if (!SimpleMetaStoreUtil.isMetaFile(parent, name)) {
            throw new RuntimeException("Meta File Error, cannot delete, does not exist.");
        }
        File savedFile = SimpleMetaStoreUtil.retrieveMetaFile(parent, name);
        if (!savedFile.delete()) {
            throw new RuntimeException("Meta File Error, cannot delete file.");
        }
        return true;
    }

    public static boolean deleteMetaFolder(File parent, String name, boolean exceptionWhenNotEmpty) {
        if (!SimpleMetaStoreUtil.isMetaFolder(parent, name)) {
            throw new RuntimeException("Meta File Error, cannot delete, does not exist.");
        }
        File folder = SimpleMetaStoreUtil.retrieveMetaFolder(parent, name);
        if (!folder.delete()) {
            if (exceptionWhenNotEmpty) {
                throw new RuntimeException("Meta File Error, cannot delete, not empty.");
            }
            return false;
        }
        return true;
    }

    public static boolean deleteMetaUserFolder(File parent, String userName) {
        String[] files = parent.list();
        if (files.length != 0) {
            throw new RuntimeException("Meta File Error, cannot delete, not empty.");
        }
        if (!parent.delete()) {
            throw new RuntimeException("Meta File Error, cannot delete folder.");
        }
        File orgFolder = parent.getParentFile();
        files = orgFolder.list();
        if (files.length != 0) {
            return true;
        }
        if (!orgFolder.delete()) {
            throw new RuntimeException("Meta File Error, cannot delete folder.");
        }
        return true;
    }

    public static String encodeWorkspaceId(String userName, String workspaceName) {
        String workspaceId = workspaceName.replace(" ", "").replace("#", "");
        return String.valueOf(userName) + SEPARATOR + workspaceId;
    }

    public static boolean isMetaFile(File parent, String name) {
        if (!parent.exists()) {
            return false;
        }
        if (!parent.isDirectory()) {
            return false;
        }
        File savedFile = SimpleMetaStoreUtil.retrieveMetaFile(parent, name);
        if (!savedFile.exists()) {
            return false;
        }
        return savedFile.isFile();
    }

    public static boolean isMetaFolder(File parent, String name) {
        if (!parent.exists()) {
            return false;
        }
        if (!parent.isDirectory()) {
            return false;
        }
        File savedFolder = SimpleMetaStoreUtil.retrieveMetaFolder(parent, name);
        if (!savedFolder.exists()) {
            return false;
        }
        return savedFolder.isDirectory();
    }

    public static boolean isMetaUserFolder(File parent, String userName) {
        if (!parent.exists()) {
            throw new RuntimeException("Meta File Error, parent folder does not exist");
        }
        if (!parent.isDirectory()) {
            throw new RuntimeException("Meta File Error, parent is not a folder");
        }
        String userPrefix = userName.substring(0, Math.min(2, userName.length()));
        File orgFolder = new File(parent, userPrefix);
        if (!orgFolder.exists()) {
            return false;
        }
        if (!SimpleMetaStoreUtil.isMetaFolder(orgFolder, userName)) {
            return false;
        }
        File userFolder = SimpleMetaStoreUtil.retrieveMetaFolder(orgFolder, userName);
        return SimpleMetaStoreUtil.isMetaFile(userFolder, USER);
    }

    public static List<String> listMetaFiles(File parent) {
        ArrayList<String> savedFiles = new ArrayList<String>();
        File[] fileArray = parent.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                savedFiles.add(file.getName());
            } else if (!file.isFile() || !file.getName().endsWith(METAFILE_EXTENSION)) {
                throw new RuntimeException("Meta File Error, contains invalid metadata:" + parent.toString() + " at " + file.getName());
            }
            ++n2;
        }
        return savedFiles;
    }

    public static List<String> listMetaUserFolders(File parent) {
        ArrayList<String> userMetaFolders = new ArrayList<String>();
        File[] fileArray = parent.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!(file.getName().equals(".metadata") || file.isFile() && file.getName().endsWith(METAFILE_EXTENSION))) {
                if (file.isDirectory()) {
                    File[] fileArray2 = file.listFiles();
                    int n3 = fileArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File userFolder = fileArray2[n4];
                        if (SimpleMetaStoreUtil.isMetaUserFolder(parent, userFolder.getName())) {
                            userMetaFolders.add(userFolder.getName());
                        } else {
                            Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
                            logger.warn("Meta File Error, root contains invalid metadata: folder " + file.toString() + "/" + userFolder.getName());
                        }
                        ++n4;
                    }
                } else {
                    Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
                    logger.warn("Meta File Error, root contains invalid metadata: file " + file.toString());
                }
            }
            ++n2;
        }
        return userMetaFolders;
    }

    public static boolean moveMetaFile(File parent, String oldName, String newName) {
        if (!SimpleMetaStoreUtil.isMetaFile(parent, oldName)) {
            return false;
        }
        File oldFile = SimpleMetaStoreUtil.retrieveMetaFile(parent, oldName);
        File newFile = SimpleMetaStoreUtil.retrieveMetaFile(parent, newName);
        return oldFile.renameTo(newFile);
    }

    public static boolean moveMetaFolder(File parent, String oldName, String newName) {
        if (!SimpleMetaStoreUtil.isMetaFolder(parent, oldName)) {
            return false;
        }
        File oldFolder = SimpleMetaStoreUtil.retrieveMetaFolder(parent, oldName);
        File newFolder = SimpleMetaStoreUtil.retrieveMetaFolder(parent, newName);
        return oldFolder.renameTo(newFolder);
    }

    public static boolean moveUserMetaFolder(File oldUserMetaFolder, File newUserMetaFolder) {
        if (!oldUserMetaFolder.exists()) {
            throw new RuntimeException("Meta File Error, parent folder does not exist");
        }
        if (!oldUserMetaFolder.isDirectory()) {
            throw new RuntimeException("Meta File Error, parent is not a folder");
        }
        if (newUserMetaFolder.exists()) {
            throw new RuntimeException("Meta File Error, new folder already exists");
        }
        File orgFolder = newUserMetaFolder.getParentFile();
        if (!orgFolder.exists() && !orgFolder.mkdir()) {
            throw new RuntimeException("Meta File Error, mkdir failed for " + orgFolder.toString());
        }
        if (!oldUserMetaFolder.renameTo(newUserMetaFolder)) {
            throw new RuntimeException("Meta File Error, renameTo failed");
        }
        orgFolder = oldUserMetaFolder.getParentFile();
        String[] files = orgFolder.list();
        if (files.length != 0) {
            return true;
        }
        if (!orgFolder.delete()) {
            throw new RuntimeException("Meta File Error, cannot delete folder.");
        }
        return true;
    }

    public static JSONObject readMetaFile(File parent, String name) {
        JSONObject jsonObject;
        block5: {
            if (SimpleMetaStoreUtil.isMetaFile(parent, name)) break block5;
            return null;
        }
        try {
            File savedFile = SimpleMetaStoreUtil.retrieveMetaFile(parent, name);
            FileReader fileReader = new FileReader(savedFile);
            char[] chars = new char[(int)savedFile.length()];
            fileReader.read(chars);
            fileReader.close();
            jsonObject = new JSONObject(new String(chars));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Meta File Error, file not found", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Meta File Error, file IO error", e);
        }
        catch (JSONException e) {
            throw new RuntimeException("Meta File Error, could not build JSON", e);
        }
        return jsonObject;
    }

    public static File readMetaFolder(File parent, String name) {
        if (!SimpleMetaStoreUtil.isMetaFolder(parent, name)) {
            return null;
        }
        return SimpleMetaStoreUtil.retrieveMetaFolder(parent, name);
    }

    public static File readMetaUserFolder(File parent, String userName) {
        String userPrefix = userName.substring(0, Math.min(2, userName.length()));
        File orgFolder = new File(parent, userPrefix);
        return new File(orgFolder, userName);
    }

    public static File retrieveMetaFile(File parent, String name) {
        return new File(parent, String.valueOf(name) + METAFILE_EXTENSION);
    }

    public static File retrieveMetaFolder(File parent, String name) {
        return new File(parent, name);
    }

    public static boolean updateMetaFile(File parent, String name, JSONObject jsonObject) {
        try {
            if (!SimpleMetaStoreUtil.isMetaFile(parent, name)) {
                throw new RuntimeException("Meta File Error, cannot update, does not exist.");
            }
            File savedFile = SimpleMetaStoreUtil.retrieveMetaFile(parent, name);
            FileWriter fileWriter = new FileWriter(savedFile);
            fileWriter.write(jsonObject.toString(4));
            fileWriter.write("\n");
            fileWriter.flush();
            fileWriter.close();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Meta File Error, file not found", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Meta File Error, file IO error", e);
        }
        catch (JSONException e) {
            throw new RuntimeException("Meta File Error, JSON error", e);
        }
        return true;
    }
}

