/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.RebaseResult;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.api.errors.UnmergedPathsException;
import org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RebaseCommand
extends GitCommand<RebaseResult> {
    public static final String REBASE_MERGE = "rebase-merge";
    private static final String REBASE_APPLY = "rebase-apply";
    public static final String STOPPED_SHA = "stopped-sha";
    private static final String AUTHOR_SCRIPT = "author-script";
    private static final String DONE = "done";
    private static final String GIT_AUTHOR_DATE = "GIT_AUTHOR_DATE";
    private static final String GIT_AUTHOR_EMAIL = "GIT_AUTHOR_EMAIL";
    private static final String GIT_AUTHOR_NAME = "GIT_AUTHOR_NAME";
    private static final String GIT_REBASE_TODO = "git-rebase-todo";
    private static final String HEAD_NAME = "head-name";
    private static final String INTERACTIVE = "interactive";
    private static final String MESSAGE = "message";
    private static final String ONTO = "onto";
    private static final String ONTO_NAME = "onto-name";
    private static final String PATCH = "patch";
    private static final String REBASE_HEAD = "head";
    private static final String AMEND = "amend";
    private Operation operation = Operation.BEGIN;
    private RevCommit upstreamCommit;
    private String upstreamCommitName;
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;
    private final RevWalk walk;
    private final RebaseState rebaseState;
    private InteractiveHandler interactiveHandler;

    protected RebaseCommand(Repository repo) {
        super(repo);
        this.walk = new RevWalk(repo);
        this.rebaseState = new RebaseState(repo.getDirectory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RebaseResult call() throws GitAPIException, NoHeadException, RefNotFoundException, WrongRepositoryStateException {
        newHead = null;
        lastStepWasForward = false;
        this.checkCallable();
        this.checkParameters();
        try {
            switch (1.$SwitchMap$org$eclipse$jgit$api$RebaseCommand$Operation[this.operation.ordinal()]) {
                case 1: {
                    try {
                        return this.abort(RebaseResult.ABORTED_RESULT);
                    }
                    catch (IOException ioe) {
                        throw new JGitInternalException(ioe.getMessage(), ioe);
                    }
                }
                case 2: 
                case 3: {
                    upstreamCommitId = this.rebaseState.readFile("onto");
                    try {
                        this.upstreamCommitName = this.rebaseState.readFile("onto-name");
                    }
                    catch (FileNotFoundException e) {
                        this.upstreamCommitName = upstreamCommitId;
                    }
                    this.upstreamCommit = this.walk.parseCommit(this.repo.resolve(upstreamCommitId));
                    break;
                }
                case 4: {
                    res = this.initFilesAndRewind();
                    if (res == null) break;
                    return res;
                }
            }
            if (this.monitor.isCancelled()) {
                return this.abort(RebaseResult.ABORTED_RESULT);
            }
            if (this.operation == Operation.CONTINUE) {
                newHead = this.continueRebase();
                amendFile = this.rebaseState.getFile("amend");
                amendExists = amendFile.exists();
                if (amendExists) {
                    FileUtils.delete(amendFile);
                }
                if (newHead == null && !amendExists) {
                    return RebaseResult.NOTHING_TO_COMMIT_RESULT;
                }
            }
            if (this.operation == Operation.SKIP) {
                newHead = this.checkoutCurrentHead();
            }
            or = this.repo.newObjectReader();
            steps = this.loadSteps();
            if (this.isInteractive()) {
                this.interactiveHandler.prepareSteps(steps);
                fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.rebaseState.getFile("git-rebase-todo")), "UTF-8"));
                fw.newLine();
                try {
                    sb = new StringBuilder();
                    for (Step step : steps) {
                        sb.setLength(0);
                        sb.append(Action.access$000(step.action));
                        sb.append(" ");
                        sb.append(step.commit.name());
                        sb.append(" ");
                        sb.append(RawParseUtils.decode(step.shortMessage).trim());
                        fw.write(sb.toString());
                        fw.newLine();
                    }
                }
                finally {
                    fw.close();
                }
            }
            i$ = steps.iterator();
            while (true) lbl-1000:
            // 5 sources

            {
                if (!i$.hasNext()) {
                    if (newHead == null) return RebaseResult.FAST_FORWARD_RESULT;
                    headName = this.rebaseState.readFile("head-name");
                    this.updateHead(headName, newHead);
                    FileUtils.delete(this.rebaseState.getDir(), 1);
                    if (lastStepWasForward == false) return RebaseResult.OK_RESULT;
                    return RebaseResult.FAST_FORWARD_RESULT;
                }
                step = i$.next();
                this.popSteps(1);
                ids = or.resolve(step.commit);
                if (ids.size() != 1) {
                    throw new JGitInternalException("Could not resolve uniquely the abbreviated object ID");
                }
                commitToPick = this.walk.parseCommit(ids.iterator().next());
                if (this.monitor.isCancelled()) {
                    return new RebaseResult(commitToPick);
                }
                try {
                    this.monitor.beginTask(MessageFormat.format(JGitText.get().applyingCommit, new Object[]{commitToPick.getShortMessage()}), 0);
                    newHead = this.tryFastForward(commitToPick);
                    v0 = lastStepWasForward = newHead != null;
                    if (!lastStepWasForward) {
                        ourCommitName = this.getOurCommitName();
                        cherryPickResult = new Git(this.repo).cherryPick().include(commitToPick).setOurCommitName(ourCommitName).call();
                        switch (1.$SwitchMap$org$eclipse$jgit$api$CherryPickResult$CherryPickStatus[cherryPickResult.getStatus().ordinal()]) {
                            case 1: {
                                if (this.operation == Operation.BEGIN) {
                                    var11_18 = this.abort(new RebaseResult(cherryPickResult.getFailingPaths()));
                                    return var11_18;
                                }
                                var11_19 = this.stop(commitToPick);
                                return var11_19;
                            }
                            case 2: {
                                var11_20 = this.stop(commitToPick);
                                return var11_20;
                            }
                            case 3: {
                                newHead = cherryPickResult.getNewHead();
                                break;
                            }
                        }
                    }
                    switch (1.$SwitchMap$org$eclipse$jgit$api$RebaseCommand$Action[step.action.ordinal()]) {
                        case 1: {
                        }
                        case 2: {
                            oldMessage = commitToPick.getFullMessage();
                            newMessage = this.interactiveHandler.modifyCommitMessage(oldMessage);
                            newHead = new Git(this.repo).commit().setMessage(newMessage).setAmend(true).call();
                        }
                        case 3: {
                            this.rebaseState.createFile("amend", commitToPick.name());
                            var11_21 = this.stop(commitToPick);
                            return var11_21;
                        }
                    }
                }
                finally {
                    this.monitor.endTask();
                    continue;
                }
                break;
            }
        }
        catch (CheckoutConflictException cce) {
            return new RebaseResult(cce.getConflictingPaths());
        }
        catch (IOException ioe) {
            throw new JGitInternalException(ioe.getMessage(), ioe);
        }
        ** GOTO lbl-1000
    }

    private String getOurCommitName() {
        String ourCommitName = "Upstream, based on " + Repository.shortenRefName(this.upstreamCommitName);
        return ourCommitName;
    }

    private void updateHead(String headName, RevCommit newHead) throws IOException {
        if (headName.startsWith("refs/")) {
            RefUpdate rup = this.repo.updateRef(headName);
            rup.setNewObjectId(newHead);
            RefUpdate.Result res = rup.forceUpdate();
            switch (res) {
                case FAST_FORWARD: 
                case FORCED: 
                case NO_CHANGE: {
                    break;
                }
                default: {
                    throw new JGitInternalException("Updating HEAD failed");
                }
            }
            rup = this.repo.updateRef("HEAD");
            res = rup.link(headName);
            switch (res) {
                case FAST_FORWARD: 
                case FORCED: 
                case NO_CHANGE: {
                    break;
                }
                default: {
                    throw new JGitInternalException("Updating HEAD failed");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RevCommit checkoutCurrentHead() throws IOException, NoHeadException {
        ObjectId headTree = this.repo.resolve("HEAD^{tree}");
        if (headTree == null) {
            throw new NoHeadException(JGitText.get().cannotRebaseWithoutCurrentHead);
        }
        DirCache dc = this.repo.lockDirCache();
        try {
            DirCacheCheckout dco = new DirCacheCheckout(this.repo, dc, headTree);
            dco.setFailOnConflict(false);
            boolean needsDeleteFiles = dco.checkout();
            if (needsDeleteFiles) {
                List<String> fileList = dco.getToBeDeleted();
                for (String filePath : fileList) {
                    File fileToDelete = new File(this.repo.getWorkTree(), filePath);
                    if (!fileToDelete.exists()) continue;
                    FileUtils.delete(fileToDelete, 3);
                }
            }
        }
        finally {
            dc.unlock();
        }
        RevWalk rw = new RevWalk(this.repo);
        RevCommit commit = rw.parseCommit(this.repo.resolve("HEAD"));
        rw.release();
        return commit;
    }

    private RevCommit continueRebase() throws GitAPIException, IOException {
        DirCache dc = this.repo.readDirCache();
        boolean hasUnmergedPaths = dc.hasUnmergedPaths();
        if (hasUnmergedPaths) {
            throw new UnmergedPathsException();
        }
        TreeWalk treeWalk = new TreeWalk(this.repo);
        treeWalk.reset();
        treeWalk.setRecursive(true);
        treeWalk.addTree(new DirCacheIterator(dc));
        ObjectId id = this.repo.resolve("HEAD^{tree}");
        if (id == null) {
            throw new NoHeadException(JGitText.get().cannotRebaseWithoutCurrentHead);
        }
        treeWalk.addTree(id);
        treeWalk.setFilter(TreeFilter.ANY_DIFF);
        boolean needsCommit = treeWalk.next();
        treeWalk.release();
        if (needsCommit) {
            CommitCommand commit = new Git(this.repo).commit();
            commit.setMessage(this.rebaseState.readFile(MESSAGE));
            commit.setAuthor(this.parseAuthor());
            return commit.call();
        }
        return null;
    }

    private PersonIdent parseAuthor() throws IOException {
        byte[] raw;
        File authorScriptFile = this.rebaseState.getFile(AUTHOR_SCRIPT);
        try {
            raw = IO.readFully(authorScriptFile);
        }
        catch (FileNotFoundException notFound) {
            return null;
        }
        return this.parseAuthor(raw);
    }

    private RebaseResult stop(RevCommit commitToPick) throws IOException {
        PersonIdent author = commitToPick.getAuthorIdent();
        String authorScript = this.toAuthorScript(author);
        this.rebaseState.createFile(AUTHOR_SCRIPT, authorScript);
        this.rebaseState.createFile(MESSAGE, commitToPick.getFullMessage());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DiffFormatter df = new DiffFormatter(bos);
        df.setRepository(this.repo);
        df.format(commitToPick.getParent(0), commitToPick);
        this.rebaseState.createFile(PATCH, new String(bos.toByteArray(), "UTF-8"));
        this.rebaseState.createFile(STOPPED_SHA, this.repo.newObjectReader().abbreviate(commitToPick).name());
        this.repo.writeCherryPickHead(null);
        return new RebaseResult(commitToPick);
    }

    String toAuthorScript(PersonIdent author) {
        StringBuilder sb = new StringBuilder(100);
        sb.append(GIT_AUTHOR_NAME);
        sb.append("='");
        sb.append(author.getName());
        sb.append("'\n");
        sb.append(GIT_AUTHOR_EMAIL);
        sb.append("='");
        sb.append(author.getEmailAddress());
        sb.append("'\n");
        sb.append(GIT_AUTHOR_DATE);
        sb.append("='");
        sb.append("@");
        String externalString = author.toExternalString();
        sb.append(externalString.substring(externalString.lastIndexOf(62) + 2));
        sb.append("'\n");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popSteps(int numSteps) throws IOException {
        if (numSteps == 0) {
            return;
        }
        ArrayList<String> todoLines = new ArrayList<String>();
        ArrayList<String> poppedLines = new ArrayList<String>();
        File todoFile = this.rebaseState.getFile(GIT_REBASE_TODO);
        File doneFile = this.rebaseState.getFile(DONE);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(todoFile), "UTF-8"));
        try {
            String popCandidate;
            while (poppedLines.size() < numSteps && (popCandidate = br.readLine()) != null) {
                if (popCandidate.length() == 0 || popCandidate.charAt(0) == '#') continue;
                int spaceIndex = popCandidate.indexOf(32);
                boolean pop = false;
                if (spaceIndex >= 0) {
                    String actionToken = popCandidate.substring(0, spaceIndex);
                    boolean bl = pop = Action.parse(actionToken) != null;
                }
                if (pop) {
                    poppedLines.add(popCandidate);
                    continue;
                }
                todoLines.add(popCandidate);
            }
            String readLine = br.readLine();
            while (readLine != null) {
                todoLines.add(readLine);
                readLine = br.readLine();
            }
        }
        finally {
            br.close();
        }
        BufferedWriter todoWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(todoFile), "UTF-8"));
        try {
            for (String writeLine : todoLines) {
                todoWriter.write(writeLine);
                todoWriter.newLine();
            }
        }
        finally {
            todoWriter.close();
        }
        if (poppedLines.size() > 0) {
            BufferedWriter doneWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(doneFile, true), "UTF-8"));
            try {
                for (String writeLine : poppedLines) {
                    doneWriter.write(writeLine);
                    doneWriter.newLine();
                }
            }
            finally {
                doneWriter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RebaseResult initFilesAndRewind() throws IOException, GitAPIException {
        Ref head = this.repo.getRef("HEAD");
        if (head == null || head.getObjectId() == null) {
            throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, "HEAD"));
        }
        String headName = head.isSymbolic() ? head.getTarget().getName() : "detached HEAD";
        ObjectId headId = head.getObjectId();
        if (headId == null) {
            throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, "HEAD"));
        }
        RevCommit headCommit = this.walk.lookupCommit(headId);
        RevCommit upstream = this.walk.lookupCommit(this.upstreamCommit.getId());
        if (!this.isInteractive() && this.walk.isMergedInto(upstream, headCommit)) {
            return RebaseResult.UP_TO_DATE_RESULT;
        }
        if (!this.isInteractive() && this.walk.isMergedInto(headCommit, upstream)) {
            this.monitor.beginTask(MessageFormat.format(JGitText.get().resettingHead, this.upstreamCommit.getShortMessage()), 0);
            this.checkoutCommit(this.upstreamCommit);
            this.monitor.endTask();
            this.updateHead(headName, this.upstreamCommit);
            return RebaseResult.FAST_FORWARD_RESULT;
        }
        this.monitor.beginTask(JGitText.get().obtainingCommitsForCherryPick, 0);
        LogCommand cmd = new Git(this.repo).log().addRange(this.upstreamCommit, headCommit);
        Object commitsToUse = cmd.call();
        ArrayList<RevCommit> cherryPickList = new ArrayList<RevCommit>();
        Iterator i$ = commitsToUse.iterator();
        while (i$.hasNext()) {
            RevCommit commit = (RevCommit)i$.next();
            if (commit.getParentCount() != 1) continue;
            cherryPickList.add(commit);
        }
        Collections.reverse(cherryPickList);
        FileUtils.mkdir(this.rebaseState.getDir());
        this.repo.writeOrigHead(headId);
        this.rebaseState.createFile(REBASE_HEAD, headId.name());
        this.rebaseState.createFile(HEAD_NAME, headName);
        this.rebaseState.createFile(ONTO, this.upstreamCommit.name());
        this.rebaseState.createFile(ONTO_NAME, this.upstreamCommitName);
        this.rebaseState.createFile(INTERACTIVE, "");
        BufferedWriter fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.rebaseState.getFile(GIT_REBASE_TODO)), "UTF-8"));
        fw.write("# Created by EGit: rebasing " + this.upstreamCommit.name() + " onto " + headId.name());
        fw.newLine();
        try {
            StringBuilder sb = new StringBuilder();
            ObjectReader reader = this.walk.getObjectReader();
            for (RevCommit commit : cherryPickList) {
                sb.setLength(0);
                sb.append(Action.PICK.toToken());
                sb.append(" ");
                sb.append(reader.abbreviate(commit).name());
                sb.append(" ");
                sb.append(commit.getShortMessage());
                fw.write(sb.toString());
                fw.newLine();
            }
        }
        finally {
            fw.close();
        }
        this.monitor.endTask();
        this.monitor.beginTask(MessageFormat.format(JGitText.get().rewinding, this.upstreamCommit.getShortMessage()), 0);
        boolean checkoutOk = false;
        try {
            checkoutOk = this.checkoutCommit(this.upstreamCommit);
        }
        finally {
            if (!checkoutOk) {
                FileUtils.delete(this.rebaseState.getDir(), 1);
            }
        }
        this.monitor.endTask();
        return null;
    }

    private boolean isInteractive() {
        return this.interactiveHandler != null;
    }

    public RevCommit tryFastForward(RevCommit newCommit) throws IOException, GitAPIException {
        Ref head = this.repo.getRef("HEAD");
        if (head == null || head.getObjectId() == null) {
            throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, "HEAD"));
        }
        ObjectId headId = head.getObjectId();
        if (headId == null) {
            throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, "HEAD"));
        }
        RevCommit headCommit = this.walk.lookupCommit(headId);
        if (this.walk.isMergedInto(newCommit, headCommit)) {
            return newCommit;
        }
        String headName = head.isSymbolic() ? head.getTarget().getName() : "detached HEAD";
        return this.tryFastForward(headName, headCommit, newCommit);
    }

    private RevCommit tryFastForward(String headName, RevCommit oldCommit, RevCommit newCommit) throws IOException, GitAPIException {
        boolean tryRebase = false;
        for (RevCommit parentCommit : newCommit.getParents()) {
            if (!parentCommit.equals(oldCommit)) continue;
            tryRebase = true;
        }
        if (!tryRebase) {
            return null;
        }
        CheckoutCommand co = new CheckoutCommand(this.repo);
        try {
            co.setName(newCommit.name()).call();
            if (headName.startsWith("refs/heads/")) {
                RefUpdate rup = this.repo.updateRef(headName);
                rup.setExpectedOldObjectId(oldCommit);
                rup.setNewObjectId(newCommit);
                rup.setRefLogMessage("Fast-foward from " + oldCommit.name() + " to " + newCommit.name(), false);
                RefUpdate.Result res = rup.update(this.walk);
                switch (res) {
                    case FAST_FORWARD: 
                    case FORCED: 
                    case NO_CHANGE: {
                        break;
                    }
                    default: {
                        throw new IOException("Could not fast-forward");
                    }
                }
            }
            return newCommit;
        }
        catch (RefAlreadyExistsException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        catch (RefNotFoundException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        catch (InvalidRefNameException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        catch (CheckoutConflictException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    private void checkParameters() throws WrongRepositoryStateException {
        block8: {
            block7: {
                if (this.operation == Operation.BEGIN) break block7;
                switch (this.repo.getRepositoryState()) {
                    case REBASING_INTERACTIVE: 
                    case REBASING: 
                    case REBASING_REBASING: 
                    case REBASING_MERGE: {
                        break block8;
                    }
                    default: {
                        throw new WrongRepositoryStateException(MessageFormat.format(JGitText.get().wrongRepositoryState, this.repo.getRepositoryState().name()));
                    }
                }
            }
            switch (this.repo.getRepositoryState()) {
                case SAFE: {
                    if (this.upstreamCommit == null) {
                        throw new JGitInternalException(MessageFormat.format(JGitText.get().missingRequiredParameter, "upstream"));
                    }
                    return;
                }
            }
            throw new WrongRepositoryStateException(MessageFormat.format(JGitText.get().wrongRepositoryState, this.repo.getRepositoryState().name()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RebaseResult abort(RebaseResult result) throws IOException {
        try {
            DirCacheCheckout dco;
            ObjectId origHead = this.repo.readOrigHead();
            String commitId = origHead != null ? origHead.name() : null;
            this.monitor.beginTask(MessageFormat.format(JGitText.get().abortingRebase, commitId), 0);
            if (commitId == null) {
                throw new JGitInternalException(JGitText.get().abortingRebaseFailedNoOrigHead);
            }
            ObjectId id = this.repo.resolve(commitId);
            RevCommit commit = this.walk.parseCommit(id);
            if (result.getStatus().equals((Object)RebaseResult.Status.FAILED)) {
                RevCommit head = this.walk.parseCommit(this.repo.resolve("HEAD"));
                dco = new DirCacheCheckout(this.repo, head.getTree(), this.repo.lockDirCache(), commit.getTree());
            } else {
                dco = new DirCacheCheckout(this.repo, this.repo.lockDirCache(), commit.getTree());
            }
            dco.setFailOnConflict(false);
            dco.checkout();
            this.walk.release();
        }
        finally {
            this.monitor.endTask();
        }
        try {
            String headName = this.rebaseState.readFile(HEAD_NAME);
            if (headName.startsWith("refs/")) {
                this.monitor.beginTask(MessageFormat.format(JGitText.get().resettingHead, headName), 0);
                RefUpdate refUpdate = this.repo.updateRef("HEAD", false);
                RefUpdate.Result res = refUpdate.link(headName);
                switch (res) {
                    case FAST_FORWARD: 
                    case FORCED: 
                    case NO_CHANGE: {
                        break;
                    }
                    default: {
                        throw new JGitInternalException(JGitText.get().abortingRebaseFailed);
                    }
                }
            }
            FileUtils.delete(this.rebaseState.getDir(), 1);
            this.repo.writeCherryPickHead(null);
            RebaseResult rebaseResult = result;
            return rebaseResult;
        }
        finally {
            this.monitor.endTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkoutCommit(RevCommit commit) throws IOException, CheckoutConflictException {
        try {
            RevCommit head = this.walk.parseCommit(this.repo.resolve("HEAD"));
            DirCacheCheckout dco = new DirCacheCheckout(this.repo, head.getTree(), this.repo.lockDirCache(), commit.getTree());
            dco.setFailOnConflict(true);
            try {
                dco.checkout();
            }
            catch (org.eclipse.jgit.errors.CheckoutConflictException cce) {
                throw new CheckoutConflictException(dco.getConflicts(), cce);
            }
            RefUpdate refUpdate = this.repo.updateRef("HEAD", true);
            refUpdate.setExpectedOldObjectId(head);
            refUpdate.setNewObjectId(commit);
            RefUpdate.Result res = refUpdate.forceUpdate();
            switch (res) {
                case FAST_FORWARD: 
                case FORCED: 
                case NO_CHANGE: {
                    return true;
                }
                default: {
                    throw new IOException("Could not rewind to upstream commit");
                }
            }
        }
        finally {
            this.walk.release();
            this.monitor.endTask();
        }
    }

    List<Step> loadSteps() throws IOException {
        byte[] buf = IO.readFully(this.rebaseState.getFile(GIT_REBASE_TODO));
        int ptr = 0;
        int tokenBegin = 0;
        ArrayList<Step> r = new ArrayList<Step>();
        while (ptr < buf.length) {
            tokenBegin = ptr;
            ptr = RawParseUtils.nextLF(buf, ptr);
            int nextSpace = RawParseUtils.next(buf, tokenBegin, ' ');
            Step current = null;
            block6: for (int tokenCount = 0; tokenCount < 3 && nextSpace < ptr; ++tokenCount) {
                switch (tokenCount) {
                    case 0: {
                        String actionToken = new String(buf, tokenBegin, nextSpace - tokenBegin - 1);
                        tokenBegin = nextSpace;
                        if (actionToken.charAt(0) == '#') {
                            tokenCount = 3;
                            continue block6;
                        }
                        Action action = Action.parse(actionToken);
                        if (action == null) continue block6;
                        current = new Step(Action.parse(actionToken));
                        continue block6;
                    }
                    case 1: {
                        if (current == null) continue block6;
                        nextSpace = RawParseUtils.next(buf, tokenBegin, ' ');
                        String commitToken = new String(buf, tokenBegin, nextSpace - tokenBegin - 1);
                        tokenBegin = nextSpace;
                        current.commit = AbbreviatedObjectId.fromString(commitToken);
                        continue block6;
                    }
                    case 2: {
                        if (current == null) continue block6;
                        nextSpace = ptr;
                        int length = ptr - tokenBegin;
                        current.shortMessage = new byte[length];
                        System.arraycopy(buf, tokenBegin, current.shortMessage, 0, length);
                        r.add(current);
                    }
                }
            }
        }
        return r;
    }

    public RebaseCommand setUpstream(RevCommit upstream) {
        this.upstreamCommit = upstream;
        this.upstreamCommitName = upstream.name();
        return this;
    }

    public RebaseCommand setUpstream(AnyObjectId upstream) {
        try {
            this.upstreamCommit = this.walk.parseCommit(upstream);
            this.upstreamCommitName = upstream.name();
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().couldNotReadObjectWhileParsingCommit, upstream.name()), e);
        }
        return this;
    }

    public RebaseCommand setUpstream(String upstream) throws RefNotFoundException {
        try {
            ObjectId upstreamId = this.repo.resolve(upstream);
            if (upstreamId == null) {
                throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, upstream));
            }
            this.upstreamCommit = this.walk.parseCommit(this.repo.resolve(upstream));
            this.upstreamCommitName = upstream;
            return this;
        }
        catch (IOException ioe) {
            throw new JGitInternalException(ioe.getMessage(), ioe);
        }
    }

    public RebaseCommand setUpstreamName(String upstreamName) {
        if (this.upstreamCommit == null) {
            throw new IllegalStateException("setUpstreamName must be called after setUpstream.");
        }
        this.upstreamCommitName = upstreamName;
        return this;
    }

    public RebaseCommand setOperation(Operation operation) {
        this.operation = operation;
        return this;
    }

    public RebaseCommand setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public RebaseCommand runInteractively(InteractiveHandler handler) {
        this.interactiveHandler = handler;
        return this;
    }

    PersonIdent parseAuthor(byte[] raw) {
        int equalsIndex;
        int end;
        if (raw.length == 0) {
            return null;
        }
        HashMap<String, String> keyValueMap = new HashMap<String, String>();
        int p = 0;
        while (p < raw.length && (end = RawParseUtils.nextLF(raw, p)) != p && (equalsIndex = RawParseUtils.next(raw, p, '=')) != end) {
            String key = RawParseUtils.decode(raw, p, equalsIndex - 1);
            String value = RawParseUtils.decode(raw, equalsIndex + 1, end - 2);
            p = end;
            keyValueMap.put(key, value);
        }
        String name = (String)keyValueMap.get(GIT_AUTHOR_NAME);
        String email = (String)keyValueMap.get(GIT_AUTHOR_EMAIL);
        String time = (String)keyValueMap.get(GIT_AUTHOR_DATE);
        int timeStart = 0;
        timeStart = time.startsWith("@") ? 1 : 0;
        long when = Long.parseLong(time.substring(timeStart, time.indexOf(32))) * 1000L;
        String tzOffsetString = time.substring(time.indexOf(32) + 1);
        int multiplier = -1;
        if (tzOffsetString.charAt(0) == '+') {
            multiplier = 1;
        }
        int hours = Integer.parseInt(tzOffsetString.substring(1, 3));
        int minutes = Integer.parseInt(tzOffsetString.substring(3, 5));
        int tz = (hours * 60 + minutes) * multiplier;
        if (name != null && email != null) {
            return new PersonIdent(name, email, when, tz);
        }
        return null;
    }

    private static class RebaseState {
        private final File repoDirectory;
        private File dir;

        public RebaseState(File repoDirectory) {
            this.repoDirectory = repoDirectory;
        }

        public File getDir() {
            if (this.dir == null) {
                File rebaseMerge;
                File rebaseApply = new File(this.repoDirectory, RebaseCommand.REBASE_APPLY);
                this.dir = rebaseApply.exists() ? rebaseApply : (rebaseMerge = new File(this.repoDirectory, RebaseCommand.REBASE_MERGE));
            }
            return this.dir;
        }

        public String readFile(String name) throws IOException {
            return RebaseState.readFile(this.getDir(), name);
        }

        public void createFile(String name, String content) throws IOException {
            RebaseState.createFile(this.getDir(), name, content);
        }

        public File getFile(String name) {
            return new File(this.getDir(), name);
        }

        private static String readFile(File directory, String fileName) throws IOException {
            byte[] content = IO.readFully(new File(directory, fileName));
            int end = RawParseUtils.prevLF(content, content.length);
            return RawParseUtils.decode(content, 0, end + 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void createFile(File parentDir, String name, String content) throws IOException {
            File file = new File(parentDir, name);
            FileOutputStream fos = new FileOutputStream(file);
            try {
                fos.write(content.getBytes("UTF-8"));
                fos.write(10);
            }
            finally {
                fos.close();
            }
        }
    }

    public static class Step {
        Action action;
        AbbreviatedObjectId commit;
        byte[] shortMessage;

        Step(Action action) {
            this.action = action;
        }

        public Action getAction() {
            return this.action;
        }

        public void setAction(Action action) {
            this.action = action;
        }

        public AbbreviatedObjectId getCommit() {
            return this.commit;
        }

        public byte[] getShortMessage() {
            return this.shortMessage;
        }

        public String toString() {
            return "Step[" + (Object)((Object)this.action) + ", " + (this.commit == null ? "null" : this.commit) + ", " + (this.shortMessage == null ? "null" : new String(this.shortMessage)) + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        PICK("pick", "p"),
        REWORD("reword", "r"),
        EDIT("edit", "e");

        private final String token;
        private final String shortToken;

        private Action(String token, String shortToken) {
            this.token = token;
            this.shortToken = shortToken;
        }

        public String toToken() {
            return this.token;
        }

        public String toString() {
            return "Action[" + this.token + "]";
        }

        static Action parse(String token) {
            for (Action action : Action.values()) {
                if (!action.token.equals(token) && !action.shortToken.equals(token)) continue;
                return action;
            }
            throw new JGitInternalException(MessageFormat.format(JGitText.get().unknownOrUnsupportedCommand, new Object[]{token, Action.values()}));
        }

        static /* synthetic */ String access$000(Action x0) {
            return x0.token;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface InteractiveHandler {
        public void prepareSteps(List<Step> var1);

        public String modifyCommitMessage(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        BEGIN,
        CONTINUE,
        SKIP,
        ABORT;

    }
}

